/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.script.CommandChain;
import schemacrawler.tools.command.script.GraalJSScriptExecutor;
import schemacrawler.tools.command.script.ScriptEngineExecutor;
import schemacrawler.tools.command.script.ScriptExecutor;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.string.StringFormat;

public final class ScriptCommand
extends BaseSchemaCrawlerCommand<ScriptOptions> {
    private static final Logger LOGGER = Logger.getLogger(ScriptCommand.class.getName());
    static final String COMMAND = "script";
    private ScriptExecutor scriptExecutor;

    public ScriptCommand() {
        super(COMMAND);
    }

    public void checkAvailability() throws Exception {
        ((ScriptOptions)this.commandOptions).getResource().orElseThrow(() -> new SchemaCrawlerException("No script found, " + ((ScriptOptions)this.commandOptions).getScript()));
        String scriptingLanguage = ((ScriptOptions)this.commandOptions).getLanguage();
        this.scriptExecutor = new GraalJSScriptExecutor(scriptingLanguage);
        if (this.scriptExecutor.canGenerate()) {
            LOGGER.log(Level.CONFIG, "Loaded JavaScript executor using Graal JavaScript");
            return;
        }
        this.scriptExecutor = new ScriptEngineExecutor(scriptingLanguage);
        if (this.scriptExecutor.canGenerate()) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loaded <%s> executor using script engine", new Object[]{scriptingLanguage}));
            return;
        }
        throw new SchemaCrawlerException("Scripting engine not found for language, " + scriptingLanguage);
    }

    public void execute() throws Exception {
        Objects.requireNonNull((ScriptOptions)this.commandOptions, "No script language provided");
        this.checkCatalog();
        if (this.scriptExecutor == null) {
            throw new SchemaCrawlerException("Scripting engine not found");
        }
        Charset inputCharset = this.outputOptions.getInputCharset();
        InputResource inputResource = ((ScriptOptions)this.commandOptions).getResource().get();
        Reader reader = inputResource.openNewInputReader(inputCharset);
        Writer writer = this.outputOptions.openNewOutputWriter();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Evaluating script, %s", new Object[]{inputResource}));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("catalog", this.catalog);
        context.put("connection", this.connection);
        context.put("chain", (Object)new CommandChain(this));
        this.scriptExecutor.initialize(context, reader, writer);
        this.scriptExecutor.call();
    }

    public boolean usesConnection() {
        return true;
    }
}

