/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SearchableType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.string.StringFormat;

final class DataTypeRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(DataTypeRetriever.class.getName());

    DataTypeRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveSystemColumnDataTypes() throws SQLException {
        SchemaReference systemSchema = new SchemaReference();
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.typeInfoRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving system column data types, using fast data dictionary retrieval");
                this.retrieveSystemColumnDataTypesFromDataDictionary(systemSchema);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving system column data types");
                this.retrieveSystemColumnDataTypesFromMetadata(systemSchema);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving system column data types");
            }
        }
    }

    void retrieveUserDefinedColumnDataTypes() throws SQLException {
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieving user-defined data types for schema <%s>", new Object[]{schema}));
            this.retrieveUserDefinedColumnDataTypesFromMetadata(schema);
        }
    }

    private void createSystemColumnDataType(MetadataResultSet results, Schema systemSchema) {
        String typeName = results.getString("TYPE_NAME");
        int dataType = results.getInt("DATA_TYPE", 0);
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving data type <%s> with type id %d", new Object[]{typeName, dataType}));
        long precision = results.getLong("PRECISION", 0L);
        String literalPrefix = results.getString("LITERAL_PREFIX");
        String literalSuffix = results.getString("LITERAL_SUFFIX");
        String createParameters = results.getString("CREATE_PARAMS");
        boolean isNullable = results.getInt("NULLABLE", 2) == 1;
        boolean isCaseSensitive = results.getBoolean("CASE_SENSITIVE");
        SearchableType searchable = results.getEnumFromId("SEARCHABLE", SearchableType.unknown);
        boolean isUnsigned = results.getBoolean("UNSIGNED_ATTRIBUTE");
        boolean isFixedPrecisionScale = results.getBoolean("FIXED_PREC_SCALE");
        boolean isAutoIncremented = results.getBoolean("AUTO_INCREMENT");
        String localTypeName = results.getString("LOCAL_TYPE_NAME");
        int minimumScale = results.getInt("MINIMUM_SCALE", 0);
        int maximumScale = results.getInt("MAXIMUM_SCALE", 0);
        int numPrecisionRadix = results.getInt("NUM_PREC_RADIX", 0);
        MutableColumnDataType columnDataType = this.lookupOrCreateColumnDataType(DataTypeType.system, systemSchema, dataType, typeName);
        columnDataType.setPrecision(precision);
        columnDataType.setLiteralPrefix(literalPrefix);
        columnDataType.setLiteralSuffix(literalSuffix);
        columnDataType.setCreateParameters(createParameters);
        columnDataType.setNullable(isNullable);
        columnDataType.setCaseSensitive(isCaseSensitive);
        columnDataType.setSearchable(searchable);
        columnDataType.setUnsigned(isUnsigned);
        columnDataType.setFixedPrecisionScale(isFixedPrecisionScale);
        columnDataType.setAutoIncrementable(isAutoIncremented);
        columnDataType.setLocalTypeName(localTypeName);
        columnDataType.setMinimumScale(minimumScale);
        columnDataType.setMaximumScale(maximumScale);
        columnDataType.setNumPrecisionRadix(numPrecisionRadix);
        columnDataType.addAttributes(results.getAttributes());
        this.catalog.addColumnDataType(columnDataType);
    }

    private void retrieveSystemColumnDataTypesFromDataDictionary(Schema systemSchema) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TYPE_INFO)) {
            throw new SchemaCrawlerSQLException("No system column data types SQL provided");
        }
        Query typeInfoSql = informationSchemaViews.getQuery(InformationSchemaKey.TYPE_INFO);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(typeInfoSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveSystemColumnDataTypesFromDataDictionary");
            int numSystemColumnDataTypes = 0;
            while (results.next()) {
                ++numSystemColumnDataTypes;
                this.createSystemColumnDataType(results, systemSchema);
            }
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d system column data types", new Object[]{numSystemColumnDataTypes}));
        }
    }

    private void retrieveSystemColumnDataTypesFromMetadata(Schema systemSchema) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTypeInfo());){
            results.setDescription("retrieveSystemColumnDataTypesFromDataDictionary");
            int numSystemColumnDataTypes = 0;
            while (results.next()) {
                ++numSystemColumnDataTypes;
                this.createSystemColumnDataType(results, systemSchema);
            }
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d system column data types", new Object[]{numSystemColumnDataTypes}));
        }
    }

    private void retrieveUserDefinedColumnDataTypesFromMetadata(Schema schema) throws SQLException {
        Objects.requireNonNull(schema, "No schema provided");
        Optional<SchemaReference> schemaOptional = this.catalog.lookupSchema(schema.getFullName());
        if (!schemaOptional.isPresent()) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Cannot locate schema, so not retrieving data types for schema: %s", new Object[]{schema}));
            return;
        }
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieving data types for schema <%s>", new Object[]{schema}));
        String catalogName = schema.getCatalogName();
        String schemaName = schema.getName();
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getUDTs(catalogName, schemaName, null, null));){
            while (results.next()) {
                String typeName = results.getString("TYPE_NAME");
                LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving data type <%s.%s>", new Object[]{schema, typeName}));
                int dataType = results.getInt("DATA_TYPE", 0);
                String className = results.getString("CLASS_NAME");
                String remarks = results.getString("REMARKS");
                short baseTypeValue = results.getShort("BASE_TYPE", (short)0);
                MutableColumnDataType baseType = baseTypeValue != 0 ? this.catalog.lookupBaseColumnDataTypeByType(baseTypeValue) : null;
                MutableColumnDataType columnDataType = this.lookupOrCreateColumnDataType(DataTypeType.user_defined, schema, dataType, typeName, className);
                columnDataType.setBaseType(baseType);
                columnDataType.setRemarks(remarks);
                columnDataType.addAttributes(results.getAttributes());
                this.catalog.addColumnDataType(columnDataType);
            }
        }
    }
}

