/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import schemacrawler.crawl.AbstractProperty;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.Property;

class ImmutableDatabaseProperty
extends AbstractProperty
implements DatabaseProperty {
    private static final long serialVersionUID = -7150431683440256142L;
    private static final Comparator<Property> comparator = Comparator.nullsLast(Comparator.comparing(Property::getDescription, String.CASE_INSENSITIVE_ORDER));
    private static final Set<Map.Entry<Pattern, String>> acronyms;
    private transient String description;

    ImmutableDatabaseProperty(String name, Object value) {
        super(name, (Serializable)value);
    }

    @Override
    public int compareTo(Property otherProperty) {
        return Objects.compare(this, otherProperty, comparator);
    }

    @Override
    public String getDescription() {
        this.buildDescription();
        return this.description;
    }

    public String toString() {
        return this.getDescription() + " = " + this.getValue();
    }

    private void buildDescription() {
        if (this.description != null) {
            return;
        }
        String get = "get";
        this.description = this.getName();
        if (this.description.startsWith("get")) {
            this.description = this.description.substring("get".length());
        }
        for (Map.Entry<Pattern, String> acronym : acronyms) {
            String lowerCaseAcronymAsWord = " " + acronym.getValue().toLowerCase();
            this.description = acronym.getKey().matcher(this.description).replaceAll(lowerCaseAcronymAsWord);
        }
        int strLen = this.description.length();
        StringBuilder buffer = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char ch = this.description.charAt(i);
            if (Character.isUpperCase(ch)) {
                buffer.append(' ').append(Character.toLowerCase(ch));
                continue;
            }
            buffer.append(ch);
        }
        this.description = buffer.toString();
        for (Map.Entry<Pattern, String> acronym : acronyms) {
            this.description = acronym.getKey().matcher(this.description).replaceAll(acronym.getValue());
        }
        this.description = this.description.trim();
    }

    static {
        HashMap<Pattern, String> acronymsMap = new HashMap<Pattern, String>();
        List<String> acronymsList = Arrays.asList("JDBC", "ANSI", "SQL", "URL", "TYPE_FORWARD_ONLY", "TYPE_SCROLL_INSENSITIVE", "TYPE_SCROLL_SENSITIVE");
        for (String acronym : acronymsList) {
            Pattern pattern = Pattern.compile(acronym, 2);
            acronymsMap.put(pattern, acronym);
        }
        acronyms = Collections.unmodifiableSet(acronymsMap.entrySet());
    }
}

