/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.TemplatingUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class QueryUtility {
    private static final Logger LOGGER = Logger.getLogger(QueryUtility.class.getName());

    public static ResultSet executeAgainstSchema(Query query, Statement statement, InclusionRule schemaInclusionRule) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, schemaInclusionRule);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSql((Statement)statement, (String)sql);
    }

    public static ResultSet executeAgainstTable(Query query, Statement statement, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Objects.requireNonNull(identifiers, "No identifiers provided");
        String sql = QueryUtility.getQuery(query, table, isAlphabeticalSortForTableColumns, identifiers);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSql((Statement)statement, (String)sql);
    }

    public static long executeForLong(Query query, Connection connection, Table table, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true, identifiers);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSqlForLong((Connection)connection, (String)sql);
    }

    public static Object executeForScalar(Query query, Connection connection) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSqlForScalar((Connection)connection, (String)sql);
    }

    public static Object executeForScalar(Query query, Connection connection, Table table, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true, identifiers);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSqlForScalar((Connection)connection, (String)sql);
    }

    private static String getQuery(Query query) {
        return TemplatingUtility.expandTemplate((String)query.getQuery());
    }

    private static String getQuery(Query query, InclusionRule schemaInclusionRule) {
        String schemaInclusionPattern;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("schemas", ".*");
        if (schemaInclusionRule != null && schemaInclusionRule instanceof InclusionRuleWithRegularExpression && !Utility.isBlank((CharSequence)(schemaInclusionPattern = ((InclusionRuleWithRegularExpression)schemaInclusionRule).getInclusionPattern().pattern()))) {
            properties.put("schemas", schemaInclusionPattern);
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate((String)sql, properties);
        sql = TemplatingUtility.expandTemplate((String)sql);
        return sql;
    }

    private static String getQuery(Query query, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            NamedObjectSort columnsSort = NamedObjectSort.getNamedObjectSort(isAlphabeticalSortForTableColumns);
            List<Column> columns = table.getColumns();
            columns.sort(columnsSort);
            Schema schema = table.getSchema();
            if (schema != null) {
                String schemaName = identifiers.quoteFullName(schema);
                tableProperties.put("schema", schemaName);
            }
            tableProperties.put("table", identifiers.quoteFullName(table));
            tableProperties.put("tablename", table.getName());
            tableProperties.put("columns", MetaDataUtility.joinColumns(columns, false, identifiers));
            tableProperties.put("orderbycolumns", MetaDataUtility.joinColumns(columns, true, identifiers));
            tableProperties.put("tabletype", table.getTableType().toString());
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate((String)sql, tableProperties);
        sql = TemplatingUtility.expandTemplate((String)sql);
        return sql;
    }

    private QueryUtility() {
    }
}

