/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.text.formatter.operation.DataTextFormatter;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class OperationCommand
extends BaseSchemaCrawlerCommand<OperationOptions> {
    private static final Logger LOGGER = Logger.getLogger(OperationCommand.class.getName());

    public OperationCommand(String command) {
        super(command);
    }

    public void checkAvailability() throws Exception {
    }

    public void execute() throws Exception {
        this.checkCatalog();
        if (!this.isOutputFormatSupported()) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Output format <%s> not supported for command <%s>", new Object[]{this.outputOptions.getOutputFormatValue(), this.getCommand()}));
            return;
        }
        DataTraversalHandler handler = this.getDataTraversalHandler();
        Query query = ((OperationOptions)this.commandOptions).getQuery();
        handler.begin();
        handler.handleInfoStart();
        handler.handle(this.catalog.getDatabaseInfo());
        handler.handle(this.catalog.getJdbcDriverInfo());
        handler.handleInfoEnd();
        if (query.isQueryOver()) {
            String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
            Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString(identifierQuoteString).build();
            try (Statement statement = DatabaseUtility.createStatement((Connection)this.connection);){
                for (Table table : this.getSortedTables(this.catalog)) {
                    boolean isAlphabeticalSortForTableColumns = ((OperationOptions)this.commandOptions).isAlphabeticalSortForTableColumns();
                    try {
                        ResultSet results = QueryUtility.executeAgainstTable((Query)query, (Statement)statement, (Table)table, (boolean)isAlphabeticalSortForTableColumns, (Identifiers)identifiers);
                        try {
                            handler.handleData(table, results);
                        }
                        finally {
                            if (results == null) continue;
                            results.close();
                        }
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Bad operation for table <%s>", new Object[]{table}));
                    }
                }
            }
        }
        String sql = query.getQuery();
        try (Statement statement = DatabaseUtility.createStatement((Connection)this.connection);
             ResultSet results = DatabaseUtility.executeSql((Statement)statement, (String)sql);){
            handler.handleData(query, results);
        }
        handler.end();
    }

    public boolean usesConnection() {
        return true;
    }

    private DataTraversalHandler getDataTraversalHandler() throws SchemaCrawlerException {
        Operation operation = ((OperationOptions)this.commandOptions).getOperation();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        DataTextFormatter formatter = new DataTextFormatter(operation, (OperationOptions)this.commandOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }

    private List<? extends Table> getSortedTables(Catalog catalog) {
        ArrayList tables = new ArrayList(catalog.getTables());
        tables.sort(NamedObjectSort.getNamedObjectSort((boolean)((OperationOptions)this.commandOptions).isAlphabeticalSortForTables()));
        return tables;
    }

    private boolean isOutputFormatSupported() {
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        boolean isOutputFormatSupported = TextOutputFormat.isSupportedFormat(outputFormatValue);
        return isOutputFormatSupported;
    }
}

