/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.LiteralsInfo;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandlerCore;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public abstract class StatementExecutionHandler
implements StatementExecutionHandlerCore {
    protected Logger logger_ = ConnectionExecutionHandler.logger__;
    protected static final Logger staticLogger__ = Log.getClientOptimizerStaticLogger();
    protected static final Logger dynamicLogger__ = Log.getClientOptimizerDynamicLogger();
    protected static final Logger dbLogger__ = Log.getDatabaseLogger();
    protected Statement physicalStatement_ = null;
    protected CentralStoreKey propertyRedirectedKey_ = null;
    protected boolean propertyRefreshEnabled_ = false;
    public ConnectionExecutionHandler connExecutionHandler_;
    protected ConnectionExecutionHandler.CachedResolvedStates currentStates_;
    public PreparedStatementExecutionHandler prepStmtHandle_;
    protected ResultSetExecutionHandler resultSet_ = null;
    protected int updateCount_ = -1;
    protected String sqlStr_;
    protected String cursorName_;
    protected LiteralsInfo litInfo_ = null;
    protected ArrayList<PreparedStatementExecutionHandler> batchingPrepStmtList_;
    protected int resultSetType_ = 1003;
    protected int resultSetConcurrency_ = 1007;
    protected int resultSetHoldability_ = 1;
    protected final String[] autoGenKeyColNames_;
    protected final int[] autoGenKeyColIndexes_;
    protected final int autoGenKeyIndicator_;
    protected final boolean autoGenKeysRequested_;
    protected final String methodName_;
    protected Method method_;
    protected Object[] args_;
    private Boolean isSELECTorXQUERY_ = null;
    protected boolean isCallStmt_ = false;
    private SqlStatementType currentSqlType_ = null;
    protected boolean isParameterizedDynamicStatement_ = false;
    public boolean isWcoWithPropertiesRefresh_ = false;
    public String posUpdateCursorName_ = null;
    protected boolean defStackTrcCaptured_ = true;
    protected String[][] definitionTraceInfo_ = null;
    protected boolean isPStmtAPI_ = false;
    protected ArrayList<SqlStatementKey> batchStatements_ = new ArrayList();
    protected HashMap<String, ArrayList<Integer>> NamedParamMap_ = null;
    public String metadataCorrelatorForMonitor_ = null;
    protected short captureMode_;
    protected short executionMode_;
    protected ConnectionExecutionHandler.CachedConnectionAttributes cachedConnectionAttributesForStatement_;
    protected ConnectionExecutionHandler.ModifiedStatementAttributes modifiedStatementAttributes_;
    private static boolean needCheckForJDBC4Plus_ = true;
    private static boolean isJDBC4_;
    private static Method methodSetPoolable_;
    private static Method methodIsPoolable_;
    private static Method methodCloseOnCompletion_;
    private static boolean isJDBC41_;
    protected static final String methodNameSetEscapeProcessing__ = "setEscapeProcessing";
    private boolean escapeProcessing_ = true;

    public StatementExecutionHandler(ConnectionExecutionHandler connectionExecutionHandler, Statement statement, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string, Method method, Object ... objectArray) throws SQLException {
        this.physicalStatement_ = statement;
        this.cachedConnectionAttributesForStatement_ = connectionExecutionHandler.getCurrentConnectionAttributes().cloneCachedConnectionAttributes();
        this.modifiedStatementAttributes_ = new ConnectionExecutionHandler.ModifiedStatementAttributes();
        this.checkForNullPhysicalStatement();
        this.currentStates_ = connectionExecutionHandler.getCurrentStates();
        this.setConnectionAndRSAttributes(connectionExecutionHandler, n2, n3, n4);
        this.autoGenKeyColNames_ = stringArray;
        this.autoGenKeyColIndexes_ = nArray;
        this.autoGenKeyIndicator_ = n5;
        this.autoGenKeysRequested_ = StaticProfileConstants.areAutoGeneratedKeysRequested(this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_);
        this.methodName_ = string;
        this.method_ = method;
        this.args_ = objectArray;
        this.propertyRedirectedKey_ = this.currentStates_.getPropertyRedirectedKey();
        this.propertyRefreshEnabled_ = this.currentStates_.isPropertyRefreshEnabled();
        this.captureMode_ = this.currentStates_.getCaptureMode();
        this.executionMode_ = this.currentStates_.getExecutionMode();
        if (this.currentStates_.getProfilerHelperInstance() == null && this.logger_.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(this.logger_, this, "", DataLogger.getShortName(this) + " profilerHelperInstance is null", false);
        }
    }

    protected void initNamedParamMap() {
        if (this.currentStates_.getEnableDynamicSQLReplacement()) {
            SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
            this.NamedParamMap_ = this.currentStates_.getProfilerHelperInstance().getMarkerPosMap(sqlStatementKey);
        }
    }

    @Override
    public abstract Object invoke(String var1, Method var2, Object[] var3) throws Throwable;

    protected boolean shouldDumpLogs(Throwable throwable) {
        if (this.isRepositoryConnection()) {
            return false;
        }
        return Log.isLoggable(throwable);
    }

    protected void dumpLogs(Throwable throwable) {
        if (this.shouldDumpLogs(throwable)) {
            Log.dumpRingBuffer(throwable);
        }
    }

    protected void setConnectionAndRSAttributes(ConnectionExecutionHandler connectionExecutionHandler, int n2, int n3, int n4) {
        this.connExecutionHandler_ = connectionExecutionHandler;
        if (n2 != 0) {
            this.resultSetType_ = n2;
        }
        if (n3 != 0) {
            this.resultSetConcurrency_ = n3;
        }
        if (n4 != 0) {
            this.resultSetHoldability_ = n4;
        }
    }

    private void checkForNullPhysicalStatement() throws SQLException {
        if (this.physicalStatement_ == null) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_STATEMENT_NULL", new Object[0]), null, null, 10456);
        }
    }

    private void findAndSetStatementType(String string, boolean bl2) throws SQLException {
        Matcher matcher;
        boolean bl3;
        if (!bl2 && null != this.currentSqlType_) {
            return;
        }
        EscapeLexer escapeLexer = new EscapeLexer(string);
        this.currentSqlType_ = escapeLexer.parseSqlAndGetSqlType();
        this.setIsSELECTorXQUERY(SqlStatementType.isSELECTorXQUERY(this.currentSqlType_));
        boolean bl4 = bl3 = SqlStatementType.UPDATE == this.currentSqlType_ || SqlStatementType.DELETE == this.currentSqlType_;
        if (bl3 && this.propertyRefreshEnabled_ && (matcher = StaticProfileConstants.WCOPat_.matcher(string)) != null && matcher.find()) {
            this.posUpdateCursorName_ = matcher.group(2);
            this.isWcoWithPropertiesRefresh_ = true;
        }
    }

    protected boolean isCapturableNonParameter() throws SQLException {
        if (!(this.isParameterizedDynamicStatement_ || this.isSELECTorXQUERY() || SqlStatementType.isDDL(this.getCurrentSqlType()))) {
            Level level;
            int n2 = this.currentStates_.getMaxNonParmSqlCount();
            if (n2 != -1 && this.currentStates_.getProfilerHelperInstance().nonParameterizeSqlCount_ >= n2) {
                ++this.currentStates_.getProfilerHelperInstance().nonCapturedNonParameterizeSqlCount_;
                this.currentStates_.getProfilerHelperInstance().UpdateNonParameterizedSqlCountNotCaptured(this.currentStates_.getProfilerHelperInstance().nonCapturedNonParameterizeSqlCount_);
                return false;
            }
            ++this.currentStates_.getProfilerHelperInstance().nonParameterizeSqlCount_;
            if (n2 == this.currentStates_.getProfilerHelperInstance().nonParameterizeSqlCount_ && this.logger_.isLoggable(level = Level.FINE)) {
                String string = DataLogger.getLocationInUserApplicationMessage();
                String string2 = DataLogger.warningMessagePrefix + Messages.getText("MSG_PROFILER_JCC_WARN_SQL_LIMIT2", "pureQuery Runtime", "pdq.maxNonParmSQL", n2, string);
                this.logger_.logp(level, DataLogger.getShortName(this), "isCapturableNonParameter", string2);
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndCaptureCallStmt(boolean bl2, long l10, long l11, int n2) throws SQLException {
        boolean bl3 = false;
        SqlStatementKey sqlStatementKey = null;
        String[][] stringArray = null;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        if (this.captureMode_ == 5) {
            Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
            synchronized (object) {
                sqlStatementKey = SqlStatementKey.generateStmtKey(this.getSqlString(), this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                bl3 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                if (bl3) {
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                    this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                } else if (!bl2) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                        stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (this.definitionTraceInfo_ == null && stringArray != null) {
                            this.definitionTraceInfo_ = (String[][])stringArray.clone();
                        }
                    }
                    sqlStatementInfo = this.recordNonQueryStmt_(sqlStatementKey, stringArray, l10, l11, n2);
                }
            }
            if (bl3) {
                object = sqlStatementInfo;
                synchronized (object) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                        String[][] stringArray2 = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (!this.isPStmtAPI_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(stringArray2, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        } else if (!this.defStackTrcCaptured_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            this.defStackTrcCaptured_ = true;
                        } else {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(null, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        }
                    }
                    this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.connExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), l10, l11, n2, 0);
                }
            }
            if (bl3 || !bl3 && !bl2) {
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndCaptureNonQueryStmt(boolean bl2, boolean bl3, long l10, long l11, int n2) throws SQLException {
        boolean bl4 = false;
        boolean bl5 = true;
        String[][] stringArray = null;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        if (this.captureMode_ == 5) {
            Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
            synchronized (object) {
                SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                bl4 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                if (bl4) {
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                    this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                } else if (!bl2 && (bl5 = this.isCapturableNonParameter())) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && bl3) {
                        stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (this.definitionTraceInfo_ == null) {
                            this.definitionTraceInfo_ = stringArray;
                        }
                    }
                    sqlStatementInfo = this.recordNonQueryStmt_(sqlStatementKey, stringArray, l10, l11, n2);
                    this.definitionTraceInfo_ = null;
                    this.defStackTrcCaptured_ = true;
                }
            }
            if (bl4) {
                object = sqlStatementInfo;
                synchronized (object) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                        String[][] stringArray2 = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (!this.isPStmtAPI_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(stringArray2, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        } else if (!this.defStackTrcCaptured_) {
                            if (bl3) {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            } else {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, null, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            }
                            this.defStackTrcCaptured_ = true;
                        } else if (bl3) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(null, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        }
                    }
                    this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.connExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), l10, l11, n2, 0);
                }
            }
            if (bl5 && (bl4 || !bl4 && !bl2)) {
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl4);
            }
        }
    }

    protected void addBatch(String string) throws SQLException {
        String string2 = null;
        if (this.captureMode_ == 5) {
            this.findAndSetStatementType(string, true);
            if (this.prepStmtHandle_ != null) {
                this.prepStmtHandle_.close();
                this.prepStmtHandle_ = null;
            }
        }
        if (this.executionMode_ == 8 || this.executionMode_ == 20) {
            if (this.currentStates_.getCapturedOnly() || this.currentStates_.getEnableDynamicSQLReplacement()) {
                SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                if (this.currentStates_.getCapturedOnly()) {
                    this.connExecutionHandler_.checkForCapturedOnly(sqlStatementKey, false, this.currentStates_);
                }
                if (this.currentStates_.getEnableDynamicSQLReplacement() && (this.executionMode_ == 8 || !((HashMap)this.currentStates_.getProfilerHelperInstance().getStmtDescriptorMap()).containsKey(sqlStatementKey))) {
                    string2 = this.currentStates_.getProfilerHelperInstance().getProcessedSQL(sqlStatementKey);
                }
            }
            if (string2 == null || string2.trim().equals("")) {
                string2 = string;
            }
            this.physicalStatement_.addBatch(string2);
            if (this.captureMode_ == 5 && !this.isSELECTorXQUERY() && (this.currentStates_.getStmtBatch().equalsIgnoreCase("ON") || SqlStatementType.isDDL(this.getCurrentSqlType()))) {
                this.recordNonQueryBatchingStmt(string, this.getCurrentSqlType());
            }
        }
    }

    protected void recordNonQueryBatchingStmt(String string, SqlStatementType sqlStatementType) throws SQLException {
        if (this.captureMode_ == 5) {
            if (SqlStatementType.SET == sqlStatementType) {
                return;
            }
            SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
            this.recordNonQueryBatchingStmtX(string, sqlStatementKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordNonQueryBatchingStmtX(String string, SqlStatementKey sqlStatementKey) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = true;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
        synchronized (object) {
            bl2 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
            if (bl2) {
                sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
            } else {
                bl3 = this.isCapturableNonParameter();
                if (bl3) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                        this.definitionTraceInfo_ = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                    }
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordNonQueryStmt(this.connExecutionHandler_, string, null, null, sqlStatementKey, null, null, this.getCurrentSqlType(), false, this.definitionTraceInfo_, null, null, null, 0L, 0L, 0);
                    this.definitionTraceInfo_ = null;
                    this.batchStatements_.add(sqlStatementKey);
                }
            }
        }
        if (bl2) {
            object = sqlStatementInfo;
            synchronized (object) {
                if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < Integer.valueOf(this.currentStates_.getMaxStackTracesCaptured()))) {
                    String[][] stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                    this.currentStates_.getProfilerHelperInstance().captureTrace(stringArray, null, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                    this.batchStatements_.add(sqlStatementKey);
                }
                this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.connExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), 0L, 0L, 0, 0);
            }
        }
        if (bl3) {
            this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl2);
        }
    }

    public String getSqlString() {
        return this.sqlStr_;
    }

    protected ResultSetExecutionHandler executeQuery(String string) throws SQLException {
        this.createPrepStmtHandle(string);
        this.resultSet_ = this.prepStmtHandle_.executeQuery();
        return this.resultSet_;
    }

    protected int executeUpdate(String string) throws SQLException {
        this.createPrepStmtHandle(string);
        return this.prepStmtHandle_.executeUpdate();
    }

    protected boolean execute(String string) throws SQLException {
        this.createPrepStmtHandle(string);
        return this.prepStmtHandle_.execute();
    }

    protected boolean executeForAGKs(String string, Object object, int n2) throws SQLException {
        this.createPrepStmtHandleForAGKs(string, object, n2);
        return this.prepStmtHandle_.execute();
    }

    protected int executeUpdateForAGKs(String string, Object object, int n2) throws SQLException {
        this.createPrepStmtHandleForAGKs(string, object, n2);
        return this.prepStmtHandle_.executeUpdate();
    }

    protected ResultSet getGeneratedKeysAsResultSet() throws SQLException {
        if (this.prepStmtHandle_ == null) {
            return this.physicalStatement_.getGeneratedKeys();
        }
        return this.prepStmtHandle_.getUnderlyingPreparedStatement().getGeneratedKeys();
    }

    protected abstract int[] executeBatch() throws SQLException;

    protected void clearBatch() throws SQLException {
        this.batchStatements_.clear();
        this.physicalStatement_.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        SQLException sQLException = null;
        if (this.prepStmtHandle_ != null) {
            try {
                this.prepStmtHandle_.close();
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                }
                sQLException.setNextException(sQLException2);
            }
            this.prepStmtHandle_ = null;
        }
        this.batchStatements_.clear();
        try {
            this.closeBatchingPreparedStmts();
        }
        catch (SQLException sQLException3) {
            if (sQLException == null) {
                sQLException = sQLException3;
            }
            sQLException.setNextException(sQLException3);
        }
        try {
            this.physicalStatement_.close();
        }
        catch (SQLException sQLException4) {
            if (sQLException == null) {
                sQLException = sQLException4;
            }
            sQLException.setNextException(sQLException4);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    protected void setIsSELECTorXQUERY(boolean bl2) {
        this.isSELECTorXQUERY_ = bl2;
    }

    protected boolean isSELECTorXQUERY() throws SQLException {
        if (null != this.isSELECTorXQUERY_) {
            return this.isSELECTorXQUERY_;
        }
        if (5 == this.captureMode_) {
            return SqlStatementType.isSELECTorXQUERY(this.getCurrentSqlType());
        }
        if (null != this.sqlStr_) {
            this.isSELECTorXQUERY_ = StaticProfileConstants.isStatementOfType(this.sqlStr_, SqlStatementType.QUERY, SqlStatementType.XQUERY);
            return this.isSELECTorXQUERY_;
        }
        String string = Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER", "isSELECTorXQUERY", this.getClass().getCanonicalName());
        string = string + "  " + Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER_VARIABLE_NOT_SET", "sqlStr_");
        throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(string, null, 11258);
    }

    public SqlStatementType getCurrentSqlType() throws SQLException {
        if (null == this.currentSqlType_) {
            if (null == this.sqlStr_) {
                String string = Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER", "getCurrentSqlType", this.getClass().getCanonicalName());
                string = string + "  " + Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER_VARIABLE_NOT_SET", "sqlStr_");
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(string, null, 11259);
            }
            this.findAndSetStatementType(this.sqlStr_, false);
        }
        return this.currentSqlType_;
    }

    public void setCurrentSqlType(SqlStatementType sqlStatementType) {
        this.currentSqlType_ = sqlStatementType;
    }

    @Override
    public void setLiteralsInfo(LiteralsInfo literalsInfo) {
        this.litInfo_ = literalsInfo;
    }

    public LiteralsInfo getLiteralsInfo() {
        return this.litInfo_;
    }

    protected void transferStatementProperties(String string) throws SQLException {
        block11: {
            ConnectionExecutionHandler.AttributeState attributeState;
            PreparedStatement preparedStatement = this.prepStmtHandle_.getUnderlyingPreparedStatement();
            preparedStatement.setMaxRows(this.physicalStatement_.getMaxRows());
            preparedStatement.setFetchSize(this.physicalStatement_.getFetchSize());
            preparedStatement.setFetchDirection(this.physicalStatement_.getFetchDirection());
            preparedStatement.setQueryTimeout(this.physicalStatement_.getQueryTimeout());
            preparedStatement.setMaxFieldSize(this.physicalStatement_.getMaxFieldSize());
            if (needCheckForJDBC4Plus_) {
                needCheckForJDBC4Plus_ = false;
                methodIsPoolable_ = StatementExecutionHandler.findMethod(this.physicalStatement_.getClass(), "isPoolable", null);
                methodSetPoolable_ = StatementExecutionHandler.findMethod(this.physicalStatement_.getClass(), "setPoolable", Boolean.TYPE);
                methodCloseOnCompletion_ = StatementExecutionHandler.findMethod(preparedStatement.getClass(), "closeOnCompletion", null);
                if (methodIsPoolable_ != null && methodSetPoolable_ != null) {
                    isJDBC4_ = true;
                }
                if (isJDBC4_ && methodCloseOnCompletion_ != null) {
                    isJDBC41_ = true;
                }
            }
            if (isJDBC4_) {
                try {
                    methodSetPoolable_.invoke((Object)preparedStatement, methodIsPoolable_.invoke((Object)this.physicalStatement_, (Object[])null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (isJDBC41_ && (attributeState = this.modifiedStatementAttributes_.getCloseOnCompletion()) == ConnectionExecutionHandler.AttributeState.SET_TRUE) {
                try {
                    methodCloseOnCompletion_.invoke((Object)preparedStatement, (Object[])null);
                }
                catch (Exception exception) {
                    if (!this.logger_.isLoggable(Level.FINE)) break block11;
                    DataLogger.logThrowable(this.logger_, exception);
                }
            }
        }
        this.initializeMetadataCorrelator(string);
    }

    protected void setEscapeProcessing(boolean bl2) {
        this.escapeProcessing_ = bl2;
        Level level = Level.FINE;
        if (!this.escapeProcessing_ && this.logger_.isLoggable(level)) {
            String string = DataLogger.getLocationInUserApplicationMessage();
            String string2 = DataLogger.warningMessagePrefix + Messages.getText("MSG_PROFILER_JCC_WARN_ESCAPE_PROCESSING3", this.escapeProcessing_, methodNameSetEscapeProcessing__, "pureQuery Runtime", true, string);
            this.logger_.logp(level, DataLogger.getShortName(this), methodNameSetEscapeProcessing__, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPrepStmtHandle(String string) throws SQLException {
        Connection connection;
        if (!(this.prepStmtHandle_ == null || this.batchingPrepStmtList_ != null && this.batchingPrepStmtList_.contains(this.prepStmtHandle_))) {
            this.prepStmtHandle_.close();
            this.resultSet_ = null;
        }
        this.physicalStatement_.getUpdateCount();
        this.currentStates_ = this.connExecutionHandler_.getCurrentStates();
        String string2 = "prepareStatement";
        Method method = ConnectionExecutionHandler.methodPrepareStatement4args_;
        Object[] objectArray = new Object[]{string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_};
        Connection connection2 = connection = this.connExecutionHandler_.physicalConnection_;
        synchronized (connection2) {
            block20: {
                if (!this.cachedConnectionAttributesForStatement_.equals(this.connExecutionHandler_.getCurrentConnectionAttributes())) {
                    try {
                        this.cachedConnectionAttributesForStatement_.transferCachedConnectionAttributes(connection);
                        try {
                            this.prepStmtHandle_ = (PreparedStatementExecutionHandler)this.connExecutionHandler_.invoke(string2, method, objectArray);
                            break block20;
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof SQLException) {
                                throw (SQLException)throwable;
                            }
                            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_STMT_RELOAD", throwable.toString()), throwable, 11755);
                        }
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11773);
                    }
                    finally {
                        try {
                            this.connExecutionHandler_.restoreConnectionAttributes();
                        }
                        catch (Throwable throwable) {
                            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11775);
                        }
                    }
                }
                try {
                    this.prepStmtHandle_ = (PreparedStatementExecutionHandler)this.connExecutionHandler_.invoke(string2, method, objectArray);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof SQLException) {
                        throw (SQLException)throwable;
                    }
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_STMT_RELOAD", throwable.toString()), throwable, 11754);
                }
            }
        }
        this.transferStatementProperties(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPrepStmtHandleForAGKs(String string, Object object, int n2) throws SQLException {
        Connection connection;
        if (!(this.prepStmtHandle_ == null || this.batchingPrepStmtList_ != null && this.batchingPrepStmtList_.contains(this.prepStmtHandle_))) {
            this.prepStmtHandle_.close();
            this.resultSet_ = null;
        }
        this.physicalStatement_.getUpdateCount();
        String string2 = "prepareStatement";
        Method method = null;
        switch (n2) {
            case -3: {
                method = ConnectionExecutionHandler.methodPrepareStatementAGKIntArray_;
                break;
            }
            case -2: {
                method = ConnectionExecutionHandler.methodPrepareStatementAGKStringArray_;
                break;
            }
            default: {
                method = ConnectionExecutionHandler.methodPrepareStatementAGKIntFlag_;
            }
        }
        Object[] objectArray = new Object[]{string, object};
        Connection connection2 = connection = this.connExecutionHandler_.physicalConnection_;
        synchronized (connection2) {
            block24: {
                if (!this.cachedConnectionAttributesForStatement_.equals(this.connExecutionHandler_.getCurrentConnectionAttributes())) {
                    try {
                        this.cachedConnectionAttributesForStatement_.transferCachedConnectionAttributes(connection);
                        try {
                            this.prepStmtHandle_ = (PreparedStatementExecutionHandler)this.connExecutionHandler_.invoke(string2, method, objectArray);
                            break block24;
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof SQLException) {
                                throw (SQLException)throwable;
                            }
                            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_STMT_RELOAD", throwable.toString()), throwable, 11753);
                        }
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11774);
                    }
                    finally {
                        try {
                            this.connExecutionHandler_.restoreConnectionAttributes();
                        }
                        catch (Throwable throwable) {
                            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11776);
                        }
                    }
                }
                try {
                    this.prepStmtHandle_ = (PreparedStatementExecutionHandler)this.connExecutionHandler_.invoke(string2, method, objectArray);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof SQLException) {
                        throw (SQLException)throwable;
                    }
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_STMT_RELOAD", throwable.toString()), throwable, 11752);
                }
            }
        }
        this.transferStatementProperties(string);
    }

    protected void closeBatchingPreparedStmts() throws SQLException {
        if (this.batchingPrepStmtList_ != null) {
            SQLException sQLException = null;
            for (int i10 = 0; i10 < this.batchingPrepStmtList_.size(); ++i10) {
                try {
                    this.batchingPrepStmtList_.get(i10).close();
                    continue;
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue;
                    }
                    sQLException.setNextException(sQLException2);
                }
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    protected int getUpdateCount() throws SQLException {
        if (this.prepStmtHandle_ == null) {
            return this.physicalStatement_.getUpdateCount();
        }
        return this.prepStmtHandle_.getUnderlyingPreparedStatement().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.resultSet_ = null;
        if (this.prepStmtHandle_ == null) {
            return this.physicalStatement_.getMoreResults();
        }
        return this.prepStmtHandle_.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        if (n2 != 2) {
            this.resultSet_ = null;
        }
        if (this.prepStmtHandle_ == null) {
            return this.physicalStatement_.getMoreResults(n2);
        }
        return this.prepStmtHandle_.getMoreResults(n2);
    }

    public Object getResultSet() throws SQLException {
        if (this.prepStmtHandle_ == null) {
            return this.physicalStatement_.getResultSet();
        }
        return this.prepStmtHandle_.getResultSet();
    }

    protected abstract StaticProfileCaptureHelper.SqlStatementInfo recordNonQueryStmt_(SqlStatementKey var1, String[][] var2, long var3, long var5, int var7) throws SQLException;

    protected abstract StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey var1, String[][] var2, PreparedStatement var3, ResultSet var4, long var5, long var7, int var9, int var10) throws SQLException;

    protected abstract StaticProfileCaptureHelper.SqlStatementInfo recordBatchedQueryStmt_(SqlStatementKey var1, String[][] var2, PreparedStatement var3) throws SQLException;

    @Override
    public Statement getUnderlyingObject() {
        return this.physicalStatement_;
    }

    protected void initializeMetadataCorrelator(String string) {
        if (this.currentStates_.getProfilerHelperInstance() == null) {
            return;
        }
        this.metadataCorrelatorForMonitor_ = this.currentStates_.getProfilerHelperInstance().getMetadataCorrelator(SqlStatementKey.generateStmtKey(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false));
    }

    @Override
    public Object[] pullData(int n2) {
        if (310 == n2) {
            Object[] objectArray = new Object[]{this.metadataCorrelatorForMonitor_};
            return objectArray;
        }
        return null;
    }

    @Override
    public ExecutionHandler checkAndReplaceExecutionHandler() throws SQLException {
        return this;
    }

    @Override
    public void setDefStackTrcCaptured(boolean bl2) {
        this.defStackTrcCaptured_ = bl2;
    }

    @Override
    public void setDefinitionTraceInfo(String[][] stringArray) {
        this.definitionTraceInfo_ = stringArray;
    }

    @Override
    public void setIsParameterizedDynamicStatement(boolean bl2) {
        this.isParameterizedDynamicStatement_ = bl2;
    }

    @Override
    public void setIsPStmtAPI(boolean bl2) {
        this.isPStmtAPI_ = bl2;
    }

    public boolean isRepositoryConnection() {
        return this.connExecutionHandler_.isRepositoryConnection();
    }

    @Override
    public void setAndTransferModifiedStatementAttributes(ConnectionExecutionHandler.ModifiedStatementAttributes modifiedStatementAttributes) throws SQLException {
        this.modifiedStatementAttributes_ = modifiedStatementAttributes;
        this.modifiedStatementAttributes_.transferModifiedStatementAttributes(this.physicalStatement_);
    }

    @Override
    public void setCachedConnectionAttributes(ConnectionExecutionHandler.CachedConnectionAttributes cachedConnectionAttributes) {
        this.cachedConnectionAttributesForStatement_ = cachedConnectionAttributes;
    }

    protected static Method findMethod(Class clazz, String string, Class ... classArray) {
        try {
            if (DataProperties.runningUnderSecurityManager_) {
                return AccessController.doPrivileged(StatementExecutionHandler.findMethodPriv(clazz, string, classArray));
            }
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final PrivilegedExceptionAction<Method> findMethodPriv(final Class clazz, final String string, final Class ... classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return clazz.getMethod(string, classArray);
            }
        };
    }
}

