/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.generic;

import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.db.LiteralsInfo;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ParameterMetaDataExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.generic.GenericConnectionExecutionHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class GenericParameterMetaDataExecutionHandler
extends ParameterMetaDataExecutionHandler {
    public GenericParameterMetaDataExecutionHandler(StatementExecutionHandler statementExecutionHandler, ParameterMetaData parameterMetaData, LiteralsInfo literalsInfo) throws SQLException {
        super(statementExecutionHandler, parameterMetaData, literalsInfo);
    }

    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        Object object = null;
        try {
            if (string.equals("getParameterCount") && (objectArray != null && objectArray.length == 0 || objectArray == null)) {
                int n2 = this.literalsInfo_.getMappedParameterCount();
                object = new Integer(n2);
            } else if ((string.startsWith("get") || string.startsWith("is")) && objectArray != null && objectArray.length == 1 && objectArray[0] instanceof Integer) {
                int n3 = (Integer)objectArray[0];
                Integer n4 = this.literalsInfo_.getParameterMappedIndex(n3);
                if (n4 != null) {
                    objectArray[0] = n4;
                    object = method.invoke((Object)this.physicalParameterMetaData_, objectArray);
                } else {
                    GenericConnectionExecutionHandler genericConnectionExecutionHandler = (GenericConnectionExecutionHandler)this.parent_.connExecutionHandler_;
                    if (genericConnectionExecutionHandler.dummyStatementForLiteralSubstitution_ == null) {
                        genericConnectionExecutionHandler.dummyStatementForLiteralSubstitution_ = genericConnectionExecutionHandler.physicalConnection_.prepareCall("select 1 from dual");
                    }
                    if (genericConnectionExecutionHandler.dummyParameterMetaDataForLiteralSubstitution_ == null) {
                        genericConnectionExecutionHandler.dummyParameterMetaDataForLiteralSubstitution_ = genericConnectionExecutionHandler.dummyStatementForLiteralSubstitution_.getParameterMetaData();
                    }
                    object = method.invoke((Object)genericConnectionExecutionHandler.dummyParameterMetaDataForLiteralSubstitution_, objectArray);
                }
            } else {
                object = method.invoke((Object)this.physicalParameterMetaData_, objectArray);
            }
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            DataLogger.logThrowable(Log.getClientOptimizerLogger(), throwable);
            this.dumpLogs(throwable);
            throw throwable;
        }
    }

    protected boolean shouldDumpLogs(Throwable throwable) {
        if (this.isRepositoryConnection()) {
            return false;
        }
        String string = DataProperties.getProperty("pdq.dumpLogsOnSqlCodes");
        if (string != null) {
            return Log.isLoggable(throwable);
        }
        return false;
    }

    protected void dumpLogs(Throwable throwable) {
        if (this.shouldDumpLogs(throwable)) {
            Log.dumpRingBuffer(throwable);
        }
    }
}

