/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.ContactInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroup;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedData;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.parser.MetadataParser;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.AbstractMetadataListener;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.PDQDiffReportException;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.Constants;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PDQBaseModel;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PackageModel;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.StatementModel;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.OptionsProcessor;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.HTMLTemplateLoader;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class HTMLReportGenerator {
    private static final String REPORT_TITLE = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_TITLE_2", new Object[0]);
    private static final String CONTACT = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_CONTACT_2", new Object[0]);
    private static final String OPTIMIZATION_PRPTY = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_OPTIMIZATION_PROPERTIES_2", new Object[0]);
    private static final String BIND_PRPTY = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_BIND_PROPERTIES", new Object[0]);
    private static final String CONFIGURE_PRPTY = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_CONFIGURE_PROPERTIES", new Object[0]);
    private static final String ACTIVE = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_ACTIVE", new Object[0]);
    private static final String INACTIVE = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_INACTIVE", new Object[0]);
    private static final String NONE = Messages.getText("MSG_OPTIMIZER_REPSTRY_REPORT_NONE", new Object[0]);
    private HTMLTemplateLoader loader = new HTMLTemplateLoader();
    private ArtifactOptionsSet options = null;

    public HTMLReportGenerator() {
    }

    public HTMLReportGenerator(ArtifactOptionsSet artifactOptionsSet) {
        this.options = artifactOptionsSet;
    }

    public void generateReport(Connection connection, String string, Writer writer) throws MetadataException {
        try {
            RuntimeGroupManager runtimeGroupManager = ManagerFactory.getRuntimeGroupManager(connection, string);
            this.printHtml(writer, runtimeGroupManager, connection);
        }
        catch (Exception exception) {
            throw new MetadataException(exception);
        }
    }

    private StringBuilder printHtml(Writer writer, RuntimeGroupManager runtimeGroupManager, Connection connection) throws MetadataException, IOException, PDQDiffReportException, SQLException {
        List<RuntimeGroup> list = runtimeGroupManager.list();
        Collections.sort(list, new RuntimeGroupComparator());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.printRuntimeGroupsSummaryTable(list));
        stringBuilder.append((CharSequence)this.detailedTables(runtimeGroupManager, list));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("style", this.loader.load("cssStyle", new Hashtable<String, String>()));
        hashtable.put("script", this.loader.load("jscript", new Hashtable<String, String>()));
        hashtable.put("backtotop_id", "BackToTop");
        hashtable.put("save", Messages.getText("MSG_DIFFERENCE_REPORT_SAVE", new Object[0]));
        hashtable.put("title", REPORT_TITLE);
        String string = null;
        try {
            string = DateFormat.getDateTimeInstance(1, 1).format(Calendar.getInstance().getTime());
        }
        catch (Exception exception) {
            string = Calendar.getInstance().getTime().toString();
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = null;
        String string3 = null;
        if (connection != null) {
            string2 = connection.getMetaData().getURL();
            string3 = connection.getMetaData().getUserName();
        }
        this.printReportSummaryTitleHtml(Messages.getText("MSG_REPORT_CREATED_ON", new Object[0]), string, stringBuilder2);
        this.printReportSummaryTitleHtml(Messages.getText("MSG_REPORT_CREATED_BY", new Object[0]), string3, stringBuilder2);
        this.printReportSummaryTitleHtml(Messages.getText("MSG_DIFFERENCE_REPORT_REPOSITORY_CONNECTION_NAME", new Object[0]), string2, stringBuilder2);
        hashtable.put("report_summary", stringBuilder2.toString());
        hashtable.put("runtime_groups", stringBuilder.toString());
        writer.write(this.loader.load("runtimeGroup", hashtable));
        writer.close();
        return stringBuilder;
    }

    private void printReportSummaryTitleHtml(String string, String string2, StringBuilder stringBuilder) throws IOException {
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder2.append(String.format("%s:<br />", string));
        stringBuilder3.append(String.format("%s<br />", string2));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("headers1", stringBuilder2.toString());
        hashtable.put("values1", stringBuilder3.toString());
        hashtable.put("div_class", "");
        hashtable.put("table_class", "");
        hashtable.put("td_class1", "sub2DescrBold");
        hashtable.put("td_class2", "sub2Descr");
        stringBuilder.append(this.loader.load("packageSummaryTableDesc", hashtable));
    }

    private StringBuilder printRuntimeGroupsSummaryTable(List<RuntimeGroup> list) throws MetadataException, IOException {
        StringBuilder stringBuilder = this.printTableSubsection(list, this.loader);
        StringBuilder stringBuilder2 = null;
        StringBuilder stringBuilder3 = null;
        if (list.size() > 0) {
            stringBuilder2 = this.rgsSummaryTblHeaderRowHtml(this.loader);
            stringBuilder3 = this.rgsSummaryTblDataRowHtml(list, this.loader);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("title", Messages.getText("MSG_DIFFERENCE_REPORT_SUMMARY", new Object[0]));
        hashtable.put("id", "");
        hashtable.put("name", "");
        hashtable.put("backtotop_title", "");
        hashtable.put("backtotop_id", "");
        if (list.size() > 0) {
            hashtable.put("table", Constants.getTableHtml(this.loader, stringBuilder2, stringBuilder3).toString());
        }
        hashtable.put("sub_sec", stringBuilder.toString());
        hashtable.put("sub_desc", "");
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder4.append(this.loader.load("tableLayout", hashtable));
        if (list.size() > 0) {
            stringBuilder4.append("<h4>Runtime Group Version Details</h4>");
        } else {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("title", "");
            stringBuilder4.append(this.loader.load("tableLayout", hashtable2));
            stringBuilder4.append("<h4><CENTER>The repository does not contain any runtime groups.</CENTER></h4>");
        }
        return stringBuilder4;
    }

    private StringBuilder rgsSummaryTblHeaderRowHtml(HTMLTemplateLoader hTMLTemplateLoader) throws MetadataException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        hashtable.put("width", "15");
        hashtable.put("column_data", Messages.getText("MSG_REPORT_RUNTIME_GROUP", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_REPORT_RUNTIME_GROUP_VERSION", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_REPORT_VERSION_STATUS", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "65");
        hashtable.put("column_data", CONTACT);
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.clear();
        hashtable.put("table_row", stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder().append(hTMLTemplateLoader.load("tableRow", hashtable));
        return stringBuilder2;
    }

    private StringBuilder rgsSummaryTblDataRowHtml(List<RuntimeGroup> list, HTMLTemplateLoader hTMLTemplateLoader) throws MetadataException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.options != null ? this.options.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID) : null;
        String string2 = this.options != null ? this.options.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION) : null;
        for (RuntimeGroup runtimeGroup : list) {
            String string3;
            String string4 = runtimeGroup.getName();
            String string5 = runtimeGroup.getVersion();
            if ((string != null || string2 != null) && (string.compareTo(string4) != 0 || string2.compareTo(string5) != 0)) continue;
            String string6 = runtimeGroup.isActive() ? ACTIVE : INACTIVE;
            ContactInfo contactInfo = runtimeGroup.getContactInfo();
            String string7 = string3 = contactInfo == null ? NONE : contactInfo.getText();
            if (string3.equals("")) {
                string3 = NONE;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            hashtable.clear();
            String string8 = string4 + string5;
            String string9 = Constants.getRefLinkHtml(string8, string4);
            hashtable.put("column_data", string9);
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            hashtable.put("column_data", string5);
            stringBuilder2.append(hTMLTemplateLoader.load("tableNumericDataCell", hashtable));
            hashtable.put("column_data", string6);
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            hashtable.put("column_data", string3);
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            hashtable.clear();
            hashtable.put("table_row", stringBuilder2.toString());
            stringBuilder.append(hTMLTemplateLoader.load("tableRow", hashtable));
        }
        return stringBuilder;
    }

    private StringBuilder printTableSubsection(List<RuntimeGroup> list, HTMLTemplateLoader hTMLTemplateLoader) throws IOException {
        Comparable<Integer> comparable;
        Comparable<Integer> comparable2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Integer n2 = 0;
        Integer n3 = 0;
        for (RuntimeGroup object2 : list) {
            if (object2.isActive()) {
                comparable2 = n2;
                n2 = n2 + 1;
                comparable = n2;
                continue;
            }
            comparable2 = n3;
            n3 = n3 + 1;
            comparable = n3;
        }
        Integer n4 = n2 + n3;
        StringBuilder stringBuilder = new StringBuilder();
        comparable2 = new StringBuilder();
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_COUNT_RG_VERSION", new Object[0])));
        ((StringBuilder)comparable2).append(String.format("%s<br />", n2));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_COUNT_INACTIVE_RG_VERSION", new Object[0])));
        ((StringBuilder)comparable2).append(String.format("%s<br />", n3));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_COUNT_ACTIVE_RG_VERSION", new Object[0])));
        ((StringBuilder)comparable2).append(String.format("%s<br />", n4));
        hashtable.put("headers1", stringBuilder.toString());
        hashtable.put("values1", ((StringBuilder)comparable2).toString());
        hashtable.put("headers2", "");
        hashtable.put("values2", "");
        hashtable.put("div_class", "subSection");
        hashtable.put("table_class", "subSecTable");
        hashtable.put("td_class1", "sub1DescrBold");
        hashtable.put("td_class2", "sub1Descr");
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(hTMLTemplateLoader.load("packageTableSubsection", hashtable));
        return comparable;
    }

    private StringBuilder detailedTables(RuntimeGroupManager runtimeGroupManager, List<RuntimeGroup> list) throws IOException, MetadataException, PDQDiffReportException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.options != null ? this.options.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID) : null;
        String string2 = this.options != null ? this.options.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION) : null;
        for (RuntimeGroup runtimeGroup : list) {
            PDQBaseModel pDQBaseModel;
            String string3 = runtimeGroup.getName();
            String string4 = runtimeGroup.getVersion();
            if ((string != null || string2 != null) && (string.compareTo(string3) != 0 || string2.compareTo(string4) != 0)) continue;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append((CharSequence)this.detailedTableHmtl(runtimeGroupManager, runtimeGroup, RuntimeGroupManager.MemberType.PdqProps));
            stringBuilder2.append((CharSequence)this.detailedTableHmtl(runtimeGroupManager, runtimeGroup, RuntimeGroupManager.MemberType.BindProps));
            stringBuilder2.append((CharSequence)this.detailedTableHmtl(runtimeGroupManager, runtimeGroup, RuntimeGroupManager.MemberType.GenProps));
            HashSet<RuntimeGroupManager.MemberType> hashSet = new HashSet<RuntimeGroupManager.MemberType>();
            hashSet.add(RuntimeGroupManager.MemberType.PDQXML);
            Map<RuntimeGroupManager.MemberType, SavedData> map = runtimeGroupManager.getData(runtimeGroup.getName(), runtimeGroup.getVersion(), hashSet);
            SavedData savedData = map.get((Object)RuntimeGroupManager.MemberType.PDQXML);
            Collection<PDQBaseModel.StatementSetModel> collection = null;
            if (savedData != null && !(collection = (pDQBaseModel = new BasePDQXMLParser().process(savedData.getContentStream())).getPackageModels()).isEmpty()) {
                stringBuilder2.append((CharSequence)this.detailedPackagesTableHTML(collection));
                stringBuilder2.append((CharSequence)this.detailedTablePackageSummaryHmtl(collection));
            }
            hashtable.clear();
            hashtable.put("title", runtimeGroup.getName() + " (" + Messages.getText("MSG_REPORT_VERSION", new Object[0]) + ": " + runtimeGroup.getVersion() + ")");
            hashtable.put("id", runtimeGroup.getName() + runtimeGroup.getVersion());
            hashtable.put("name", "");
            hashtable.put("backtotop_title", Messages.getText("MSG_DIFFERENCE_REPORT_BACKTOTOP", new Object[0]));
            hashtable.put("backtotop_id", "BackToTop");
            hashtable.put("table", stringBuilder2.toString());
            hashtable.put("sub_sec", this.detailedTableSubsectionHtml(runtimeGroup, collection).toString());
            hashtable.put("sub_desc", "");
            stringBuilder.append(this.loader.load("tableLayout", hashtable));
        }
        return stringBuilder;
    }

    private StringBuilder detailedTableSubsectionHtml(RuntimeGroup runtimeGroup, Collection<PDQBaseModel.StatementSetModel> collection) throws IOException {
        Comparable<Integer> comparable;
        String string;
        String string2 = runtimeGroup.getVersion();
        String string3 = runtimeGroup.isActive() ? ACTIVE : INACTIVE;
        ContactInfo contactInfo = runtimeGroup.getContactInfo();
        String string4 = string = contactInfo == null ? NONE : contactInfo.getText();
        if (string.equals("")) {
            string = NONE;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_RUNTIME_GROUP_VERSION", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", string2));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_VERSION_STATUS", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", string3));
        stringBuilder.append(String.format("%s:<br />", CONTACT));
        stringBuilder2.append(String.format("%s<br />", string));
        stringBuilder3.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_TOTAL_PACKAGES", new Object[0])));
        if (collection != null) {
            stringBuilder4.append(String.format("%s<br />", collection.size()));
        } else {
            stringBuilder4.append(String.format("%s<br />", Messages.getText("MSG_REPORT_NO_PUREQUERY_XML_DATA_AVAILABLE", new Object[0])));
        }
        stringBuilder3.append(String.format("%s:<br />", Messages.getText("MSG_REPORT_TOTAL_SQL", new Object[0])));
        if (collection != null) {
            comparable = 0;
            for (PDQBaseModel.StatementSetModel statementSetModel : collection) {
                comparable = (Integer)comparable + statementSetModel.getStatements().size();
            }
            stringBuilder4.append(String.format("%s<br />", ((Integer)comparable).toString()));
        } else {
            stringBuilder4.append(String.format("%s<br />", Messages.getText("MSG_REPORT_NO_PUREQUERY_XML_DATA_AVAILABLE", new Object[0])));
        }
        hashtable.put("headers1", stringBuilder.toString());
        hashtable.put("values1", stringBuilder2.toString());
        hashtable.put("headers2", stringBuilder3.toString());
        hashtable.put("values2", stringBuilder4.toString());
        hashtable.put("div_class", "subSection");
        hashtable.put("table_class", "subSecTable");
        hashtable.put("td_class1", "sub1DescrBold");
        hashtable.put("td_class2", "sub1Descr");
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(this.loader.load("packageTableSubsection", hashtable));
        return comparable;
    }

    private StringBuilder detailedTableHmtl(RuntimeGroupManager runtimeGroupManager, RuntimeGroup runtimeGroup, RuntimeGroupManager.MemberType memberType) throws MetadataException, IOException {
        CharSequence charSequence;
        List<Object> list;
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        HashSet<RuntimeGroupManager.MemberType> hashSet = new HashSet<RuntimeGroupManager.MemberType>();
        hashSet.add(memberType);
        Map<RuntimeGroupManager.MemberType, SavedData> map = runtimeGroupManager.getData(runtimeGroup.getName(), runtimeGroup.getVersion(), hashSet);
        SavedData savedData = map.get((Object)memberType);
        if (savedData != null) {
            object = new BufferedReader(new InputStreamReader(savedData.getContentStream()));
            list = OptionsProcessor.parseOptionsFile(Tool.MANAGE_REPOSITORY, (BufferedReader)object, memberType.toString());
        } else {
            list = new ArrayList();
        }
        object = list.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = null;
        switch (memberType) {
            case PdqProps: {
                string = OPTIMIZATION_PRPTY;
                break;
            }
            case BindProps: {
                string = BIND_PRPTY;
                break;
            }
            case GenProps: {
                string = CONFIGURE_PRPTY;
            }
        }
        hashtable.put("width", "40");
        hashtable.put("column_data", string);
        stringBuilder2.append(this.loader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "60");
        hashtable.put("column_data", Messages.getText("MSG_REPORT_VALUE", new Object[0]));
        stringBuilder2.append(this.loader.load("tableHeaderCell", hashtable));
        hashtable.clear();
        hashtable.put("table_row", stringBuilder2.toString());
        stringBuilder.append(this.loader.load("tableRow", hashtable));
        StringBuilder stringBuilder3 = new StringBuilder();
        do {
            Object object2;
            charSequence = null;
            String string2 = null;
            if (list.isEmpty()) {
                charSequence = NONE;
                string2 = NONE;
            } else {
                object2 = (String[])object.next();
                charSequence = object2[0];
                string2 = object2[1];
            }
            object2 = new StringBuilder();
            hashtable.clear();
            hashtable.put("column_data", (String)charSequence);
            ((StringBuilder)object2).append(this.loader.load("tableDataCell", hashtable));
            hashtable.put("column_data", string2);
            ((StringBuilder)object2).append(this.loader.load("tableDataCell", hashtable));
            hashtable.clear();
            hashtable.put("table_row", ((StringBuilder)object2).toString());
            stringBuilder3.append(this.loader.load("tableRow", hashtable));
        } while (object.hasNext());
        charSequence = Constants.getTableHtml(this.loader, stringBuilder2, stringBuilder3);
        return charSequence;
    }

    private StringBuilder detailedPackagesTableHTML(Collection<PDQBaseModel.StatementSetModel> collection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("width", "15");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_COLLECTION", new Object[0]));
        stringBuilder.append(this.loader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "40");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_PACKAGE", new Object[0]));
        stringBuilder.append(this.loader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_VERSION", new Object[0]));
        stringBuilder.append(this.loader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "35");
        hashtable.put("column_data", Messages.getText("MSG_REPORT_SQL_COUNT", new Object[0]));
        stringBuilder.append(this.loader.load("tableHeaderCell", hashtable));
        hashtable.clear();
        hashtable.put("table_row", stringBuilder.toString());
        stringBuilder = new StringBuilder().append(this.loader.load("tableRow", hashtable));
        StringBuilder stringBuilder2 = new StringBuilder();
        for (PDQBaseModel.StatementSetModel statementSetModel : collection) {
            PackageModel packageModel = statementSetModel.getPackageModel();
            String string = packageModel.getPkgNameRoot();
            String string2 = packageModel.getDbPkgVersion();
            String string3 = packageModel.getCollectionId();
            String string4 = string3 + string + string2;
            String string5 = Constants.getRefLinkHtml(string4, string);
            Integer n2 = statementSetModel.getStatements().size();
            StringBuilder stringBuilder3 = new StringBuilder();
            hashtable.clear();
            hashtable.put("column_data", string3);
            stringBuilder3.append(this.loader.load("tableDataCell", hashtable));
            hashtable.put("column_data", string5);
            stringBuilder3.append(this.loader.load("tableDataCell", hashtable));
            hashtable.put("width", "10");
            hashtable.put("column_data", string2);
            stringBuilder3.append(this.loader.load("tableDataCell", hashtable));
            hashtable.put("column_data", n2.toString());
            stringBuilder3.append(this.loader.load("tableNumericDataCell", hashtable));
            hashtable.clear();
            hashtable.put("table_row", stringBuilder3.toString());
            stringBuilder2.append(this.loader.load("tableRow", hashtable));
        }
        StringBuilder stringBuilder4 = Constants.getTableHtml(this.loader, stringBuilder, stringBuilder2);
        return stringBuilder4;
    }

    private StringBuilder detailedTablePackageSummaryHmtl(Collection<PDQBaseModel.StatementSetModel> collection) throws MetadataException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (PDQBaseModel.StatementSetModel statementSetModel : collection) {
                PackageModel packageModel = statementSetModel.getPackageModel();
                String string = packageModel.getPkgNameRoot();
                String string2 = packageModel.getDbPkgVersion();
                String string3 = packageModel.getCollectionId();
                StringBuilder stringBuilder2 = new StringBuilder();
                PossibleArgs.PredefinedOptionValues predefinedOptionValues = this.options != null ? this.options.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.REPORT_LENGTH) : null;
                StringBuilder stringBuilder3 = new StringBuilder();
                if (predefinedOptionValues != null && predefinedOptionValues.compareTo(PossibleArgs.PredefinedOptionValues.SHORT) == 0) continue;
                hashtable.put("width", "10");
                hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_SECTION_NUMBER", new Object[0]));
                stringBuilder2.append(this.loader.load("tableHeaderCell", hashtable));
                hashtable.put("width", "90");
                if (string2.equalsIgnoreCase("")) {
                    string2 = "\"\"";
                }
                hashtable.put("column_data", Constants.getRefNameHtml(string3 + string + string2, Messages.getText("MSG_REPORT_SQL_TABLE_HEADER", string, string2, string3)));
                stringBuilder2.append(this.loader.load("tableHeaderCell", hashtable));
                hashtable.clear();
                hashtable.put("table_row", stringBuilder2.toString());
                stringBuilder2 = new StringBuilder().append(this.loader.load("tableRow", hashtable));
                Collection<StatementModel> collection2 = statementSetModel.getStatements();
                for (StatementModel statementModel : collection2) {
                    StringBuilder stringBuilder4 = new StringBuilder();
                    String string4 = statementModel.getSql();
                    String string5 = statementModel.getProcessedSql();
                    String string6 = statementModel.getSectionNumber();
                    hashtable.clear();
                    hashtable.put("column_data", string6);
                    stringBuilder4.append(this.loader.load("tableNumericDataCell", hashtable));
                    if (string5 != null && !string5.equals("")) {
                        hashtable.put("id", "");
                        hashtable.put("parent_node", string4);
                        hashtable.put("child_node", string5);
                        stringBuilder4.append(this.loader.load("twistyTableColumn", hashtable));
                    } else {
                        hashtable.put("column_data", string4);
                        stringBuilder4.append(this.loader.load("tableDataCell", hashtable));
                    }
                    hashtable.clear();
                    hashtable.put("table_row", stringBuilder4.toString());
                    stringBuilder3.append(this.loader.load("tableRow", hashtable));
                }
                stringBuilder.append((CharSequence)Constants.getTableHtml(this.loader, stringBuilder2, stringBuilder3));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder;
    }

    public void generateReport(Connection connection, String string, String string2) throws MetadataException {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8");
            this.generateReport(connection, string, writer);
        }
        catch (Exception exception) {
            throw new MetadataException(exception);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    throw new MetadataException(iOException);
                }
            }
        }
    }

    public class BasePDQXMLParser
    extends AbstractMetadataListener {
        private PDQBaseModel model = null;

        @Override
        protected void process(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
            this.model.includeStatement(string4, string3, string6, string5, string, string2, string8, string7, string9, string10, string11);
        }

        public PDQBaseModel process(InputStream inputStream) throws PDQDiffReportException {
            try {
                MetadataParser metadataParser = new MetadataParser();
                this.model = new PDQBaseModel();
                metadataParser.parse(inputStream, this, true);
            }
            catch (Exception exception) {
                String string = Messages.getText("ERR_PROFILER_CAPTURE_FILE_NOT_PARSEABLE", "");
                throw new PDQDiffReportException(string, exception);
            }
            return this.model;
        }
    }

    private class RuntimeGroupComparator
    implements Comparator<RuntimeGroup> {
        private RuntimeGroupComparator() {
        }

        @Override
        public int compare(RuntimeGroup runtimeGroup, RuntimeGroup runtimeGroup2) {
            int n2 = runtimeGroup.getName().compareToIgnoreCase(runtimeGroup2.getName());
            if (n2 == 0) {
                n2 = runtimeGroup.getVersion().compareToIgnoreCase(runtimeGroup2.getVersion());
            }
            return n2;
        }
    }
}

