/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.ConnectionImpl;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class Reply {
    private ByteBuffer envelopeByteBuffer_ = ByteBuffer.allocate(255);
    private String currentProcessorType_ = "";
    private int payloadLength = 0;
    private int type_ = 0;
    private ConnectionImpl connection_ = null;

    public Reply(ConnectionImpl connectionImpl) {
        this.connection_ = connectionImpl;
    }

    public int getType() {
        return this.type_;
    }

    private synchronized void parseEnvelopeHeader() throws IOException {
        String string;
        this.payloadLength = this.readLength(this.envelopeByteBuffer_);
        this.read(this.envelopeByteBuffer_, 1);
        if (this.envelopeByteBuffer_.get() != -47) {
            throw new IOException("Protocol error - invalid format byte");
        }
        this.read(this.envelopeByteBuffer_, 1);
        this.type_ = this.envelopeByteBuffer_.get();
        this.read(this.envelopeByteBuffer_, 1);
        byte by2 = this.envelopeByteBuffer_.get();
        this.read(this.envelopeByteBuffer_, by2);
        CharBuffer charBuffer = JSONHelper.decodeJSONMessage(this.envelopeByteBuffer_);
        this.currentProcessorType_ = string = charBuffer.toString();
    }

    public Message parseReply() throws IOException {
        this.parseEnvelopeHeader();
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.payloadLength);
        for (int i10 = 0; i10 < this.payloadLength; i10 += this.fillBuffer(byteBuffer)) {
        }
        byteBuffer.flip();
        Message message = new Message(this.currentProcessorType_, byteBuffer);
        return message;
    }

    private IOException createIOException(String string) {
        try {
            this.connection_.getSocketChannel().close();
            this.connection_.getSocketChannel().socket().close();
        }
        catch (IOException iOException) {
            return new IOException(iOException.getMessage());
        }
        return new IOException(string);
    }

    protected int fillBuffer(ByteBuffer byteBuffer) throws IOException {
        int n2 = 0;
        try {
            n2 = this.connection_.getSocketChannel().read(byteBuffer);
            if (n2 == -1) {
                throw this.createIOException("socket closed, no bytes read.");
            }
        }
        catch (IOException iOException) {
            throw this.createIOException("socket closed");
        }
        return n2;
    }

    private void read(ByteBuffer byteBuffer, int n2) throws IOException {
        byteBuffer.clear();
        byteBuffer.limit(n2);
        while (byteBuffer.position() < n2) {
            this.fillBuffer(byteBuffer);
        }
        byteBuffer.flip();
    }

    int readLength(ByteBuffer byteBuffer) throws IOException {
        this.read(byteBuffer, 2);
        if ((byteBuffer.get(0) & 0xFFFFFF80) == -128) {
            if (byteBuffer.get(1) == 4) {
                this.read(byteBuffer, 4);
                return byteBuffer.getInt();
            }
            throw new RuntimeException("length not supported");
        }
        return byteBuffer.getShort();
    }
}

