/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.metadata;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransactionRule;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientProfileUtil {
    public static String CLIENT_INFO_PROPERTY_KEY_USER = "clientUser";
    public static String CLIENT_INFO_PROPERTY_KEY_WRKSTATION = "clientWorkstation";
    public static String CLIENT_INFO_PROPERTY_KEY_APPLICATION = "clientApplicationInformation";
    public static String CLIENT_INFO_PROPERTY_KEY_ACCOUNTING = "clientAccountingInformation";
    public static String JCC_GLOBAL_PROPERTY_PREFIX = "db2.jcc.";
    public static String JCC_GLOBAL_PROPERTY_OVERRIDE_PREFIX = "db2.jcc.override.";
    public static String JCC_GLOBAL_PROPERTY_DEFAULT_PREFIX = "db2.jcc.default.";
    public static Object globalPushdownLock_ = new Object();
    public static final String[] supportedDataSourceDynamicProperties = new String[]{"maxTransportObjects", "traceLevel", "traceTimer"};
    public static final String[] supportedGlobalDynamicProperties = new String[]{"minTransportObjects", "maxTransportObjects", "maxTransportObjectIdleTime", "maxTransportObjectWaitTime", "maxRefreshInterval"};
    public static final String[] supportedWASDataSourceOrPoolProperties = new String[]{"maxConnections", "connectionTimeout"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getTransactionProperties(Profile.DataSource objectArray, ClientInfo clientInfo, long l10, long l11, long l12) {
        Logger logger = Log.getCMXClientLogger();
        TransactionRule.Remapping[] remappingArray = null;
        TransactionRule.PenaltyBox[] penaltyBoxArray = null;
        ClientInfo clientInfo2 = null;
        Database database = null;
        Database database2 = null;
        Profile.Database database3 = null;
        boolean bl2 = false;
        long l13 = -1L;
        long l14 = -1L;
        long l15 = -1L;
        int n2 = 0;
        Object object = new Object();
        if (objectArray == null) {
            return ClientProfileUtil.getTransactionProperties(clientInfo, null, false);
        }
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            l15 = objectArray.getVersion();
            database2 = objectArray.getTargetDatabase();
            if (database2 != null) {
                l13 = database2.getVersion();
                l14 = database2.getVersionOfLastPhysicalLocationChange();
                database3 = database2.getDatabaseProfile();
                object = database2;
            }
            remappingArray = objectArray.getTransactionRemappingRules();
            Object object2 = object;
            synchronized (object2) {
                if (remappingArray == null && database3 != null) {
                    remappingArray = database3.getTransactionRemappingRules();
                }
                if (remappingArray != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Number of remapping rules: " + remappingArray.length);
                        for (n2 = 0; n2 < remappingArray.length; ++n2) {
                            logger.log(Level.FINEST, "Remap rule : " + (Object)((Object)remappingArray[n2].getFlavor()) + " ," + Arrays.toString(remappingArray[n2].getSubstringExtractionPatternsForClientInfo()) + " ," + Arrays.deepToString((Object[])remappingArray[n2].getSubstringExtractionPositionsForClientInfo()) + " ," + Arrays.toString(remappingArray[n2].getFinalClientInfoSubstitutionPatterns()) + " ," + Arrays.toString(remappingArray[n2].getConditionsOfSubstitution()) + " ," + Arrays.toString(remappingArray[n2].getClientInfoFieldsToIgnoreInKey()) + " ," + remappingArray[n2].getHashMap());
                        }
                    }
                    clientInfo2 = ClientProfileUtil.remapClientInfo(remappingArray, clientInfo);
                    bl2 = true;
                } else {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "No remap rule present. Using Original client info");
                    }
                    clientInfo2 = clientInfo;
                }
                penaltyBoxArray = objectArray.getTransactionPenaltyBoxRules();
                if ((penaltyBoxArray == null || penaltyBoxArray.length == 0) && database3 != null) {
                    penaltyBoxArray = database3.getTransactionPenaltyBoxRules();
                }
                if (penaltyBoxArray != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Number of penalty boxing rules: " + penaltyBoxArray.length);
                    }
                    for (n2 = 0; n2 < penaltyBoxArray.length; ++n2) {
                        if (penaltyBoxArray[n2] == null) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Penalty box rule " + n2 + ": " + (Object)((Object)penaltyBoxArray[n2].getFlavor()) + " ," + Arrays.toString(penaltyBoxArray[n2].getSubstringExtractionPatternsForClientInfo()) + " ," + Arrays.deepToString((Object[])penaltyBoxArray[n2].getSubstringExtractionPositionsForClientInfo()) + " ," + Arrays.toString(penaltyBoxArray[n2].getClientInfoFieldsToIgnore()) + " ," + penaltyBoxArray[n2].getHashMap());
                        }
                        if ((database = penaltyBoxArray[n2].getPenaltyBox(clientInfo2)) == null) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Using penalty box rule " + n2);
                        }
                        penaltyBoxArray[n2].incrNumberOfTimesApplied();
                        break;
                    }
                }
            }
            if (database == null) {
                database = objectArray.getRerouteDatabase();
                if (l13 > l10 && l14 == l11) {
                    database = database2;
                }
                if (database != null) {
                    objectArray.incrNumberOfTimesApplied();
                }
            }
            // ** MonitorExit[var24_18] (shouldn't be in output)
            objectArray2 = ClientProfileUtil.getTransactionProperties(clientInfo2, database, bl2);
            objectArray2[4] = l13;
            objectArray2[5] = l14;
            objectArray2[6] = l15;
            return objectArray2;
        }
    }

    private static ClientInfo remapClientInfo(TransactionRule.Remapping[] remappingArray, ClientInfo clientInfo) {
        Logger logger = Log.getCMXClientLogger();
        ClientInfo clientInfo2 = null;
        Object[] objectArray = new Object[1];
        for (int i10 = 0; i10 < remappingArray.length; ++i10) {
            objectArray[0] = false;
            if (remappingArray[i10] != null) {
                clientInfo2 = remappingArray[i10].remapClientInfo(clientInfo, objectArray);
                if (objectArray[0] != Boolean.valueOf("true")) continue;
                if (!logger.isLoggable(Level.FINEST)) break;
                logger.log(Level.FINEST, "ClientInfo Remapping rule substitution occured at index = " + i10);
                break;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ClientInfo Remapping rule is null at index = " + i10);
            }
            if (clientInfo2 != null) continue;
            clientInfo2 = clientInfo;
        }
        return clientInfo2;
    }

    private static Object[] getTransactionProperties(ClientInfo clientInfo, Database database, boolean bl2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray = new Object[7];
        if (bl2) {
            if (clientInfo.getUser() != null) {
                hashMap.put(CLIENT_INFO_PROPERTY_KEY_USER, clientInfo.getUser());
            }
            if (clientInfo.getWorkstation() != null) {
                hashMap.put(CLIENT_INFO_PROPERTY_KEY_WRKSTATION, clientInfo.getWorkstation());
            }
            if (clientInfo.getApplication() != null) {
                hashMap.put(CLIENT_INFO_PROPERTY_KEY_APPLICATION, clientInfo.getApplication());
            }
            if (clientInfo.getAccounting() != null) {
                hashMap.put(CLIENT_INFO_PROPERTY_KEY_ACCOUNTING, clientInfo.getAccounting());
            }
        }
        if (database != null) {
            objectArray[0] = database.getServerName();
            objectArray[1] = database.getPort();
            objectArray[2] = database.getDatabaseName();
        }
        objectArray[3] = hashMap;
        return objectArray;
    }

    public static PushDownError getPushDownError(Object[] objectArray, PushDownError.PushDownLevel pushDownLevel) {
        Logger logger = Log.getCMXClientLogger();
        if (((Boolean)objectArray[1]).booleanValue()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Pushdown error : " + (String)objectArray[0]);
            }
            return new PushDownError.UnrecognizedProperty((String)objectArray[0], pushDownLevel);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Pushdown SQLException error : " + (String)objectArray[0] + " SQLException :" + objectArray[2]);
        }
        return new PushDownError.SQLException((String)objectArray[0], pushDownLevel, (SQLException)objectArray[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getDataSourceDynamicProperties(Profile.DataSource dataSource) {
        String string = null;
        HashMap<String, String> hashMap = null;
        Profile.DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            HashMap<String, String> hashMap2 = dataSource.getJccDirectives();
            if (hashMap2 == null) {
                return null;
            }
            hashMap = new HashMap<String, String>();
            for (int i10 = 0; i10 < supportedDataSourceDynamicProperties.length; ++i10) {
                string = null;
                string = hashMap2.get(supportedDataSourceDynamicProperties[i10]);
                if (string == null) continue;
                hashMap.put(supportedDataSourceDynamicProperties[i10], string);
            }
            if (hashMap.containsKey("traceLevel") && !hashMap.containsKey("traceTimer")) {
                hashMap.put("traceTimer", "300");
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getWASOverrideProperties(Profile.DataSource dataSource) {
        String string = null;
        HashMap<String, String> hashMap = null;
        Profile.DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            HashMap<String, String> hashMap2 = dataSource.getWasDirectives();
            if (hashMap2 == null) {
                return null;
            }
            hashMap = new HashMap<String, String>();
            for (int i10 = 0; i10 < supportedWASDataSourceOrPoolProperties.length; ++i10) {
                string = null;
                string = hashMap2.get(supportedWASDataSourceOrPoolProperties[i10]);
                if (string == null) continue;
                hashMap.put(supportedWASDataSourceOrPoolProperties[i10], string);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getGlobalDynamicProperties(Profile.Driver driver) {
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = null;
        Profile.Driver driver2 = driver;
        synchronized (driver2) {
            HashMap<String, String> hashMap2 = driver.getJccDirectives();
            if (hashMap2 == null) {
                return null;
            }
            hashMap = new HashMap<String, String>();
            for (int i10 = 0; i10 < supportedGlobalDynamicProperties.length; ++i10) {
                string = null;
                string2 = supportedGlobalDynamicProperties[i10];
                string = hashMap2.get(supportedGlobalDynamicProperties[i10]);
                if (string == null) {
                    string2 = JCC_GLOBAL_PROPERTY_PREFIX + supportedGlobalDynamicProperties[i10];
                    string = hashMap2.get(string2);
                }
                if (string == null) continue;
                hashMap.put(JCC_GLOBAL_PROPERTY_PREFIX + supportedGlobalDynamicProperties[i10], string);
            }
        }
        return hashMap;
    }

    public static Properties getSpecialRegisters(Profile.DataSource dataSource) {
        Database database = null;
        Profile.Database database2 = null;
        if (dataSource != null && dataSource.getSpecialRegisters() != null) {
            return dataSource.getSpecialRegisters();
        }
        database = dataSource.getTargetDatabase();
        if (database != null && (database2 = database.getDatabaseProfile()) != null && database2.getSpecialRegisters() != null) {
            return database2.getSpecialRegisters();
        }
        return null;
    }
}

