/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.util.function.Supplier;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.lint.Linter;
import schemacrawler.tools.lint.LinterRegistry;

public final class LinterHelp
implements Supplier<String[]> {
    private final boolean generateMarkdown;

    public LinterHelp() {
        this(false);
    }

    public LinterHelp(boolean generateMarkdown) {
        this.generateMarkdown = generateMarkdown;
    }

    @Override
    public String[] get() {
        try {
            StringBuilder buffer = new StringBuilder(1024);
            if (this.generateMarkdown) {
                this.printMarkdownHeader(buffer);
            } else {
                this.printHelpHeader(buffer);
            }
            LinterRegistry registry = new LinterRegistry();
            for (String linterId : registry) {
                Linter linter = registry.newLinter(linterId);
                if (this.generateMarkdown) {
                    this.printMarkdownLinterHeader(buffer, linter);
                } else {
                    this.printLinterHeader(buffer, linter);
                }
                buffer.append(linter.getDescription()).append(System.lineSeparator()).append(System.lineSeparator());
            }
            return new String[]{buffer.toString()};
        }
        catch (SchemaCrawlerException e) {
            return new String[0];
        }
    }

    private void printHelpHeader(StringBuilder buffer) {
        buffer.append(System.lineSeparator()).append("Available SchemaCrawler linters:").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printLinterHeader(StringBuilder buffer, Linter linter) {
        buffer.append("Linter: ").append(linter.getLinterId()).append(System.lineSeparator());
    }

    private void printMarkdownHeader(StringBuilder buffer) {
        buffer.append(System.lineSeparator()).append("## Lint Checks").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printMarkdownLinterHeader(StringBuilder buffer, Linter linter) {
        buffer.append("### Linter: *").append(linter.getLinterId()).append("*  ").append(System.lineSeparator());
    }
}

