/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetUTF;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    CharacterSetByte(int id) {
        super(id);
        this.rep = 1;
    }

    @Override
    public boolean isLossyFrom(CharacterSet from) {
        return from.rep != 1;
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        return source.rep <= 1024;
    }

    @DisableTrace
    private String toString(byte[] bytes, int offset, int count, char replacement) throws SQLException {
        try {
            return new String(bytes, offset, count, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 183).fillInStackTrace();
        }
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            return this.toString(bytes, offset, count, '?');
        }
        catch (SQLException ex) {
            throw new Error("CharacterSetByte.toString");
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        return this.toString(bytes, offset, count);
    }

    @Override
    public byte[] convert(String s2) throws SQLException {
        int sLength = s2.length();
        char[] chars = new char[s2.length()];
        s2.getChars(0, sLength, chars, 0);
        return CharacterSetByte.charsToBytes(chars, (byte)0);
    }

    @Override
    public byte[] convertWithReplacement(String s2) {
        int sLength = s2.length();
        char[] chars = new char[s2.length()];
        s2.getChars(0, sLength, chars, 0);
        try {
            return CharacterSetByte.charsToBytes(chars, (byte)63);
        }
        catch (SQLException ex) {
            return new byte[0];
        }
    }

    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        byte[] result;
        if (from.rep == 1) {
            result = CharacterSetByte.useOrCopy(source, offset, count);
        } else if (from.rep == 2) {
            char[] chars = CharacterSetUTF.UTFToJavaChar(source, offset, count);
            result = CharacterSetByte.charsToBytes(chars, (byte)0);
        } else {
            String s2 = from.toString(source, offset, count);
            char[] chars = s2.toCharArray();
            result = CharacterSetByte.charsToBytes(chars, (byte)0);
        }
        return result;
    }

    @Override
    int decode(CharacterWalker walker) {
        int c2 = walker.bytes[walker.next] & 0xFF;
        ++walker.next;
        return c2;
    }

    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        CharacterSetByte.need(buffer, 1);
        if (c2 < 256) {
            buffer.bytes[buffer.next] = (byte)c2;
            ++buffer.next;
        }
    }

    static byte[] charsToBytes(char[] chars, byte replacement) throws SQLException {
        byte[] bytes = new byte[chars.length];
        for (int x2 = 0; x2 < chars.length; ++x2) {
            if (chars[x2] > '\u00ff') {
                bytes[x2] = replacement;
                if (replacement != 0) continue;
                CharacterSetByte.failCharacterConversion(CharacterSet.make(31));
                continue;
            }
            bytes[x2] = (byte)chars[x2];
        }
        return bytes;
    }

    static {
        try {
            $$$methodRef$$$8 = CharacterSetByte.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = CharacterSetByte.class.getDeclaredMethod("charsToBytes", char[].class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = CharacterSetByte.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CharacterSetByte.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CharacterSetByte.class.getDeclaredMethod("convert", CharacterSet.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CharacterSetByte.class.getDeclaredMethod("convertWithReplacement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CharacterSetByte.class.getDeclaredMethod("convert", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CharacterSetByte.class.getDeclaredMethod("isConvertibleFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CharacterSetByte.class.getDeclaredMethod("isLossyFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

