/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public final class MonetClob
implements Clob,
Serializable,
Comparable<MonetClob> {
    private final StringBuilder buffer;

    public MonetClob(String in) {
        this.buffer = in != null ? new StringBuilder(in) : null;
    }

    public MonetClob(char[] toParse, int startPosition, int count) {
        this.buffer = new StringBuilder(new String(toParse, startPosition, count));
    }

    private void checkBufIsNotNull() throws SQLException {
        if (this.buffer == null) {
            throw new SQLException("This MonetClob has been freed", "M1M20");
        }
    }

    @Override
    public void free() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw MonetWrapper.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkBufIsNotNull();
        return new StringReader(this.buffer.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkBufIsNotNull();
        if (pos < 1L || pos > (long)this.buffer.length()) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (length < 0L || pos - 1L + length > (long)this.buffer.length()) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        return new StringReader(this.getSubString(pos, (int)length));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkBufIsNotNull();
        if (pos < 1L || pos > (long)this.buffer.length()) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (length < 0 || pos - 1L + (long)length > (long)this.buffer.length()) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        try {
            return this.buffer.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M1M05");
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buffer.length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            throw new SQLException("Missing searchstr object", "M1M05");
        }
        return this.position(searchstr.toString(), start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.checkBufIsNotNull();
        if (searchstr == null) {
            throw new SQLException("Missing searchstr object", "M1M05");
        }
        if (start < 1L || start > (long)this.buffer.length()) {
            throw new SQLException("Invalid start value: " + start, "M1M05");
        }
        return this.buffer.indexOf(searchstr, (int)(start - 1L));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw MonetWrapper.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw MonetWrapper.newSQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (str == null) {
            throw new SQLException("Missing str object", "M1M05");
        }
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkBufIsNotNull();
        if (str == null) {
            throw new SQLException("Missing str object", "M1M05");
        }
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (offset < 0 || offset > str.length()) {
            throw new SQLException("Invalid offset value: " + offset, "M1M05");
        }
        if (len < 1 || offset + len > str.length()) {
            throw new SQLException("Invalid len value: " + len, "M1M05");
        }
        int ipos = (int)pos;
        if (ipos + len > this.buffer.capacity()) {
            this.buffer.ensureCapacity(ipos + len);
        }
        this.buffer.replace(ipos - 1, ipos + len, str.substring(offset, offset + len));
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkBufIsNotNull();
        if (len < 0L || len > (long)this.buffer.length()) {
            throw new SQLException("Invalid len value: " + len, "M1M05");
        }
        this.buffer.delete((int)len, this.buffer.length());
    }

    public String toString() {
        if (this.buffer == null || this.buffer.length() == 0) {
            return "null";
        }
        return this.buffer.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof MonetClob && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        if (this.buffer == null || this.buffer.length() == 0) {
            return 0;
        }
        return this.buffer.toString().hashCode();
    }

    @Override
    public int compareTo(MonetClob o) {
        return this.toString().compareTo(o.toString());
    }
}

