/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection.mapi;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import nl.cwi.monetdb.mcl.connection.helpers.BufferReallocator;
import nl.cwi.monetdb.mcl.connection.mapi.MapiConnection;

public abstract class AbstractSocket
implements Closeable {
    protected final Socket socket;
    protected final MapiConnection connection;
    private final ByteBuffer bufferIn;
    private final ByteBuffer bufferOut;
    private final CharBuffer stringsDecoded;
    private final CharBuffer stringsEncoded;
    private final CharsetEncoder utf8Encoder = StandardCharsets.UTF_8.newEncoder();
    private final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder();

    AbstractSocket(String hostname, int port, MapiConnection connection) throws IOException {
        this.socket = new Socket(hostname, port);
        this.connection = connection;
        this.bufferIn = ByteBuffer.wrap(new byte[this.getFullBlockSize()]);
        this.bufferOut = ByteBuffer.wrap(new byte[this.getFullBlockSize()]);
        this.stringsDecoded = CharBuffer.allocate(this.getFullBlockSize());
        ((Buffer)this.stringsDecoded).flip();
        this.stringsEncoded = CharBuffer.allocate(this.getFullBlockSize());
    }

    int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    void setSoTimeout(int s) throws SocketException {
        this.socket.setSoTimeout(s);
    }

    void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    void setSocketChannelEndianness(ByteOrder bo) {
        this.bufferIn.order(bo);
        this.bufferOut.order(bo);
    }

    public abstract int getFullBlockSize();

    public abstract int getBlockSize();

    abstract int readToBufferIn(ByteBuffer var1) throws IOException;

    abstract int writeFromBufferOut(ByteBuffer var1) throws IOException;

    abstract void flush() throws IOException;

    private void readToInputBuffer() throws IOException {
        int read = this.readToBufferIn(this.bufferIn);
        if (read == 0) {
            throw new IOException("The server has reached EOF!");
        }
        this.stringsDecoded.clear();
        this.utf8Decoder.reset();
        this.utf8Decoder.decode(this.bufferIn, this.stringsDecoded, true);
        this.utf8Decoder.flush(this.stringsDecoded);
        ((Buffer)this.stringsDecoded).flip();
    }

    public CharBuffer readLine(CharBuffer lineBuffer) throws IOException {
        lineBuffer.clear();
        boolean found = false;
        char[] sourceArray = this.stringsDecoded.array();
        int sourcePosition = this.stringsDecoded.position();
        int sourceLimit = this.stringsDecoded.limit();
        char[] destinationArray = lineBuffer.array();
        int destinationPosition = 0;
        int destinationLimit = lineBuffer.limit();
        while (!found) {
            char c;
            if (sourcePosition >= sourceLimit) {
                this.stringsDecoded.position(sourcePosition);
                this.readToInputBuffer();
                sourceArray = this.stringsDecoded.array();
                sourcePosition = 0;
                sourceLimit = this.stringsDecoded.limit();
            }
            if ((c = sourceArray[sourcePosition++]) == '\n') {
                found = true;
                continue;
            }
            if (destinationPosition + 1 >= destinationLimit) {
                lineBuffer = BufferReallocator.reallocateBuffer(lineBuffer);
                destinationArray = lineBuffer.array();
                destinationLimit = lineBuffer.limit();
            }
            destinationArray[destinationPosition++] = c;
        }
        this.stringsDecoded.position(sourcePosition);
        lineBuffer.position(destinationPosition);
        ((Buffer)lineBuffer).flip();
        return lineBuffer;
    }

    private void writeToOutputBuffer(boolean toFlush) throws IOException {
        CoderResult res;
        ((Buffer)this.stringsEncoded).flip();
        this.utf8Encoder.reset();
        int written = 0;
        do {
            res = this.utf8Encoder.encode(this.stringsEncoded, this.bufferOut, false);
            written += this.writeFromBufferOut(this.bufferOut);
        } while (res == CoderResult.OVERFLOW);
        this.utf8Encoder.encode(this.stringsEncoded, this.bufferOut, true);
        this.utf8Encoder.flush(this.bufferOut);
        this.stringsEncoded.clear();
        this.bufferOut.clear();
        if ((written += this.writeFromBufferOut(this.bufferOut)) == 0) {
            throw new IOException("The query could not be sent to the server!");
        }
        if (toFlush) {
            this.flush();
        }
    }

    private void writeNextBlock(String line) throws IOException {
        int limit = line.length();
        int destinationPosition = this.stringsEncoded.position();
        int destinationCapacity = this.stringsEncoded.capacity();
        char[] destinationArray = this.stringsEncoded.array();
        for (int i = 0; i < limit; ++i) {
            if (destinationPosition >= destinationCapacity) {
                this.stringsEncoded.position(destinationPosition);
                this.writeToOutputBuffer(false);
                destinationArray = this.stringsEncoded.array();
                destinationPosition = 0;
            }
            destinationArray[destinationPosition++] = line.charAt(i);
        }
        this.stringsEncoded.position(destinationPosition);
    }

    public void writeNextLine(String prefix, String line, String suffix) throws IOException {
        if (prefix != null) {
            this.writeNextBlock(prefix);
        }
        this.writeNextBlock(line);
        if (suffix != null) {
            this.writeNextBlock(suffix);
        }
        this.writeToOutputBuffer(true);
    }
}

