/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.responses;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.mcl.connection.helpers.GregorianCalendarParser;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.IIncompleteResponse;

public abstract class AbstractDataBlockResponse
implements IIncompleteResponse {
    public final AbstractProtocol protocol;
    public int blockLine;
    public final int rowcount;
    public final int[] jdbcSQLTypes;
    public final String[] types;
    public boolean lastReadWasNull = true;

    public AbstractDataBlockResponse(int rowcount, AbstractProtocol protocol, int[] JdbcSQLTypes, String[] types) {
        this.rowcount = rowcount;
        this.protocol = protocol;
        this.jdbcSQLTypes = JdbcSQLTypes;
        this.types = types;
    }

    @Override
    public abstract boolean wantsMore();

    @Override
    public abstract void addLines(AbstractProtocol var1) throws ProtocolException;

    void setBlockLine(int blockLine) {
        this.blockLine = blockLine;
    }

    public boolean isLastReadWasNull() {
        return this.lastReadWasNull;
    }

    public abstract boolean getBooleanValue(int var1);

    public abstract byte getByteValue(int var1);

    public abstract short getShortValue(int var1);

    public abstract int getIntValue(int var1);

    public abstract long getLongValue(int var1);

    public abstract float getFloatValue(int var1);

    public abstract double getDoubleValue(int var1);

    public abstract Object getObjectValue(int var1) throws ProtocolException;

    public abstract String getValueAsString(int var1) throws ProtocolException;

    public abstract Object getValueAsObject(int var1) throws ProtocolException;

    public Calendar getDateValueFromString(MonetResultSet mrs, int column, int jdbcType) throws SQLException {
        try {
            SimpleDateFormat aux;
            String value = this.getObjectValue(column).toString();
            switch (jdbcType) {
                case 91: {
                    aux = this.protocol.getMonetDate();
                    break;
                }
                case 92: 
                case 2013: {
                    aux = this.protocol.getMonetTimePrinter();
                    break;
                }
                case 93: 
                case 2014: {
                    aux = this.protocol.getMonetTimestampPrinter();
                    break;
                }
                default: {
                    throw new SQLException("Internal error!", "M1M05");
                }
            }
            return GregorianCalendarParser.parseDateString(mrs, value, this.protocol.getMonetParserPosition(), aux, jdbcType);
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
    }

    public abstract int getLastNanos();
}

