/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.AuthMech;
import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.PluginProfilesConfigFile;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.AmazonRedshiftClientBuilder;
import com.amazonaws.services.redshift.model.AuthenticationProfile;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.DescribeAuthenticationProfilesRequest;
import com.amazonaws.services.redshift.model.DescribeAuthenticationProfilesResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.Endpoint;
import com.amazonaws.services.redshift.model.GetClusterCredentialsRequest;
import com.amazonaws.services.redshift.model.GetClusterCredentialsResult;
import com.amazonaws.services.redshiftinternal.AmazonRedshiftInternalClient;
import com.amazonaws.services.redshiftinternal.AmazonRedshiftInternalClientBuilder;
import com.amazonaws.services.redshiftinternal.model.GetClusterCredentialsWithIAMRequest;
import com.amazonaws.services.redshiftinternal.model.GetClusterCredentialsWithIAMResult;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class IamHelper {
    private static final int MAX_AMAZONCLIENT_RETRY = 5;
    private static final int MAX_AMAZONCLIENT_RETRY_DELAY_MS = 1000;
    private static final String KEY_PREFERRED_ROLE = "preferred_role";
    private static final String KEY_ROLE_SESSION_NAME = "roleSessionName";
    private static final String KEY_ROLE_ARN = "roleArn";
    public static final int SAML_PLUGIN = 1;
    public static final int JWT_PLUGIN = 2;
    public static final int GET_CLUSTER_CREDENTIALS_V1_API = 1;
    public static final int GET_CLUSTER_CREDENTIALS_IAM_V2_API = 2;
    public static final int GET_CLUSTER_CREDENTIALS_SAML_V2_API = 3;
    public static final int GET_CLUSTER_CREDENTIALS_JWT_V2_API = 4;
    private static Map<String, GetClusterCredentialsResult> credentialsCache = new HashMap<String, GetClusterCredentialsResult>();
    private static Map<String, GetClusterCredentialsWithIAMResult> credentialsV2Cache = new HashMap<String, GetClusterCredentialsWithIAMResult>();

    private IamHelper() {
    }

    public static Properties setIAMProperties(Properties info, RedshiftJDBCSettings settings, RedshiftLogger log) throws RedshiftException {
        try {
            String profile;
            String password;
            if (settings.m_authMech == null || settings.m_authMech.ordinal() < AuthMech.VERIFY_CA.ordinal()) {
                settings.m_authMech = AuthMech.VERIFY_CA;
            }
            String iamAccessKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_ACCESS_KEY_ID.getName(), info);
            String iamSecretKey = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SECRET_ACCESS_KEY.getName(), info);
            String iamSessionToken = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_SESSION_TOKEN.getName(), info);
            String authProfile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AUTH_PROFILE.getName(), info);
            if (!StringUtils.isNullOrEmpty((String)authProfile)) {
                if (!StringUtils.isNullOrEmpty((String)iamAccessKey)) {
                    Properties authProfileProps = IamHelper.readAuthProfile(authProfile, iamAccessKey, iamSecretKey, iamSessionToken, log, info);
                    if (authProfileProps != null) {
                        authProfileProps.putAll((Map<?, ?>)info);
                        info = authProfileProps;
                    }
                } else {
                    RedshiftException err = new RedshiftException(GT.tr("Dependent connection property setting for {0} is missing {1}", RedshiftProperty.AUTH_PROFILE.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
            }
            String clusterId = RedshiftConnectionImpl.getRequiredConnSetting(RedshiftProperty.CLUSTER_IDENTIFIER.getName(), info);
            String awsRegion = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_REGION.getName(), info);
            String endpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.ENDPOINT_URL.getName(), info);
            String stsEndpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.STS_ENDPOINT_URL.getName(), info);
            String userName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.UID.getName(), info);
            if (userName == null) {
                userName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.USER.getName(), info);
            }
            if ((password = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PWD.getName(), info)) == null) {
                password = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PASSWORD.getName(), info);
            }
            if ((profile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_PROFILE.getName(), info)) == null) {
                profile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_PROFILE.getName().toLowerCase(), info);
            }
            String iamDuration = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_DURATION.getName(), info);
            String iamCredentialProvider = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.CREDENTIALS_PROVIDER.getName(), info);
            String iamAutoCreate = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.USER_AUTOCREATE.getName(), info);
            String iamDbUser = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DB_USER.getName(), info);
            String iamDbGroups = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DB_GROUPS.getName(), info);
            String iamForceLowercase = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.FORCE_LOWERCASE.getName(), info);
            String iamGroupFederation = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.GROUP_FEDERATION.getName(), info);
            String dbName = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.DBNAME.getName(), info);
            String hosts = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.HOST.getName(), info);
            String ports = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.PORT.getName(), info);
            String iamDisableCache = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.IAM_DISABLE_CACHE.getName(), info);
            settings.m_clusterIdentifier = clusterId;
            if (settings.m_clusterIdentifier.isEmpty()) {
                RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.CLUSTER_IDENTIFIER.getName()), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            if (null != awsRegion) {
                settings.m_awsRegion = awsRegion.trim().toLowerCase();
            }
            settings.m_endpoint = null != endpointUrl ? endpointUrl : System.getProperty("redshift.endpoint-url");
            settings.m_stsEndpoint = null != stsEndpointUrl ? stsEndpointUrl : System.getProperty("sts.endpoint-url");
            if (null != userName) {
                settings.m_username = userName;
            }
            if (null != password) {
                settings.m_password = password;
            }
            if (null != profile) {
                settings.m_profile = profile;
            }
            if (null != iamDuration) {
                try {
                    settings.m_iamDuration = Integer.parseInt(iamDuration);
                    if (settings.m_iamDuration < 900 || settings.m_iamDuration > 3600) {
                        RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value or type range(900-3600) {0}", RedshiftProperty.IAM_DURATION.getName()), RedshiftState.UNEXPECTED_ERROR);
                        if (RedshiftLogger.isEnable()) {
                            log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                        }
                        throw err;
                    }
                }
                catch (NumberFormatException e) {
                    RedshiftException err = new RedshiftException(GT.tr("Invalid connection property value {0} : {1}", RedshiftProperty.IAM_DURATION.getName(), iamDuration), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, err.toString(), new Object[0]);
                    }
                    throw err;
                }
            }
            if (null != iamAccessKey) {
                settings.m_iamAccessKeyID = iamAccessKey;
            }
            if (null != iamSecretKey) {
                if (StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                    RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                settings.m_iamSecretKey = iamSecretKey;
                if (settings.m_iamSecretKey.isEmpty()) {
                    settings.m_iamSecretKey = settings.m_password;
                }
            } else {
                settings.m_iamSecretKey = settings.m_password;
            }
            if (null != iamSessionToken) {
                if (StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                    RedshiftException err = new RedshiftException(GT.tr("Missing connection property {0}", RedshiftProperty.IAM_ACCESS_KEY_ID.getName()), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                settings.m_iamSessionToken = iamSessionToken;
            }
            if (null != iamCredentialProvider) {
                settings.m_credentialsProvider = iamCredentialProvider;
            }
            Enumeration<?> enums = info.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                String value = info.getProperty(key);
                key = key.toLowerCase(Locale.getDefault());
                if ("*".equals(value)) continue;
                settings.m_pluginArgs.put(key, value);
            }
            settings.m_autocreate = iamAutoCreate == null ? null : Boolean.valueOf(iamAutoCreate);
            settings.m_iamDisableCache = iamDisableCache == null ? false : Boolean.valueOf(iamDisableCache);
            settings.m_forceLowercase = iamForceLowercase == null ? null : Boolean.valueOf(iamForceLowercase);
            settings.m_groupFederation = iamGroupFederation == null ? false : Boolean.valueOf(iamGroupFederation);
            if (null != iamDbUser) {
                settings.m_dbUser = iamDbUser;
            }
            settings.m_dbGroups = iamDbGroups != null ? Arrays.asList((settings.m_forceLowercase != null && settings.m_forceLowercase != false ? iamDbGroups.toLowerCase(Locale.getDefault()) : iamDbGroups).split(",")) : Collections.emptyList();
            settings.m_Schema = dbName;
            if (hosts != null) {
                settings.m_host = hosts;
            }
            if (ports != null) {
                settings.m_port = Integer.parseInt(ports);
            }
            IamHelper.setIAMCredentials(settings, log, authProfile);
            return info;
        }
        catch (RedshiftException re) {
            if (RedshiftLogger.isEnable()) {
                log.logError(re);
            }
            throw re;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void setIAMCredentials(RedshiftJDBCSettings settings, RedshiftLogger log, String authProfile) throws RedshiftException {
        providerType = CredentialProviderType.NONE;
        idpCredentialsRefresh = false;
        idpToken = null;
        if (!StringUtils.isNullOrEmpty((String)settings.m_credentialsProvider)) {
            if (!StringUtils.isNullOrEmpty((String)settings.m_profile)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.CREDENTIALS_PROVIDER.getName(), RedshiftProperty.AWS_PROFILE.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            if (StringUtils.isNullOrEmpty((String)authProfile) && !StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.CREDENTIALS_PROVIDER.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            try {
                clazz = Class.forName(settings.m_credentialsProvider).asSubclass(AWSCredentialsProvider.class);
                provider = clazz.newInstance();
                if (!(provider instanceof IPlugin)) ** GOTO lbl69
                plugin = (IPlugin)provider;
                providerType = CredentialProviderType.PLUGIN;
                plugin.setLogger(log);
                plugin.setGroupFederation(settings.m_groupFederation);
                for (Map.Entry<String, String> entry : settings.m_pluginArgs.entrySet()) {
                    pluginArgKey = entry.getKey();
                    plugin.addParameter(pluginArgKey, entry.getValue());
                    if ("preferred_role".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_preferredRole = entry.getValue();
                        continue;
                    }
                    if ("roleArn".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_roleArn = entry.getValue();
                        continue;
                    }
                    if ("roleSessionName".equalsIgnoreCase(pluginArgKey)) {
                        settings.m_roleSessionName = entry.getValue();
                        continue;
                    }
                    if (!RedshiftProperty.DB_GROUPS_FILTER.getName().equalsIgnoreCase(pluginArgKey)) continue;
                    settings.m_dbGroupsFilter = entry.getValue();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                err = new RedshiftException(GT.tr("Invalid credentials provider class {0}", new Object[]{settings.m_credentialsProvider}), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            catch (NumberFormatException e) {
                err = new RedshiftException(GT.tr("{0} : {1}", new Object[]{e.getMessage(), settings.m_credentialsProvider}), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        } else if (!StringUtils.isNullOrEmpty((String)settings.m_profile)) {
            if (StringUtils.isNullOrEmpty((String)authProfile) && !StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
                err = new RedshiftException(GT.tr("Conflict in connection property setting {0} and {1}", new Object[]{RedshiftProperty.AWS_PROFILE.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
            pcf = new PluginProfilesConfigFile(settings, log);
            provider = new ProfileCredentialsProvider((ProfilesConfigFile)pcf, settings.m_profile);
            providerType = CredentialProviderType.PROFILE;
        } else if (!StringUtils.isNullOrEmpty((String)settings.m_iamAccessKeyID)) {
            if (!StringUtils.isNullOrEmpty((String)settings.m_iamSessionToken)) {
                credentials = new BasicSessionCredentials(settings.m_iamAccessKeyID, settings.m_iamSecretKey, settings.m_iamSessionToken);
                providerType = CredentialProviderType.IAM_KEYS_WITH_SESSION;
            } else {
                credentials = new BasicAWSCredentials(settings.m_iamAccessKeyID, settings.m_iamSecretKey);
                providerType = CredentialProviderType.IAM_KEYS;
            }
            provider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        } else {
            provider = new DefaultAWSCredentialsProviderChain();
        }
lbl69:
        // 5 sources

        if (RedshiftLogger.isEnable()) {
            log.log(LogLevel.DEBUG, "IDP Credential Provider {0}:{1}", new Object[]{provider, settings.m_credentialsProvider});
        }
        if ((getClusterCredentialApiType = IamHelper.findTypeOfGetClusterCredentialsAPI(settings, providerType, (AWSCredentialsProvider)provider)) == 1 || getClusterCredentialApiType == 2) {
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "Calling provider.getCredentials()", new Object[0]);
            }
            if ((credentials = provider.getCredentials()) instanceof CredentialsHolder) {
                idpCredentialsRefresh = ((CredentialsHolder)credentials).isRefresh();
                im = ((CredentialsHolder)credentials).getMetadata();
                if (null != im) {
                    autoCreate = im.getAutoCreate();
                    dbUser = im.getDbUser();
                    samlDbUser = im.getSamlDbUser();
                    profileDbUser = im.getProfileDbUser();
                    dbGroups = im.getDbGroups();
                    forceLowercase = im.getForceLowercase();
                    allowDbUserOverride = im.getAllowDbUserOverride();
                    if (null == settings.m_autocreate) {
                        settings.m_autocreate = autoCreate;
                    }
                    if (null == settings.m_forceLowercase) {
                        settings.m_forceLowercase = forceLowercase;
                    }
                    if (allowDbUserOverride) {
                        if (null != samlDbUser) {
                            settings.m_dbUser = samlDbUser;
                        } else if (null != dbUser) {
                            settings.m_dbUser = dbUser;
                        } else if (null != profileDbUser) {
                            settings.m_dbUser = profileDbUser;
                        }
                    } else if (null != dbUser) {
                        settings.m_dbUser = dbUser;
                    } else if (null != profileDbUser) {
                        settings.m_dbUser = profileDbUser;
                    } else if (null != samlDbUser) {
                        settings.m_dbUser = samlDbUser;
                    }
                    if (settings.m_dbGroups.isEmpty() && null != dbGroups) {
                        settings.m_dbGroups = Arrays.asList((settings.m_forceLowercase != false ? dbGroups.toLowerCase(Locale.getDefault()) : dbGroups).split(","));
                    }
                }
            }
            if ("*".equals(settings.m_username) && null == settings.m_dbUser) {
                err = new RedshiftException(GT.tr("Missing connection property {0}", new Object[]{RedshiftProperty.DB_USER.getName()}), RedshiftState.UNEXPECTED_ERROR);
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                }
                throw err;
            }
        } else {
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "groupFederation=" + settings.m_groupFederation, new Object[0]);
            }
            key = null;
            credentials = null;
            if (!settings.m_iamDisableCache) {
                key = IamHelper.getCredentialsV2CacheKey(settings, providerType, (AWSCredentialsProvider)provider, getClusterCredentialApiType);
                credentials = IamHelper.credentialsV2Cache.get(key);
            }
            if (credentials == null || credentials.getExpiration().before(new Date(System.currentTimeMillis() - 300000L))) {
                if (providerType == CredentialProviderType.PLUGIN) {
                    plugin = (IPlugin)provider;
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.DEBUG, "Calling plugin.getIdpToken()", new Object[0]);
                    }
                    idpToken = plugin.getIdpToken();
                }
                settings.m_idpToken = idpToken;
            }
        }
        IamHelper.setClusterCredentials((AWSCredentialsProvider)provider, settings, log, providerType, idpCredentialsRefresh, getClusterCredentialApiType);
    }

    private static void setClusterCredentials(AWSCredentialsProvider credProvider, RedshiftJDBCSettings settings, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh, int getClusterCredentialApiType) throws RedshiftException {
        try {
            if (getClusterCredentialApiType == 1) {
                AmazonRedshift client;
                AmazonRedshiftClientBuilder builder = AmazonRedshiftClientBuilder.standard();
                ClientConfiguration clientConfig = RequestUtils.getProxyClientConfig(log);
                if (clientConfig != null) {
                    builder.setClientConfiguration(clientConfig);
                }
                if (settings.m_endpoint != null) {
                    AwsClientBuilder.EndpointConfiguration cfg = new AwsClientBuilder.EndpointConfiguration(settings.m_endpoint, settings.m_awsRegion);
                    builder.setEndpointConfiguration(cfg);
                } else if (settings.m_awsRegion != null && !settings.m_awsRegion.isEmpty()) {
                    builder.setRegion(settings.m_awsRegion);
                }
                AmazonRedshift amazonRedshift = client = getClusterCredentialApiType == 1 || getClusterCredentialApiType == 2 ? (AmazonRedshift)((AmazonRedshiftClientBuilder)builder.withCredentials(credProvider)).build() : (AmazonRedshift)builder.build();
                if (null == settings.m_host || settings.m_port == 0) {
                    if (getClusterCredentialApiType == 1 || getClusterCredentialApiType == 2) {
                        DescribeClustersRequest req = new DescribeClustersRequest();
                        req.setClusterIdentifier(settings.m_clusterIdentifier);
                        DescribeClustersResult resp = client.describeClusters(req);
                        List clusters = resp.getClusters();
                        if (clusters.isEmpty()) {
                            throw new AmazonClientException("Failed to describeClusters.");
                        }
                        Cluster cluster = (Cluster)clusters.get(0);
                        Endpoint endpoint = cluster.getEndpoint();
                        if (null == endpoint) {
                            throw new AmazonClientException("Cluster is not fully created yet.");
                        }
                        settings.m_host = endpoint.getAddress();
                        settings.m_port = endpoint.getPort();
                    } else {
                        throw new AmazonClientException("Host or Port parameter is missing.");
                    }
                }
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.DEBUG, "Call V1 API of GetClusterCredentials", new Object[0]);
                }
                GetClusterCredentialsResult result = IamHelper.getClusterCredentialsResult(settings, client, log, providerType, idpCredentialsRefresh);
                settings.m_username = result.getDbUser();
                settings.m_password = result.getDbPassword();
                if (RedshiftLogger.isEnable()) {
                    Date now = new Date();
                    log.logInfo(now + ": Using GetClusterCredentialsResult with expiration " + result.getExpiration(), new Object[0]);
                }
            } else {
                AmazonRedshiftInternalClient client;
                AmazonRedshiftInternalClientBuilder builder = AmazonRedshiftInternalClientBuilder.standard();
                ClientConfiguration clientConfig = RequestUtils.getProxyClientConfig(log);
                if (clientConfig != null) {
                    builder.setClientConfiguration(clientConfig);
                }
                if (settings.m_endpoint != null) {
                    AwsClientBuilder.EndpointConfiguration cfg = new AwsClientBuilder.EndpointConfiguration(settings.m_endpoint, settings.m_awsRegion);
                    builder.setEndpointConfiguration(cfg);
                } else if (settings.m_awsRegion != null && !settings.m_awsRegion.isEmpty()) {
                    builder.setRegion(settings.m_awsRegion);
                }
                AmazonRedshiftInternalClient amazonRedshiftInternalClient = client = getClusterCredentialApiType == 1 || getClusterCredentialApiType == 2 ? (AmazonRedshiftInternalClient)((AmazonRedshiftInternalClientBuilder)builder.withCredentials(credProvider)).build() : (AmazonRedshiftInternalClient)builder.build();
                if (RedshiftLogger.isEnable()) {
                    log.log(LogLevel.DEBUG, "Call V2 API of GetClusterCredentials", new Object[0]);
                }
                GetClusterCredentialsWithIAMResult result = IamHelper.getClusterCredentialsResultV2(settings, client, log, providerType, idpCredentialsRefresh, credProvider, getClusterCredentialApiType);
                settings.m_username = result.getDbUser();
                settings.m_password = result.getDbPassword();
                if (RedshiftLogger.isEnable()) {
                    Date now = new Date();
                    log.logInfo(now + ": Using GetClusterCredentialsResultV2 with expiration " + result.getExpiration(), new Object[0]);
                    log.logInfo(now + ": Using GetClusterCredentialsResultV2 with TimeToRefresh " + result.getNextRefreshTime(), new Object[0]);
                }
            }
        }
        catch (AmazonClientException e) {
            RedshiftException err = new RedshiftException(GT.tr("IAM error retrieving temp credentials: {0}", e.getMessage()), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.ERROR, err.toString(), new Object[0]);
            }
            throw err;
        }
    }

    private static synchronized GetClusterCredentialsResult getClusterCredentialsResult(RedshiftJDBCSettings settings, AmazonRedshift client, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh) throws AmazonClientException {
        String key = null;
        GetClusterCredentialsResult credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsCacheKey(settings, providerType);
            credentials = credentialsCache.get(key);
        }
        if (credentials == null || providerType == CredentialProviderType.PLUGIN && idpCredentialsRefresh || credentials.getExpiration().before(new Date(System.currentTimeMillis() - 300000L))) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo("GetClusterCredentials NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.remove(key);
            }
            GetClusterCredentialsRequest request = new GetClusterCredentialsRequest();
            request.setClusterIdentifier(settings.m_clusterIdentifier);
            if (settings.m_iamDuration > 0) {
                request.setDurationSeconds(Integer.valueOf(settings.m_iamDuration));
            }
            request.setDbName(settings.m_Schema);
            request.setDbUser(settings.m_dbUser == null ? settings.m_username : settings.m_dbUser);
            request.setAutoCreate(settings.m_autocreate);
            request.setDbGroups(settings.m_dbGroups);
            if (RedshiftLogger.isEnable()) {
                log.logInfo(request.toString(), new Object[0]);
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    credentials = client.getClusterCredentials(request);
                    break;
                }
                catch (AmazonClientException ace) {
                    if (ace.getMessage().contains("Rate exceeded") && i < 4) {
                        if (RedshiftLogger.isEnable()) {
                            log.logInfo("getClusterCredentialsResult caught 'Rate exceeded' error...", new Object[0]);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    throw ace;
                }
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            log.logInfo("GetClusterCredentials from cache", new Object[0]);
        }
        return credentials;
    }

    private static synchronized GetClusterCredentialsWithIAMResult getClusterCredentialsResultV2(RedshiftJDBCSettings settings, AmazonRedshiftInternalClient client, RedshiftLogger log, CredentialProviderType providerType, boolean idpCredentialsRefresh, AWSCredentialsProvider provider, int getClusterCredentialApiType) throws AmazonClientException {
        String key = null;
        GetClusterCredentialsWithIAMResult credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsV2CacheKey(settings, providerType, provider, getClusterCredentialApiType);
            credentials = credentialsV2Cache.get(key);
        }
        if (credentials == null || providerType == CredentialProviderType.PLUGIN && settings.m_idpToken != null || credentials.getExpiration().before(new Date(System.currentTimeMillis() - 300000L))) {
            if (RedshiftLogger.isEnable()) {
                log.logInfo("GetClusterCredentialsV2 NOT from cache", new Object[0]);
            }
            GetClusterCredentialsWithIAMRequest iamRequest = null;
            if (!settings.m_iamDisableCache) {
                credentialsV2Cache.remove(key);
            }
            if (getClusterCredentialApiType == 2) {
                GetClusterCredentialsWithIAMRequest request;
                iamRequest = request = new GetClusterCredentialsWithIAMRequest();
                request.setClusterIdentifier(settings.m_clusterIdentifier);
                if (settings.m_iamDuration > 0) {
                    request.setDurationSeconds(Integer.valueOf(settings.m_iamDuration));
                }
                request.setDbName(settings.m_Schema);
                if (RedshiftLogger.isEnable()) {
                    log.logInfo(request.toString(), new Object[0]);
                }
            } else if (getClusterCredentialApiType == 3 || getClusterCredentialApiType == 4) {
                // empty if block
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    if (getClusterCredentialApiType != 2) break;
                    credentials = client.getClusterCredentialsWithIAM(iamRequest);
                    break;
                }
                catch (AmazonClientException ace) {
                    if (ace.getMessage().contains("Rate exceeded") && i < 4) {
                        if (RedshiftLogger.isEnable()) {
                            log.logInfo("getClusterCredentialsResultV2 caught 'Rate exceeded' error...", new Object[0]);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    throw ace;
                }
            }
            if (!settings.m_iamDisableCache) {
                credentialsV2Cache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            log.logInfo("GetClusterCredentialsV2 from cache", new Object[0]);
        }
        return credentials;
    }

    private static String getCredentialsCacheKey(RedshiftJDBCSettings settings, CredentialProviderType providerType) {
        String dbGroups = "";
        if (settings.m_dbGroups != null && !settings.m_dbGroups.isEmpty()) {
            Collections.sort(settings.m_dbGroups);
            dbGroups = String.join((CharSequence)",", settings.m_dbGroups);
        }
        String key = settings.m_clusterIdentifier + ";" + (settings.m_dbUser == null ? settings.m_username : settings.m_dbUser) + ";" + (settings.m_Schema == null ? "" : settings.m_Schema) + ";" + dbGroups + ";" + settings.m_autocreate + ";" + settings.m_iamDuration;
        switch (providerType) {
            case PROFILE: {
                key = key + ";" + settings.m_profile;
                break;
            }
            case IAM_KEYS_WITH_SESSION: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey + ";" + settings.m_iamSessionToken;
                break;
            }
            case IAM_KEYS: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey;
                break;
            }
        }
        return key;
    }

    private static Properties readAuthProfile(String authProfile, String iamAccessKeyID, String iamSecretKey, String iamSessionToken, RedshiftLogger log, Properties info) throws RedshiftException {
        Properties authProfileProps = null;
        String awsRegion = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AWS_REGION.getName(), info);
        String endpointUrl = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.ENDPOINT_URL.getName(), info);
        Object credentials = !StringUtils.isNullOrEmpty((String)iamSessionToken) ? new BasicSessionCredentials(iamAccessKeyID, iamSecretKey, iamSessionToken) : new BasicAWSCredentials(iamAccessKeyID, iamSecretKey);
        AWSStaticCredentialsProvider provider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        AmazonRedshiftClientBuilder builder = AmazonRedshiftClientBuilder.standard();
        ClientConfiguration clientConfig = RequestUtils.getProxyClientConfig(log);
        if (clientConfig != null) {
            builder.setClientConfiguration(clientConfig);
        }
        if (endpointUrl != null) {
            AwsClientBuilder.EndpointConfiguration cfg = new AwsClientBuilder.EndpointConfiguration(endpointUrl, awsRegion);
            builder.setEndpointConfiguration(cfg);
        } else if (awsRegion != null && !awsRegion.isEmpty()) {
            builder.setRegion(awsRegion);
        }
        AmazonRedshift client = (AmazonRedshift)((AmazonRedshiftClientBuilder)builder.withCredentials((AWSCredentialsProvider)provider)).build();
        DescribeAuthenticationProfilesRequest request = new DescribeAuthenticationProfilesRequest();
        request.setAuthenticationProfileName(authProfile);
        DescribeAuthenticationProfilesResult result = client.describeAuthenticationProfiles(request);
        String profileContent = ((AuthenticationProfile)result.getAuthenticationProfiles().get(0)).getAuthenticationProfileContent();
        authProfileProps = new Properties(info);
        JsonNode profileJson = Jackson.jsonNodeOf((String)profileContent);
        if (profileJson != null) {
            Iterator elements = profileJson.fields();
            while (elements.hasNext()) {
                Map.Entry element = (Map.Entry)elements.next();
                String key = (String)element.getKey();
                String val = ((JsonNode)element.getValue()).asText();
                authProfileProps.put(key, val);
            }
        } else {
            RedshiftException err = new RedshiftException(GT.tr("Auth profile JSON error", new Object[0]), RedshiftState.UNEXPECTED_ERROR);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.ERROR, err.toString(), new Object[0]);
            }
            throw err;
        }
        return authProfileProps;
    }

    private static String getCredentialsV2CacheKey(RedshiftJDBCSettings settings, CredentialProviderType providerType, AWSCredentialsProvider provider, int getClusterCredentialApiType) {
        String key = "";
        if (providerType == CredentialProviderType.PLUGIN) {
            IPlugin plugin = (IPlugin)provider;
            key = plugin.getCacheKey();
        }
        key = key + settings.m_clusterIdentifier + ";" + (settings.m_Schema == null ? "" : settings.m_Schema) + ";" + settings.m_iamDuration;
        if (getClusterCredentialApiType == 3) {
            if (settings.m_preferredRole != null) {
                key = key + settings.m_preferredRole + ";";
            }
            if (settings.m_dbGroupsFilter != null) {
                key = key + settings.m_dbGroupsFilter + ";";
            }
        } else if (getClusterCredentialApiType == 4) {
            if (settings.m_idpToken != null) {
                key = key + settings.m_idpToken + ";";
            }
            if (settings.m_roleArn != null) {
                key = key + settings.m_roleArn + ";";
            }
            if (settings.m_roleSessionName != null) {
                key = key + settings.m_roleSessionName + ";";
            }
        }
        switch (providerType) {
            case PROFILE: {
                key = key + ";" + settings.m_profile;
                break;
            }
            case IAM_KEYS_WITH_SESSION: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey + ";" + settings.m_iamSessionToken;
                break;
            }
            case IAM_KEYS: {
                key = key + ";" + settings.m_iamAccessKeyID + ";" + settings.m_iamSecretKey;
                break;
            }
        }
        return key;
    }

    private static int findTypeOfGetClusterCredentialsAPI(RedshiftJDBCSettings settings, CredentialProviderType providerType, AWSCredentialsProvider provider) {
        if (!settings.m_groupFederation.booleanValue()) {
            return 1;
        }
        if (providerType == CredentialProviderType.PROFILE) {
            throw new AmazonClientException("Authentication with profile is not supported for group federation");
        }
        if (providerType != CredentialProviderType.PLUGIN) {
            return 2;
        }
        IPlugin plugin = (IPlugin)provider;
        if (plugin.getSubType() == 1) {
            return 3;
        }
        if (plugin.getSubType() == 2) {
            return 4;
        }
        throw new AmazonClientException("Invalid plugin sub type:" + plugin.getSubType());
    }

    private static enum CredentialProviderType {
        NONE,
        PROFILE,
        IAM_KEYS_WITH_SESSION,
        IAM_KEYS,
        PLUGIN;

    }
}

