/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Objects;
import schemacrawler.testdb.SqlScript;

public class TestSchemaCreator
implements Runnable {
    private final Connection connection;
    private final String scriptsResource;

    public TestSchemaCreator(Connection connection, String scriptsResource) {
        this.connection = Objects.requireNonNull(connection, "No database connection provided");
        this.scriptsResource = Objects.requireNonNull(scriptsResource, "No script resource provided");
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TestSchemaCreator.class.getResourceAsStream(this.scriptsResource), StandardCharsets.UTF_8));){
            reader.lines().forEach(line -> new SqlScript((String)line, this.connection).run());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

