/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.sqlserver;

import java.io.IOException;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.tools.databaseconnector.DatabaseConnectionUrlBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;

public final class SqlServerDatabaseConnector
extends DatabaseConnector {
    public SqlServerDatabaseConnector() throws IOException {
        super(new DatabaseServerType("sqlserver", "Microsoft SQL Server"), url -> url != null && url.startsWith("jdbc:sqlserver:"), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/sqlserver.information_schema"), (schemaRetrievalOptionsBuilder, connection) -> {}, limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionRule(".*\\.dbo", "model\\..*|master\\..*|msdb\\..*|tempdb\\..*|rdsadmin\\..*")), () -> DatabaseConnectionUrlBuilder.builder((String)"jdbc:sqlserver://${host}:${port};databaseName=${database};applicationName=SchemaCrawler").withDefaultPort(1433));
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = super.getHelpCommand();
        pluginCommand.addOption("server", String.class, new String[]{"--server=mysql", "Loads SchemaCrawler plug-in for Microsoft SQL Server", "If you are using instance names, named pipes, or Windows authentication, you will need to provide a database connection URL on the SchemaCrawler command-line", "See https://www.schemacrawler.com/database-support.html"}).addOption("host", String.class, new String[]{"Host name", "Optional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number", "Optional, defaults to 1433"}).addOption("database", String.class, new String[]{"Database name", "Be sure to also restrict your schemas to this database, by using an additional option,", "--schemas=<database>.dbo"});
        return pluginCommand;
    }
}

