/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol.oldmapi;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.text.SimpleDateFormat;
import java.util.Map;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.mcl.connection.mapi.OldMapiSocket;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiDataBlockResponse;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiServerResponseParser;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiStartOfHeaderParser;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiTableHeaderParser;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiTupleLineParser;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.AutoCommitResponse;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;
import nl.cwi.monetdb.mcl.responses.UpdateResponse;

public class OldMapiProtocol
extends AbstractProtocol {
    private static final int TUPLE_LINE_BUFFER_DEFAULT_SIZE = 1024;
    final SimpleDateFormat timeParser = new SimpleDateFormat("HH:mm:ss");
    final SimpleDateFormat timestampParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int currentServerResponseHeader = 0;
    private final OldMapiSocket socket;
    CharBuffer lineBuffer;
    CharBuffer tupleLineBuffer;

    public OldMapiProtocol(OldMapiSocket socket) {
        this.socket = socket;
        this.lineBuffer = CharBuffer.wrap(new char[8192]);
        this.tupleLineBuffer = CharBuffer.wrap(new char[1024]);
    }

    public OldMapiSocket getSocket() {
        return this.socket;
    }

    @Override
    public int getCurrentServerResponse() {
        return this.currentServerResponseHeader;
    }

    @Override
    public void waitUntilPrompt() throws IOException {
        while (this.currentServerResponseHeader != 4) {
            this.lineBuffer = this.socket.readLine(this.lineBuffer);
            if (this.lineBuffer.limit() == 0) {
                throw new IOException("Connection to server lost!");
            }
            this.currentServerResponseHeader = OldMapiServerResponseParser.parseOldMapiServerResponse(this);
            this.lineBuffer.position(0);
            if (this.currentServerResponseHeader != 1) continue;
            this.lineBuffer.position(1);
        }
    }

    @Override
    public void fetchNextResponseData() throws IOException {
        this.lineBuffer = this.socket.readLine(this.lineBuffer);
        if (this.lineBuffer.limit() == 0) {
            throw new IOException("Connection to server lost!");
        }
        this.currentServerResponseHeader = OldMapiServerResponseParser.parseOldMapiServerResponse(this);
        if (this.currentServerResponseHeader == 1 && !this.lineBuffer.toString().matches("^[0-9A-Z]{5}!.+")) {
            int limit = this.lineBuffer.limit();
            CharBuffer newbuffer = CharBuffer.wrap(new char[this.lineBuffer.capacity() + 7]);
            newbuffer.put("!22000");
            newbuffer.put(this.lineBuffer.array(), 0, limit);
            newbuffer.limit(limit + 6);
            ((Buffer)newbuffer).flip();
            this.lineBuffer = newbuffer;
        }
        this.lineBuffer.position(1);
    }

    @Override
    public int getNextStarterHeader() {
        return OldMapiStartOfHeaderParser.getNextStartHeaderOnOldMapi(this);
    }

    @Override
    public ResultSetResponse getNextResultSetResponse(MonetConnection con, MonetConnection.ResponseList list, int seqnr, int maxrows) throws ProtocolException {
        int id = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        int tuplecount = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        int columncount = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        int rowcount = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        if (maxrows != 0 && tuplecount > maxrows) {
            tuplecount = maxrows;
        }
        return new ResultSetResponse(con, list, id, seqnr, rowcount, tuplecount, columncount);
    }

    @Override
    public UpdateResponse getNextUpdateResponse() throws ProtocolException {
        int count = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        int lastId = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        return new UpdateResponse(lastId, count);
    }

    @Override
    public AutoCommitResponse getNextAutoCommitResponse() throws ProtocolException {
        boolean ac = this.lineBuffer.get() == 't';
        return new AutoCommitResponse(ac);
    }

    @Override
    public AbstractDataBlockResponse getAnEmptyDataBlockResponse(int rowcount, int columncount, AbstractProtocol protocol, int[] JdbcSQLTypes, String[] types) {
        return new OldMapiDataBlockResponse(rowcount, columncount, protocol, JdbcSQLTypes, types);
    }

    @Override
    public AbstractDataBlockResponse getNextDatablockResponse(Map<Integer, ResultSetResponse> rsresponses) throws ProtocolException {
        int id = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        int rowcount = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        int offset = OldMapiStartOfHeaderParser.getNextResponseDataAsInt(this);
        ResultSetResponse rs = rsresponses.get(id);
        if (rs == null) {
            return null;
        }
        return rs.addDataBlockResponse(offset, rowcount);
    }

    @Override
    public int getNextTableHeader(String[] columnNames, int[] columnLengths, String[] types, String[] tableNames) throws ProtocolException {
        return OldMapiTableHeaderParser.getNextTableHeader(this.lineBuffer, columnNames, columnLengths, types, tableNames);
    }

    int parseTupleLines(int firstLineNumber, int[] typesMap, Object[] values) throws ProtocolException {
        OldMapiTupleLineParser.oldMapiParseTupleLine(this, firstLineNumber, typesMap, values);
        return firstLineNumber;
    }

    @Override
    public String getRemainingStringLine(int startIndex) {
        if (this.lineBuffer.limit() > startIndex) {
            if (this.lineBuffer.array()[startIndex] == '!') {
                ++startIndex;
            }
            return new String(this.lineBuffer.array(), startIndex, this.lineBuffer.limit() - startIndex);
        }
        return null;
    }

    @Override
    public void writeNextQuery(String prefix, String query, String suffix) throws IOException {
        this.socket.writeNextLine(prefix, query, suffix);
        this.currentServerResponseHeader = 0;
    }
}

