/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.executable.CommandOptions;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.Utility;

public abstract class BaseSchemaCrawlerCommand<C extends CommandOptions>
implements SchemaCrawlerCommand<C> {
    protected final String command;
    protected C commandOptions;
    protected Catalog catalog;
    protected Connection connection;
    protected Identifiers identifiers;
    protected OutputOptions outputOptions;
    protected SchemaCrawlerOptions schemaCrawlerOptions;

    protected BaseSchemaCrawlerCommand(String command) {
        this.command = Utility.requireNotBlank((String)command, (String)"No command specified");
        this.schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
    }

    @Override
    public void checkAvailability() throws Exception {
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public final String getCommand() {
        return this.command;
    }

    @Override
    public final C getCommandOptions() {
        return this.commandOptions;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    @Override
    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    @Override
    public void initialize() throws Exception {
        this.checkOptions();
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public final void setCommandOptions(C commandOptions) {
        this.commandOptions = (CommandOptions)Objects.requireNonNull(commandOptions, "No command options provided");
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void setIdentifiers(Identifiers identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public final void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions != null ? outputOptions : OutputOptionsBuilder.newOutputOptions();
    }

    @Override
    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions != null ? schemaCrawlerOptions : SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
    }

    public final String toString() {
        return this.command;
    }

    protected void checkCatalog() {
        Objects.requireNonNull(this.catalog, "No database catalog provided");
        if (this.usesConnection()) {
            Objects.requireNonNull(this.connection, "No database connection provided");
        }
    }

    private void checkOptions() {
        Objects.requireNonNull(this.schemaCrawlerOptions, "No SchemaCrawler options provided");
        Objects.requireNonNull(this.commandOptions, "No command options provided");
        Objects.requireNonNull(this.outputOptions, "No output options provided");
        Objects.requireNonNull(this.identifiers, "No database identifiers provided");
    }
}

