/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.WeakAssociationBuilder;
import schemacrawler.loader.weakassociations.ProposedWeakAssociation;
import schemacrawler.loader.weakassociations.WeakAssociationsAnalyzer;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.StopWatch;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationsCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationsCatalogLoader.class.getName());
    private static final String OPTION_WEAK_ASSOCIATIONS = "weak-associations";

    public WeakAssociationsCatalogLoader() {
        super(new CommandDescription("weakassociationsloader", "Loader for weak associations"), 3);
    }

    public void findWeakAssociations() {
        Catalog catalog = this.getCatalog();
        ArrayList<Table> allTables = new ArrayList<Table>(catalog.getTables());
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables);
        Collection<ProposedWeakAssociation> proposedWeakAssociations = weakAssociationsAnalyzer.analyzeTables();
        for (ProposedWeakAssociation proposedWeakAssociation : proposedWeakAssociations) {
            LOGGER.log(Level.INFO, new StringFormat("Adding weak association <%s> ", proposedWeakAssociation));
            Column fkColumn = (Column)proposedWeakAssociation.getValue();
            Column pkColumn = (Column)proposedWeakAssociation.getKey();
            WeakAssociationBuilder builder = WeakAssociationBuilder.builder(catalog);
            builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
            builder.build();
        }
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        CommandDescription commandDescription = this.getCommandDescription();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand(commandDescription.getName(), commandDescription.getDescription());
        pluginCommand.addOption(OPTION_WEAK_ASSOCIATIONS, Boolean.class, "Analyzes the schema to find weak associations between tables, based on table and column naming patterns", "This can be a time consuming operation", "Optional, defaults to false");
        return pluginCommand;
    }

    @Override
    public void loadCatalog() throws SchemaCrawlerException {
        if (!this.isLoaded()) {
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlAnalysis");
        LOGGER.log(Level.INFO, "Finding weak associations");
        try {
            stopWatch.time("retrieveWeakAssociations", () -> {
                Config config = this.getAdditionalConfiguration();
                boolean findWeakAssociations = config.getBooleanValue(OPTION_WEAK_ASSOCIATIONS, false);
                if (findWeakAssociations) {
                    this.findWeakAssociations();
                    return null;
                }
                LOGGER.log(Level.INFO, "Not retrieving weak associations, since this was not requested");
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving weak association information", e);
        }
    }
}

