/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.diagram.AbstractGraphProcessExecutor;
import schemacrawler.tools.command.text.diagram.GraphvizUtility;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import us.fatehi.utility.ProcessExecutor;
import us.fatehi.utility.string.FileContents;
import us.fatehi.utility.string.StringFormat;

final class GraphvizProcessExecutor
extends AbstractGraphProcessExecutor {
    private static final Logger LOGGER = Logger.getLogger(GraphvizProcessExecutor.class.getName());
    private final List<String> graphvizOpts;

    GraphvizProcessExecutor(Path dotFile, Path outputFile, DiagramOutputFormat diagramOutputFormat, List<String> graphvizOpts) throws SchemaCrawlerException {
        super(dotFile, outputFile, diagramOutputFormat);
        this.graphvizOpts = Objects.requireNonNull(graphvizOpts, "No Graphviz options provided");
    }

    @Override
    public Boolean call() {
        Integer exitCode;
        List<String> command = this.createDiagramCommand();
        LOGGER.log(Level.INFO, new StringFormat("Generating diagram using Graphviz:\n%s", command.toString()));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, String.format("Could not generate diagram using Graphviz:%n%s", command.toString()), e);
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        LOGGER.log(Level.FINE, new StringFormat("Graphviz stdout:%n%s", new FileContents(processExecutor.getProcessOutput())));
        if (!successful) {
            FileContents processError = new FileContents(processExecutor.getProcessError());
            System.err.println(processError);
            LOGGER.log(Level.SEVERE, new StringFormat("Graphviz returned exit code <%d>%nGraphviz stderr:%n%s", exitCode, processError));
            this.retainDotFile(processExecutor.getCommand());
        } else {
            LOGGER.log(Level.FINE, new StringFormat("Graphviz stderr:%n%s", new FileContents(processExecutor.getProcessError())));
            LOGGER.log(Level.INFO, new StringFormat("Generated diagram <%s>", this.outputFile));
        }
        return successful;
    }

    @Override
    public boolean canGenerate() {
        return GraphvizUtility.isGraphvizAvailable();
    }

    private List<String> createDiagramCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.addAll(this.graphvizOpts);
        command.add("-T");
        command.add(this.diagramOutputFormat.getFormat());
        command.add("-o");
        command.add(this.outputFile.toString());
        command.add(this.dotFile.toString());
        return command;
    }

    private void retainDotFile(List<String> command) {
        try {
            Path parentPath = this.outputFile.normalize().getParent();
            if (parentPath == null) {
                throw new UnsupportedOperationException("Cannot use output file path");
            }
            Path movedDotFile = parentPath.resolve(this.outputFile.getFileName() + ".dot");
            Files.copy(this.dotFile, movedDotFile, StandardCopyOption.REPLACE_EXISTING);
            command.remove(command.size() - 1);
            command.remove(command.size() - 1);
            command.add(this.outputFile.toString());
            command.add(movedDotFile.toString());
            LOGGER.log(Level.SEVERE, String.format("Error generating diagram%nGenerate your diagram manually, using:%n%s", String.join((CharSequence)" ", command)));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not retain generated DOT file", e);
        }
    }
}

