/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.StateScript;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Axes;
import org.jmol.shape.Balls;
import org.jmol.shape.Echo;
import org.jmol.shape.FontLineShape;
import org.jmol.shape.Frank;
import org.jmol.shape.Halos;
import org.jmol.shape.Hover;
import org.jmol.shape.Labels;
import org.jmol.shape.Measures;
import org.jmol.shape.Shape;
import org.jmol.shape.Sticks;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Vibration;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.GlobalSettings;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class StateCreator
extends JmolStateCreator {
    private Viewer vwr;
    private Map<String, BS> temp = new Hashtable<String, BS>();
    private Map<String, BS> temp2 = new Hashtable<String, BS>();
    private Map<String, BS> temp3 = new Hashtable<String, BS>();
    private boolean undoWorking = false;
    private static final int MAX_ACTION_UNDO = 100;

    @Override
    void setViewer(Viewer vwr) {
        this.vwr = vwr;
    }

    @Override
    String getStateScript(String type, int width, int height) {
        SB sfunc;
        boolean isAll = type == null || type.equalsIgnoreCase("all");
        SB s = new SB();
        SB sB = sfunc = isAll ? new SB().append("function _setState() {\n") : null;
        if (isAll) {
            s.append("# Jmol state version " + Viewer.getJmolVersion() + ";\n");
            if (this.vwr.isApplet) {
                this.app(s, "# fullName = " + PT.esc(this.vwr.fullName));
                this.app(s, "# documentBase = " + PT.esc(Viewer.appletDocumentBase));
                this.app(s, "# codeBase = " + PT.esc(Viewer.appletCodeBase));
                s.append("\n");
            }
        }
        GlobalSettings global = this.vwr.g;
        if (isAll || type.equalsIgnoreCase("windowState")) {
            s.append(this.getWindowState(sfunc, width, height));
        }
        if (isAll || type.equalsIgnoreCase("fileState")) {
            s.append(this.getFileState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("definedState")) {
            s.append(this.getDefinedState(sfunc, true));
        }
        if (isAll || type.equalsIgnoreCase("variableState")) {
            s.append(this.getParameterState(global, sfunc));
        }
        if (isAll || type.equalsIgnoreCase("dataState")) {
            s.append(this.getDataState(sfunc));
        }
        if (isAll || type.equalsIgnoreCase("modelState")) {
            s.append(this.getModelState(sfunc, true, this.vwr.getBooleanProperty("saveProteinStructureState")));
        }
        if (isAll || type.equalsIgnoreCase("colorState")) {
            s.append(this.getColorState(this.vwr.cm, sfunc));
        }
        if (isAll || type.equalsIgnoreCase("frameState")) {
            s.append(this.getAnimState(this.vwr.am, sfunc));
        }
        if (isAll || type.equalsIgnoreCase("perspectiveState")) {
            s.append(this.getViewState(this.vwr.tm, sfunc));
        }
        if (isAll || type.equalsIgnoreCase("selectionState")) {
            s.append(this.getSelectionState(this.vwr.slm, sfunc));
        }
        if (sfunc != null) {
            this.app(sfunc, "set refreshing true");
            this.app(sfunc, "set antialiasDisplay " + global.antialiasDisplay);
            this.app(sfunc, "set antialiasTranslucent " + global.antialiasTranslucent);
            this.app(sfunc, "set antialiasImages " + global.antialiasImages);
            if (this.vwr.tm.spinOn) {
                this.app(sfunc, "spin on");
            }
            sfunc.append("}\n\n_setState;\n");
        }
        if (isAll) {
            s.appendSB(sfunc);
        }
        return s.toString();
    }

    private String getDataState(SB sfunc) {
        String info;
        SB commands = new SB();
        boolean haveData = false;
        String atomProps = this.getAtomicPropertyState(-1, null);
        if (atomProps.length() > 0) {
            haveData = true;
            commands.append(atomProps);
        }
        if (this.vwr.userVdws != null && (info = this.vwr.getDefaultVdwNameOrData(0, VDW.USER, this.vwr.bsUserVdws)).length() > 0) {
            haveData = true;
            commands.append(info);
        }
        if (this.vwr.nmrCalculation != null) {
            haveData |= this.vwr.nmrCalculation.getState(commands);
        }
        if (this.vwr.dm != null) {
            haveData |= this.vwr.dm.getDataState(this, commands);
        }
        if (!haveData) {
            return "";
        }
        String cmd = "";
        if (sfunc != null) {
            sfunc.append("  _setDataState;\n");
            cmd = "function _setDataState() {\n";
            commands.append("}\n\n");
        }
        return cmd + commands.toString();
    }

    private String getDefinedState(SB sfunc, boolean isAll) {
        String cmd;
        ModelSet ms = this.vwr.ms;
        int len = ms.stateScripts.size();
        if (len == 0) {
            return "";
        }
        boolean haveDefs = false;
        SB commands = new SB();
        for (int i = 0; i < len; ++i) {
            StateScript ss = (StateScript)ms.stateScripts.get(i);
            if (!ss.inDefinedStateBlock || (cmd = ss.toString()).length() <= 0) continue;
            this.app(commands, cmd);
            haveDefs = true;
        }
        if (!haveDefs) {
            return "";
        }
        cmd = "";
        if (isAll && sfunc != null) {
            sfunc.append("  _setDefinedState;\n");
            cmd = "function _setDefinedState() {\n\n";
        }
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return cmd + commands.toString();
    }

    @Override
    String getModelState(SB sfunc, boolean isAll, boolean withProteinStructure) {
        int i;
        SB commands = new SB();
        if (isAll && sfunc != null) {
            sfunc.append("  _setModelState;\n");
            commands.append("function _setModelState() {\n");
        }
        ModelSet ms = this.vwr.ms;
        Bond[] bonds = ms.bo;
        Model[] models = ms.am;
        int modelCount = ms.mc;
        if (isAll) {
            int len = ms.stateScripts.size();
            for (int i2 = 0; i2 < len; ++i2) {
                String cmd;
                StateScript ss = (StateScript)ms.stateScripts.get(i2);
                if (ss.inDefinedStateBlock || (cmd = ss.toString()).length() <= 0) continue;
                this.app(commands, cmd);
            }
            SB sb = new SB();
            for (i = 0; i < ms.bondCount; ++i) {
                if (models[bonds[i].atom1.mi].isModelKit || !bonds[i].isHydrogen() && (bonds[i].order & 0x20000) == 0) continue;
                Bond bond = bonds[i];
                int index = bond.atom1.i;
                if (bond.atom1.group.isAdded(index)) {
                    index = -1 - index;
                }
                sb.appendI(index).appendC('\t').appendI(bond.atom2.i).appendC('\t').appendI(bond.order & 0xFFFDFFFF).appendC('\t').appendF((float)bond.mad / 1000.0f).appendC('\t').appendF(bond.getEnergy()).appendC('\t').append(Edge.getBondOrderNameFromOrder(bond.order)).append(";\n");
            }
            if (sb.length() > 0) {
                commands.append("data \"connect_atoms\"\n").appendSB(sb).append("end \"connect_atoms\";\n");
            }
            commands.append("\n");
        }
        if (ms.haveHiddenBonds) {
            BondSet bs = new BondSet();
            int i3 = ms.bondCount;
            while (--i3 >= 0) {
                if (bonds[i3].mad == 0 || (bonds[i3].shapeVisibilityFlags & Bond.myVisibilityFlag) != 0) continue;
                bs.set(i3);
            }
            if (bs.isEmpty()) {
                ms.haveHiddenBonds = false;
            } else {
                commands.append("  hide ").append(Escape.eBond(bs)).append(";\n");
            }
        }
        this.vwr.setModelVisibility();
        if (withProteinStructure) {
            commands.append(ms.getProteinStructureState(null, isAll ? 1073742327 : 1073742158));
        }
        for (int i4 = 0; i4 < modelCount; ++i4) {
            if (models[i4].mat4 == null) continue;
            commands.append("  frame orientation " + ms.getModelNumberDotted(i4) + Escape.matrixToScript(models[i4].mat4) + ";\n");
        }
        this.getShapeStatePriv(commands, isAll, Integer.MAX_VALUE);
        if (isAll) {
            boolean needOrientations = false;
            for (int i5 = 0; i5 < modelCount; ++i5) {
                if (!models[i5].isJmolDataFrame) continue;
                needOrientations = true;
                break;
            }
            SB sb = new SB();
            for (i = 0; i < modelCount; ++i) {
                String t;
                Model m = models[i];
                sb.setLength(0);
                String s = (String)ms.getInfo(i, "modelID");
                if (s != null && !s.equals(ms.getInfo(i, "modelID0"))) {
                    sb.append("  frame ID ").append(PT.esc(s)).append(";\n");
                }
                if ((t = ms.frameTitles[i]) != null && t.length() > 0) {
                    sb.append("  frame title ").append(PT.esc(t)).append(";\n");
                }
                if (needOrientations && m.orientation != null && !ms.isTrajectorySubFrame(i)) {
                    sb.append("  ").append(m.orientation.getMoveToText(false)).append(";\n");
                }
                if (m.frameDelay != 0L && !ms.isTrajectorySubFrame(i)) {
                    sb.append("  frame delay ").appendF((float)m.frameDelay / 1000.0f).append(";\n");
                }
                if (m.simpleCage != null) {
                    sb.append("  unitcell ").append(Escape.eAP(m.simpleCage.getUnitCellVectors())).append(";\n");
                    this.getShapeStatePriv(sb, isAll, 33);
                }
                if (sb.length() <= 0) continue;
                commands.append("  frame " + ms.getModelNumberDotted(i) + ";\n").appendSB(sb);
            }
            boolean loadUC = false;
            if (ms.unitCells != null) {
                boolean haveModulation = false;
                for (int i6 = 0; i6 < modelCount; ++i6) {
                    SymmetryInterface symmetry = ms.getUnitCell(i6);
                    if (symmetry == null) continue;
                    sb.setLength(0);
                    if (symmetry.getState(sb)) {
                        loadUC = true;
                        commands.append("  frame ").append(ms.getModelNumberDotted(i6)).appendSB(sb).append(";\n");
                    }
                    haveModulation |= this.vwr.ms.getLastVibrationVector(i6, 1275072532) >= 0;
                }
                if (loadUC) {
                    this.vwr.shm.loadShape(33);
                }
                this.getShapeStatePriv(commands, isAll, 33);
                if (haveModulation) {
                    Hashtable<String, BS> temp = new Hashtable<String, BS>();
                    int i7 = modelCount;
                    while (--i7 >= 0) {
                        int ivib = this.vwr.ms.getLastVibrationVector(i7, 1275072532);
                        if (ivib < 0) continue;
                        for (int j = models[i7].firstAtomIndex; j <= ivib; ++j) {
                            JmolModulationSet mset = ms.getModulation(j);
                            if (mset == null) continue;
                            BSUtil.setMapBitSet(temp, j, j, mset.getState());
                        }
                    }
                    commands.append(this.getCommands(temp, null, "select"));
                }
            }
            commands.append("  set fontScaling " + this.vwr.getBoolean(603979845) + ";\n");
        }
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return commands.toString();
    }

    private String getWindowState(SB sfunc, int width, int height) {
        GlobalSettings global = this.vwr.g;
        SB str = new SB();
        if (sfunc != null) {
            sfunc.append("  initialize;\n  set refreshing false;\n  _setWindowState;\n");
            str.append("\nfunction _setWindowState() {\n");
        }
        if (width != 0) {
            str.append("# preferredWidthHeight ").appendI(width).append(" ").appendI(height).append(";\n");
        }
        str.append("# width ").appendI(width == 0 ? this.vwr.getScreenWidth() : width).append(";\n# height ").appendI(height == 0 ? this.vwr.getScreenHeight() : height).append(";\n");
        this.app(str, "stateVersion = " + JC.versionInt);
        this.app(str, "background " + Escape.escapeColor(global.objColors[0]));
        for (int i = 1; i < 7; ++i) {
            if (global.objColors[i] == 0) continue;
            this.app(str, StateManager.getObjectNameFromId(i) + "Color = \"" + Escape.escapeColor(global.objColors[i]) + '\"');
        }
        if (global.backgroundImageFileName != null) {
            this.app(str, "background IMAGE " + (global.backgroundImageFileName.startsWith(";base64,") ? "" : "/*file*/") + PT.esc(global.backgroundImageFileName));
        }
        str.append(this.getLightingState(false));
        if (sfunc != null) {
            str.append("}\n\n");
        }
        return str.toString();
    }

    @Override
    String getLightingState(boolean isAll) {
        SB str = new SB();
        GData g = this.vwr.gdata;
        this.app(str, "set ambientPercent " + g.getAmbientPercent());
        this.app(str, "set diffusePercent " + g.getDiffusePercent());
        this.app(str, "set specular " + g.getSpecular());
        this.app(str, "set specularPercent " + g.getSpecularPercent());
        this.app(str, "set specularPower " + g.getSpecularPower());
        int se = g.getSpecularExponent();
        int pe = g.getPhongExponent();
        this.app(str, Math.pow(2.0, se) == (double)pe ? "set specularExponent " + se : "set phongExponent " + pe);
        this.app(str, "set celShading " + g.getCel());
        this.app(str, "set celShadingPower " + g.getCelPower());
        this.app(str, "set zShadePower " + this.vwr.g.zShadePower);
        if (isAll) {
            this.getZshadeState(str, this.vwr.tm, true);
        }
        return str.toString();
    }

    private String getFileState(SB sfunc) {
        SB commands = new SB();
        if (sfunc != null) {
            sfunc.append("  _setFileState;\n");
            commands.append("function _setFileState() {\n\n");
        }
        if (commands.indexOf("append") < 0 && this.vwr.getModelSetFileName().equals("zapped")) {
            commands.append("  zap;\n");
        }
        this.appendLoadStates(commands);
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return commands.toString();
    }

    private void appendLoadStates(SB cmds) {
        Map<String, Boolean> ligandModelSet = this.vwr.ligandModelSet;
        if (ligandModelSet != null) {
            for (String key : ligandModelSet.keySet()) {
                String data = (String)this.vwr.ligandModels.get(key + "_data");
                if (data != null) {
                    cmds.append("  ").append(Escape.encapsulateData("ligand_" + key, data.trim() + "\n", 0));
                }
                if ((data = (String)this.vwr.ligandModels.get(key + "_file")) == null) continue;
                cmds.append("  ").append(Escape.encapsulateData("file_" + key, data.trim() + "\n", 0));
            }
        }
        SB commands = new SB();
        ModelSet ms = this.vwr.ms;
        Model[] models = ms.am;
        int modelCount = ms.mc;
        for (int i = 0; i < modelCount; ++i) {
            if (ms.isJmolDataFrameForModel(i) || ms.isTrajectorySubFrame(i)) continue;
            Model m = models[i];
            int pt = commands.indexOf(m.loadState);
            if (pt < 0 || pt != commands.lastIndexOf(m.loadState)) {
                commands.append(models[i].loadState);
            }
            if (models[i].isModelKit) {
                BS bs = ms.getModelAtomBitSetIncludingDeleted(i, false);
                if (ms.tainted != null) {
                    if (ms.tainted[2] != null) {
                        ms.tainted[2].andNot(bs);
                    }
                    if (ms.tainted[3] != null) {
                        ms.tainted[3].andNot(bs);
                    }
                }
                m.loadScript = new SB();
                this.getInlineData(commands, this.vwr.getModelExtract(bs, false, true, "MOL"), i > 0, null);
                continue;
            }
            commands.appendSB(m.loadScript);
            Lst auxFiles = (Lst)m.auxiliaryInfo.get("auxFiles");
            if (auxFiles == null) continue;
            for (int j = 0; j < auxFiles.size(); ++j) {
                commands.append(";#FILE1=" + PT.esc((String)auxFiles.get(j)) + ";");
            }
        }
        String s = commands.toString();
        if (s.indexOf("data \"append ") < 0) {
            int i = s.indexOf("load /*data*/");
            int j = s.indexOf("load /*file*/");
            if (j >= 0 && j < i) {
                i = j;
            }
            if ((j = s.indexOf("load \"@")) >= 0 && j < i) {
                i = j;
            }
            if (i >= 0) {
                s = s.substring(0, i) + "zap;" + s.substring(i);
            }
        }
        cmds.append(s);
    }

    @Override
    public void getInlineData(SB loadScript, String strModel, boolean isAppend, String loadFilter) {
        String tag = (isAppend ? "append" : "model") + " inline";
        loadScript.append("load /*data*/ data \"").append(tag).append("\"\n").append(strModel).append("end \"").append(tag).append(loadFilter == null || loadFilter.length() == 0 ? "" : " filter" + PT.esc(loadFilter)).append("\";");
    }

    private String getColorState(ColorManager cm, SB sfunc) {
        SB s = new SB();
        int n = this.getCEState(cm.ce, s);
        if (n > 0 && sfunc != null) {
            sfunc.append("\n  _setColorState\n");
        }
        return n > 0 && sfunc != null ? "function _setColorState() {\n" + s.append("}\n\n").toString() : s.toString();
    }

    private int getCEState(ColorEncoder p, SB s) {
        int n = 0;
        for (Map.Entry<String, int[]> entry : p.schemes.entrySet()) {
            String name = entry.getKey();
            if (!(name.length() > 0 & n++ >= 0)) continue;
            s.append("color \"" + name + "=" + ColorEncoder.getColorSchemeList(entry.getValue()) + "\";\n");
        }
        return n;
    }

    private String getAnimState(AnimationManager am, SB sfunc) {
        int modelCount = this.vwr.ms.mc;
        if (modelCount < 2) {
            return "";
        }
        SB commands = new SB();
        if (sfunc != null) {
            sfunc.append("  _setFrameState;\n");
            commands.append("function _setFrameState() {\n");
        }
        commands.append("# frame state;\n");
        commands.append("# modelCount ").appendI(modelCount).append(";\n# first ").append(this.vwr.getModelNumberDotted(0)).append(";\n# last ").append(this.vwr.getModelNumberDotted(modelCount - 1)).append(";\n");
        if (am.backgroundModelIndex >= 0) {
            this.app(commands, "set backgroundModel " + this.vwr.getModelNumberDotted(am.backgroundModelIndex));
        }
        if (this.vwr.tm.bsFrameOffsets != null) {
            this.app(commands, "frame align " + Escape.eBS(this.vwr.tm.bsFrameOffsets));
        } else if (this.vwr.ms.translations != null) {
            int i = modelCount;
            while (--i >= 0) {
                P3 t = this.vwr.ms.getTranslation(i);
                if (t == null) continue;
                this.app(commands, "frame " + this.vwr.ms.getModelNumberDotted(i) + " align " + t);
            }
        }
        this.app(commands, "frame RANGE " + am.getModelSpecial(-1) + " " + am.getModelSpecial(1));
        this.app(commands, "animation DIRECTION " + (am.animationDirection == 1 ? "+1" : "-1"));
        this.app(commands, "animation FPS " + am.animationFps);
        this.app(commands, "animation MODE " + T.nameOf(am.animationReplayMode) + " " + am.firstFrameDelay + " " + am.lastFrameDelay);
        if (am.morphCount > 0) {
            this.app(commands, "animation MORPH " + am.morphCount);
        }
        boolean showModel = true;
        if (am.animationFrames != null) {
            this.app(commands, "anim frames " + Escape.eAI(am.animationFrames));
            int i = am.caf;
            this.app(commands, "frame " + (i + 1));
            boolean bl = showModel = am.cmi != am.modelIndexForFrame(i);
        }
        if (showModel) {
            String s = am.getModelSpecial(0);
            this.app(commands, s.equals("0") ? "frame *" : "model " + s);
        }
        this.app(commands, "animation " + (!am.animationOn ? "OFF" : (am.currentDirection == 1 ? "PLAY" : "PLAYREV")));
        if (am.animationOn && am.animationPaused) {
            this.app(commands, "animation PAUSE");
        }
        if (sfunc != null) {
            commands.append("}\n\n");
        }
        return commands.toString();
    }

    private String getParameterState(GlobalSettings global, SB sfunc) {
        boolean isState;
        Object[] list = new String[global.htBooleanParameterFlags.size() + global.htNonbooleanParameterValues.size()];
        SB commands = new SB();
        boolean bl = isState = sfunc != null;
        if (isState) {
            sfunc.append("  _setParameterState;\n");
            commands.append("function _setParameterState() {\n\n");
        }
        int n = 0;
        for (String key : global.htBooleanParameterFlags.keySet()) {
            if (!GlobalSettings.doReportProperty(key)) continue;
            list[n++] = "set " + key + " " + global.htBooleanParameterFlags.get(key);
        }
        for (String key : global.htNonbooleanParameterValues.keySet()) {
            if (!GlobalSettings.doReportProperty(key)) continue;
            Object value = global.htNonbooleanParameterValues.get(key);
            if (key.charAt(0) == '=') {
                key = key.substring(1);
            } else {
                key = (key.indexOf("default") == 0 ? " " : "") + "set " + key;
                value = Escape.e(value);
            }
            list[n++] = key + " " + value;
        }
        switch (global.axesMode) {
            case 0x24000020: {
                list[n++] = "set axes unitcell";
                break;
            }
            case 603979804: {
                list[n++] = "set axes molecular";
                break;
            }
            default: {
                list[n++] = "set axes window";
            }
        }
        Arrays.sort(list, 0, n);
        for (int i = 0; i < n; ++i) {
            if (list[i] == null) continue;
            this.app(commands, (String)list[i]);
        }
        String s = StateManager.getVariableList(global.htUserVariables, 0, false, true);
        if (s.length() > 0) {
            commands.append("\n#user-defined atom sets; \n");
            commands.append(s);
        }
        if (this.vwr.shm.getShape(5) != null) {
            commands.append(this.getDefaultLabelState((Labels)this.vwr.shm.shapes[5]));
        }
        if (global.haveSetStructureList) {
            Map<STR, float[]> slist = global.structureList;
            commands.append("struture HELIX set " + Escape.eAF(slist.get((Object)STR.HELIX)));
            commands.append("struture SHEET set " + Escape.eAF(slist.get((Object)STR.SHEET)));
            commands.append("struture TURN set " + Escape.eAF(slist.get((Object)STR.TURN)));
        }
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return commands.toString();
    }

    private String getDefaultLabelState(Labels l) {
        SB s = new SB().append("\n# label defaults;\n");
        this.app(s, "select none");
        this.app(s, Shape.getColorCommand("label", l.defaultPaletteID, l.defaultColix, l.translucentAllowed));
        this.app(s, "background label " + Shape.encodeColor(l.defaultBgcolix));
        this.app(s, "set labelOffset " + JC.getXOffset(l.defaultOffset) + " " + JC.getYOffset(l.defaultOffset));
        String align = JC.getHorizAlignmentName(l.defaultAlignment);
        this.app(s, "set labelAlignment " + (align.length() < 5 ? "left" : align));
        String pointer = JC.getPointerName(l.defaultPointer);
        this.app(s, "set labelPointer " + (pointer.length() == 0 ? "off" : pointer));
        if ((l.defaultZPos & 0x20) != 0) {
            this.app(s, "set labelFront");
        } else if ((l.defaultZPos & 0x10) != 0) {
            this.app(s, "set labelGroup");
        }
        this.app(s, Shape.getFontCommand("label", Font.getFont3D(l.defaultFontId)));
        return s.toString();
    }

    private String getSelectionState(SelectionManager sm, SB sfunc) {
        SB commands = new SB();
        if (sfunc != null) {
            sfunc.append("  _setSelectionState;\n");
            commands.append("function _setSelectionState() {\n");
        }
        if (this.vwr.ms.trajectory != null) {
            this.app(commands, this.vwr.ms.trajectory.getState());
        }
        Hashtable<String, BS> temp = new Hashtable<String, BS>();
        String cmd = null;
        this.addBs(commands, "hide ", sm.bsHidden);
        this.addBs(commands, "subset ", sm.bsSubset);
        this.addBs(commands, "delete ", sm.bsDeleted);
        this.addBs(commands, "fix ", sm.bsFixed);
        temp.put("-", this.vwr.slm.getSelectedAtomsNoSubset());
        cmd = this.getCommands(temp, null, "select");
        if (cmd == null) {
            this.app(commands, "select none");
        } else {
            commands.append(cmd);
        }
        this.app(commands, "set hideNotSelected " + sm.hideNotSelected);
        commands.append((String)this.vwr.getShapeProperty(1, "selectionState"));
        if (this.vwr.getSelectionHalosEnabled()) {
            this.app(commands, "SelectionHalos ON");
        }
        if (sfunc != null) {
            commands.append("}\n\n");
        }
        return commands.toString();
    }

    private String getViewState(TransformManager tm, SB sfunc) {
        boolean slabInternal;
        boolean navigating;
        SB commands = new SB();
        String moveToText = tm.getMoveToText(0.0f, false);
        if (sfunc != null) {
            sfunc.append("  _setPerspectiveState;\n");
            commands.append("function _setPerspectiveState() {\n");
        }
        this.app(commands, "set perspectiveModel " + tm.perspectiveModel);
        this.app(commands, "set scaleAngstromsPerInch " + tm.scale3DAngstromsPerInch);
        this.app(commands, "set perspectiveDepth " + tm.perspectiveDepth);
        this.app(commands, "set visualRange " + tm.visualRangeAngstroms);
        if (!tm.isWindowCentered()) {
            this.app(commands, "set windowCentered false");
        }
        this.app(commands, "set cameraDepth " + tm.cameraDepth);
        boolean bl = navigating = tm.mode == 1;
        if (navigating) {
            this.app(commands, "set navigationMode true");
        }
        this.app(commands, this.vwr.ms.getBoundBoxCommand(false));
        this.app(commands, "center " + Escape.eP(tm.fixedRotationCenter));
        commands.append(this.vwr.getOrientationText(1073742034, null, null).toString());
        this.app(commands, moveToText);
        if (!navigating && !tm.zoomEnabled) {
            this.app(commands, "zoom off");
        }
        commands.append("  slab ").appendI(tm.slabPercentSetting).append(";depth ").appendI(tm.depthPercentSetting).append(tm.slabEnabled && !navigating ? ";slab on" : "").append(";\n");
        commands.append("  set slabRange ").appendF(tm.slabRange).append(";\n");
        if (tm.slabPlane != null) {
            commands.append("  slab plane ").append(Escape.eP4(tm.slabPlane)).append(";\n");
        }
        if (tm.depthPlane != null) {
            commands.append("  depth plane ").append(Escape.eP4(tm.depthPlane)).append(";\n");
        }
        this.getZshadeState(commands, tm, false);
        commands.append(this.getSpinState(true)).append("\n");
        if (this.vwr.ms.modelSetHasVibrationVectors() && tm.vibrationOn) {
            this.app(commands, "set vibrationPeriod " + tm.vibrationPeriod + ";vibration on");
        }
        boolean bl2 = slabInternal = tm.depthPlane != null || tm.slabPlane != null;
        if (navigating) {
            commands.append(tm.getNavigationState());
        }
        if (!tm.slabEnabled && slabInternal) {
            commands.append("  slab off;\n");
        }
        if (sfunc != null) {
            commands.append("}\n\n");
        }
        return commands.toString();
    }

    private void getZshadeState(SB s, TransformManager tm, boolean isAll) {
        if (isAll) {
            this.app(s, "set zDepth " + tm.zDepthPercentSetting);
            this.app(s, "set zSlab " + tm.zSlabPercentSetting);
            if (!tm.zShadeEnabled) {
                this.app(s, "set zShade false");
            }
        }
        if (tm.zShadeEnabled) {
            this.app(s, "set zShade true");
        }
        try {
            if (tm.zSlabPoint != null) {
                this.app(s, "set zSlab " + Escape.eP(tm.zSlabPoint));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    String getSpinState(boolean isAll) {
        String prefix;
        TransformManager tm = this.vwr.tm;
        String s = "  set spinX " + (int)tm.spinX + "; set spinY " + (int)tm.spinY + "; set spinZ " + (int)tm.spinZ + "; set spinFps " + (int)tm.spinFps + ";";
        if (!Float.isNaN(tm.navFps)) {
            s = s + "  set navX " + (int)tm.navX + "; set navY " + (int)tm.navY + "; set navZ " + (int)tm.navZ + "; set navFps " + (int)tm.navFps + ";";
        }
        if (tm.navOn) {
            s = s + " navigation on;";
        }
        if (!tm.spinOn) {
            return s;
        }
        String string = prefix = tm.isSpinSelected ? "\n  select " + Escape.eBS(this.vwr.bsA()) + ";\n  rotateSelected" : "\n ";
        if (tm.isSpinInternal) {
            P3 pt = P3.newP(tm.internalRotationCenter);
            pt.sub(tm.rotationAxis);
            s = s + prefix + " spin " + tm.rotationRate + " " + Escape.eP(tm.internalRotationCenter) + " " + Escape.eP(pt);
        } else {
            s = tm.isSpinFixed ? s + prefix + " spin axisangle " + Escape.eP(tm.rotationAxis) + " " + tm.rotationRate : s + " spin on";
        }
        return s + ";";
    }

    @Override
    String getCommands(Map<String, BS> htDefine, Map<String, BS> htMore, String selectCmd) {
        SB s = new SB();
        String setPrev = this.getCommands2(htDefine, s, null, selectCmd);
        if (htMore != null) {
            this.getCommands2(htMore, s, setPrev, "select");
        }
        return s.toString();
    }

    private String getCommands2(Map<String, BS> ht, SB s, String setPrev, String selectCmd) {
        if (ht == null) {
            return "";
        }
        for (Map.Entry<String, BS> entry : ht.entrySet()) {
            String key = entry.getKey();
            String set = Escape.eBS(entry.getValue());
            if (set.length() < 5) continue;
            set = selectCmd + " " + set;
            if (!set.equals(setPrev)) {
                this.app(s, set);
            }
            setPrev = set;
            if (key.indexOf("-") == 0) continue;
            this.app(s, key);
        }
        return setPrev;
    }

    private void app(SB s, String cmd) {
        if (cmd.length() != 0) {
            s.append("  ").append(cmd).append(";\n");
        }
    }

    private void addBs(SB sb, String key, BS bs) {
        if (bs == null || bs.length() == 0) {
            return;
        }
        this.app(sb, key + Escape.eBS(bs));
    }

    private String getFontState(String myType, Font font3d) {
        int objId = StateManager.getObjectIdFromName(myType.equalsIgnoreCase("axes") ? "axis" : myType);
        if (objId < 0) {
            return "";
        }
        int mad = this.vwr.getObjectMad10(objId);
        SB s = new SB().append("\n");
        this.app(s, myType + (mad == 0 ? " off" : (mad == 1 ? " on" : (mad == -1 ? " dotted" : (mad < 20 ? " " + mad : " " + (float)mad / 20000.0f)))));
        if (s.length() < 3) {
            return "";
        }
        String fcmd = Shape.getFontCommand(myType, font3d);
        if (fcmd.length() > 0) {
            fcmd = "  " + fcmd + ";\n";
        }
        return s + fcmd;
    }

    private void appendTickInfo(String myType, SB sb, TickInfo t) {
        sb.append("  ");
        sb.append(myType);
        StateCreator.addTickInfo(sb, t, false);
        sb.append(";\n");
    }

    private static void addTickInfo(SB sb, TickInfo tickInfo, boolean addFirst) {
        boolean isUnitCell;
        sb.append(" ticks ").append(tickInfo.type).append(" ").append(Escape.eP(tickInfo.ticks));
        boolean bl = isUnitCell = tickInfo.scale != null && Float.isNaN(tickInfo.scale.x);
        if (isUnitCell) {
            sb.append(" UNITCELL");
        }
        if (tickInfo.tickLabelFormats != null) {
            sb.append(" format ").append(Escape.eAS(tickInfo.tickLabelFormats, false));
        }
        if (!isUnitCell && tickInfo.scale != null) {
            sb.append(" scale ").append(Escape.eP(tickInfo.scale));
        }
        if (addFirst && !Float.isNaN(tickInfo.first) && tickInfo.first != 0.0f) {
            sb.append(" first ").appendF(tickInfo.first);
        }
        if (tickInfo.reference != null) {
            sb.append(" point ").append(Escape.eP(tickInfo.reference));
        }
    }

    private String getMeasurementState(Measures shape) {
        String s;
        int i;
        Lst<Measurement> mList = shape.measurements;
        int measurementCount = shape.measurementCount;
        Font font3d = Measures.font3d;
        TickInfo ti = shape.defaultTickInfo;
        SB commands = new SB();
        this.app(commands, "measures delete");
        for (int i2 = 0; i2 < measurementCount; ++i2) {
            TickInfo tickInfo;
            boolean isProperty;
            Measurement m = (Measurement)mList.get(i2);
            boolean bl = isProperty = m.property != null;
            if (isProperty && Float.isNaN(m.value)) continue;
            int count = m.count;
            SB sb = new SB().append("measure");
            if (m.thisID != null) {
                sb.append(" ID ").append(PT.esc(m.thisID));
            }
            if (m.mad != 0) {
                sb.append(" radius ").appendF(m.thisID == null || m.mad > 0 ? (float)m.mad / 2000.0f : 0.0f);
            }
            if (m.colix != 0) {
                sb.append(" color ").append(Escape.escapeColor(C.getArgb(m.colix)));
            }
            if (m.text != null) {
                if (m.text.font != null) {
                    sb.append(" font ").append(m.text.font.getInfo());
                }
                if (m.text.align != 0) {
                    sb.append(" align ").append(JC.getHorizAlignmentName(m.text.align));
                }
                if (m.text.pymolOffset != null) {
                    sb.append(" offset ").append(Escape.eAF(m.text.pymolOffset));
                }
            }
            if ((tickInfo = m.tickInfo) != null) {
                StateCreator.addTickInfo(sb, tickInfo, true);
            }
            for (int j = 1; j <= count; ++j) {
                sb.append(" ").append(m.getLabel(j, true, true));
            }
            if (isProperty) {
                sb.append(" " + m.property + " value " + (Float.isNaN(m.value) ? 0.0f : m.value)).append(" " + PT.esc(m.getString()));
            }
            this.app(commands, sb.toString());
        }
        this.app(commands, Shape.getFontCommand("measures", font3d));
        int nHidden = 0;
        Hashtable<String, BS> temp = new Hashtable<String, BS>();
        BS bs = BS.newN(measurementCount);
        for (i = 0; i < measurementCount; ++i) {
            Measurement m = (Measurement)mList.get(i);
            if (m.isHidden) {
                ++nHidden;
                bs.set(i);
            }
            if (shape.bsColixSet == null || !shape.bsColixSet.get(i)) continue;
            BSUtil.setMapBitSet(temp, i, i, Shape.getColorCommandUnk("measure", m.colix, shape.translucentAllowed));
        }
        if (nHidden > 0) {
            if (nHidden == measurementCount) {
                this.app(commands, "measures off; # lines and numbers off");
            } else {
                for (i = 0; i < measurementCount; ++i) {
                    if (!bs.get(i)) continue;
                    BSUtil.setMapBitSet(temp, i, i, "measure off");
                }
            }
        }
        if (ti != null) {
            commands.append(" measure ");
            StateCreator.addTickInfo(commands, ti, true);
            commands.append(";\n");
        }
        if (shape.mad >= 0) {
            commands.append(" set measurements ").appendF((float)shape.mad / 2000.0f).append(";\n");
        }
        if ((s = this.getCommands(temp, null, "select measures")) != null && s.length() != 0) {
            commands.append(s);
            this.app(commands, "select measures ({null})");
        }
        return commands.toString();
    }

    private void getShapeStatePriv(SB commands, boolean isAll, int iShape) {
        int imax;
        int i;
        Shape[] shapes = this.vwr.shm.shapes;
        if (shapes == null) {
            return;
        }
        if (iShape == Integer.MAX_VALUE) {
            i = 0;
            imax = 37;
        } else {
            i = iShape;
            imax = i + 1;
        }
        while (i < imax) {
            String cmd;
            Shape shape = shapes[i];
            if (shape != null && (isAll || i >= 9 && i < 16) && (cmd = this.getShapeState(shape)) != null && cmd.length() > 1) {
                commands.append(cmd);
            }
            ++i;
        }
        commands.append("  select *;\n");
    }

    private String getBondState(Sticks shape) {
        int i;
        int i0;
        BS bsOrderSet = shape.bsOrderSet;
        boolean reportAll = shape.reportAll;
        this.clearTemp();
        ModelSet modelSet = this.vwr.ms;
        boolean haveTainted = false;
        Bond[] bonds = modelSet.bo;
        int bondCount = modelSet.bondCount;
        if (reportAll || shape.bsSizeSet != null) {
            i = i0 = reportAll ? bondCount - 1 : shape.bsSizeSet.nextSetBit(0);
            while (i >= 0) {
                short r;
                BSUtil.setMapBitSet(this.temp, i, i, "wireframe " + ((r = bonds[i].mad) == 1 ? "on" : "" + PT.escF((float)r / 2000.0f)));
                i = reportAll ? i - 1 : shape.bsSizeSet.nextSetBit(i + 1);
            }
        }
        if (reportAll || bsOrderSet != null) {
            i = i0 = reportAll ? bondCount - 1 : bsOrderSet.nextSetBit(0);
            while (i >= 0) {
                Bond bond = bonds[i];
                if (reportAll || (bond.order & 0x20000) == 0) {
                    BSUtil.setMapBitSet(this.temp, i, i, "bondOrder " + Edge.getBondOrderNameFromOrder(bond.order));
                }
                i = reportAll ? i - 1 : bsOrderSet.nextSetBit(i + 1);
            }
        }
        if (shape.bsColixSet != null) {
            int i2 = shape.bsColixSet.nextSetBit(0);
            while (i2 >= 0) {
                short colix = bonds[i2].colix;
                if ((colix & 0xFFFF87FF) == 2) {
                    BSUtil.setMapBitSet(this.temp, i2, i2, Shape.getColorCommand("bonds", PAL.CPK.id, colix, shape.translucentAllowed));
                } else {
                    BSUtil.setMapBitSet(this.temp, i2, i2, Shape.getColorCommandUnk("bonds", colix, shape.translucentAllowed));
                }
                i2 = shape.bsColixSet.nextSetBit(i2 + 1);
            }
        }
        String s = this.getCommands(this.temp, null, "select BONDS") + "\n" + (haveTainted ? this.getCommands(this.temp2, null, "select BONDS") + "\n" : "");
        this.clearTemp();
        return s;
    }

    private void clearTemp() {
        this.temp.clear();
        this.temp2.clear();
    }

    private String getShapeState(Shape shape) {
        String s;
        switch (shape.shapeID) {
            case 34: {
                s = this.getAxesState((Axes)shape);
                break;
            }
            case 33: {
                SymmetryInterface uc;
                if (!this.vwr.ms.haveUnitCells) {
                    return "";
                }
                String st = s = this.getFontLineShapeState((FontLineShape)shape);
                int iAtom = this.vwr.am.getUnitCellAtomIndex();
                if (iAtom >= 0) {
                    s = s + "  unitcell ({" + iAtom + "});\n";
                }
                if ((uc = this.vwr.getCurrentUnitCell()) == null) break;
                s = s + uc.getUnitCellState();
                s = s + st;
                break;
            }
            case 32: {
                s = this.getFontLineShapeState((FontLineShape)shape);
                break;
            }
            case 36: {
                s = this.getFontState(shape.myType, ((Frank)shape).baseFont3d);
                break;
            }
            case 6: {
                s = this.getMeasurementState((Measures)shape);
                break;
            }
            case 7: 
            case 18: {
                s = this.getAtomShapeState((AtomShape)shape);
                break;
            }
            case 1: {
                s = this.getBondState((Sticks)shape);
                break;
            }
            case 31: {
                Echo es = (Echo)shape;
                SB sb = new SB();
                sb.append("\n  set echo off;\n");
                for (Text t : es.objects.values()) {
                    sb.append(this.getTextState(t));
                    if (!t.hidden) continue;
                    sb.append("  set echo ID ").append(PT.esc(t.target)).append(" hidden;\n");
                }
                s = sb.toString();
                break;
            }
            case 8: {
                Halos hs = (Halos)shape;
                s = this.getAtomShapeState(hs) + (hs.colixSelection == 2 ? "" : (hs.colixSelection == 0 ? "  color SelectionHalos NONE;\n" : Shape.getColorCommandUnk("selectionHalos", hs.colixSelection, hs.translucentAllowed) + ";\n"));
                if (hs.bsHighlight == null) break;
                s = s + "  set highlight " + Escape.eBS(hs.bsHighlight) + "; " + Shape.getColorCommandUnk("highlight", hs.colixHighlight, hs.translucentAllowed) + ";\n";
                break;
            }
            case 35: {
                this.clearTemp();
                Hover h = (Hover)shape;
                if (h.atomFormats != null) {
                    int i = this.vwr.ms.ac;
                    while (--i >= 0) {
                        if (h.atomFormats[i] == null) continue;
                        BSUtil.setMapBitSet(this.temp, i, i, "set hoverLabel " + PT.esc(h.atomFormats[i]));
                    }
                }
                s = "\n  hover " + PT.esc(h.labelFormat == null ? "" : h.labelFormat) + ";\n" + this.getCommands(this.temp, null, "select");
                this.clearTemp();
                break;
            }
            case 5: {
                Labels l = (Labels)shape;
                if (!l.isActive || l.bsSizeSet == null) {
                    return "";
                }
                this.clearTemp();
                int i = l.bsSizeSet.nextSetBit(0);
                while (i >= 0) {
                    Text text;
                    float sppm;
                    Text t = l.getLabel(i);
                    String cmd = "label ";
                    if (t == null) {
                        cmd = cmd + PT.esc(l.formats[i]);
                    } else {
                        cmd = cmd + PT.esc(t.textUnformatted);
                        if (t.pymolOffset != null) {
                            cmd = cmd + ";set labelOffset " + Escape.eAF(t.pymolOffset);
                        }
                    }
                    BSUtil.setMapBitSet(this.temp, i, i, cmd);
                    if (l.bsColixSet != null && l.bsColixSet.get(i)) {
                        BSUtil.setMapBitSet(this.temp2, i, i, Shape.getColorCommand("label", l.paletteIDs[i], l.colixes[i], l.translucentAllowed));
                    }
                    if (l.bsBgColixSet != null && l.bsBgColixSet.get(i)) {
                        BSUtil.setMapBitSet(this.temp2, i, i, "background label " + Shape.encodeColor(l.bgcolixes[i]));
                    }
                    float f = sppm = (text = l.getLabel(i)) != null ? text.scalePixelsPerMicron : 0.0f;
                    if (sppm > 0.0f) {
                        BSUtil.setMapBitSet(this.temp2, i, i, "set labelScaleReference " + 10000.0f / sppm);
                    }
                    if (l.offsets != null && l.offsets.length > i) {
                        int offsetFull = l.offsets[i];
                        BSUtil.setMapBitSet(this.temp2, i, i, "set " + (JC.isOffsetAbsolute(offsetFull) ? "labelOffsetAbsolute " : "labelOffset ") + JC.getXOffset(offsetFull) + " " + JC.getYOffset(offsetFull));
                        String align = JC.getHorizAlignmentName(offsetFull >> 2);
                        String pointer = JC.getPointerName(offsetFull);
                        if (pointer.length() > 0) {
                            BSUtil.setMapBitSet(this.temp2, i, i, "set labelPointer " + pointer);
                        }
                        if ((offsetFull & 0x20) != 0) {
                            BSUtil.setMapBitSet(this.temp2, i, i, "set labelFront");
                        } else if ((offsetFull & 0x10) != 0) {
                            BSUtil.setMapBitSet(this.temp2, i, i, "set labelGroup");
                        }
                        if (align.length() > 0) {
                            BSUtil.setMapBitSet(this.temp3, i, i, "set labelAlignment " + align);
                        }
                    }
                    if (l.mads != null && l.mads[i] < 0) {
                        BSUtil.setMapBitSet(this.temp2, i, i, "set toggleLabel");
                    }
                    if (l.bsFontSet != null && l.bsFontSet.get(i)) {
                        BSUtil.setMapBitSet(this.temp2, i, i, Shape.getFontCommand("label", Font.getFont3D(l.fids[i])));
                    }
                    i = l.bsSizeSet.nextSetBit(i + 1);
                }
                s = this.getCommands(this.temp, this.temp2, "select") + this.getCommands(null, this.temp3, "select");
                this.temp3.clear();
                this.clearTemp();
                break;
            }
            case 0: {
                this.clearTemp();
                int ac = this.vwr.ms.ac;
                Atom[] atoms = this.vwr.ms.at;
                Balls balls = (Balls)shape;
                short[] colixes = balls.colixes;
                byte[] pids = balls.paletteIDs;
                float r = 0.0f;
                for (int i = 0; i < ac; ++i) {
                    if (shape.bsSizeSet != null && shape.bsSizeSet.get(i)) {
                        float f;
                        r = atoms[i].madAtom;
                        if (f < 0.0f) {
                            BSUtil.setMapBitSet(this.temp, i, i, "Spacefill on");
                        } else {
                            BSUtil.setMapBitSet(this.temp, i, i, "Spacefill " + PT.escF(r / 2000.0f));
                        }
                    }
                    if (shape.bsColixSet == null || !shape.bsColixSet.get(i)) continue;
                    byte pid = atoms[i].paletteID;
                    if (pid != PAL.CPK.id || C.isColixTranslucent(atoms[i].colixAtom)) {
                        BSUtil.setMapBitSet(this.temp, i, i, Shape.getColorCommand("atoms", pid, atoms[i].colixAtom, shape.translucentAllowed));
                    }
                    if (colixes == null || i >= colixes.length) continue;
                    BSUtil.setMapBitSet(this.temp2, i, i, Shape.getColorCommand("balls", pids[i], colixes[i], shape.translucentAllowed));
                }
                s = this.getCommands(this.temp, this.temp2, "select");
                this.clearTemp();
                break;
            }
            default: {
                s = shape.getShapeState();
            }
        }
        return s;
    }

    private String getFontLineShapeState(FontLineShape shape) {
        String s = this.getFontState(shape.myType, shape.font3d);
        if (shape.tickInfos == null) {
            return s;
        }
        boolean isOff = s.indexOf(" off") >= 0;
        SB sb = new SB();
        sb.append(s);
        for (int i = 0; i < 4; ++i) {
            if (shape.tickInfos[i] == null) continue;
            this.appendTickInfo(shape.myType, sb, shape.tickInfos[i]);
        }
        if (isOff) {
            sb.append("  " + shape.myType + " off;\n");
        }
        return sb.toString();
    }

    private String getAxesState(Axes axes) {
        String[] labels;
        SB sb = new SB();
        sb.append(this.getFontLineShapeState(axes));
        sb.append("  axes scale ").appendF(this.vwr.getFloat(0x22000002)).append(";\n");
        if (axes.fixedOrigin != null) {
            sb.append("  axes center ").append(Escape.eP(axes.fixedOrigin)).append(";\n");
        }
        P3 axisXY = axes.axisXY;
        if (axisXY.z != 0.0f) {
            sb.append("  axes position [").appendI((int)axisXY.x).append(" ").appendI((int)axisXY.y).append(" ").append(axisXY.z < 0.0f ? " %" : "").append("];\n");
        }
        if ((labels = axes.labels) != null) {
            sb.append("  axes labels ");
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i] == null) continue;
                sb.append(PT.esc(labels[i])).append(" ");
            }
            sb.append(";\n");
        }
        if (axes.axisType != null) {
            sb.append("  axes type " + PT.esc(axes.axisType));
        }
        return sb.toString();
    }

    @Override
    public String getAtomShapeState(AtomShape shape) {
        int i;
        boolean isVector;
        if (!shape.isActive) {
            return "";
        }
        this.clearTemp();
        String type = JC.shapeClassBases[shape.shapeID];
        boolean bl = isVector = shape.shapeID == 18;
        if (shape.bsSizeSet != null) {
            i = shape.bsSizeSet.nextSetBit(0);
            while (i >= 0) {
                short mad;
                BSUtil.setMapBitSet(this.temp, i, i, type + " " + ((mad = shape.mads[i]) < 0 ? (isVector && mad < -1 ? "" + -mad : "on") : PT.escF((float)mad / 2000.0f)));
                i = shape.bsSizeSet.nextSetBit(i + 1);
            }
        }
        if (shape.bsColixSet != null) {
            i = shape.bsColixSet.nextSetBit(0);
            while (i >= 0) {
                BSUtil.setMapBitSet(this.temp2, i, i, Shape.getColorCommand(type, shape.paletteIDs[i], shape.colixes[i], shape.translucentAllowed));
                i = shape.bsColixSet.nextSetBit(i + 1);
            }
        }
        String s = this.getCommands(this.temp, this.temp2, "select");
        this.clearTemp();
        return s;
    }

    private String getTextState(Text t) {
        SB s = new SB();
        String text = t.text;
        if (text == null || !t.isEcho || t.target.equals("error")) {
            return "";
        }
        boolean isImage = t.image != null;
        String strOff = null;
        String echoCmd = "set echo ID " + PT.esc(t.target);
        switch (t.valign) {
            case 3: {
                strOff = t.movableXPercent == Integer.MAX_VALUE || t.movableYPercent == Integer.MAX_VALUE ? (t.movableXPercent == Integer.MAX_VALUE ? t.movableX + " " : t.movableXPercent + "% ") + (t.movableYPercent == Integer.MAX_VALUE ? t.movableY + "" : t.movableYPercent + "%") : "[" + t.movableXPercent + " " + t.movableYPercent + "%]";
            }
            case 4: {
                if (strOff == null) {
                    strOff = Escape.eP(t.xyz);
                }
                s.append("  ").append(echoCmd).append(" ").append(strOff);
                if (t.align == 4) break;
                s.append(";  ").append(echoCmd).append(" ").append(JC.getHorizAlignmentName(t.align));
                break;
            }
            default: {
                s.append("  set echo ").append(JC.getEchoName(t.valign)).append(" ").append(JC.getHorizAlignmentName(t.align));
            }
        }
        if (t.movableZPercent != Integer.MAX_VALUE) {
            s.append(";  ").append(echoCmd).append(" depth ").appendI(t.movableZPercent);
        }
        if (isImage) {
            s.append("; ").append(echoCmd).append(" IMAGE /*file*/");
        } else {
            s.append("; echo ");
        }
        s.append(PT.esc(text));
        s.append(";\n");
        if (isImage && t.imageScale != 1.0f) {
            s.append("  ").append(echoCmd).append(" scale ").appendF(t.imageScale).append(";\n");
        }
        if (t.script != null) {
            s.append("  ").append(echoCmd).append(" script ").append(PT.esc(t.script)).append(";\n");
        }
        if (t.modelIndex >= 0) {
            s.append("  ").append(echoCmd).append(" model ").append(this.vwr.getModelNumberDotted(t.modelIndex)).append(";\n");
        }
        if (t.pointerPt != null) {
            s.append("  ").append(echoCmd).append(" point ").append(t.pointerPt instanceof Atom ? "({" + ((Atom)t.pointerPt).i + "})" : Escape.eP(t.pointerPt)).append(";\n");
        }
        if (t.pymolOffset != null) {
            s.append("  ").append(echoCmd).append(" offset ").append(Escape.escapeFloatA(t.pymolOffset, true)).append(";\n");
        }
        t.appendFontCmd(s);
        s.append("; color echo");
        if (C.isColixTranslucent(t.colix)) {
            s.append(C.getColixTranslucencyLabel(t.colix));
        }
        s.append(" ").append(C.getHexCode(t.colix));
        if (t.bgcolix != 0) {
            s.append("; color echo background ");
            if (C.isColixTranslucent(t.bgcolix)) {
                s.append(C.getColixTranslucencyLabel(t.bgcolix)).append(" ");
            }
            s.append(C.getHexCode(t.bgcolix));
        }
        s.append(";\n");
        return s.toString();
    }

    @Override
    String getAllSettings(String prefix) {
        Object value;
        GlobalSettings g = this.vwr.g;
        SB commands = new SB();
        Object[] list = new String[g.htBooleanParameterFlags.size() + g.htNonbooleanParameterValues.size() + g.htUserVariables.size()];
        int n = 0;
        String _prefix = "_" + prefix;
        for (String key : g.htBooleanParameterFlags.keySet()) {
            if (prefix != null && key.indexOf(prefix) != 0 && key.indexOf(_prefix) != 0) continue;
            list[n++] = (key.indexOf("_") == 0 ? key + " = " : "set " + key + " ") + g.htBooleanParameterFlags.get(key);
        }
        for (String key : g.htNonbooleanParameterValues.keySet()) {
            if (key.charAt(0) == '@' || prefix != null && key.indexOf(prefix) != 0 && key.indexOf(_prefix) != 0) continue;
            value = g.htNonbooleanParameterValues.get(key);
            if (value instanceof String) {
                value = StateCreator.chop(PT.esc((String)value));
            }
            list[n++] = (key.indexOf("_") == 0 ? key + " = " : "set " + key + " ") + value;
        }
        for (String key : g.htUserVariables.keySet()) {
            if (prefix != null && key.indexOf(prefix) != 0) continue;
            value = g.htUserVariables.get(key);
            String s = ((SV)value).escape();
            list[n++] = key + " " + (key.startsWith("@") ? "" : "= ") + (((SV)value).tok == 4 ? StateCreator.chop(PT.esc(s)) : s);
        }
        Arrays.sort(list, 0, n);
        for (int i = 0; i < n; ++i) {
            if (list[i] == null) continue;
            this.app(commands, (String)list[i]);
        }
        commands.append("\n");
        return commands.toString();
    }

    private static String chop(String s) {
        int len = s.length();
        if (len < 512) {
            return s;
        }
        SB sb = new SB();
        String sep = "\"\\\n    + \"";
        int pt = 0;
        for (int i = 72; i < len; i += 72) {
            while (s.charAt(i - 1) == '\\') {
                ++i;
            }
            sb.append(pt == 0 ? "" : sep).append(s.substring(pt, i));
            pt = i;
        }
        sb.append(sep).append(s.substring(pt, len));
        return sb.toString();
    }

    @Override
    String getFunctionCalls(String f) {
        boolean namesOnly;
        if (f == null) {
            f = "";
        }
        SB s = new SB();
        int pt = f.indexOf("*");
        boolean isGeneric = pt >= 0;
        boolean isStatic = f.indexOf("static_") == 0;
        boolean bl = namesOnly = f.equalsIgnoreCase("names") || f.equalsIgnoreCase("static_names");
        if (namesOnly) {
            f = "";
        }
        if (isGeneric) {
            f = f.substring(0, pt);
        }
        f = f.toLowerCase();
        if (isStatic || f.length() == 0) {
            this.addFunctions(s, Viewer.staticFunctions, f, isGeneric, namesOnly);
        }
        if (!isStatic || f.length() == 0) {
            this.addFunctions(s, this.vwr.localFunctions, f, isGeneric, namesOnly);
        }
        return s.toString();
    }

    private void addFunctions(SB s, Map<String, JmolScriptFunction> ht, String selectedFunction, boolean isGeneric, boolean namesOnly) {
        Object[] names = new String[ht.size()];
        int n = 0;
        for (String name : ht.keySet()) {
            if ((selectedFunction.length() != 0 || name.startsWith("_")) && !name.equalsIgnoreCase(selectedFunction) && (!isGeneric || name.toLowerCase().indexOf(selectedFunction) != 0)) continue;
            names[n++] = name;
        }
        Arrays.sort(names, 0, n);
        for (int i = 0; i < n; ++i) {
            JmolScriptFunction f = ht.get(names[i]);
            s.append(namesOnly ? f.getSignature() : f.toString());
            s.appendC('\n');
        }
    }

    private static boolean isTainted(BS[] tainted, int atomIndex, int type) {
        return tainted != null && tainted[type] != null && tainted[type].get(atomIndex);
    }

    @Override
    String getAtomicPropertyState(int taintWhat, BS bsSelected) {
        if (!this.vwr.g.preserveState) {
            return "";
        }
        SB commands = new SB();
        for (int type = 0; type < 17; ++type) {
            BS bs;
            if (taintWhat >= 0 && type != taintWhat || (bs = bsSelected != null ? bsSelected : this.vwr.ms.getTaintedAtoms(type)) == null) continue;
            this.getAtomicPropertyStateBuffer(commands, type, bs, null, null);
        }
        return commands.toString();
    }

    @Override
    void getAtomicPropertyStateBuffer(SB commands, int type, BS bs, String label, float[] fData) {
        if (!this.vwr.g.preserveState) {
            return;
        }
        SB s = new SB();
        String dataLabel = (label == null ? AtomCollection.userSettableValues[type] : label) + " set";
        int n = 0;
        boolean isDefault = type == 2;
        Atom[] atoms = this.vwr.ms.at;
        BS[] tainted = this.vwr.ms.tainted;
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                if (!atoms[i].isDeleted()) {
                    s.appendI(i + 1).append(" ").append(atoms[i].getElementSymbol()).append(" ").append(atoms[i].getInfo().replace(' ', '_')).append(" ");
                    switch (type) {
                        case 17: {
                            if (i >= fData.length) break;
                            s.appendF(fData[i]);
                            break;
                        }
                        case 13: {
                            s.appendI(atoms[i].getAtomNumber());
                            break;
                        }
                        case 16: {
                            s.append(atoms[i].getChainIDStr());
                            break;
                        }
                        case 15: {
                            s.appendI(atoms[i].group.getResno());
                            break;
                        }
                        case 14: {
                            s.appendI(atoms[i].getSeqID());
                            break;
                        }
                        case 0: {
                            s.append(atoms[i].getAtomName());
                            break;
                        }
                        case 1: {
                            s.append(atoms[i].getAtomType());
                            break;
                        }
                        case 2: {
                            if (StateCreator.isTainted(tainted, i, 2)) {
                                isDefault = false;
                            }
                            s.appendF(atoms[i].x).append(" ").appendF(atoms[i].y).append(" ").appendF(atoms[i].z);
                            break;
                        }
                        case 12: {
                            Vibration v = atoms[i].getVibrationVector();
                            if (v == null) {
                                s.append("0 0 0");
                                break;
                            }
                            if (Float.isNaN(v.modScale)) {
                                s.appendF(v.x).append(" ").appendF(v.y).append(" ").appendF(v.z);
                                break;
                            }
                            s.appendF(Float.MIN_VALUE).append(" ").appendF(Float.MIN_VALUE).append(" ").appendF(v.modScale);
                            break;
                        }
                        case 3: {
                            s.appendI(atoms[i].getAtomicAndIsotopeNumber());
                            break;
                        }
                        case 4: {
                            s.appendI(atoms[i].getFormalCharge());
                            break;
                        }
                        case 6: {
                            s.appendF(atoms[i].getBondingRadius());
                            break;
                        }
                        case 7: {
                            s.appendI(atoms[i].getOccupancy100());
                            break;
                        }
                        case 8: {
                            s.appendF(atoms[i].getPartialCharge());
                            break;
                        }
                        case 9: {
                            s.appendF((float)atoms[i].getBfactor100() / 100.0f);
                            break;
                        }
                        case 10: {
                            s.appendI(atoms[i].getValence());
                            break;
                        }
                        case 11: {
                            s.appendF(atoms[i].getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO));
                        }
                    }
                    s.append(" ;\n");
                    ++n;
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        if (n == 0) {
            return;
        }
        if (isDefault) {
            dataLabel = dataLabel + "(default)";
        }
        commands.append("\n  DATA \"" + dataLabel + "\"\n").appendI(n).append(" ;\nJmol Property Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
        commands.appendSB(s);
        commands.append("  end \"" + dataLabel + "\";\n");
    }

    @Override
    void undoMoveAction(int action, int n) {
        block0 : switch (action) {
            case 4139: 
            case 4165: {
                switch (n) {
                    case -2: {
                        this.vwr.undoClear();
                        break block0;
                    }
                    case -1: {
                        (action == 4165 ? this.vwr.actionStates : this.vwr.actionStatesRedo).clear();
                        break block0;
                    }
                    case 0: {
                        n = Integer.MAX_VALUE;
                    }
                }
                if (n > 100) {
                    n = (action == 4165 ? this.vwr.actionStates : this.vwr.actionStatesRedo).size();
                }
                for (int i = 0; i < n; ++i) {
                    this.undoMoveActionClear(0, action, true);
                }
                break;
            }
        }
    }

    @Override
    void undoMoveActionClear(int taintedAtom, int type, boolean clearRedo) {
        if (!this.vwr.g.preserveState) {
            return;
        }
        int modelIndex = taintedAtom >= 0 ? (int)this.vwr.ms.at[taintedAtom].mi : this.vwr.ms.mc - 1;
        switch (type) {
            case 4139: 
            case 4165: {
                Lst<String> list2;
                Lst<String> list1;
                this.vwr.stopMinimization();
                String s = "";
                switch (type) {
                    default: {
                        list1 = this.vwr.actionStates;
                        list2 = this.vwr.actionStatesRedo;
                        break;
                    }
                    case 4139: {
                        list1 = this.vwr.actionStatesRedo;
                        list2 = this.vwr.actionStates;
                        if (this.vwr.actionStatesRedo.size() != 1) break;
                        return;
                    }
                }
                if (list1.size() == 0 || this.undoWorking) {
                    return;
                }
                this.undoWorking = true;
                list2.add(0, list1.removeItemAt(0));
                s = (String)this.vwr.actionStatesRedo.get(0);
                if (type == 4165 && list2.size() == 1) {
                    int[] pt = new int[]{1};
                    type = PT.parseIntNext(s, pt);
                    taintedAtom = PT.parseIntNext(s, pt);
                    this.undoMoveActionClear(taintedAtom, type, false);
                }
                if (this.vwr.ms.am[modelIndex].isModelKit || s.indexOf("zap ") < 0) {
                    if (Logger.debugging) {
                        this.vwr.log(s);
                    }
                    this.vwr.evalStringQuiet(s);
                    break;
                }
                this.vwr.actionStates.clear();
                break;
            }
            default: {
                if (this.undoWorking && clearRedo) {
                    return;
                }
                this.undoWorking = true;
                SB sb = new SB();
                sb.append("#" + type + " " + taintedAtom + " " + new Date() + "\n");
                if (taintedAtom >= 0) {
                    BS bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
                    this.vwr.ms.taintAtoms(bs, type);
                    sb.append(this.getAtomicPropertyState(-1, null));
                } else {
                    BS bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
                    sb.append("zap ");
                    sb.append(Escape.eBS(bs)).append(";");
                    this.getInlineData(sb, this.vwr.getModelExtract(bs, false, true, "MOL"), true, null);
                    sb.append("set refreshing false;").append(this.vwr.acm.getPickingState()).append(this.vwr.tm.getMoveToText(0.0f, false)).append("set refreshing true;");
                }
                if (clearRedo) {
                    this.vwr.actionStates.add(0, sb.toString());
                    this.vwr.actionStatesRedo.clear();
                } else {
                    this.vwr.actionStatesRedo.add(1, sb.toString());
                }
                if (this.vwr.actionStates.size() != 100) break;
                this.vwr.actionStates.removeItemAt(99);
            }
        }
        this.undoWorking = !clearRedo;
    }
}

