/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.DecoratedCommand;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class CommandWrapper<K, V, T>
implements RedisCommand<K, V, T>,
CompleteableCommand<T>,
DecoratedCommand<K, V, T> {
    private static final AtomicReferenceFieldUpdater<CommandWrapper, Object[]> ONCOMPLETE = AtomicReferenceFieldUpdater.newUpdater(CommandWrapper.class, Object[].class, "onComplete");
    private static final Object[] EMPTY = new Object[0];
    private static final Object[] COMPLETE = new Object[0];
    protected final RedisCommand<K, V, T> command;
    private volatile Object[] onComplete = EMPTY;

    public CommandWrapper(RedisCommand<K, V, T> command) {
        this.command = command;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.command.getOutput();
    }

    @Override
    public void complete() {
        Object[] consumers = ONCOMPLETE.get(this);
        if (consumers != COMPLETE && ONCOMPLETE.compareAndSet(this, consumers, COMPLETE)) {
            this.command.complete();
            this.doOnComplete();
            this.notifyConsumers(consumers);
        }
    }

    protected void doOnComplete() {
    }

    private void notifyConsumers(Object[] consumers) {
        for (Object callback : consumers) {
            Object consumer;
            if (callback instanceof Consumer) {
                consumer = (Consumer)callback;
                if (this.getOutput() != null) {
                    consumer.accept(this.getOutput().get());
                } else {
                    consumer.accept(null);
                }
            }
            if (!(callback instanceof BiConsumer)) continue;
            consumer = (BiConsumer)callback;
            if (this.getOutput() != null) {
                consumer.accept(this.getOutput().get(), null);
                continue;
            }
            consumer.accept(null, null);
        }
    }

    @Override
    public void cancel() {
        Object[] consumers = ONCOMPLETE.get(this);
        if (consumers != COMPLETE && ONCOMPLETE.compareAndSet(this, consumers, COMPLETE)) {
            this.command.cancel();
            CancellationException exception = new CancellationException();
            this.doOnError(exception);
            this.notifyBiConsumer(consumers, exception);
        }
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        Object[] consumers = ONCOMPLETE.get(this);
        boolean result = false;
        if (consumers != COMPLETE && ONCOMPLETE.compareAndSet(this, consumers, COMPLETE)) {
            result = this.command.completeExceptionally(throwable);
            this.doOnError(throwable);
            this.notifyBiConsumer(consumers, throwable);
        }
        return result;
    }

    protected void doOnError(Throwable throwable) {
    }

    private void notifyBiConsumer(Object[] consumers, Throwable exception) {
        for (Object callback : consumers) {
            if (!(callback instanceof BiConsumer)) continue;
            BiConsumer consumer = (BiConsumer)callback;
            if (this.getOutput() != null) {
                consumer.accept(this.getOutput().get(), exception);
                continue;
            }
            consumer.accept(null, exception);
        }
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public boolean isCancelled() {
        return this.command.isCancelled();
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        this.command.setOutput(output);
    }

    @Override
    public void onComplete(Consumer<? super T> action) {
        this.addOnComplete(action);
    }

    @Override
    public void onComplete(BiConsumer<? super T, Throwable> action) {
        this.addOnComplete(action);
    }

    private void addOnComplete(Object action) {
        Object[] updated;
        Object[] existing;
        do {
            existing = ONCOMPLETE.get(this);
            updated = new Object[existing.length + 1];
            System.arraycopy(existing, 0, updated, 0, existing.length);
            updated[existing.length] = action;
        } while (!ONCOMPLETE.compareAndSet(this, existing, updated));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.getType());
        sb.append(", output=").append(this.getOutput());
        sb.append(", commandType=").append(this.command.getClass().getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean isDone() {
        return this.command.isDone();
    }

    @Override
    public RedisCommand<K, V, T> getDelegate() {
        return this.command;
    }

    public static <K, V, T> RedisCommand<K, V, T> unwrap(RedisCommand<K, V, T> wrapped) {
        RedisCommand<K, V, T> result = wrapped;
        while (result instanceof DecoratedCommand) {
            result = ((DecoratedCommand)((Object)result)).getDelegate();
        }
        return result;
    }

    public static <R, K, V, T> R unwrap(RedisCommand<K, V, T> wrapped, Class<R> iface) {
        RedisCommand<K, V, T> result = wrapped;
        if (iface.isInstance(wrapped)) {
            return iface.cast(wrapped);
        }
        while (result instanceof DecoratedCommand) {
            if (!iface.isInstance(result = ((DecoratedCommand)((Object)result)).getDelegate())) continue;
            return iface.cast(result);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisCommand)) {
            return false;
        }
        RedisCommand<K, V, T> left = this.command;
        while (left instanceof DecoratedCommand) {
            left = CommandWrapper.unwrap(left);
        }
        RedisCommand<K, V, T> right = (RedisCommand<K, V, T>)o;
        while (right instanceof DecoratedCommand) {
            right = CommandWrapper.unwrap(right);
        }
        return left == right;
    }

    public int hashCode() {
        RedisCommand<K, V, T> toHash = this.command;
        while (toHash instanceof DecoratedCommand) {
            toHash = CommandWrapper.unwrap(toHash);
        }
        return toHash != null ? toHash.hashCode() : 0;
    }
}

