/* pantheon-files-core.h generated by valac 0.54.3, the Vala compiler, do not modify */

#ifndef __LIBCORE_PANTHEON_FILES_CORE_H__
#define __LIBCORE_PANTHEON_FILES_CORE_H__

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <sys/types.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_ABSTRACT_SLOT (files_abstract_slot_get_type ())
#define FILES_ABSTRACT_SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlot))
#define FILES_ABSTRACT_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlotClass))
#define FILES_IS_ABSTRACT_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_SLOT))
#define FILES_IS_ABSTRACT_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_SLOT))
#define FILES_ABSTRACT_SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_SLOT, FilesAbstractSlotClass))

typedef struct _FilesAbstractSlot FilesAbstractSlot;
typedef struct _FilesAbstractSlotClass FilesAbstractSlotClass;
typedef struct _FilesAbstractSlotPrivate FilesAbstractSlotPrivate;

#define FILES_TYPE_FILE (files_file_get_type ())
#define FILES_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE, FilesFile))
#define FILES_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE, FilesFileClass))
#define FILES_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE))
#define FILES_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE))
#define FILES_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE, FilesFileClass))

typedef struct _FilesFile FilesFile;
typedef struct _FilesFileClass FilesFileClass;

#define FILES_TYPE_DIRECTORY (files_directory_get_type ())
#define FILES_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_DIRECTORY, FilesDirectory))
#define FILES_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_DIRECTORY, FilesDirectoryClass))
#define FILES_IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_DIRECTORY))
#define FILES_IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_DIRECTORY))
#define FILES_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_DIRECTORY, FilesDirectoryClass))

typedef struct _FilesDirectory FilesDirectory;
typedef struct _FilesDirectoryClass FilesDirectoryClass;

#define FILES_TYPE_BOOKMARK (files_bookmark_get_type ())
#define FILES_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_BOOKMARK, FilesBookmark))
#define FILES_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_BOOKMARK, FilesBookmarkClass))
#define FILES_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_BOOKMARK))
#define FILES_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_BOOKMARK))
#define FILES_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_BOOKMARK, FilesBookmarkClass))

typedef struct _FilesBookmark FilesBookmark;
typedef struct _FilesBookmarkClass FilesBookmarkClass;
typedef struct _FilesBookmarkPrivate FilesBookmarkPrivate;

#define FILES_TYPE_BOOKMARK_LIST (files_bookmark_list_get_type ())
#define FILES_BOOKMARK_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_BOOKMARK_LIST, FilesBookmarkList))
#define FILES_BOOKMARK_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_BOOKMARK_LIST, FilesBookmarkListClass))
#define FILES_IS_BOOKMARK_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_BOOKMARK_LIST))
#define FILES_IS_BOOKMARK_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_BOOKMARK_LIST))
#define FILES_BOOKMARK_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_BOOKMARK_LIST, FilesBookmarkListClass))

typedef struct _FilesBookmarkList FilesBookmarkList;
typedef struct _FilesBookmarkListClass FilesBookmarkListClass;
typedef struct _FilesBookmarkListPrivate FilesBookmarkListPrivate;

#define FILES_CONNECT_SERVER_TYPE_OPERATION (files_connect_server_operation_get_type ())
#define FILES_CONNECT_SERVER_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_CONNECT_SERVER_TYPE_OPERATION, FilesConnectServerOperation))
#define FILES_CONNECT_SERVER_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_CONNECT_SERVER_TYPE_OPERATION, FilesConnectServerOperationClass))
#define FILES_CONNECT_SERVER_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_CONNECT_SERVER_TYPE_OPERATION))
#define FILES_CONNECT_SERVER_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_CONNECT_SERVER_TYPE_OPERATION))
#define FILES_CONNECT_SERVER_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_CONNECT_SERVER_TYPE_OPERATION, FilesConnectServerOperationClass))

typedef struct _FilesConnectServerOperation FilesConnectServerOperation;
typedef struct _FilesConnectServerOperationClass FilesConnectServerOperationClass;
typedef struct _FilesConnectServerOperationPrivate FilesConnectServerOperationPrivate;

#define PF_TYPE_CONNECT_SERVER_DIALOG (pf_connect_server_dialog_get_type ())
#define PF_CONNECT_SERVER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialog))
#define PF_CONNECT_SERVER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialogClass))
#define PF_IS_CONNECT_SERVER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_TYPE_CONNECT_SERVER_DIALOG))
#define PF_IS_CONNECT_SERVER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_TYPE_CONNECT_SERVER_DIALOG))
#define PF_CONNECT_SERVER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialogClass))

typedef struct _PFConnectServerDialog PFConnectServerDialog;
typedef struct _PFConnectServerDialogClass PFConnectServerDialogClass;
typedef struct _PFConnectServerDialogPrivate PFConnectServerDialogPrivate;

#define FILES_TYPE_DND_HANDLER (files_dnd_handler_get_type ())
#define FILES_DND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_DND_HANDLER, FilesDndHandler))
#define FILES_DND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_DND_HANDLER, FilesDndHandlerClass))
#define FILES_IS_DND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_DND_HANDLER))
#define FILES_IS_DND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_DND_HANDLER))
#define FILES_DND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_DND_HANDLER, FilesDndHandlerClass))

typedef struct _FilesDndHandler FilesDndHandler;
typedef struct _FilesDndHandlerClass FilesDndHandlerClass;
typedef struct _FilesDndHandlerPrivate FilesDndHandlerPrivate;
typedef enum  {
	FILES_WINDOW_STATE_NORMAL,
	FILES_WINDOW_STATE_TILED_START,
	FILES_WINDOW_STATE_TILED_END,
	FILES_WINDOW_STATE_MAXIMIZED,
	FILES_WINDOW_STATE_INVALID
} FilesWindowState;

#define FILES_TYPE_WINDOW_STATE (files_window_state_get_type ())
typedef enum  {
	FILES_VIEW_MODE_ICON = 0,
	FILES_VIEW_MODE_LIST = 1,
	FILES_VIEW_MODE_MILLER_COLUMNS = 2,
	FILES_VIEW_MODE_CURRENT,
	FILES_VIEW_MODE_PREFERRED,
	FILES_VIEW_MODE_INVALID
} FilesViewMode;

#define FILES_TYPE_VIEW_MODE (files_view_mode_get_type ())
typedef enum  {
	FILES_OPEN_FLAG_DEFAULT,
	FILES_OPEN_FLAG_NEW_ROOT,
	FILES_OPEN_FLAG_NEW_TAB,
	FILES_OPEN_FLAG_NEW_WINDOW,
	FILES_OPEN_FLAG_APP
} FilesOpenFlag;

#define FILES_TYPE_OPEN_FLAG (files_open_flag_get_type ())
typedef enum  {
	FILES_ZOOM_LEVEL_SMALLEST,
	FILES_ZOOM_LEVEL_SMALLER,
	FILES_ZOOM_LEVEL_SMALL,
	FILES_ZOOM_LEVEL_NORMAL,
	FILES_ZOOM_LEVEL_LARGE,
	FILES_ZOOM_LEVEL_LARGER,
	FILES_ZOOM_LEVEL_HUGE,
	FILES_ZOOM_LEVEL_HUGER,
	FILES_ZOOM_LEVEL_LARGEST,
	FILES_ZOOM_LEVEL_N_LEVELS,
	FILES_ZOOM_LEVEL_INVALID
} FilesZoomLevel;

#define FILES_TYPE_ZOOM_LEVEL (files_zoom_level_get_type ())
typedef enum  {
	FILES_ICON_SIZE_EMBLEM = 16,
	FILES_ICON_SIZE_SMALLEST = 16,
	FILES_ICON_SIZE_LARGE_EMBLEM = 24,
	FILES_ICON_SIZE_SMALLER = 24,
	FILES_ICON_SIZE_SMALL = 32,
	FILES_ICON_SIZE_NORMAL = 48,
	FILES_ICON_SIZE_LARGE = 64,
	FILES_ICON_SIZE_LARGER = 96,
	FILES_ICON_SIZE_HUGE = 128,
	FILES_ICON_SIZE_HUGER = 192,
	FILES_ICON_SIZE_LARGEST = 256
} FilesIconSize;

#define FILES_TYPE_ICON_SIZE (files_icon_size_get_type ())
typedef enum  {
	FILES_TARGET_TYPE_STRING,
	FILES_TARGET_TYPE_TEXT_URI_LIST,
	FILES_TARGET_TYPE_XDND_DIRECT_SAVE0,
	FILES_TARGET_TYPE_NETSCAPE_URL,
	FILES_TARGET_TYPE_BOOKMARK_ROW
} FilesTargetType;

#define FILES_TYPE_TARGET_TYPE (files_target_type_get_type ())
typedef struct _FilesFilePrivate FilesFilePrivate;
typedef enum  {
	FILES_FILE_ICON_FLAGS_NONE,
	FILES_FILE_ICON_FLAGS_USE_THUMBNAILS
} FilesFileIconFlags;

#define FILES_FILE_TYPE_ICON_FLAGS (files_file_icon_flags_get_type ())
typedef enum  {
	FILES_FILE_THUMB_STATE_UNKNOWN,
	FILES_FILE_THUMB_STATE_NONE,
	FILES_FILE_THUMB_STATE_READY,
	FILES_FILE_THUMB_STATE_LOADING
} FilesFileThumbState;

#define FILES_FILE_TYPE_THUMB_STATE (files_file_thumb_state_get_type ())

#define FILES_TYPE_ICON_INFO (files_icon_info_get_type ())
#define FILES_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ICON_INFO, FilesIconInfo))
#define FILES_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ICON_INFO, FilesIconInfoClass))
#define FILES_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ICON_INFO))
#define FILES_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ICON_INFO))
#define FILES_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ICON_INFO, FilesIconInfoClass))

typedef struct _FilesIconInfo FilesIconInfo;
typedef struct _FilesIconInfoClass FilesIconInfoClass;

#define FILES_TYPE_FILE_CONFLICT_DIALOG (files_file_conflict_dialog_get_type ())
#define FILES_FILE_CONFLICT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialog))
#define FILES_FILE_CONFLICT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialogClass))
#define FILES_IS_FILE_CONFLICT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CONFLICT_DIALOG))
#define FILES_IS_FILE_CONFLICT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CONFLICT_DIALOG))
#define FILES_FILE_CONFLICT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialogClass))

typedef struct _FilesFileConflictDialog FilesFileConflictDialog;
typedef struct _FilesFileConflictDialogClass FilesFileConflictDialogClass;
typedef struct _FilesFileConflictDialogPrivate FilesFileConflictDialogPrivate;
typedef enum  {
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_SKIP,
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME,
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_REPLACE,
	FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_NEWEST
} FilesFileConflictDialogResponseType;

#define FILES_FILE_CONFLICT_DIALOG_TYPE_RESPONSE_TYPE (files_file_conflict_dialog_response_type_get_type ())

#define FILES_TYPE_LIST_MODEL (files_list_model_get_type ())
#define FILES_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_LIST_MODEL, FilesListModel))
#define FILES_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_LIST_MODEL, FilesListModelClass))
#define FILES_IS_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_LIST_MODEL))
#define FILES_IS_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_LIST_MODEL))
#define FILES_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_LIST_MODEL, FilesListModelClass))

typedef struct _FilesListModel FilesListModel;
typedef struct _FilesListModelClass FilesListModelClass;
typedef struct _FilesListModelPrivate FilesListModelPrivate;
typedef enum  {
	FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN,
	FILES_LIST_MODEL_COLUMN_ID_COLOR,
	FILES_LIST_MODEL_COLUMN_ID_PIXBUF,
	FILES_LIST_MODEL_COLUMN_ID_FILENAME,
	FILES_LIST_MODEL_COLUMN_ID_SIZE,
	FILES_LIST_MODEL_COLUMN_ID_TYPE,
	FILES_LIST_MODEL_COLUMN_ID_MODIFIED,
	FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS
} FilesListModelColumnID;

#define FILES_LIST_MODEL_TYPE_COLUMN_ID (files_list_model_column_id_get_type ())

#define FILES_TYPE_CALL_WHEN_READY (files_call_when_ready_get_type ())
#define FILES_CALL_WHEN_READY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_CALL_WHEN_READY, FilesCallWhenReady))
#define FILES_CALL_WHEN_READY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_CALL_WHEN_READY, FilesCallWhenReadyClass))
#define FILES_IS_CALL_WHEN_READY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_CALL_WHEN_READY))
#define FILES_IS_CALL_WHEN_READY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_CALL_WHEN_READY))
#define FILES_CALL_WHEN_READY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_CALL_WHEN_READY, FilesCallWhenReadyClass))

typedef struct _FilesCallWhenReady FilesCallWhenReady;
typedef struct _FilesCallWhenReadyClass FilesCallWhenReadyClass;
typedef struct _FilesCallWhenReadyPrivate FilesCallWhenReadyPrivate;
typedef void (*FilesCallWhenReadycall_when_ready_func) (GList* files, gpointer user_data);
typedef struct _FilesDirectoryPrivate FilesDirectoryPrivate;
typedef enum  {
	FILES_DIRECTORY_STATE_NOT_LOADED,
	FILES_DIRECTORY_STATE_LOADING,
	FILES_DIRECTORY_STATE_LOADED,
	FILES_DIRECTORY_STATE_TIMED_OUT
} FilesDirectoryState;

#define FILES_DIRECTORY_TYPE_STATE (files_directory_state_get_type ())
typedef void (*FilesDirectoryFileLoadedFunc) (FilesFile* file, gpointer user_data);

#define FILES_TYPE_PREFERENCES (files_preferences_get_type ())
#define FILES_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_PREFERENCES, FilesPreferences))
#define FILES_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_PREFERENCES, FilesPreferencesClass))
#define FILES_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_PREFERENCES))
#define FILES_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_PREFERENCES))
#define FILES_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_PREFERENCES, FilesPreferencesClass))

typedef struct _FilesPreferences FilesPreferences;
typedef struct _FilesPreferencesClass FilesPreferencesClass;
typedef struct _FilesPreferencesPrivate FilesPreferencesPrivate;

#define FILES_TYPE_PLUGIN_MANAGER (files_plugin_manager_get_type ())
#define FILES_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_PLUGIN_MANAGER, FilesPluginManager))
#define FILES_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_PLUGIN_MANAGER, FilesPluginManagerClass))
#define FILES_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_PLUGIN_MANAGER))
#define FILES_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_PLUGIN_MANAGER))
#define FILES_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_PLUGIN_MANAGER, FilesPluginManagerClass))

typedef struct _FilesPluginManager FilesPluginManager;
typedef struct _FilesPluginManagerClass FilesPluginManagerClass;
typedef struct _FilesPluginManagerPrivate FilesPluginManagerPrivate;

#define FILES_PLUGINS_TYPE_BASE (files_plugins_base_get_type ())
#define FILES_PLUGINS_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_PLUGINS_TYPE_BASE, FilesPluginsBase))
#define FILES_PLUGINS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_PLUGINS_TYPE_BASE, FilesPluginsBaseClass))
#define FILES_PLUGINS_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_PLUGINS_TYPE_BASE))
#define FILES_PLUGINS_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_PLUGINS_TYPE_BASE))
#define FILES_PLUGINS_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_PLUGINS_TYPE_BASE, FilesPluginsBaseClass))

typedef struct _FilesPluginsBase FilesPluginsBase;
typedef struct _FilesPluginsBaseClass FilesPluginsBaseClass;
typedef struct _FilesPluginsBasePrivate FilesPluginsBasePrivate;

#define PF_PROGRESS_TYPE_INFO (pf_progress_info_get_type ())
#define PF_PROGRESS_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_PROGRESS_TYPE_INFO, PFProgressInfo))
#define PF_PROGRESS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_PROGRESS_TYPE_INFO, PFProgressInfoClass))
#define PF_PROGRESS_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_PROGRESS_TYPE_INFO))
#define PF_PROGRESS_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_PROGRESS_TYPE_INFO))
#define PF_PROGRESS_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_PROGRESS_TYPE_INFO, PFProgressInfoClass))

typedef struct _PFProgressInfo PFProgressInfo;
typedef struct _PFProgressInfoClass PFProgressInfoClass;
typedef struct _PFProgressInfoPrivate PFProgressInfoPrivate;

#define PF_PROGRESS_TYPE_INFO_MANAGER (pf_progress_info_manager_get_type ())
#define PF_PROGRESS_INFO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_PROGRESS_TYPE_INFO_MANAGER, PFProgressInfoManager))
#define PF_PROGRESS_INFO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_PROGRESS_TYPE_INFO_MANAGER, PFProgressInfoManagerClass))
#define PF_PROGRESS_IS_INFO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_PROGRESS_TYPE_INFO_MANAGER))
#define PF_PROGRESS_IS_INFO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_PROGRESS_TYPE_INFO_MANAGER))
#define PF_PROGRESS_INFO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_PROGRESS_TYPE_INFO_MANAGER, PFProgressInfoManagerClass))

typedef struct _PFProgressInfoManager PFProgressInfoManager;
typedef struct _PFProgressInfoManagerClass PFProgressInfoManagerClass;
typedef struct _PFProgressInfoManagerPrivate PFProgressInfoManagerPrivate;

#define FILES_TYPE_SIDEBAR_PLUGIN_ITEM (files_sidebar_plugin_item_get_type ())
#define FILES_SIDEBAR_PLUGIN_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_SIDEBAR_PLUGIN_ITEM, FilesSidebarPluginItem))
#define FILES_SIDEBAR_PLUGIN_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_SIDEBAR_PLUGIN_ITEM, FilesSidebarPluginItemClass))
#define FILES_IS_SIDEBAR_PLUGIN_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_SIDEBAR_PLUGIN_ITEM))
#define FILES_IS_SIDEBAR_PLUGIN_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_SIDEBAR_PLUGIN_ITEM))
#define FILES_SIDEBAR_PLUGIN_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_SIDEBAR_PLUGIN_ITEM, FilesSidebarPluginItemClass))

typedef struct _FilesSidebarPluginItem FilesSidebarPluginItem;
typedef struct _FilesSidebarPluginItemClass FilesSidebarPluginItemClass;
typedef struct _FilesSidebarPluginItemPrivate FilesSidebarPluginItemPrivate;
typedef enum  {
	FILES_PLACE_TYPE_BUILT_IN,
	FILES_PLACE_TYPE_MOUNTED_VOLUME,
	FILES_PLACE_TYPE_BOOKMARK,
	FILES_PLACE_TYPE_BOOKMARKS_CATEGORY,
	FILES_PLACE_TYPE_PERSONAL_CATEGORY,
	FILES_PLACE_TYPE_STORAGE_CATEGORY,
	FILES_PLACE_TYPE_NETWORK_CATEGORY,
	FILES_PLACE_TYPE_PLUGIN_ITEM
} FilesPlaceType;

#define FILES_TYPE_PLACE_TYPE (files_place_type_get_type ())
typedef void (*FilesSidebarCallbackFunc) (GtkWidget* widget);

#define PF_TYPE_SOUND_MANAGER (pf_sound_manager_get_type ())
#define PF_SOUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PF_TYPE_SOUND_MANAGER, PFSoundManager))
#define PF_SOUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PF_TYPE_SOUND_MANAGER, PFSoundManagerClass))
#define PF_IS_SOUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PF_TYPE_SOUND_MANAGER))
#define PF_IS_SOUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PF_TYPE_SOUND_MANAGER))
#define PF_SOUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PF_TYPE_SOUND_MANAGER, PFSoundManagerClass))

typedef struct _PFSoundManager PFSoundManager;
typedef struct _PFSoundManagerClass PFSoundManagerClass;
typedef struct _PFSoundManagerPrivate PFSoundManagerPrivate;

#define FILES_TYPE_TRASH_MONITOR (files_trash_monitor_get_type ())
#define FILES_TRASH_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_TRASH_MONITOR, FilesTrashMonitor))
#define FILES_TRASH_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_TRASH_MONITOR, FilesTrashMonitorClass))
#define FILES_IS_TRASH_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_TRASH_MONITOR))
#define FILES_IS_TRASH_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_TRASH_MONITOR))
#define FILES_TRASH_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_TRASH_MONITOR, FilesTrashMonitorClass))

typedef struct _FilesTrashMonitor FilesTrashMonitor;
typedef struct _FilesTrashMonitorClass FilesTrashMonitorClass;
typedef struct _FilesTrashMonitorPrivate FilesTrashMonitorPrivate;
typedef enum  {
	MARLIN_UNDO_COPY,
	MARLIN_UNDO_DUPLICATE,
	MARLIN_UNDO_MOVE,
	MARLIN_UNDO_RENAME,
	MARLIN_UNDO_CREATEEMPTYFILE,
	MARLIN_UNDO_CREATEFILEFROMTEMPLATE,
	MARLIN_UNDO_CREATEFOLDER,
	MARLIN_UNDO_MOVETOTRASH,
	MARLIN_UNDO_CREATELINK,
	MARLIN_UNDO_RESTOREFROMTRASH,
	MARLIN_UNDO_SETPERMISSIONS,
	MARLIN_UNDO_RECURSIVESETPERMISSIONS,
	MARLIN_UNDO_CHANGEOWNER,
	MARLIN_UNDO_CHANGEGROUP
} FilesUndoActionType;

#define FILES_TYPE_UNDO_ACTION_TYPE (files_undo_action_type_get_type ())

#define FILES_TYPE_UNDO_ACTION_DATA (files_undo_action_data_get_type ())
#define FILES_UNDO_ACTION_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionData))
#define FILES_UNDO_ACTION_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionDataClass))
#define FILES_IS_UNDO_ACTION_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_UNDO_ACTION_DATA))
#define FILES_IS_UNDO_ACTION_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_UNDO_ACTION_DATA))
#define FILES_UNDO_ACTION_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionDataClass))

typedef struct _FilesUndoActionData FilesUndoActionData;
typedef struct _FilesUndoActionDataClass FilesUndoActionDataClass;
typedef struct _FilesUndoActionDataPrivate FilesUndoActionDataPrivate;

#define FILES_TYPE_UNDO_MANAGER (files_undo_manager_get_type ())
#define FILES_UNDO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_UNDO_MANAGER, FilesUndoManager))
#define FILES_UNDO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_UNDO_MANAGER, FilesUndoManagerClass))
#define FILES_IS_UNDO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_UNDO_MANAGER))
#define FILES_IS_UNDO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_UNDO_MANAGER))
#define FILES_UNDO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_UNDO_MANAGER, FilesUndoManagerClass))

typedef struct _FilesUndoManager FilesUndoManager;
typedef struct _FilesUndoManagerClass FilesUndoManagerClass;
typedef struct _FilesUndoManagerPrivate FilesUndoManagerPrivate;
typedef struct _FilesIconInfoPrivate FilesIconInfoPrivate;

#define FILES_TYPE_THUMBNAILER_DAEMON (files_thumbnailer_daemon_get_type ())
#define FILES_THUMBNAILER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_THUMBNAILER_DAEMON, FilesThumbnailerDaemon))
#define FILES_IS_THUMBNAILER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_THUMBNAILER_DAEMON))
#define FILES_THUMBNAILER_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_TYPE_THUMBNAILER_DAEMON, FilesThumbnailerDaemonIface))

typedef struct _FilesThumbnailerDaemon FilesThumbnailerDaemon;
typedef struct _FilesThumbnailerDaemonIface FilesThumbnailerDaemonIface;

#define FILES_TYPE_THUMBNAILER_DAEMON_PROXY (files_thumbnailer_daemon_proxy_get_type ())

#define FILES_TYPE_THUMBNAILER (files_thumbnailer_get_type ())
#define FILES_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_THUMBNAILER, FilesThumbnailer))
#define FILES_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_THUMBNAILER, FilesThumbnailerClass))
#define FILES_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_THUMBNAILER))
#define FILES_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_THUMBNAILER))
#define FILES_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_THUMBNAILER, FilesThumbnailerClass))

typedef struct _FilesThumbnailer FilesThumbnailer;
typedef struct _FilesThumbnailerClass FilesThumbnailerClass;
typedef struct _FilesThumbnailerPrivate FilesThumbnailerPrivate;

#define MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB (marlin_file_operations_common_job_get_type ())
#define MARLIN_FILE_OPERATIONS_COMMON_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJob))
#define MARLIN_FILE_OPERATIONS_COMMON_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJobClass))
#define MARLIN_FILE_OPERATIONS_IS_COMMON_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB))
#define MARLIN_FILE_OPERATIONS_IS_COMMON_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB))
#define MARLIN_FILE_OPERATIONS_COMMON_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, FilesFileOperationsCommonJobClass))

typedef struct _FilesFileOperationsCommonJob FilesFileOperationsCommonJob;
typedef struct _FilesFileOperationsCommonJobClass FilesFileOperationsCommonJobClass;
typedef struct _FilesFileOperationsCommonJobPrivate FilesFileOperationsCommonJobPrivate;

#define MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB (marlin_file_operations_empty_trash_job_get_type ())
#define MARLIN_FILE_OPERATIONS_EMPTY_TRASH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB, FilesFileOperationsEmptyTrashJob))
#define MARLIN_FILE_OPERATIONS_EMPTY_TRASH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB, FilesFileOperationsEmptyTrashJobClass))
#define MARLIN_FILE_OPERATIONS_IS_EMPTY_TRASH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB))
#define MARLIN_FILE_OPERATIONS_IS_EMPTY_TRASH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB))
#define MARLIN_FILE_OPERATIONS_EMPTY_TRASH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MARLIN_FILE_OPERATIONS_TYPE_EMPTY_TRASH_JOB, FilesFileOperationsEmptyTrashJobClass))

typedef struct _FilesFileOperationsEmptyTrashJob FilesFileOperationsEmptyTrashJob;
typedef struct _FilesFileOperationsEmptyTrashJobClass FilesFileOperationsEmptyTrashJobClass;
typedef struct _FilesFileOperationsEmptyTrashJobPrivate FilesFileOperationsEmptyTrashJobPrivate;

#define FILES_TYPE_SIDEBAR_INTERFACE (files_sidebar_interface_get_type ())
#define FILES_SIDEBAR_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_SIDEBAR_INTERFACE, FilesSidebarInterface))
#define FILES_IS_SIDEBAR_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_SIDEBAR_INTERFACE))
#define FILES_SIDEBAR_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FILES_TYPE_SIDEBAR_INTERFACE, FilesSidebarInterfaceIface))

typedef struct _FilesSidebarInterface FilesSidebarInterface;
typedef struct _FilesSidebarInterfaceIface FilesSidebarInterfaceIface;

struct _FilesAbstractSlot {
	GObject parent_instance;
	FilesAbstractSlotPrivate * priv;
	GtkBox* extra_location_widgets;
	GtkBox* extra_action_widgets;
	GtkBox* content_box;
	gint width;
};

struct _FilesAbstractSlotClass {
	GObjectClass parent_class;
	void (*initialize_directory) (FilesAbstractSlot* self);
	GList* (*get_selected_files) (FilesAbstractSlot* self);
	void (*set_active_state) (FilesAbstractSlot* self, gboolean set_active, gboolean animate);
	FilesAbstractSlot* (*get_current_slot) (FilesAbstractSlot* self);
	void (*reload) (FilesAbstractSlot* self, gboolean non_local_only);
	void (*grab_focus) (FilesAbstractSlot* self);
	void (*user_path_change_request) (FilesAbstractSlot* self, GFile* loc, gboolean make_root);
	void (*focus_first_for_empty_selection) (FilesAbstractSlot* self, gboolean select);
	void (*select_glib_files) (FilesAbstractSlot* self, GList* locations, GFile* focus_location);
	void (*make_view) (FilesAbstractSlot* self);
	void (*close) (FilesAbstractSlot* self);
	GFileInfo* (*lookup_file_info) (FilesAbstractSlot* self, GFile* loc);
	void (*zoom_out) (FilesAbstractSlot* self);
	void (*zoom_in) (FilesAbstractSlot* self);
	void (*zoom_normal) (FilesAbstractSlot* self);
	gboolean (*set_all_selected) (FilesAbstractSlot* self, gboolean all_selected);
	GtkWidget* (*get_content_box) (FilesAbstractSlot* self);
	gchar* (*get_root_uri) (FilesAbstractSlot* self);
	gchar* (*get_tip_uri) (FilesAbstractSlot* self);
	gboolean (*get_realized) (FilesAbstractSlot* self);
	gboolean (*get_locked_focus) (FilesAbstractSlot* self);
	gboolean (*get_is_frozen) (FilesAbstractSlot* self);
	void (*set_is_frozen) (FilesAbstractSlot* self, gboolean value);
};

struct _FilesBookmark {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesBookmarkPrivate * priv;
};

struct _FilesBookmarkClass {
	GTypeClass parent_class;
	void (*finalize) (FilesBookmark *self);
};

struct _FilesBookmarkList {
	GObject parent_instance;
	FilesBookmarkListPrivate * priv;
};

struct _FilesBookmarkListClass {
	GObjectClass parent_class;
};

struct _FilesConnectServerOperation {
	GtkMountOperation parent_instance;
	FilesConnectServerOperationPrivate * priv;
};

struct _FilesConnectServerOperationClass {
	GtkMountOperationClass parent_class;
};

struct _PFConnectServerDialog {
	GraniteDialog parent_instance;
	PFConnectServerDialogPrivate * priv;
};

struct _PFConnectServerDialogClass {
	GraniteDialogClass parent_class;
};

struct _FilesDndHandler {
	GObject parent_instance;
	FilesDndHandlerPrivate * priv;
};

struct _FilesDndHandlerClass {
	GObjectClass parent_class;
};

struct _FilesFile {
	GObject parent_instance;
	FilesFilePrivate * priv;
	gboolean is_gone;
	GFile* target_location;
	FilesFile* target_gof;
	GIcon* icon;
	GList* emblems_list;
	guint n_emblems;
	GFileInfo* info;
	gchar* custom_display_name;
	guint64 size;
	gchar* format_size;
	gint color;
	guint64 modified;
	gchar* formated_modified;
	gchar* formated_type;
	gchar* tagstype;
	GdkPixbuf* pix;
	gchar* custom_icon_name;
	gint pix_size;
	gint pix_scale;
	gint width;
	gint height;
	gint sort_column_id;
	GtkSortType sort_order;
	GFileType file_type;
	gboolean is_hidden;
	gboolean is_directory;
	gboolean is_desktop;
	gboolean is_expanded;
	gboolean can_unmount;
	guint thumbstate;
	gchar* thumbnail_path;
	gboolean is_mounted;
	gboolean exists;
	guint32 uid;
	guint32 gid;
	gchar* owner;
	gchar* group;
	gboolean has_permissions;
	guint32 permissions;
	GMount* mount;
	gboolean is_connected;
	gchar* utf8_collation_key;
	gboolean link_known_target;
};

struct _FilesFileClass {
	GObjectClass parent_class;
};

struct _FilesFileConflictDialog {
	GraniteMessageDialog parent_instance;
	FilesFileConflictDialogPrivate * priv;
};

struct _FilesFileConflictDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _FilesListModel {
	GtkTreeStore parent_instance;
	FilesListModelPrivate * priv;
};

struct _FilesListModelClass {
	GtkTreeStoreClass parent_class;
};

struct _FilesCallWhenReady {
	GObject parent_instance;
	FilesCallWhenReadyPrivate * priv;
	GList* files;
};

struct _FilesCallWhenReadyClass {
	GObjectClass parent_class;
};

struct _FilesDirectory {
	GObject parent_instance;
	FilesDirectoryPrivate * priv;
	gint icon_size;
	gboolean permission_denied;
	gboolean network_available;
};

struct _FilesDirectoryClass {
	GObjectClass parent_class;
};

struct _FilesPreferences {
	GObject parent_instance;
	FilesPreferencesPrivate * priv;
};

struct _FilesPreferencesClass {
	GObjectClass parent_class;
};

struct _FilesPluginManager {
	GObject parent_instance;
	FilesPluginManagerPrivate * priv;
	GList* menus G_GNUC_DEPRECATED ;
};

struct _FilesPluginManagerClass {
	GObjectClass parent_class;
};

struct _FilesPluginsBase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesPluginsBasePrivate * priv;
	GtkWidget* window;
};

struct _FilesPluginsBaseClass {
	GTypeClass parent_class;
	void (*finalize) (FilesPluginsBase *self);
	void (*directory_loaded) (FilesPluginsBase* self, GtkApplicationWindow* window, FilesAbstractSlot* view, FilesFile* directory);
	void (*context_menu) (FilesPluginsBase* self, GtkWidget* widget, GList* files);
	void (*sidebar_loaded) (FilesPluginsBase* self, GtkWidget* widget);
	void (*update_sidebar) (FilesPluginsBase* self, GtkWidget* widget);
	void (*update_file_info) (FilesPluginsBase* self, FilesFile* file);
};

struct _PFProgressInfo {
	GObject parent_instance;
	PFProgressInfoPrivate * priv;
};

struct _PFProgressInfoClass {
	GObjectClass parent_class;
};

struct _PFProgressInfoManager {
	GObject parent_instance;
	PFProgressInfoManagerPrivate * priv;
};

struct _PFProgressInfoManagerClass {
	GObjectClass parent_class;
};

struct _FilesSidebarPluginItem {
	GObject parent_instance;
	FilesSidebarPluginItemPrivate * priv;
};

struct _FilesSidebarPluginItemClass {
	GObjectClass parent_class;
};

struct _PFSoundManager {
	GObject parent_instance;
	PFSoundManagerPrivate * priv;
};

struct _PFSoundManagerClass {
	GObjectClass parent_class;
};

struct _FilesTrashMonitor {
	GObject parent_instance;
	FilesTrashMonitorPrivate * priv;
};

struct _FilesTrashMonitorClass {
	GObjectClass parent_class;
};

struct _FilesUndoActionData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesUndoActionDataPrivate * priv;
	FilesUndoActionType action_type;
	gboolean is_valid;
	gboolean locked;
	gboolean freed;
	guint count;
	GFile* src_dir;
	GFile* dest_dir;
	GList* sources;
	GList* destinations;
	gchar* undo_label;
	gchar* undo_description;
	gchar* redo_label;
	gchar* redo_description;
	gchar* template;
	gchar* target_uri;
	gchar* old_uri;
	gchar* new_uri;
	GHashTable* trashed;
	GHashTable* original_permissions;
	guint32 dir_mask;
	guint32 dir_permissions;
	guint32 file_mask;
	guint32 file_permissions;
	guint32 current_permissions;
	guint32 new_permissions;
	gchar* original_group_name_or_id;
	gchar* new_group_name_or_id;
	gchar* original_user_name_or_id;
	gchar* new_user_name_or_id;
};

struct _FilesUndoActionDataClass {
	GTypeClass parent_class;
	void (*finalize) (FilesUndoActionData *self);
};

struct _FilesUndoManager {
	GObject parent_instance;
	FilesUndoManagerPrivate * priv;
};

struct _FilesUndoManagerClass {
	GObjectClass parent_class;
};

struct _FilesIconInfo {
	GObject parent_instance;
	FilesIconInfoPrivate * priv;
};

struct _FilesIconInfoClass {
	GObjectClass parent_class;
};

struct _FilesThumbnailerDaemonIface {
	GTypeInterface parent_iface;
	void (*queue) (FilesThumbnailerDaemon* self, gchar** uris, gint uris_length1, gchar** mime_types, gint mime_types_length1, const gchar* flavor, const gchar* scheduler, guint handle_to_unqueue, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*queue_finish) (FilesThumbnailerDaemon* self, GAsyncResult* _res_, GError** error);
	void (*dequeue) (FilesThumbnailerDaemon* self, guint handle, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*dequeue_finish) (FilesThumbnailerDaemon* self, GAsyncResult* _res_, GError** error);
	void (*get_supported) (FilesThumbnailerDaemon* self, gchar*** uri_schemes, gint* uri_schemes_length1, gchar*** mime_types, gint* mime_types_length1, GError** error);
};

struct _FilesThumbnailer {
	GObject parent_instance;
	FilesThumbnailerPrivate * priv;
};

struct _FilesThumbnailerClass {
	GObjectClass parent_class;
};

struct _FilesFileOperationsCommonJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FilesFileOperationsCommonJobPrivate * priv;
	GtkWindow* parent_window;
	guint inhibit_cookie;
	GCancellable* cancellable;
	PFProgressInfo* progress;
	FilesUndoActionData* undo_redo_data;
};

struct _FilesFileOperationsCommonJobClass {
	GTypeClass parent_class;
	void (*finalize) (FilesFileOperationsCommonJob *self);
};

struct _FilesFileOperationsEmptyTrashJob {
	FilesFileOperationsCommonJob parent_instance;
	FilesFileOperationsEmptyTrashJobPrivate * priv;
};

struct _FilesFileOperationsEmptyTrashJobClass {
	FilesFileOperationsCommonJobClass parent_class;
};

struct _FilesSidebarInterfaceIface {
	GTypeInterface parent_iface;
	guint32 (*add_plugin_item) (FilesSidebarInterface* self, FilesSidebarPluginItem* item, FilesPlaceType category);
	gboolean (*update_plugin_item) (FilesSidebarInterface* self, FilesSidebarPluginItem* item, guint32 item_id);
	gboolean (*remove_item_by_id) (FilesSidebarInterface* self, guint32 item_id);
	void (*add_favorite_uri) (FilesSidebarInterface* self, const gchar* uri, const gchar* custom_name);
	gboolean (*has_favorite_uri) (FilesSidebarInterface* self, const gchar* uri);
	void (*sync_uri) (FilesSidebarInterface* self, const gchar* uri);
	void (*reload) (FilesSidebarInterface* self);
	void (*on_free_space_change) (FilesSidebarInterface* self);
};

VALA_EXTERN GType files_abstract_slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractSlot, g_object_unref)
VALA_EXTERN GType files_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFile, g_object_unref)
VALA_EXTERN void files_abstract_slot_add_extra_widget (FilesAbstractSlot* self,
                                           GtkWidget* widget);
VALA_EXTERN void files_abstract_slot_add_extra_action_widget (FilesAbstractSlot* self,
                                                  GtkWidget* widget);
VALA_EXTERN void files_abstract_slot_add_overlay (FilesAbstractSlot* self,
                                      GtkWidget* widget);
VALA_EXTERN void files_abstract_slot_initialize_directory (FilesAbstractSlot* self);
VALA_EXTERN GList* files_abstract_slot_get_selected_files (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_active_state (FilesAbstractSlot* self,
                                           gboolean set_active,
                                           gboolean animate);
VALA_EXTERN FilesAbstractSlot* files_abstract_slot_get_current_slot (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_reload (FilesAbstractSlot* self,
                                 gboolean non_local_only);
VALA_EXTERN void files_abstract_slot_grab_focus (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_user_path_change_request (FilesAbstractSlot* self,
                                                   GFile* loc,
                                                   gboolean make_root);
VALA_EXTERN void files_abstract_slot_focus_first_for_empty_selection (FilesAbstractSlot* self,
                                                          gboolean select);
VALA_EXTERN void files_abstract_slot_select_glib_files (FilesAbstractSlot* self,
                                            GList* locations,
                                            GFile* focus_location);
VALA_EXTERN void files_abstract_slot_make_view (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_close (FilesAbstractSlot* self);
VALA_EXTERN GFileInfo* files_abstract_slot_lookup_file_info (FilesAbstractSlot* self,
                                                 GFile* loc);
VALA_EXTERN void files_abstract_slot_zoom_out (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_zoom_in (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_zoom_normal (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_set_all_selected (FilesAbstractSlot* self,
                                               gboolean all_selected);
VALA_EXTERN GtkWidget* files_abstract_slot_get_content_box (FilesAbstractSlot* self);
VALA_EXTERN gchar* files_abstract_slot_get_root_uri (FilesAbstractSlot* self);
VALA_EXTERN gchar* files_abstract_slot_get_tip_uri (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_get_realized (FilesAbstractSlot* self);
VALA_EXTERN FilesAbstractSlot* files_abstract_slot_construct (GType object_type);
VALA_EXTERN GType files_directory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesDirectory, g_object_unref)
VALA_EXTERN FilesDirectory* files_abstract_slot_get_directory (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_directory (FilesAbstractSlot* self,
                                        FilesDirectory* value);
VALA_EXTERN FilesFile* files_abstract_slot_get_file (FilesAbstractSlot* self);
VALA_EXTERN GFile* files_abstract_slot_get_location (FilesAbstractSlot* self);
VALA_EXTERN const gchar* files_abstract_slot_get_uri (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_get_locked_focus (FilesAbstractSlot* self);
VALA_EXTERN gboolean files_abstract_slot_get_is_frozen (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_is_frozen (FilesAbstractSlot* self,
                                        gboolean value);
VALA_EXTERN GtkOverlay* files_abstract_slot_get_overlay (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_overlay (FilesAbstractSlot* self,
                                      GtkOverlay* value);
VALA_EXTERN gint files_abstract_slot_get_slot_number (FilesAbstractSlot* self);
VALA_EXTERN void files_abstract_slot_set_slot_number (FilesAbstractSlot* self,
                                          gint value);
VALA_EXTERN gpointer files_bookmark_ref (gpointer instance);
VALA_EXTERN void files_bookmark_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_param_spec_bookmark (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void files_value_set_bookmark (GValue* value,
                               gpointer v_object);
VALA_EXTERN void files_value_take_bookmark (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer files_value_get_bookmark (const GValue* value);
VALA_EXTERN GType files_bookmark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesBookmark, files_bookmark_unref)
VALA_EXTERN GCompareFunc files_bookmark_compare_with;
VALA_EXTERN FilesBookmark* files_bookmark_new (FilesFile* gof_file,
                                   const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_construct (GType object_type,
                                         FilesFile* gof_file,
                                         const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_new_from_uri (const gchar* uri,
                                            const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_construct_from_uri (GType object_type,
                                                  const gchar* uri,
                                                  const gchar* label);
VALA_EXTERN FilesBookmark* files_bookmark_copy (FilesBookmark* self);
VALA_EXTERN GFile* files_bookmark_get_location (FilesBookmark* self);
VALA_EXTERN gchar* files_bookmark_get_parse_name (FilesBookmark* self);
VALA_EXTERN GIcon* files_bookmark_get_icon (FilesBookmark* self);
VALA_EXTERN gboolean files_bookmark_uri_known_not_to_exist (FilesBookmark* self);
VALA_EXTERN const gchar* files_bookmark_get_custom_name (FilesBookmark* self);
VALA_EXTERN void files_bookmark_set_custom_name (FilesBookmark* self,
                                     const gchar* value);
VALA_EXTERN FilesFile* files_bookmark_get_gof_file (FilesBookmark* self);
VALA_EXTERN const gchar* files_bookmark_get_basename (FilesBookmark* self);
VALA_EXTERN const gchar* files_bookmark_get_uri (FilesBookmark* self);
VALA_EXTERN GType files_bookmark_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesBookmarkList, g_object_unref)
VALA_EXTERN FilesBookmarkList* files_bookmark_list_get_instance (void);
VALA_EXTERN FilesBookmark* files_bookmark_list_insert_uri (FilesBookmarkList* self,
                                               const gchar* uri,
                                               guint index,
                                               const gchar* custom_name);
VALA_EXTERN FilesBookmark* files_bookmark_list_insert_uri_at_end (FilesBookmarkList* self,
                                                      const gchar* uri,
                                                      const gchar* custom_name);
VALA_EXTERN void files_bookmark_list_insert_uris (FilesBookmarkList* self,
                                      GList* uris,
                                      guint index);
VALA_EXTERN gboolean files_bookmark_list_contains (FilesBookmarkList* self,
                                       FilesBookmark* bm);
VALA_EXTERN void files_bookmark_list_delete_item_at (FilesBookmarkList* self,
                                         guint index);
VALA_EXTERN void files_bookmark_list_rename_item_with_uri (FilesBookmarkList* self,
                                               const gchar* uri,
                                               const gchar* new_name);
VALA_EXTERN void files_bookmark_list_delete_items_with_uri (FilesBookmarkList* self,
                                                const gchar* uri);
VALA_EXTERN guint files_bookmark_list_length (FilesBookmarkList* self);
VALA_EXTERN FilesBookmark* files_bookmark_list_item_at (FilesBookmarkList* self,
                                            guint index);
VALA_EXTERN void files_bookmark_list_move_item_uri (FilesBookmarkList* self,
                                        const gchar* uri,
                                        gint step);
VALA_EXTERN GList* files_bookmark_list_get_list (FilesBookmarkList* self);
VALA_EXTERN GType files_connect_server_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesConnectServerOperation, g_object_unref)
VALA_EXTERN GType pf_connect_server_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFConnectServerDialog, g_object_unref)
VALA_EXTERN FilesConnectServerOperation* files_connect_server_operation_new (PFConnectServerDialog* dialog);
VALA_EXTERN FilesConnectServerOperation* files_connect_server_operation_construct (GType object_type,
                                                                       PFConnectServerDialog* dialog);
VALA_EXTERN PFConnectServerDialog* pf_connect_server_dialog_new (GtkWindow* window);
VALA_EXTERN PFConnectServerDialog* pf_connect_server_dialog_construct (GType object_type,
                                                           GtkWindow* window);
VALA_EXTERN void pf_connect_server_dialog_fill_details_async (PFConnectServerDialog* self,
                                                  GMountOperation* mount_operation,
                                                  const gchar* default_user,
                                                  const gchar* default_domain,
                                                  GAskPasswordFlags askpassword_flags,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN gboolean pf_connect_server_dialog_fill_details_finish (PFConnectServerDialog* self,
                                                       GAsyncResult* _res_);
VALA_EXTERN const gchar* pf_connect_server_dialog_get_server_uri (PFConnectServerDialog* self);
VALA_EXTERN GType files_dnd_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesDndHandler, g_object_unref)
VALA_EXTERN FilesDndHandler* files_dnd_handler_new (void);
VALA_EXTERN FilesDndHandler* files_dnd_handler_construct (GType object_type);
VALA_EXTERN gboolean files_dnd_handler_dnd_perform (FilesDndHandler* self,
                                        GtkWidget* widget,
                                        FilesFile* drop_target,
                                        GList* drop_file_list,
                                        GdkDragAction action);
VALA_EXTERN GdkDragAction* files_dnd_handler_drag_drop_action_ask (FilesDndHandler* self,
                                                       GtkWidget* dest_widget,
                                                       GtkApplicationWindow* win,
                                                       GdkDragAction possible_actions);
VALA_EXTERN void files_dnd_handler_on_choice (FilesDndHandler* self,
                                  GVariant* param);
VALA_EXTERN gchar* files_dnd_handler_get_source_filename (FilesDndHandler* self,
                                              GdkDragContext* context);
VALA_EXTERN void files_dnd_handler_set_source_uri (FilesDndHandler* self,
                                       GdkDragContext* context,
                                       const gchar* uri);
VALA_EXTERN gboolean files_dnd_handler_handle_xdnddirectsave (FilesDndHandler* self,
                                                  GdkDragContext* context,
                                                  FilesFile* drop_target,
                                                  GtkSelectionData* selection);
VALA_EXTERN gboolean files_dnd_handler_handle_netscape_url (FilesDndHandler* self,
                                                GdkDragContext* context,
                                                FilesFile* drop_target,
                                                GtkSelectionData* selection);
VALA_EXTERN gboolean files_dnd_handler_handle_file_drag_actions (FilesDndHandler* self,
                                                     GtkWidget* dest_widget,
                                                     GdkDragContext* context,
                                                     FilesFile* drop_target,
                                                     GList* drop_file_list,
                                                     GdkDragAction possible_actions,
                                                     GdkDragAction suggested_action,
                                                     GtkApplicationWindow* win,
                                                     guint32 timestamp);
VALA_EXTERN gboolean files_dnd_handler_selection_data_is_uri_list (GtkSelectionData* selection_data,
                                                       guint info,
                                                       gchar* * text);
VALA_EXTERN gchar* files_dnd_handler_data_to_string (guchar* cdata,
                                         gint cdata_length1);
VALA_EXTERN void files_dnd_handler_set_selection_data_from_file_list (GtkSelectionData* selection_data,
                                                          GList* file_list,
                                                          const gchar* prefix);
VALA_EXTERN void files_dnd_handler_set_selection_text_from_file_list (GtkSelectionData* selection_data,
                                                          GList* file_list,
                                                          const gchar* prefix);
VALA_EXTERN GType files_window_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_window_state_to_string (FilesWindowState self);
VALA_EXTERN FilesWindowState files_window_state_from_gdk_window_state (GdkWindowState state,
                                                           gboolean start);
VALA_EXTERN gboolean files_window_state_is_tiled (FilesWindowState self);
VALA_EXTERN gboolean files_window_state_is_maximized (FilesWindowState self);
VALA_EXTERN GType files_view_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_open_flag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_zoom_level_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_icon_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesIconSize files_zoom_level_to_icon_size (FilesZoomLevel self);
VALA_EXTERN GType files_target_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_file_icon_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType files_file_thumb_state_get_type (void) G_GNUC_CONST ;
#define FILES_FILE_GIO_DEFAULT_ATTRIBUTES "standard::is-hidden,standard::is-backup,standard::is-symlink,standard:" \
":type,standard::name," "standard::display-name,standard::content-type,standard::fast-content-t" \
"ype,standard::size," "standard::symlink-target,standard::target-uri,access::*,time::*,owner:" \
":*,trash::*,unix::*,id::filesystem," "thumbnail::*,mountable::*,metadata::marlin-sort-column-id,metadata::ma" \
"rlin-sort-reversed"
VALA_EXTERN FilesFile* files_file_get (GFile* location);
VALA_EXTERN FilesFile* files_file_get_by_uri (const gchar* uri);
VALA_EXTERN FilesFile* files_file_get_by_commandline_arg (const gchar* arg);
VALA_EXTERN FilesFile* files_file_cache_lookup (GFile* file);
VALA_EXTERN GMount* files_file_get_mount_at (GFile* location);
VALA_EXTERN FilesFile* files_file_new (GFile* location,
                           GFile* dir);
VALA_EXTERN FilesFile* files_file_construct (GType object_type,
                                 GFile* location,
                                 GFile* dir);
VALA_EXTERN void files_file_remove_from_caches (FilesFile* self);
VALA_EXTERN void files_file_set_expanded (FilesFile* self,
                              gboolean expanded);
VALA_EXTERN gboolean files_file_is_folder (FilesFile* self);
VALA_EXTERN gboolean files_file_is_symlink (FilesFile* self);
VALA_EXTERN gboolean files_file_is_desktop_file (FilesFile* self);
VALA_EXTERN gboolean files_file_is_image (FilesFile* self);
VALA_EXTERN gboolean files_file_is_trashed (FilesFile* self);
VALA_EXTERN gboolean files_file_is_readable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_writable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_executable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_mountable (FilesFile* self);
VALA_EXTERN gboolean files_file_is_smb_share (FilesFile* self);
VALA_EXTERN gboolean files_file_is_smb_server (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_display_name (FilesFile* self);
VALA_EXTERN GFile* files_file_get_target_location (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_symlink_target (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_ftype (FilesFile* self);
VALA_EXTERN gchar* files_file_get_formated_time (FilesFile* self,
                                     const gchar* attr);
VALA_EXTERN GdkPixbuf* files_file_get_icon_pixbuf (FilesFile* self,
                                       gint size,
                                       gint scale,
                                       FilesFileIconFlags flags);
VALA_EXTERN void files_file_get_folder_icon_from_uri_or_path (FilesFile* self);
VALA_EXTERN GType files_icon_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesIconInfo, g_object_unref)
VALA_EXTERN FilesIconInfo* files_file_get_icon (FilesFile* self,
                                    gint size,
                                    gint scale,
                                    FilesFileIconFlags flags);
VALA_EXTERN void files_file_update (FilesFile* self);
VALA_EXTERN void files_file_update_type (FilesFile* self);
VALA_EXTERN void files_file_update_icon (FilesFile* self,
                             gint size,
                             gint scale);
VALA_EXTERN void files_file_update_desktop_file (FilesFile* self);
VALA_EXTERN void files_file_query_update (FilesFile* self);
VALA_EXTERN void files_file_query_thumbnail_update (FilesFile* self);
VALA_EXTERN gboolean files_file_ensure_query_info (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_thumbnail_path (FilesFile* self);
VALA_EXTERN gboolean files_file_can_set_owner (FilesFile* self);
VALA_EXTERN gboolean files_file_can_set_group (FilesFile* self);
VALA_EXTERN gboolean files_file_can_set_permissions (FilesFile* self);
VALA_EXTERN gboolean files_file_can_unmount (FilesFile* self);
VALA_EXTERN gchar* files_file_get_permissions_as_string (FilesFile* self);
VALA_EXTERN GList* files_file_get_settable_group_names (FilesFile* self);
VALA_EXTERN gboolean files_file_is_remote_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_root_network_folder (FilesFile* self);
VALA_EXTERN gboolean files_file_is_network_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_smb_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_recent_uri_scheme (FilesFile* self);
VALA_EXTERN gboolean files_file_is_other_uri_scheme (FilesFile* self);
VALA_EXTERN gchar* files_file_get_display_target_uri (FilesFile* self);
VALA_EXTERN GAppInfo* files_file_get_default_handler (FilesFile* self);
VALA_EXTERN gboolean files_file_execute (FilesFile* self,
                             GList* files,
                             GError** error);
VALA_EXTERN gint files_file_compare_for_sort (FilesFile* self,
                                  FilesFile* other,
                                  gint sort_type,
                                  gboolean directories_first,
                                  gboolean reversed);
VALA_EXTERN gint files_file_compare_by_display_name (FilesFile* self,
                                         FilesFile* other);
VALA_EXTERN void files_file_update_emblem (FilesFile* self);
VALA_EXTERN void files_file_add_emblem (FilesFile* self,
                            const gchar* emblem);
VALA_EXTERN GFile* files_file_get_location (FilesFile* self);
VALA_EXTERN GFile* files_file_get_directory (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_basename (FilesFile* self);
VALA_EXTERN const gchar* files_file_get_uri (FilesFile* self);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_lighten (GdkPixbuf* src);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_darken (GdkPixbuf* src,
                                   guint8 saturation,
                                   guint8 darken);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_colorize (GdkPixbuf* src,
                                     GdkRGBA* color);
VALA_EXTERN GdkPixbuf* pf_pixbuf_utils_lucent (GdkPixbuf* src,
                                   guint percent);
VALA_EXTERN void files_file_changes_queue_file_added (GFile* location);
VALA_EXTERN void files_file_changes_queue_file_changed (GFile* location);
VALA_EXTERN void files_file_changes_queue_file_removed (GFile* location);
VALA_EXTERN void files_file_changes_queue_file_moved (GFile* from,
                                          GFile* to);
VALA_EXTERN void files_file_changes_consume_changes (gboolean consume_all);
VALA_EXTERN GList* files_file_utils_files_from_uris (const gchar* uris);
VALA_EXTERN GKeyFile* files_file_utils_key_file_from_file (GFile* file,
                                               GCancellable* cancellable,
                                               GError** error);
VALA_EXTERN GFile* files_file_utils_get_file_for_path (const gchar* path);
VALA_EXTERN gchar* files_file_utils_get_parent_path_from_path (const gchar* path,
                                                   gboolean include_file_protocol);
VALA_EXTERN void files_file_utils_restore_files_from_trash (GList* files,
                                                GtkWidget* widget);
VALA_EXTERN gchar* files_file_utils_get_path_for_symlink (GFile* file);
VALA_EXTERN gboolean files_file_utils_path_has_parent (const gchar* new_path);
VALA_EXTERN gchar* files_file_utils_escape_uri (const gchar* uri,
                                    gboolean allow_utf8,
                                    gboolean allow_single_quote);
VALA_EXTERN gchar* files_file_utils_sanitize_path (const gchar* input_uri,
                                       const gchar* input_current_uri,
                                       gboolean include_file_protocol);
VALA_EXTERN void files_file_utils_split_protocol_from_path (const gchar* path,
                                                gchar* * protocol,
                                                gchar* * new_path);
VALA_EXTERN gchar* files_file_utils_get_smb_share_from_uri (const gchar* uri);
VALA_EXTERN void files_file_utils_get_rename_region (const gchar* filename,
                                         gint* start_offset,
                                         gint* end_offset,
                                         gboolean select_all);
VALA_EXTERN gchar* files_file_utils_custom_basename_from_file (GFile* location);
VALA_EXTERN void files_file_utils_set_file_display_name (GFile* old_location,
                                             const gchar* new_name,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN GFile* files_file_utils_set_file_display_name_finish (GAsyncResult* _res_,
                                                      GError** error);
VALA_EXTERN gchar* files_file_utils_get_formatted_time_attribute_from_info (GFileInfo* info,
                                                                const gchar* attr);
VALA_EXTERN gchar* files_file_utils_get_formatted_date_time (GDateTime* dt);
VALA_EXTERN guint16 files_file_utils_get_default_port_for_protocol (const gchar* protocol);
VALA_EXTERN gboolean files_file_utils_get_is_tls_for_protocol (const gchar* protocol);
VALA_EXTERN gboolean files_file_utils_location_is_in_trash (GFile* location);
VALA_EXTERN GdkDragAction files_file_utils_file_accepts_drop (FilesFile* dest,
                                                  GList* drop_file_list,
                                                  GdkDragContext* context,
                                                  GdkDragAction* suggested_action_return);
VALA_EXTERN gint files_file_utils_compare_modification_dates (GFile* a,
                                                  GFile* b);
VALA_EXTERN void files_file_utils_remove_thumbnail_paths_for_uri (const gchar* uri);
VALA_EXTERN gboolean files_file_utils_same_location (const gchar* uri_a,
                                         const gchar* uri_b);
VALA_EXTERN guint64 files_file_utils_get_file_modification_time (GFile* file);
VALA_EXTERN gchar* files_file_utils_get_afp_target_uri (const gchar* standard_target_uri,
                                            const gchar* uri);
VALA_EXTERN gboolean files_file_utils_make_file_name_valid_for_dest_fs (gchar* * filename,
                                                            const gchar* dest_fs_type);
VALA_EXTERN gchar* files_file_utils_format_time (gint seconds,
                                     gint* time_unit);
#define FILES_FILE_UTILS_COPY_TAG N_ ("copy")
#define FILES_FILE_UTILS_LINK_TAG N_ ("link")
#define FILES_FILE_UTILS_OPENING_COPY_LINK_TAG N_ ("(")
#define FILES_FILE_UTILS_CLOSING_COPY_LINK_TAG N_ (")")
VALA_EXTERN gchar* files_file_utils_get_duplicate_name (const gchar* name,
                                            gint count_increment,
                                            gint max_length,
                                            gboolean is_link);
VALA_EXTERN gchar* files_file_utils_shorten_utf8_string (const gchar* base_string,
                                             gint reduce_by_num_bytes);
VALA_EXTERN gchar* files_file_utils_get_link_name (const gchar* target_name,
                                       gint count,
                                       gint max_length);
VALA_EXTERN gchar* files_file_utils_get_copy_name (const gchar* base_name,
                                       const gchar* suffix,
                                       gint count,
                                       gint max_length);
VALA_EXTERN gint files_file_utils_get_max_name_length (GFile* file_dir);
VALA_EXTERN gboolean files_file_utils_protocol_is_supported (const gchar* protocol);
#define FILES_ROOT_FS_URI "file://"
#define FILES_TRASH_URI "trash://"
#define FILES_NETWORK_URI "network://"
#define FILES_RECENT_URI "recent://"
#define FILES_AFP_URI "afp://"
#define FILES_AFC_URI "afc://"
#define FILES_DAV_URI "dav://"
#define FILES_DAVS_URI "davs://"
#define FILES_SFTP_URI "sftp://"
#define FILES_FTP_URI "ftp://"
#define FILES_SMB_URI "smb://"
#define FILES_MTP_URI "mtp://"
#define FILES_PTP_URI "gphoto2://"
VALA_EXTERN GType files_file_conflict_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileConflictDialog, g_object_unref)
VALA_EXTERN GType files_file_conflict_dialog_response_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesFileConflictDialog* files_file_conflict_dialog_new (GtkWindow* parent,
                                                         GFile* _source,
                                                         GFile* _destination,
                                                         GFile* _dest_dir);
VALA_EXTERN FilesFileConflictDialog* files_file_conflict_dialog_construct (GType object_type,
                                                               GtkWindow* parent,
                                                               GFile* _source,
                                                               GFile* _destination,
                                                               GFile* _dest_dir);
VALA_EXTERN gchar* files_file_conflict_dialog_get_new_name (FilesFileConflictDialog* self);
VALA_EXTERN gboolean files_file_conflict_dialog_get_apply_to_all (FilesFileConflictDialog* self);
VALA_EXTERN GType files_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesListModel, g_object_unref)
VALA_EXTERN GType files_list_model_column_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesListModelColumnID files_list_model_column_id_from_string (const gchar* column_id);
VALA_EXTERN const gchar* files_list_model_column_id_to_string (FilesListModelColumnID self);
VALA_EXTERN FilesFile* files_list_model_file_for_path (FilesListModel* self,
                                           GtkTreePath* path);
VALA_EXTERN FilesFile* files_list_model_file_for_iter (FilesListModel* self,
                                           GtkTreeIter* iter);
VALA_EXTERN guint files_list_model_get_length (FilesListModel* self);
VALA_EXTERN gboolean files_list_model_get_first_iter_for_file (FilesListModel* self,
                                                   FilesFile* file,
                                                   GtkTreeIter** iter);
VALA_EXTERN void files_list_model_file_changed (FilesListModel* self,
                                    FilesFile* file,
                                    FilesDirectory* dir);
VALA_EXTERN void files_list_model_set_should_sort_directories_first (FilesListModel* self,
                                                         gboolean sort_directories_first);
VALA_EXTERN gboolean files_list_model_load_subdirectory (FilesListModel* self,
                                             GtkTreePath* path,
                                             FilesDirectory* * dir);
VALA_EXTERN gboolean files_list_model_unload_subdirectory (FilesListModel* self,
                                               GtkTreeIter* iter);
VALA_EXTERN gboolean files_list_model_add_file (FilesListModel* self,
                                    FilesFile* file,
                                    FilesDirectory* dir);
VALA_EXTERN gboolean files_list_model_remove_file (FilesListModel* self,
                                       FilesFile* file,
                                       FilesDirectory* dir);
VALA_EXTERN FilesListModel* files_list_model_new (void);
VALA_EXTERN FilesListModel* files_list_model_construct (GType object_type);
VALA_EXTERN gint files_list_model_get_icon_size (FilesListModel* self);
VALA_EXTERN void files_list_model_set_icon_size (FilesListModel* self,
                                     gint value);
VALA_EXTERN gboolean files_list_model_get_has_child (FilesListModel* self);
VALA_EXTERN void files_list_model_set_has_child (FilesListModel* self,
                                     gboolean value);
VALA_EXTERN GType files_call_when_ready_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesCallWhenReady, g_object_unref)
VALA_EXTERN FilesCallWhenReady* files_call_when_ready_new (GList* _files,
                                               FilesCallWhenReadycall_when_ready_func _f,
                                               gpointer _f_target);
VALA_EXTERN FilesCallWhenReady* files_call_when_ready_construct (GType object_type,
                                                     GList* _files,
                                                     FilesCallWhenReadycall_when_ready_func _f,
                                                     gpointer _f_target);
VALA_EXTERN GType files_directory_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void files_directory_init (FilesDirectory* self,
                           FilesDirectoryFileLoadedFunc file_loaded_func,
                           gpointer file_loaded_func_target);
VALA_EXTERN void files_directory_check_network (FilesDirectory* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN gboolean files_directory_check_network_finish (FilesDirectory* self,
                                               GAsyncResult* _res_);
VALA_EXTERN void files_directory_cancel (FilesDirectory* self);
VALA_EXTERN void files_directory_reload (FilesDirectory* self);
VALA_EXTERN void files_directory_block_monitor (FilesDirectory* self);
VALA_EXTERN void files_directory_unblock_monitor (FilesDirectory* self);
VALA_EXTERN void files_directory_load_hiddens (FilesDirectory* self);
VALA_EXTERN void files_directory_update_files (FilesDirectory* self);
VALA_EXTERN void files_directory_update_desktop_files (FilesDirectory* self);
VALA_EXTERN FilesFile* files_directory_file_hash_lookup_location (FilesDirectory* self,
                                                      GFile* location);
VALA_EXTERN void files_directory_file_hash_add_file (FilesDirectory* self,
                                         FilesFile* gof);
VALA_EXTERN FilesFile* files_directory_file_cache_find_or_insert (FilesDirectory* self,
                                                      GFile* file,
                                                      gboolean update_hash);
VALA_EXTERN void files_directory_notify_files_changed (GList* files);
VALA_EXTERN void files_directory_notify_files_added (GList* files);
VALA_EXTERN void files_directory_notify_files_removed (GList* files);
VALA_EXTERN void files_directory_notify_files_moved (GList* files);
VALA_EXTERN FilesDirectory* files_directory_from_gfile (GFile* file);
VALA_EXTERN FilesDirectory* files_directory_from_file (FilesFile* gof);
VALA_EXTERN FilesDirectory* files_directory_cache_lookup (GFile* file);
VALA_EXTERN FilesDirectory* files_directory_cache_lookup_parent (GFile* file);
VALA_EXTERN gboolean files_directory_remove_dir_from_cache (FilesDirectory* dir);
VALA_EXTERN gboolean files_directory_purge_dir_from_cache (FilesDirectory* dir);
VALA_EXTERN gboolean files_directory_has_parent (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_parent (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_is_loading (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_is_loaded (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_has_timed_out (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_is_empty (FilesDirectory* self);
VALA_EXTERN GList* files_directory_get_sorted_dirs (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_creation_key (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_location (FilesDirectory* self);
VALA_EXTERN GFile* files_directory_get_selected_file (FilesDirectory* self);
VALA_EXTERN FilesFile* files_directory_get_file (FilesDirectory* self);
VALA_EXTERN FilesDirectoryState files_directory_get_state (FilesDirectory* self);
VALA_EXTERN guint files_directory_get_displayed_files_count (FilesDirectory* self);
VALA_EXTERN const gchar* files_directory_get_scheme (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_local (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_trash (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_network (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_recent (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_is_no_info (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_has_mounts (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_has_trash_dirs (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_can_load (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_can_open_files (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_can_stream_files (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_allow_user_interaction (FilesDirectory* self);
VALA_EXTERN void files_directory_set_allow_user_interaction (FilesDirectory* self,
                                                 gboolean value);
VALA_EXTERN gboolean files_directory_get_is_cancelled (FilesDirectory* self);
VALA_EXTERN const gchar* files_directory_get_last_error_message (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_loaded_from_cache (FilesDirectory* self);
VALA_EXTERN gboolean files_directory_get_freeze_update (FilesDirectory* self);
VALA_EXTERN void files_directory_set_freeze_update (FilesDirectory* self,
                                        gboolean value);
VALA_EXTERN GType files_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesPreferences, g_object_unref)
VALA_EXTERN FilesPreferences* files_preferences;
VALA_EXTERN FilesPreferences* files_preferences_get_default (void);
VALA_EXTERN FilesPreferences* files_preferences_new (void);
VALA_EXTERN FilesPreferences* files_preferences_construct (GType object_type);
VALA_EXTERN gboolean files_preferences_get_show_hidden_files (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_show_hidden_files (FilesPreferences* self,
                                              gboolean value);
VALA_EXTERN gboolean files_preferences_get_show_remote_thumbnails (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_show_remote_thumbnails (FilesPreferences* self,
                                                   gboolean value);
VALA_EXTERN gboolean files_preferences_get_hide_local_thumbnails (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_hide_local_thumbnails (FilesPreferences* self,
                                                  gboolean value);
VALA_EXTERN gboolean files_preferences_get_confirm_trash (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_confirm_trash (FilesPreferences* self,
                                          gboolean value);
VALA_EXTERN gboolean files_preferences_get_force_icon_size (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_force_icon_size (FilesPreferences* self,
                                            gboolean value);
VALA_EXTERN gboolean files_preferences_get_sort_directories_first (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_sort_directories_first (FilesPreferences* self,
                                                   gboolean value);
VALA_EXTERN gboolean files_preferences_get_remember_history (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_remember_history (FilesPreferences* self,
                                             gboolean value);
VALA_EXTERN const gchar* files_preferences_get_date_format (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_date_format (FilesPreferences* self,
                                        const gchar* value);
VALA_EXTERN const gchar* files_preferences_get_clock_format (FilesPreferences* self);
VALA_EXTERN void files_preferences_set_clock_format (FilesPreferences* self,
                                         const gchar* value);
VALA_EXTERN GType files_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesPluginManager, g_object_unref)
VALA_EXTERN FilesPluginManager* plugins;
VALA_EXTERN FilesPluginManager* files_plugin_manager_new (const gchar* plugin_dir,
                                              guint user_id);
VALA_EXTERN FilesPluginManager* files_plugin_manager_construct (GType object_type,
                                                    const gchar* plugin_dir,
                                                    guint user_id);
VALA_EXTERN void files_plugin_manager_hook_context_menu (FilesPluginManager* self,
                                             GtkWidget* menu,
                                             GList* files);
VALA_EXTERN void files_plugin_manager_directory_loaded (FilesPluginManager* self,
                                            GtkApplicationWindow* window,
                                            FilesAbstractSlot* view,
                                            FilesFile* directory);
VALA_EXTERN void files_plugin_manager_interface_loaded (FilesPluginManager* self,
                                            GtkWidget* win);
VALA_EXTERN void files_plugin_manager_sidebar_loaded (FilesPluginManager* self,
                                          GtkWidget* widget);
VALA_EXTERN void files_plugin_manager_update_sidebar (FilesPluginManager* self,
                                          GtkWidget* widget);
VALA_EXTERN void files_plugin_manager_update_file_info (FilesPluginManager* self,
                                            FilesFile* file);
VALA_EXTERN GeeList* files_plugin_manager_get_available_plugins (FilesPluginManager* self);
VALA_EXTERN GeeList* files_plugin_manager_get_menuitem_references (FilesPluginManager* self);
VALA_EXTERN gpointer files_plugins_base_ref (gpointer instance);
VALA_EXTERN void files_plugins_base_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_plugins_param_spec_base (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void files_plugins_value_set_base (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void files_plugins_value_take_base (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer files_plugins_value_get_base (const GValue* value);
VALA_EXTERN GType files_plugins_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesPluginsBase, files_plugins_base_unref)
VALA_EXTERN void files_plugins_base_directory_loaded (FilesPluginsBase* self,
                                          GtkApplicationWindow* window,
                                          FilesAbstractSlot* view,
                                          FilesFile* directory);
VALA_EXTERN void files_plugins_base_context_menu (FilesPluginsBase* self,
                                      GtkWidget* widget,
                                      GList* files);
VALA_EXTERN void files_plugins_base_sidebar_loaded (FilesPluginsBase* self,
                                        GtkWidget* widget);
VALA_EXTERN void files_plugins_base_update_sidebar (FilesPluginsBase* self,
                                        GtkWidget* widget);
VALA_EXTERN void files_plugins_base_update_file_info (FilesPluginsBase* self,
                                          FilesFile* file);
VALA_EXTERN void files_plugins_base_interface_loaded (FilesPluginsBase* self,
                                          GtkWidget* widget);
VALA_EXTERN FilesPluginsBase* files_plugins_base_construct (GType object_type);
VALA_EXTERN GType pf_progress_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFProgressInfo, g_object_unref)
VALA_EXTERN PFProgressInfo* pf_progress_info_new (void);
VALA_EXTERN PFProgressInfo* pf_progress_info_construct (GType object_type);
VALA_EXTERN void pf_progress_info_cancel (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_start (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_finish (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_pause (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_resume (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_take_status (PFProgressInfo* self,
                                   gchar* _status);
VALA_EXTERN void pf_progress_info_take_details (PFProgressInfo* self,
                                    gchar* _details);
VALA_EXTERN void pf_progress_info_update_progress (PFProgressInfo* self,
                                       gdouble current,
                                       gdouble total);
VALA_EXTERN void pf_progress_info_pulse_progress (PFProgressInfo* self);
VALA_EXTERN GCancellable* pf_progress_info_get_cancellable (PFProgressInfo* self);
VALA_EXTERN const gchar* pf_progress_info_get_title (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_set_title (PFProgressInfo* self,
                                 const gchar* value);
VALA_EXTERN const gchar* pf_progress_info_get_status (PFProgressInfo* self);
VALA_EXTERN const gchar* pf_progress_info_get_details (PFProgressInfo* self);
VALA_EXTERN void pf_progress_info_set_details (PFProgressInfo* self,
                                   const gchar* value);
VALA_EXTERN gdouble pf_progress_info_get_progress (PFProgressInfo* self);
VALA_EXTERN gdouble pf_progress_info_get_current (PFProgressInfo* self);
VALA_EXTERN gdouble pf_progress_info_get_total (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_activity_mode (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_started (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_finished (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_paused (PFProgressInfo* self);
VALA_EXTERN gboolean pf_progress_info_get_is_cancelled (PFProgressInfo* self);
VALA_EXTERN GType pf_progress_info_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFProgressInfoManager, g_object_unref)
VALA_EXTERN PFProgressInfoManager* pf_progress_info_manager_get_instance (void);
VALA_EXTERN void pf_progress_info_manager_add_new_info (PFProgressInfoManager* self,
                                            PFProgressInfo* info);
VALA_EXTERN void pf_progress_info_manager_remove_finished_info (PFProgressInfoManager* self,
                                                    PFProgressInfo* info);
VALA_EXTERN GeeLinkedList* pf_progress_info_manager_get_all_infos (PFProgressInfoManager* self);
VALA_EXTERN PFProgressInfoManager* pf_progress_info_manager_new (void);
VALA_EXTERN PFProgressInfoManager* pf_progress_info_manager_construct (GType object_type);
VALA_EXTERN GType files_sidebar_plugin_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesSidebarPluginItem, g_object_unref)
VALA_EXTERN GType files_place_type_get_type (void) G_GNUC_CONST ;
#define FILES_SIDEBAR_PLUGIN_ITEM_PLACE_TYPE FILES_PLACE_TYPE_PLUGIN_ITEM
VALA_EXTERN FilesSidebarPluginItem* files_sidebar_plugin_item_new (void);
VALA_EXTERN FilesSidebarPluginItem* files_sidebar_plugin_item_construct (GType object_type);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_name (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_name (FilesSidebarPluginItem* self,
                                         const gchar* value);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_uri (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_uri (FilesSidebarPluginItem* self,
                                        const gchar* value);
VALA_EXTERN GDrive* files_sidebar_plugin_item_get_drive (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_drive (FilesSidebarPluginItem* self,
                                          GDrive* value);
VALA_EXTERN GVolume* files_sidebar_plugin_item_get_volume (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_volume (FilesSidebarPluginItem* self,
                                           GVolume* value);
VALA_EXTERN GMount* files_sidebar_plugin_item_get_mount (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_mount (FilesSidebarPluginItem* self,
                                          GMount* value);
VALA_EXTERN GIcon* files_sidebar_plugin_item_get_icon (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_icon (FilesSidebarPluginItem* self,
                                         GIcon* value);
VALA_EXTERN guint files_sidebar_plugin_item_get_index (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_index (FilesSidebarPluginItem* self,
                                          guint value);
VALA_EXTERN gboolean files_sidebar_plugin_item_get_can_eject (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_can_eject (FilesSidebarPluginItem* self,
                                              gboolean value);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_tooltip (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_tooltip (FilesSidebarPluginItem* self,
                                            const gchar* value);
VALA_EXTERN GIcon* files_sidebar_plugin_item_get_action_icon (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_action_icon (FilesSidebarPluginItem* self,
                                                GIcon* value);
VALA_EXTERN gboolean files_sidebar_plugin_item_get_show_spinner (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_show_spinner (FilesSidebarPluginItem* self,
                                                 gboolean value);
VALA_EXTERN guint64 files_sidebar_plugin_item_get_free_space (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_free_space (FilesSidebarPluginItem* self,
                                               guint64 value);
VALA_EXTERN guint64 files_sidebar_plugin_item_get_disk_size (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_disk_size (FilesSidebarPluginItem* self,
                                              guint64 value);
VALA_EXTERN GActionGroup* files_sidebar_plugin_item_get_action_group (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_action_group (FilesSidebarPluginItem* self,
                                                 GActionGroup* value);
VALA_EXTERN const gchar* files_sidebar_plugin_item_get_action_group_namespace (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_action_group_namespace (FilesSidebarPluginItem* self,
                                                           const gchar* value);
VALA_EXTERN GMenuModel* files_sidebar_plugin_item_get_menu_model (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_menu_model (FilesSidebarPluginItem* self,
                                               GMenuModel* value);
VALA_EXTERN FilesSidebarCallbackFunc files_sidebar_plugin_item_get_cb (FilesSidebarPluginItem* self);
VALA_EXTERN void files_sidebar_plugin_item_set_cb (FilesSidebarPluginItem* self,
                                       FilesSidebarCallbackFunc value);
VALA_EXTERN GType pf_sound_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PFSoundManager, g_object_unref)
VALA_EXTERN PFSoundManager* pf_sound_manager_get_instance (void);
VALA_EXTERN void pf_sound_manager_play_delete_sound (PFSoundManager* self);
VALA_EXTERN void pf_sound_manager_play_empty_trash_sound (PFSoundManager* self);
VALA_EXTERN void pf_sound_manager_play_sound (PFSoundManager* self,
                                  const gchar* pf_sound_id);
#define PF_SOUND_THEME "freedesktop"
#define PF_SOUND_DELETE "trash-empty"
#define PF_SOUND_EMPTY_TRASH "trash-empty"
#define CANCEL _ ("_Cancel")
#define DELETE _ ("Delete")
#define SKIP _ ("_Skip")
#define SKIP_ALL _ ("S_kip All")
#define RETRY _ ("_Retry")
#define DELETE_ALL _ ("Delete _All")
#define REPLACE _ ("_Replace")
#define REPLACE_ALL _ ("Replace _All")
#define MERGE _ ("_Merge")
#define MERGE_ALL _ ("Merge _All")
#define COPY_FORCE _ ("Copy _Anyway")
#define EMPTY_TRASH _ ("Empty _Trash")
VALA_EXTERN GraniteMessageDialog* pf_dialogs_show_error_dialog (const gchar* primary_text,
                                                    const gchar* secondary_text,
                                                    GtkWindow* parent);
VALA_EXTERN GraniteMessageDialog* pf_dialogs_show_warning_dialog (const gchar* primary_text,
                                                      const gchar* secondary_text,
                                                      GtkWindow* parent);
VALA_EXTERN GType files_trash_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesTrashMonitor, g_object_unref)
#define FILES_TRASH_MONITOR_URI "trash://"
VALA_EXTERN FilesTrashMonitor* files_trash_monitor_get_default (void);
VALA_EXTERN GIcon* files_trash_monitor_get_icon (FilesTrashMonitor* self);
VALA_EXTERN FilesTrashMonitor* files_trash_monitor_new (void);
VALA_EXTERN FilesTrashMonitor* files_trash_monitor_construct (GType object_type);
VALA_EXTERN gboolean files_trash_monitor_get_is_empty (FilesTrashMonitor* self);
VALA_EXTERN GList* pf_user_utils_get_user_names (void);
VALA_EXTERN GList* pf_user_utils_get_group_names_for_user (void);
VALA_EXTERN GList* pf_user_utils_get_all_group_names (void);
VALA_EXTERN gboolean pf_user_utils_user_in_group (const gchar* group_name);
VALA_EXTERN uid_t* pf_user_utils_get_group_id_from_group_name (const gchar* group_name);
VALA_EXTERN uid_t* pf_user_utils_get_user_id_from_user_name (const gchar* user_name);
VALA_EXTERN const gchar* pf_user_utils_get_user_home_from_user_uid (uid_t uid);
VALA_EXTERN uid_t* pf_user_utils_get_id_from_digit_string (const gchar* digit_string);
VALA_EXTERN gchar* pf_user_utils_get_real_user_home (void);
VALA_EXTERN GType files_undo_action_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer files_undo_action_data_ref (gpointer instance);
VALA_EXTERN void files_undo_action_data_unref (gpointer instance);
VALA_EXTERN GParamSpec* files_param_spec_undo_action_data (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void files_value_set_undo_action_data (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void files_value_take_undo_action_data (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer files_value_get_undo_action_data (const GValue* value);
VALA_EXTERN GType files_undo_action_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesUndoActionData, files_undo_action_data_unref)
VALA_EXTERN FilesUndoActionData* files_undo_action_data_new (FilesUndoActionType action_type,
                                                 gint items_count);
VALA_EXTERN FilesUndoActionData* files_undo_action_data_construct (GType object_type,
                                                       FilesUndoActionType action_type,
                                                       gint items_count);
VALA_EXTERN void files_undo_action_data_set_src_dir (FilesUndoActionData* self,
                                         GFile* src);
VALA_EXTERN void files_undo_action_data_set_dest_dir (FilesUndoActionData* self,
                                          GFile* dest);
VALA_EXTERN void files_undo_action_data_add_origin_target_pair (FilesUndoActionData* self,
                                                    GFile* origin,
                                                    GFile* target);
VALA_EXTERN void files_undo_action_data_set_create_data (FilesUndoActionData* self,
                                             const gchar* target_uri,
                                             const gchar* template);
VALA_EXTERN void files_undo_action_data_set_rename_information (FilesUndoActionData* self,
                                                    GFile* old_file,
                                                    GFile* new_file);
VALA_EXTERN void files_undo_action_data_add_trashed_file (FilesUndoActionData* self,
                                              GFile* file,
                                              guint64 mtime);
VALA_EXTERN void files_undo_action_data_add_file_permissions (FilesUndoActionData* self,
                                                  GFile* file,
                                                  guint32 permission);
VALA_EXTERN void files_undo_action_data_set_recursive_permissions (FilesUndoActionData* self,
                                                       guint32 file_permissions,
                                                       guint32 file_mask,
                                                       guint32 dir_permissions,
                                                       guint32 dir_mask);
VALA_EXTERN void files_undo_action_data_set_file_permissions (FilesUndoActionData* self,
                                                  const gchar* uri,
                                                  guint32 current_permissions,
                                                  guint32 new_permissions);
VALA_EXTERN void files_undo_action_data_set_owner_change_information (FilesUndoActionData* self,
                                                          const gchar* uri,
                                                          const gchar* current_user,
                                                          const gchar* new_user);
VALA_EXTERN void files_undo_action_data_set_group_change_information (FilesUndoActionData* self,
                                                          const gchar* uri,
                                                          const gchar* current_group,
                                                          const gchar* new_group);
VALA_EXTERN GType files_undo_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesUndoManager, g_object_unref)
VALA_EXTERN FilesUndoManager* files_undo_manager_instance (void);
VALA_EXTERN void files_undo_manager_undo (FilesUndoManager* self,
                              GtkWidget* widget,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN gboolean files_undo_manager_undo_finish (FilesUndoManager* self,
                                         GAsyncResult* _res_,
                                         GError** error);
VALA_EXTERN void files_undo_manager_redo (FilesUndoManager* self,
                              GtkWidget* widget,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN gboolean files_undo_manager_redo_finish (FilesUndoManager* self,
                                         GAsyncResult* _res_,
                                         GError** error);
VALA_EXTERN void files_undo_manager_add_action (FilesUndoManager* self,
                                    FilesUndoActionData* action);
VALA_EXTERN void files_undo_manager_add_rename_action (FilesUndoManager* self,
                                           GFile* renamed_file,
                                           const gchar* original_name);
VALA_EXTERN void files_undo_manager_trash_has_emptied (FilesUndoManager* self);
VALA_EXTERN gboolean files_undo_manager_can_undo (FilesUndoManager* self);
VALA_EXTERN gboolean files_undo_manager_can_redo (FilesUndoManager* self);
VALA_EXTERN FilesUndoManager* files_undo_manager_new (void);
VALA_EXTERN FilesUndoManager* files_undo_manager_construct (GType object_type);
VALA_EXTERN guint files_undo_manager_get_undo_levels (FilesUndoManager* self);
VALA_EXTERN void files_undo_manager_set_undo_levels (FilesUndoManager* self,
                                         guint value);
VALA_EXTERN gboolean files_undo_manager_get_confirm_delete (FilesUndoManager* self);
VALA_EXTERN void files_undo_manager_set_confirm_delete (FilesUndoManager* self,
                                            gboolean value);
VALA_EXTERN gboolean files_undo_manager_get_undo_redo_flag (FilesUndoManager* self);
VALA_EXTERN FilesIconInfo* files_icon_info_new_for_pixbuf (GdkPixbuf* pixbuf);
VALA_EXTERN FilesIconInfo* files_icon_info_construct_for_pixbuf (GType object_type,
                                                     GdkPixbuf* pixbuf);
VALA_EXTERN FilesIconInfo* files_icon_info_new_for_icon_info (GtkIconInfo* icon_info);
VALA_EXTERN FilesIconInfo* files_icon_info_construct_for_icon_info (GType object_type,
                                                        GtkIconInfo* icon_info);
VALA_EXTERN FilesIconInfo* files_icon_info_lookup (GIcon* icon,
                                       gint size,
                                       gint scale);
VALA_EXTERN FilesIconInfo* files_icon_info_get_generic_icon (gint size,
                                                 gint scale);
VALA_EXTERN FilesIconInfo* files_icon_info_lookup_from_name (const gchar* icon_name,
                                                 gint size,
                                                 gint scale);
VALA_EXTERN FilesIconInfo* files_icon_info_lookup_from_path (const gchar* path,
                                                 gint size,
                                                 gint scale);
VALA_EXTERN gboolean files_icon_info_is_fallback (FilesIconInfo* self);
VALA_EXTERN GdkPixbuf* files_icon_info_get_pixbuf_nodefault (FilesIconInfo* self);
VALA_EXTERN GtkIconTheme* files_icon_info_get_icon_theme (void);
VALA_EXTERN guint files_icon_info_loadable_icon_cache_info (void);
VALA_EXTERN guint files_icon_info_themed_icon_cache_info (void);
VALA_EXTERN void files_icon_info_remove_cache (const gchar* path,
                                   gint size,
                                   gint scale);
VALA_EXTERN void files_icon_info_set_reap_time (guint milliseconds);
VALA_EXTERN void files_icon_info_clear_caches (void);
VALA_EXTERN FilesIconInfo* files_icon_info_new (void);
VALA_EXTERN FilesIconInfo* files_icon_info_construct (GType object_type);
VALA_EXTERN GType files_thumbnailer_daemon_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint files_thumbnailer_daemon_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN GType files_thumbnailer_daemon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void files_thumbnailer_daemon_queue (FilesThumbnailerDaemon* self,
                                     gchar** uris,
                                     gint uris_length1,
                                     gchar** mime_types,
                                     gint mime_types_length1,
                                     const gchar* flavor,
                                     const gchar* scheduler,
                                     guint handle_to_unqueue,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN guint files_thumbnailer_daemon_queue_finish (FilesThumbnailerDaemon* self,
                                             GAsyncResult* _res_,
                                             GError** error);
VALA_EXTERN void files_thumbnailer_daemon_dequeue (FilesThumbnailerDaemon* self,
                                       guint handle,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void files_thumbnailer_daemon_dequeue_finish (FilesThumbnailerDaemon* self,
                                              GAsyncResult* _res_,
                                              GError** error);
VALA_EXTERN void files_thumbnailer_daemon_get_supported (FilesThumbnailerDaemon* self,
                                             gchar*** uri_schemes,
                                             gint* uri_schemes_length1,
                                             gchar*** mime_types,
                                             gint* mime_types_length1,
                                             GError** error);
VALA_EXTERN GType files_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesThumbnailer, g_object_unref)
VALA_EXTERN FilesThumbnailer* files_thumbnailer_get (void);
VALA_EXTERN gboolean files_thumbnailer_queue_file (FilesThumbnailer* self,
                                       FilesFile* file,
                                       gint* request,
                                       gboolean large);
VALA_EXTERN gboolean files_thumbnailer_queue_files (FilesThumbnailer* self,
                                        GList* files,
                                        gint* request,
                                        gboolean large);
VALA_EXTERN void files_thumbnailer_dequeue (FilesThumbnailer* self,
                                gint request);
VALA_EXTERN gpointer marlin_file_operations_common_job_ref (gpointer instance);
VALA_EXTERN void marlin_file_operations_common_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* marlin_file_operations_param_spec_common_job (const gchar* name,
                                                          const gchar* nick,
                                                          const gchar* blurb,
                                                          GType object_type,
                                                          GParamFlags flags);
VALA_EXTERN void marlin_file_operations_value_set_common_job (GValue* value,
                                                  gpointer v_object);
VALA_EXTERN void marlin_file_operations_value_take_common_job (GValue* value,
                                                   gpointer v_object);
VALA_EXTERN gpointer marlin_file_operations_value_get_common_job (const GValue* value);
VALA_EXTERN GType marlin_file_operations_common_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsCommonJob, marlin_file_operations_common_job_unref)
VALA_EXTERN FilesFileOperationsCommonJob* marlin_file_operations_common_job_new (GtkWindow* parent_window);
VALA_EXTERN FilesFileOperationsCommonJob* marlin_file_operations_common_job_construct (GType object_type,
                                                                           GtkWindow* parent_window);
VALA_EXTERN void marlin_file_operations_common_job_inhibit_power_manager (FilesFileOperationsCommonJob* self,
                                                              const gchar* message);
VALA_EXTERN gboolean marlin_file_operations_common_job_aborted (FilesFileOperationsCommonJob* self);
VALA_EXTERN GType marlin_file_operations_empty_trash_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileOperationsEmptyTrashJob, marlin_file_operations_common_job_unref)
VALA_EXTERN FilesFileOperationsEmptyTrashJob* marlin_file_operations_empty_trash_job_new (GtkWindow* parent_window,
                                                                              GList* trash_dirs);
VALA_EXTERN FilesFileOperationsEmptyTrashJob* marlin_file_operations_empty_trash_job_construct (GType object_type,
                                                                                    GtkWindow* parent_window,
                                                                                    GList* trash_dirs);
VALA_EXTERN void marlin_file_operations_empty_trash_job_empty_trash (FilesFileOperationsEmptyTrashJob* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN void marlin_file_operations_empty_trash_job_empty_trash_finish (FilesFileOperationsEmptyTrashJob* self,
                                                                GAsyncResult* _res_);
VALA_EXTERN void marlin_file_operations_mount_volume_full (GVolume* volume,
                                               GtkWindow* parent_window,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN gboolean marlin_file_operations_mount_volume_full_finish (GAsyncResult* _res_,
                                                          GError** error);
VALA_EXTERN void marlin_file_operations_mount_volume (GVolume* volume,
                                          GtkWindow* parent_window);
VALA_EXTERN gboolean marlin_file_operations_has_trash_files (GMount* mount);
VALA_EXTERN gboolean marlin_file_operations_mount_has_trash (GMount* mount);
VALA_EXTERN GList* marlin_file_operations_get_trash_dirs_for_mount (GMount* mount);
VALA_EXTERN void marlin_file_operations_empty_trash_for_mount (GtkWidget* parent_view,
                                                   GMount* mount);
VALA_EXTERN gint pf_run_error (GtkWindow* parent_window,
                   GTimer* time,
                   PFProgressInfo* info,
                   gchar* primary_text,
                   gchar* secondary_text,
                   const gchar* details_text,
                   gboolean show_all,
                   ...);
VALA_EXTERN gint pf_run_warning (GtkWindow* parent_window,
                     GTimer* time,
                     PFProgressInfo* info,
                     gchar* primary_text,
                     gchar* secondary_text,
                     const gchar* details_text,
                     gboolean show_all,
                     ...);
VALA_EXTERN gint pf_run_question (GtkWindow* parent_window,
                      GTimer* time,
                      PFProgressInfo* info,
                      gchar* primary_text,
                      gchar* secondary_text,
                      const gchar* details_text,
                      gboolean show_all,
                      ...);
VALA_EXTERN gint pf_run_conflict_dialog (GtkWindow* parent_window,
                             GTimer* time,
                             PFProgressInfo* info,
                             GFile* src,
                             GFile* dest,
                             GFile* dest_dir,
                             gchar* * new_name,
                             gboolean* apply_to_all);
VALA_EXTERN GType files_sidebar_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint32 files_sidebar_interface_add_plugin_item (FilesSidebarInterface* self,
                                                 FilesSidebarPluginItem* item,
                                                 FilesPlaceType category);
VALA_EXTERN gboolean files_sidebar_interface_update_plugin_item (FilesSidebarInterface* self,
                                                     FilesSidebarPluginItem* item,
                                                     guint32 item_id);
VALA_EXTERN gboolean files_sidebar_interface_remove_item_by_id (FilesSidebarInterface* self,
                                                    guint32 item_id);
VALA_EXTERN void files_sidebar_interface_add_favorite_uri (FilesSidebarInterface* self,
                                               const gchar* uri,
                                               const gchar* custom_name);
VALA_EXTERN gboolean files_sidebar_interface_has_favorite_uri (FilesSidebarInterface* self,
                                                   const gchar* uri);
VALA_EXTERN void files_sidebar_interface_sync_uri (FilesSidebarInterface* self,
                                       const gchar* uri);
VALA_EXTERN void files_sidebar_interface_reload (FilesSidebarInterface* self);
VALA_EXTERN void files_sidebar_interface_on_free_space_change (FilesSidebarInterface* self);

VALA_EXTERN const gchar* FILES_PREFERENCES_TAGS_COLORS[12];

G_END_DECLS

#endif
