
#ifndef KROSSCORE_EXPORT_H
#define KROSSCORE_EXPORT_H

#ifdef KROSSCORE_STATIC_DEFINE
#  define KROSSCORE_EXPORT
#  define KROSSCORE_NO_EXPORT
#else
#  ifndef KROSSCORE_EXPORT
#    ifdef KF5KrossCore_EXPORTS
        /* We are building this library */
#      define KROSSCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KROSSCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KROSSCORE_NO_EXPORT
#    define KROSSCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KROSSCORE_DECL_DEPRECATED
#  define KROSSCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KROSSCORE_DECL_DEPRECATED_EXPORT
#  define KROSSCORE_DECL_DEPRECATED_EXPORT KROSSCORE_EXPORT KROSSCORE_DECL_DEPRECATED
#endif

#ifndef KROSSCORE_DECL_DEPRECATED_NO_EXPORT
#  define KROSSCORE_DECL_DEPRECATED_NO_EXPORT KROSSCORE_NO_EXPORT KROSSCORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KROSSCORE_NO_DEPRECATED
#    define KROSSCORE_NO_DEPRECATED
#  endif
#endif

#define KROSSCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KROSSCORE_NO_DEPRECATED) && !defined(KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KROSSCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KROSSCORE_NO_DEPRECATED_WARNINGS) && !defined(KROSSCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KROSSCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KROSSCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KROSSCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KROSSCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KROSSCORE_NO_DEPRECATED)
#  undef KROSSCORE_DEPRECATED
#  define KROSSCORE_DEPRECATED_EXPORT KROSSCORE_EXPORT
#  define KROSSCORE_DEPRECATED_NO_EXPORT KROSSCORE_NO_EXPORT
#elif defined(KROSSCORE_NO_DEPRECATED_WARNINGS)
#  define KROSSCORE_DEPRECATED
#  define KROSSCORE_DEPRECATED_EXPORT KROSSCORE_EXPORT
#  define KROSSCORE_DEPRECATED_NO_EXPORT KROSSCORE_NO_EXPORT
#else
#  define KROSSCORE_DEPRECATED KROSSCORE_DECL_DEPRECATED
#  define KROSSCORE_DEPRECATED_EXPORT KROSSCORE_DECL_DEPRECATED_EXPORT
#  define KROSSCORE_DEPRECATED_NO_EXPORT KROSSCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KROSSCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KROSSCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KROSSCORE_NO_DEPRECATED
#  define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55800
#endif
#ifdef KROSSCORE_NO_DEPRECATED_WARNINGS
#  define KROSSCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KROSSCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KROSSCORE_DEPRECATED_WARNINGS_SINCE KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KROSSCORE_DEPRECATED_WARNINGS_SINCE 0x55800
#  endif
#endif

#ifndef KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KROSSCORE_DEPRECATED
#  define KROSSCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KROSSCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KROSSCORE_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KROSSCORE_DEPRECATED_VERSION_5_88(text) KROSSCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KROSSCORE_DEPRECATED_VERSION_5_88(text)
#endif
#define KROSSCORE_DEPRECATED_VERSION_5(minor, text)      KROSSCORE_DEPRECATED_VERSION_5_##minor(text)
#define KROSSCORE_DEPRECATED_VERSION(major, minor, text) KROSSCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KROSSCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KROSSCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KROSSCORE_DEPRECATED_VERSION(major, minor, text)
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KROSSCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KROSSCORE_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KROSSCORE_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KROSSCORE_EXPORT_H


#define KROSSCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KROSSCORE_NO_DEPRECATED) && !defined(KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KROSSCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KROSSCORE_NO_DEPRECATED_WARNINGS) && !defined(KROSSCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KROSSCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KROSSCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KROSSCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KROSSCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KROSSCORE_NO_DEPRECATED)
#  undef KROSSCORE_DEPRECATED
#  define KROSSCORE_DEPRECATED_EXPORT KROSSCORE_EXPORT
#  define KROSSCORE_DEPRECATED_NO_EXPORT KROSSCORE_NO_EXPORT
#elif defined(KROSSCORE_NO_DEPRECATED_WARNINGS)
#  define KROSSCORE_DEPRECATED
#  define KROSSCORE_DEPRECATED_EXPORT KROSSCORE_EXPORT
#  define KROSSCORE_DEPRECATED_NO_EXPORT KROSSCORE_NO_EXPORT
#else
#  define KROSSCORE_DEPRECATED KROSSCORE_DECL_DEPRECATED
#  define KROSSCORE_DEPRECATED_EXPORT KROSSCORE_DECL_DEPRECATED_EXPORT
#  define KROSSCORE_DEPRECATED_NO_EXPORT KROSSCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KROSSCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KROSSCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KROSSCORE_NO_DEPRECATED
#  define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55800
#endif
#ifdef KROSSCORE_NO_DEPRECATED_WARNINGS
#  define KROSSCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KROSSCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KROSSCORE_DEPRECATED_WARNINGS_SINCE KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KROSSCORE_DEPRECATED_WARNINGS_SINCE 0x55800
#  endif
#endif

#ifndef KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KROSSCORE_DEPRECATED
#  define KROSSCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KROSSCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KROSSCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KROSSCORE_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KROSSCORE_DEPRECATED_VERSION_5_88(text) KROSSCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KROSSCORE_DEPRECATED_VERSION_5_88(text)
#endif
#define KROSSCORE_DEPRECATED_VERSION_5(minor, text)      KROSSCORE_DEPRECATED_VERSION_5_##minor(text)
#define KROSSCORE_DEPRECATED_VERSION(major, minor, text) KROSSCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KROSSCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KROSSCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KROSSCORE_DEPRECATED_VERSION(major, minor, text)
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KROSSCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KROSSCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KROSSCORE_EXPORT_H */
