/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.transport.wagon;

import org.jetbrains.kotlin.org.apache.maven.wagon.Wagon;
import org.jetbrains.kotlin.org.codehaus.plexus.PlexusContainer;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonConfigurator;

@Component(role=WagonConfigurator.class, hint="plexus")
public class PlexusWagonConfigurator
implements WagonConfigurator {
    @Requirement
    private PlexusContainer container;

    public PlexusWagonConfigurator() {
    }

    public PlexusWagonConfigurator(PlexusContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("plexus container has not been specified");
        }
        this.container = container;
    }

    @Override
    public void configure(Wagon wagon, Object configuration) throws Exception {
        PlexusConfiguration config = null;
        if (configuration instanceof PlexusConfiguration) {
            config = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            config = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        } else {
            if (configuration == null) {
                return;
            }
            throw new IllegalArgumentException("Unexpected configuration type: " + configuration.getClass().getName());
        }
        WagonComponentConfigurator configurator = new WagonComponentConfigurator();
        configurator.configureComponent(wagon, config, this.container.getContainerRealm());
    }

    static class WagonComponentConfigurator
    extends AbstractComponentConfigurator {
        WagonComponentConfigurator() {
        }

        @Override
        public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener listener) throws ComponentConfigurationException {
            ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
            converter.processConfiguration(this.converterLookup, component, containerRealm, configuration, expressionEvaluator, listener);
        }
    }
}

