/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transport.wagon;

import java.nio.ByteBuffer;
import org.jetbrains.kotlin.org.apache.maven.wagon.events.TransferEvent;
import org.jetbrains.kotlin.org.apache.maven.wagon.observers.AbstractTransferListener;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportListener;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferCancelledException;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonCancelledException;

final class WagonTransferListener
extends AbstractTransferListener {
    private final TransportListener listener;

    public WagonTransferListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public void transferStarted(TransferEvent event) {
        try {
            this.listener.transportStarted(0L, event.getResource().getContentLength());
        }
        catch (TransferCancelledException transferCancelledException) {
            // empty catch block
        }
    }

    @Override
    public void transferProgress(TransferEvent event, byte[] buffer, int length) {
        try {
            this.listener.transportProgressed(ByteBuffer.wrap(buffer, 0, length));
        }
        catch (TransferCancelledException e) {
            throw new WagonCancelledException(e);
        }
    }
}

