/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.lang.constant.Constable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\rH\u0002J&\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ConstantEvaluator;", "", "containingClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;Lorg/jetbrains/kotlin/javac/JavacWrapper;Lcom/sun/source/tree/CompilationUnitTree;)V", "evaluateBinaryExpression", "value", "Lcom/sun/tools/javac/tree/JCTree$JCBinary;", "evaluateUnaryExpression", "Lcom/sun/tools/javac/tree/JCTree$JCUnary;", "evaluateValue", "lhsValue", "rhsValue", "opcode", "Lcom/sun/tools/javac/tree/JCTree$Tag;", "getValue", "expr", "Lcom/sun/tools/javac/tree/JCTree$JCExpression;", "javac-wrapper"})
public final class ConstantEvaluator {
    @NotNull
    private final JavaClass containingClass;
    @NotNull
    private final JavacWrapper javac;
    @NotNull
    private final CompilationUnitTree compilationUnit;

    public ConstantEvaluator(@NotNull JavaClass containingClass, @NotNull JavacWrapper javac2, @NotNull CompilationUnitTree compilationUnit) {
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(javac2, "javac");
        Intrinsics.checkNotNullParameter(compilationUnit, "compilationUnit");
        this.containingClass = containingClass;
        this.javac = javac2;
        this.compilationUnit = compilationUnit;
    }

    @Nullable
    public final Object getValue(@NotNull JCTree.JCExpression expr) {
        Object object;
        Intrinsics.checkNotNullParameter(expr, "expr");
        JCTree.JCExpression jCExpression = expr;
        if (jCExpression instanceof JCTree.JCLiteral) {
            object = ((JCTree.JCLiteral)expr).typetag == TypeTag.BOOLEAN ? Boolean.valueOf(!Intrinsics.areEqual(((JCTree.JCLiteral)expr).value, (Object)0)) : ((JCTree.JCLiteral)expr).value;
        } else if (jCExpression instanceof JCTree.JCIdent ? true : jCExpression instanceof JCTree.JCFieldAccess) {
            JavaField javaField2 = this.javac.resolveField(expr, this.compilationUnit, this.containingClass);
            object = javaField2 == null ? null : javaField2.getInitializerValue();
        } else if (jCExpression instanceof JCTree.JCBinary) {
            object = this.evaluateBinaryExpression((JCTree.JCBinary)expr);
        } else if (jCExpression instanceof JCTree.JCParens) {
            JCTree.JCExpression jCExpression2 = ((JCTree.JCParens)expr).expr;
            Intrinsics.checkNotNullExpressionValue(jCExpression2, "expr.expr");
            object = this.getValue(jCExpression2);
        } else {
            object = jCExpression instanceof JCTree.JCUnary ? this.evaluateUnaryExpression((JCTree.JCUnary)expr) : null;
        }
        return object;
    }

    private final Object evaluateUnaryExpression(JCTree.JCUnary value2) {
        Constable constable;
        Object object = value2.arg;
        Intrinsics.checkNotNullExpressionValue(object, "value.arg");
        Object argValue = this.getValue((JCTree.JCExpression)object);
        object = value2.getTag();
        int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                Object object2 = argValue;
                if (object2 instanceof Integer) {
                    constable = ~((Number)argValue).intValue();
                    break;
                }
                if (object2 instanceof Long) {
                    constable = ((Number)argValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                if (object2 instanceof Short) {
                    constable = ~((Number)argValue).shortValue();
                    break;
                }
                if (object2 instanceof Byte) {
                    constable = ~((Number)argValue).byteValue();
                    break;
                }
                constable = null;
                break;
            }
            case 2: {
                Boolean bl;
                Boolean bl2 = bl = argValue instanceof Boolean ? (Boolean)argValue : null;
                if (bl == null) {
                    constable = null;
                    break;
                }
                Boolean bl3 = bl;
                boolean it = bl3;
                boolean bl4 = false;
                constable = Boolean.valueOf(!it);
                break;
            }
            default: {
                constable = null;
            }
        }
        return constable;
    }

    private final Object evaluateBinaryExpression(JCTree.JCBinary value2) {
        Object object = value2.lhs;
        Intrinsics.checkNotNullExpressionValue(object, "value.lhs");
        Object object2 = this.getValue((JCTree.JCExpression)object);
        if (object2 == null) {
            return null;
        }
        Object lhsValue = object2;
        JCTree.JCExpression jCExpression = value2.rhs;
        Intrinsics.checkNotNullExpressionValue(jCExpression, "value.rhs");
        object = this.getValue(jCExpression);
        if (object == null) {
            return null;
        }
        Object rhsValue = object;
        object = value2.getTag();
        Intrinsics.checkNotNullExpressionValue(object, "value.tag");
        return this.evaluateValue(lhsValue, rhsValue, (JCTree.Tag)((Object)object));
    }

    private final Object evaluateValue(Object lhsValue, Object rhsValue, JCTree.Tag opcode) {
        if (lhsValue instanceof String && opcode == JCTree.Tag.PLUS) {
            return Intrinsics.stringPlus((String)lhsValue, rhsValue);
        }
        if (lhsValue instanceof Boolean && rhsValue instanceof Boolean) {
            Boolean bl;
            JCTree.Tag tag = opcode;
            int n = WhenMappings.$EnumSwitchMapping$0[tag.ordinal()];
            switch (n) {
                case 3: {
                    bl = (Boolean)lhsValue != false && (Boolean)rhsValue != false;
                    break;
                }
                case 4: {
                    bl = (Boolean)lhsValue != false || (Boolean)rhsValue != false;
                    break;
                }
                case 5: {
                    bl = Intrinsics.areEqual(lhsValue, rhsValue);
                    break;
                }
                case 6: {
                    bl = !Intrinsics.areEqual(lhsValue, rhsValue);
                    break;
                }
                case 7: {
                    bl = (Boolean)lhsValue ^ (Boolean)rhsValue;
                    break;
                }
                case 8: {
                    bl = (Boolean)lhsValue & (Boolean)rhsValue;
                    break;
                }
                case 9: {
                    bl = (Boolean)lhsValue | (Boolean)rhsValue;
                    break;
                }
                default: {
                    bl = null;
                }
            }
            return bl;
        }
        if (lhsValue instanceof Number && rhsValue instanceof Number) {
            Constable constable;
            boolean isInteger;
            boolean bl = isInteger = !(lhsValue instanceof Float) && !(lhsValue instanceof Double) && !(rhsValue instanceof Float) && !(rhsValue instanceof Double);
            boolean isWide = isInteger ? lhsValue instanceof Long || rhsValue instanceof Long : lhsValue instanceof Double || rhsValue instanceof Double;
            JCTree.Tag tag = opcode;
            int n = WhenMappings.$EnumSwitchMapping$0[tag.ordinal()];
            switch (n) {
                case 10: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() + ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() + ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() + ((Number)rhsValue).floatValue());
                    break;
                }
                case 11: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() - ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() - ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() - ((Number)rhsValue).floatValue());
                    break;
                }
                case 12: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() * ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() * ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() * ((Number)rhsValue).floatValue());
                    break;
                }
                case 13: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() / ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() / ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() / ((Number)rhsValue).floatValue());
                    break;
                }
                case 14: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() % ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() % ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() % ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() % ((Number)rhsValue).floatValue());
                    break;
                }
                case 15: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() >> ((Number)rhsValue).intValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() >> ((Number)rhsValue).intValue();
                    break;
                }
                case 16: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() << ((Number)rhsValue).intValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() << ((Number)rhsValue).intValue();
                    break;
                }
                case 8: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() & ((Number)rhsValue).longValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() & ((Number)rhsValue).intValue();
                    break;
                }
                case 9: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() | ((Number)rhsValue).longValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() | ((Number)rhsValue).intValue();
                    break;
                }
                case 7: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() ^ ((Number)rhsValue).longValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() ^ ((Number)rhsValue).intValue();
                    break;
                }
                case 17: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() >>> ((Number)rhsValue).intValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() >>> ((Number)rhsValue).intValue();
                    break;
                }
                case 5: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() == ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() == ((Number)rhsValue).doubleValue());
                    break;
                }
                case 6: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() != ((Number)rhsValue).longValue() : !(((Number)lhsValue).doubleValue() == ((Number)rhsValue).doubleValue()));
                    break;
                }
                case 18: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() < ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() < ((Number)rhsValue).doubleValue());
                    break;
                }
                case 19: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() <= ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() <= ((Number)rhsValue).doubleValue());
                    break;
                }
                case 20: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() > ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() > ((Number)rhsValue).doubleValue());
                    break;
                }
                case 21: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() >= ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() >= ((Number)rhsValue).doubleValue());
                    break;
                }
                default: {
                    constable = null;
                }
            }
            return constable;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JCTree.Tag.values().length];
            nArray[JCTree.Tag.COMPL.ordinal()] = 1;
            nArray[JCTree.Tag.NOT.ordinal()] = 2;
            nArray[JCTree.Tag.AND.ordinal()] = 3;
            nArray[JCTree.Tag.OR.ordinal()] = 4;
            nArray[JCTree.Tag.EQ.ordinal()] = 5;
            nArray[JCTree.Tag.NE.ordinal()] = 6;
            nArray[JCTree.Tag.BITXOR.ordinal()] = 7;
            nArray[JCTree.Tag.BITAND.ordinal()] = 8;
            nArray[JCTree.Tag.BITOR.ordinal()] = 9;
            nArray[JCTree.Tag.PLUS.ordinal()] = 10;
            nArray[JCTree.Tag.MINUS.ordinal()] = 11;
            nArray[JCTree.Tag.MUL.ordinal()] = 12;
            nArray[JCTree.Tag.DIV.ordinal()] = 13;
            nArray[JCTree.Tag.MOD.ordinal()] = 14;
            nArray[JCTree.Tag.SR.ordinal()] = 15;
            nArray[JCTree.Tag.SL.ordinal()] = 16;
            nArray[JCTree.Tag.USR.ordinal()] = 17;
            nArray[JCTree.Tag.LT.ordinal()] = 18;
            nArray[JCTree.Tag.LE.ordinal()] = 19;
            nArray[JCTree.Tag.GT.ordinal()] = 20;
            nArray[JCTree.Tag.GE.ordinal()] = 21;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

