/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class InlineParameterChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineParameterChecker INSTANCE = new InlineParameterChecker();

    private InlineParameterChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block7: {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            if (!(declaration2 instanceof KtFunction)) break block7;
            boolean inline = declaration2.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration2).getValueParameters()) {
                KotlinType kotlinType;
                boolean bl;
                Object object;
                VariableDescriptor parameterDescriptor;
                block9: {
                    block8: {
                        parameterDescriptor = (VariableDescriptor)context2.getTrace().get(BindingContext.VALUE_PARAMETER, parameter);
                        if (!inline) break block8;
                        if (parameterDescriptor == null) break block9;
                        object = parameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue(object, "parameterDescriptor.type");
                        if (FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object)) break block9;
                    }
                    Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                    object = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(object, "NOINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, (KtModifierKeywordToken)object, context2.getTrace());
                    object = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(object, "CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, (KtModifierKeywordToken)object, context2.getTrace());
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD) || parameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD)) continue;
                object = parameterDescriptor;
                if (object == null) {
                    bl = false;
                } else {
                    kotlinType = object.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
                    bl = FunctionTypesKt.isSuspendFunctionType(kotlinType);
                }
                if (!bl) continue;
                if (declaration2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    PsiElement psiElement;
                    KtModifierList ktModifierList;
                    Intrinsics.checkNotNull(parameter.getTypeReference());
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "parameter.typeReference!!");
                    Object typeReference = kotlinType;
                    Intrinsics.checkNotNull(((KtModifierListOwnerStub)typeReference).getModifierList());
                    Intrinsics.checkNotNullExpressionValue(ktModifierList, "typeReference.modifierList!!");
                    KtModifierList modifierList2 = ktModifierList;
                    Intrinsics.checkNotNull(modifierList2.getModifier(KtTokens.SUSPEND_KEYWORD));
                    Intrinsics.checkNotNullExpressionValue(psiElement, "modifierList.getModifier\u2026Tokens.SUSPEND_KEYWORD)!!");
                    PsiElement modifier = psiElement;
                    context2.getTrace().report(Errors.REDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE.on(modifier));
                    continue;
                }
                context2.getTrace().report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(KtParameter $this$reportIncorrectInline, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        PsiElement psiElement = $this$reportIncorrectInline.getModifierList();
        PsiElement modifier = psiElement == null ? null : psiElement.getModifier(modifierToken);
        psiElement = modifier;
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = psiElement;
            boolean bl = false;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }
}

