/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.ParameterNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003567B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0011H\u0016J\u001a\u0010.\u001a\u00020\"2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J*\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u00032\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "access", "", "name", "", "desc", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getAccess", "()I", "annotations", "", "Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode$MethodAnnotation;", "attributes", "Lorg/jetbrains/org/objectweb/asm/Attribute;", "getDesc", "()Ljava/lang/String;", "getExceptions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "invisibleAnnotableParameterCount", "getName", "parameterAnnotations", "Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode$MethodParameterAnnotation;", "parameters", "Lorg/jetbrains/org/objectweb/asm/tree/ParameterNode;", "getSignature", "typeAnnotations", "Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode$MethodTypeAnnotation;", "visibleAnnotableParameterCount", "accept", "", "classVisitor", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "visitAnnotableParameterCount", "parameterCount", "visible", "", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "descriptor", "visitAttribute", "attribute", "visitParameter", "visitParameterAnnotation", "parameter", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "MethodAnnotation", "MethodParameterAnnotation", "MethodTypeAnnotation", "jvm-abi-gen"})
final class StrippedMethodNode
extends MethodVisitor {
    private final int access;
    @NotNull
    private final String name;
    @NotNull
    private final String desc;
    @Nullable
    private final String signature;
    @Nullable
    private final String[] exceptions;
    @NotNull
    private final List<ParameterNode> parameters;
    @NotNull
    private final List<MethodAnnotation> annotations;
    @NotNull
    private final List<MethodTypeAnnotation> typeAnnotations;
    private int visibleAnnotableParameterCount;
    private int invisibleAnnotableParameterCount;
    @NotNull
    private final List<MethodParameterAnnotation> parameterAnnotations;
    @NotNull
    private final List<Attribute> attributes;

    public StrippedMethodNode(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        super(589824);
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = exceptions;
        this.parameters = new ArrayList();
        this.annotations = new ArrayList();
        this.typeAnnotations = new ArrayList();
        this.parameterAnnotations = new ArrayList();
        this.attributes = new ArrayList();
    }

    public final int getAccess() {
        return this.access;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDesc() {
        return this.desc;
    }

    @Nullable
    public final String getSignature() {
        return this.signature;
    }

    @Nullable
    public final String[] getExceptions() {
        return this.exceptions;
    }

    public void visitParameter(@Nullable String name, int access) {
        this.parameters.add(new ParameterNode(name, access));
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String descriptor, boolean visible) {
        AnnotationNode annotationNode;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        AnnotationNode it = annotationNode = new AnnotationNode(589824, descriptor);
        boolean bl = false;
        this.annotations.add(new MethodAnnotation(visible, it));
        return (AnnotationVisitor)annotationNode;
    }

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor, boolean visible) {
        AnnotationNode annotationNode;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        AnnotationNode it = annotationNode = new AnnotationNode(589824, descriptor);
        boolean bl = false;
        this.typeAnnotations.add(new MethodTypeAnnotation(typeRef, typePath, visible, it));
        return (AnnotationVisitor)annotationNode;
    }

    public void visitAttribute(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.attributes.add(attribute);
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        if (visible) {
            this.visibleAnnotableParameterCount = parameterCount;
        } else {
            this.invisibleAnnotableParameterCount = parameterCount;
        }
    }

    @NotNull
    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String descriptor, boolean visible) {
        AnnotationNode annotationNode;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        AnnotationNode it = annotationNode = new AnnotationNode(589824, descriptor);
        boolean bl = false;
        this.parameterAnnotations.add(new MethodParameterAnnotation(parameter, visible, it));
        return (AnnotationVisitor)annotationNode;
    }

    public final void accept(@NotNull ClassVisitor classVisitor) {
        AnnotationVisitor it;
        AnnotationVisitor annotationVisitor;
        AnnotationVisitor annotationVisitor2;
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        MethodVisitor visitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, this.exceptions);
        for (ParameterNode parameter : this.parameters) {
            visitor.visitParameter(parameter.name, parameter.access);
        }
        for (MethodAnnotation annotation : this.annotations) {
            annotationVisitor2 = visitor.visitAnnotation(annotation.getNode().desc, annotation.getVisible());
            if (annotationVisitor2 == null) continue;
            it = annotationVisitor = annotationVisitor2;
            boolean bl = false;
            annotation.getNode().accept(it);
        }
        for (MethodTypeAnnotation typeAnnotation : this.typeAnnotations) {
            annotationVisitor2 = visitor.visitTypeAnnotation(typeAnnotation.getTypeRef(), typeAnnotation.getTypePath(), typeAnnotation.getNode().desc, typeAnnotation.getVisible());
            if (annotationVisitor2 == null) continue;
            it = annotationVisitor = annotationVisitor2;
            boolean bl = false;
            typeAnnotation.getNode().accept(it);
        }
        visitor.visitAnnotableParameterCount(this.visibleAnnotableParameterCount, true);
        visitor.visitAnnotableParameterCount(this.invisibleAnnotableParameterCount, false);
        for (MethodParameterAnnotation parameterAnnotation : this.parameterAnnotations) {
            annotationVisitor2 = visitor.visitParameterAnnotation(parameterAnnotation.getParameter(), parameterAnnotation.getNode().desc, parameterAnnotation.getVisible());
            if (annotationVisitor2 == null) continue;
            it = annotationVisitor = annotationVisitor2;
            boolean bl = false;
            parameterAnnotation.getNode().accept(it);
        }
        for (Attribute attribute : this.attributes) {
            visitor.visitAttribute(attribute);
        }
        if ((this.access & 0x500) == 0) {
            visitor.visitCode();
            visitor.visitInsn(1);
            visitor.visitInsn(191);
            visitor.visitMaxs(0, this.parameters.size());
        }
        visitor.visitEnd();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode$MethodAnnotation;", "", "visible", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "(ZLorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;)V", "getNode", "()Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "getVisible", "()Z", "jvm-abi-gen"})
    private static final class MethodAnnotation {
        private final boolean visible;
        @NotNull
        private final AnnotationNode node;

        public MethodAnnotation(boolean visible, @NotNull AnnotationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.visible = visible;
            this.node = node;
        }

        public final boolean getVisible() {
            return this.visible;
        }

        @NotNull
        public final AnnotationNode getNode() {
            return this.node;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode$MethodTypeAnnotation;", "", "typeRef", "", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "visible", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "(ILorg/jetbrains/org/objectweb/asm/TypePath;ZLorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;)V", "getNode", "()Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "getTypePath", "()Lorg/jetbrains/org/objectweb/asm/TypePath;", "getTypeRef", "()I", "getVisible", "()Z", "jvm-abi-gen"})
    private static final class MethodTypeAnnotation {
        private final int typeRef;
        @Nullable
        private final TypePath typePath;
        private final boolean visible;
        @NotNull
        private final AnnotationNode node;

        public MethodTypeAnnotation(int typeRef, @Nullable TypePath typePath, boolean visible, @NotNull AnnotationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.typeRef = typeRef;
            this.typePath = typePath;
            this.visible = visible;
            this.node = node;
        }

        public final int getTypeRef() {
            return this.typeRef;
        }

        @Nullable
        public final TypePath getTypePath() {
            return this.typePath;
        }

        public final boolean getVisible() {
            return this.visible;
        }

        @NotNull
        public final AnnotationNode getNode() {
            return this.node;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/StrippedMethodNode$MethodParameterAnnotation;", "", "parameter", "", "visible", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "(IZLorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;)V", "getNode", "()Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "getParameter", "()I", "getVisible", "()Z", "jvm-abi-gen"})
    private static final class MethodParameterAnnotation {
        private final int parameter;
        private final boolean visible;
        @NotNull
        private final AnnotationNode node;

        public MethodParameterAnnotation(int parameter, boolean visible, @NotNull AnnotationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.parameter = parameter;
            this.visible = visible;
            this.node = node;
        }

        public final int getParameter() {
            return this.parameter;
        }

        public final boolean getVisible() {
            return this.visible;
        }

        @NotNull
        public final AnnotationNode getNode() {
            return this.node;
        }
    }
}

