/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.core.ApplicationJspPropertyGroupDescriptor;
import org.apache.catalina.core.ApplicationTaglibDescriptor;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextHandler;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.InjectionTarget;
import org.apache.catalina.deploy.JspPropertyGroup;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.MultipartDef;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.SecurityRoleRef;
import org.apache.catalina.deploy.ServletDef;
import org.apache.catalina.deploy.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class WebXml {
    protected static final String ORDER_OTHERS = "org.apache.catalina.order.others";
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.deploy");
    private static final Log log = LogFactory.getLog(WebXml.class);
    private boolean overridable = false;
    private boolean duplicated = false;
    private Set<String> absoluteOrdering = null;
    private Set<String> after = new LinkedHashSet<String>();
    private Set<String> before = new LinkedHashSet<String>();
    private String publicId = null;
    private boolean metadataComplete = false;
    private String name = null;
    private int majorVersion = 3;
    private int minorVersion = 0;
    private String displayName = null;
    private boolean distributable = false;
    private Map<String, String> contextParams = new HashMap<String, String>();
    private Map<String, FilterDef> filters = new LinkedHashMap<String, FilterDef>();
    private Set<FilterMap> filterMaps = new LinkedHashSet<FilterMap>();
    private Set<String> filterMappingNames = new HashSet<String>();
    private Set<String> listeners = new LinkedHashSet<String>();
    private Map<String, ServletDef> servlets = new HashMap<String, ServletDef>();
    private Map<String, String> servletMappings = new HashMap<String, String>();
    private Set<String> servletMappingNames = new HashSet<String>();
    private SessionConfig sessionConfig = new SessionConfig();
    private Map<String, String> mimeMappings = new HashMap<String, String>();
    private boolean replaceWelcomeFiles = false;
    private boolean alwaysAddWelcomeFiles = true;
    private Set<String> welcomeFiles = new LinkedHashSet<String>();
    private Map<String, ErrorPage> errorPages = new HashMap<String, ErrorPage>();
    private Map<String, String> taglibs = new HashMap<String, String>();
    private Set<JspPropertyGroup> jspPropertyGroups = new LinkedHashSet<JspPropertyGroup>();
    private Set<SecurityConstraint> securityConstraints = new HashSet<SecurityConstraint>();
    private LoginConfig loginConfig = null;
    private Set<String> securityRoles = new HashSet<String>();
    private Map<String, ContextEnvironment> envEntries = new HashMap<String, ContextEnvironment>();
    private Map<String, ContextEjb> ejbRefs = new HashMap<String, ContextEjb>();
    private Map<String, ContextLocalEjb> ejbLocalRefs = new HashMap<String, ContextLocalEjb>();
    private Map<String, ContextService> serviceRefs = new HashMap<String, ContextService>();
    private Map<String, ContextResource> resourceRefs = new HashMap<String, ContextResource>();
    private Map<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap<String, ContextResourceEnvRef>();
    private Map<String, MessageDestinationRef> messageDestinationRefs = new HashMap<String, MessageDestinationRef>();
    private Map<String, MessageDestination> messageDestinations = new HashMap<String, MessageDestination>();
    private Map<String, String> localeEncodingMappings = new HashMap<String, String>();
    private Map<String, String> postConstructMethods = new HashMap<String, String>();
    private Map<String, String> preDestroyMethods = new HashMap<String, String>();
    private URL uRL = null;
    private String jarName = null;
    private static final String INDENT2 = "  ";
    private static final String INDENT4 = "    ";
    private static final String INDENT6 = "      ";

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean bl) {
        this.overridable = bl;
    }

    public boolean isDuplicated() {
        return this.duplicated;
    }

    public void setDuplicated(boolean bl) {
        this.duplicated = bl;
    }

    public void createAbsoluteOrdering() {
        if (this.absoluteOrdering == null) {
            this.absoluteOrdering = new LinkedHashSet<String>();
        }
    }

    public void addAbsoluteOrdering(String string) {
        this.createAbsoluteOrdering();
        this.absoluteOrdering.add(string);
    }

    public void addAbsoluteOrderingOthers() {
        this.createAbsoluteOrdering();
        this.absoluteOrdering.add(ORDER_OTHERS);
    }

    public Set<String> getAbsoluteOrdering() {
        return this.absoluteOrdering;
    }

    public void addAfterOrdering(String string) {
        this.after.add(string);
    }

    public void addAfterOrderingOthers() {
        if (this.before.contains(ORDER_OTHERS)) {
            throw new IllegalArgumentException(sm.getString("webXml.multipleOther"));
        }
        this.after.add(ORDER_OTHERS);
    }

    public Set<String> getAfterOrdering() {
        return this.after;
    }

    public void addBeforeOrdering(String string) {
        this.before.add(string);
    }

    public void addBeforeOrderingOthers() {
        if (this.after.contains(ORDER_OTHERS)) {
            throw new IllegalArgumentException(sm.getString("webXml.multipleOther"));
        }
        this.before.add(ORDER_OTHERS);
    }

    public Set<String> getBeforeOrdering() {
        return this.before;
    }

    public String getVersion() {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(this.majorVersion);
        stringBuilder.append('.');
        stringBuilder.append(this.minorVersion);
        return stringBuilder.toString();
    }

    public void setVersion(String string) {
        if (string == null) {
            return;
        }
        if ("2.4".equals(string)) {
            this.majorVersion = 2;
            this.minorVersion = 4;
        } else if ("2.5".equals(string)) {
            this.majorVersion = 2;
            this.minorVersion = 5;
        } else if ("3.0".equals(string)) {
            this.majorVersion = 3;
            this.minorVersion = 0;
        } else {
            log.warn((Object)sm.getString("webXml.version.unknown", new Object[]{string}));
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String string) {
        if (string == null) {
            return;
        }
        if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(string)) {
            this.majorVersion = 2;
            this.minorVersion = 2;
            this.publicId = string;
        } else if ("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(string)) {
            this.majorVersion = 2;
            this.minorVersion = 3;
            this.publicId = string;
        } else {
            log.warn((Object)sm.getString("webXml.unrecognisedPublicId", new Object[]{string}));
        }
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean bl) {
        this.metadataComplete = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (ORDER_OTHERS.equalsIgnoreCase(string)) {
            log.warn((Object)sm.getString("webXml.reservedName", new Object[]{string}));
        } else {
            this.name = string;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean bl) {
        this.distributable = bl;
    }

    public void addContextParam(String string, String string2) {
        this.contextParams.put(string, string2);
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public void addFilter(FilterDef filterDef) {
        if (this.filters.containsKey(filterDef.getFilterName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateFilter", new Object[]{filterDef.getFilterName()}));
        }
        this.filters.put(filterDef.getFilterName(), filterDef);
    }

    public Map<String, FilterDef> getFilters() {
        return this.filters;
    }

    public void addFilterMapping(FilterMap filterMap) {
        this.filterMaps.add(filterMap);
        this.filterMappingNames.add(filterMap.getFilterName());
    }

    public Set<FilterMap> getFilterMappings() {
        return this.filterMaps;
    }

    public void addListener(String string) {
        this.listeners.add(string);
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public void addServlet(ServletDef servletDef) {
        this.servlets.put(servletDef.getServletName(), servletDef);
        if (this.overridable) {
            servletDef.setOverridable(this.overridable);
        }
    }

    public Map<String, ServletDef> getServlets() {
        return this.servlets;
    }

    public void addServletMapping(String string, String string2) {
        String string3 = this.servletMappings.put(string, string2);
        if (string3 != null) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateServletMapping", new Object[]{string3, string2, string}));
        }
        this.servletMappingNames.add(string2);
    }

    public Map<String, String> getServletMappings() {
        return this.servletMappings;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void addMimeMapping(String string, String string2) {
        this.mimeMappings.put(string, string2);
    }

    public Map<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public void setReplaceWelcomeFiles(boolean bl) {
        this.replaceWelcomeFiles = bl;
    }

    public void setAlwaysAddWelcomeFiles(boolean bl) {
        this.alwaysAddWelcomeFiles = bl;
    }

    public void addWelcomeFile(String string) {
        if (this.replaceWelcomeFiles) {
            this.welcomeFiles.clear();
            this.replaceWelcomeFiles = false;
        }
        this.welcomeFiles.add(string);
    }

    public Set<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.errorPages.put(errorPage.getName(), errorPage);
    }

    public Map<String, ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public void addTaglib(String string, String string2) {
        if (this.taglibs.containsKey(string)) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateTaglibUri", new Object[]{string}));
        }
        this.taglibs.put(string, string2);
    }

    public Map<String, String> getTaglibs() {
        return this.taglibs;
    }

    public void addJspPropertyGroup(JspPropertyGroup jspPropertyGroup) {
        this.jspPropertyGroups.add(jspPropertyGroup);
    }

    public Set<JspPropertyGroup> getJspPropertyGroups() {
        return this.jspPropertyGroups;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.add(securityConstraint);
    }

    public Set<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void addSecurityRole(String string) {
        this.securityRoles.add(string);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void addEnvEntry(ContextEnvironment contextEnvironment) {
        if (this.envEntries.containsKey(contextEnvironment.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateEnvEntry", new Object[]{contextEnvironment.getName()}));
        }
        this.envEntries.put(contextEnvironment.getName(), contextEnvironment);
    }

    public Map<String, ContextEnvironment> getEnvEntries() {
        return this.envEntries;
    }

    public void addEjbRef(ContextEjb contextEjb) {
        this.ejbRefs.put(contextEjb.getName(), contextEjb);
    }

    public Map<String, ContextEjb> getEjbRefs() {
        return this.ejbRefs;
    }

    public void addEjbLocalRef(ContextLocalEjb contextLocalEjb) {
        this.ejbLocalRefs.put(contextLocalEjb.getName(), contextLocalEjb);
    }

    public Map<String, ContextLocalEjb> getEjbLocalRefs() {
        return this.ejbLocalRefs;
    }

    public void addServiceRef(ContextService contextService) {
        this.serviceRefs.put(contextService.getName(), contextService);
    }

    public Map<String, ContextService> getServiceRefs() {
        return this.serviceRefs;
    }

    public void addResourceRef(ContextResource contextResource) {
        if (this.resourceRefs.containsKey(contextResource.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateResourceRef", new Object[]{contextResource.getName()}));
        }
        this.resourceRefs.put(contextResource.getName(), contextResource);
    }

    public Map<String, ContextResource> getResourceRefs() {
        return this.resourceRefs;
    }

    public void addResourceEnvRef(ContextResourceEnvRef contextResourceEnvRef) {
        if (this.resourceEnvRefs.containsKey(contextResourceEnvRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateResourceEnvRef", new Object[]{contextResourceEnvRef.getName()}));
        }
        this.resourceEnvRefs.put(contextResourceEnvRef.getName(), contextResourceEnvRef);
    }

    public Map<String, ContextResourceEnvRef> getResourceEnvRefs() {
        return this.resourceEnvRefs;
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        if (this.messageDestinationRefs.containsKey(messageDestinationRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateMessageDestinationRef", new Object[]{messageDestinationRef.getName()}));
        }
        this.messageDestinationRefs.put(messageDestinationRef.getName(), messageDestinationRef);
    }

    public Map<String, MessageDestinationRef> getMessageDestinationRefs() {
        return this.messageDestinationRefs;
    }

    public void addMessageDestination(MessageDestination messageDestination) {
        if (this.messageDestinations.containsKey(messageDestination.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateMessageDestination", new Object[]{messageDestination.getName()}));
        }
        this.messageDestinations.put(messageDestination.getName(), messageDestination);
    }

    public Map<String, MessageDestination> getMessageDestinations() {
        return this.messageDestinations;
    }

    public void addLocaleEncodingMapping(String string, String string2) {
        this.localeEncodingMappings.put(string, string2);
    }

    public Map<String, String> getLocalEncodingMappings() {
        return this.localeEncodingMappings;
    }

    public void addPostConstructMethods(String string, String string2) {
        if (!this.postConstructMethods.containsKey(string)) {
            this.postConstructMethods.put(string, string2);
        }
    }

    public Map<String, String> getPostConstructMethods() {
        return this.postConstructMethods;
    }

    public void addPreDestroyMethods(String string, String string2) {
        if (!this.preDestroyMethods.containsKey(string)) {
            this.preDestroyMethods.put(string, string2);
        }
    }

    public Map<String, String> getPreDestroyMethods() {
        return this.preDestroyMethods;
    }

    public void setURL(URL uRL) {
        this.uRL = uRL;
    }

    public URL getURL() {
        return this.uRL;
    }

    public void setJarName(String string) {
        this.jarName = string;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("Name: ");
        stringBuilder.append(this.getName());
        stringBuilder.append(", URL: ");
        stringBuilder.append(this.getURL());
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toXml() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.publicId != null) {
            stringBuilder.append("<!DOCTYPE web-app PUBLIC\n");
            stringBuilder.append("  \"");
            stringBuilder.append(this.publicId);
            stringBuilder.append("\"\n");
            stringBuilder.append("  \"");
            if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(this.publicId)) {
                stringBuilder.append("http://java.sun.com/dtd/web-app_2_2.dtd");
            } else {
                stringBuilder.append("http://java.sun.com/dtd/web-app_2_3.dtd");
            }
            stringBuilder.append("\">\n");
            stringBuilder.append("<web-app>");
        } else {
            void var3_7;
            Iterator<Object> iterator = null;
            Object object2 = null;
            object = this.getVersion();
            if ("2.4".equals(object)) {
                iterator = "http://java.sun.com/xml/ns/j2ee";
                String string = "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
            } else if ("2.5".equals(object)) {
                iterator = "http://java.sun.com/xml/ns/javaee";
                String string = "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd";
            } else if ("3.0".equals(object)) {
                iterator = "http://java.sun.com/xml/ns/javaee";
                String string = "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd";
            }
            stringBuilder.append("<web-app xmlns=\"");
            stringBuilder.append((String)((Object)iterator));
            stringBuilder.append("\"\n");
            stringBuilder.append("         xmlns:xsi=");
            stringBuilder.append("\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            stringBuilder.append("         xsi:schemaLocation=\"");
            stringBuilder.append((String)((Object)iterator));
            stringBuilder.append(" ");
            stringBuilder.append((String)var3_7);
            stringBuilder.append("\"\n");
            stringBuilder.append("         version=\"");
            stringBuilder.append(this.getVersion());
            stringBuilder.append("\"");
            if ("2.4".equals(object)) {
                stringBuilder.append(">\n\n");
            } else {
                stringBuilder.append("\n         metadata-complete=\"true\">\n\n");
            }
        }
        WebXml.appendElement(stringBuilder, INDENT2, "display-name", this.displayName);
        if (this.isDistributable()) {
            stringBuilder.append("  <distributable/>\n\n");
        }
        for (Map.Entry entry : this.contextParams.entrySet()) {
            stringBuilder.append("  <context-param>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "param-name", (String)entry.getKey());
            WebXml.appendElement(stringBuilder, INDENT4, "param-value", (String)entry.getValue());
            stringBuilder.append("  </context-param>\n");
        }
        stringBuilder.append('\n');
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (Map.Entry<String, FilterDef> entry : this.filters.entrySet()) {
                object = entry.getValue();
                stringBuilder.append("  <filter>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", ((FilterDef)object).getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", ((FilterDef)object).getDisplayName());
                WebXml.appendElement(stringBuilder, INDENT4, "filter-name", ((FilterDef)object).getFilterName());
                WebXml.appendElement(stringBuilder, INDENT4, "filter-class", ((FilterDef)object).getFilterClass());
                if (this.getMajorVersion() != 2) {
                    WebXml.appendElement(stringBuilder, INDENT4, "async-supported", ((FilterDef)object).getAsyncSupported());
                }
                for (Map.Entry<String, String> entry2 : ((FilterDef)object).getParameterMap().entrySet()) {
                    stringBuilder.append("    <init-param>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "param-name", entry2.getKey());
                    WebXml.appendElement(stringBuilder, INDENT6, "param-value", entry2.getValue());
                    stringBuilder.append("    </init-param>\n");
                }
                stringBuilder.append("  </filter>\n");
            }
            stringBuilder.append('\n');
            for (FilterMap filterMap : this.filterMaps) {
                stringBuilder.append("  <filter-mapping>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "filter-name", filterMap.getFilterName());
                if (filterMap.getMatchAllServletNames()) {
                    stringBuilder.append("    <servlet-name>*</servlet-name>\n");
                } else {
                    int n;
                    object = filterMap.getServletNames();
                    int n2 = ((String[])object).length;
                    boolean bl = false;
                    while (n < n2) {
                        String string = object[n];
                        WebXml.appendElement(stringBuilder, INDENT4, "servlet-name", string);
                        ++n;
                    }
                }
                if (filterMap.getMatchAllUrlPatterns()) {
                    stringBuilder.append("    <url-pattern>*</url-pattern>\n");
                } else {
                    for (String string : filterMap.getURLPatterns()) {
                        WebXml.appendElement(stringBuilder, INDENT4, "url-pattern", string);
                    }
                }
                if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
                    for (String string : filterMap.getDispatcherNames()) {
                        if (this.getMajorVersion() == 2 && DispatcherType.ASYNC.name().equals(string)) continue;
                        WebXml.appendElement(stringBuilder, INDENT4, "dispatcher", string);
                    }
                }
                stringBuilder.append("  </filter-mapping>\n");
            }
            stringBuilder.append('\n');
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (String string : this.listeners) {
                stringBuilder.append("  <listener>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "listener-class", string);
                stringBuilder.append("  </listener>\n");
            }
            stringBuilder.append('\n');
        }
        for (Map.Entry entry : this.servlets.entrySet()) {
            object = (ServletDef)entry.getValue();
            stringBuilder.append("  <servlet>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", ((ServletDef)object).getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "display-name", ((ServletDef)object).getDisplayName());
            WebXml.appendElement(stringBuilder, INDENT4, "servlet-name", (String)entry.getKey());
            WebXml.appendElement(stringBuilder, INDENT4, "servlet-class", ((ServletDef)object).getServletClass());
            WebXml.appendElement(stringBuilder, INDENT4, "jsp-file", ((ServletDef)object).getJspFile());
            for (Map.Entry<String, String> entry3 : ((ServletDef)object).getParameterMap().entrySet()) {
                stringBuilder.append("    <init-param>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "param-name", entry3.getKey());
                WebXml.appendElement(stringBuilder, INDENT6, "param-value", entry3.getValue());
                stringBuilder.append("    </init-param>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "load-on-startup", ((ServletDef)object).getLoadOnStartup());
            WebXml.appendElement(stringBuilder, INDENT4, "enabled", ((ServletDef)object).getEnabled());
            if (this.getMajorVersion() != 2) {
                WebXml.appendElement(stringBuilder, INDENT4, "async-supported", ((ServletDef)object).getAsyncSupported());
            }
            if ((this.getMajorVersion() > 2 || this.getMinorVersion() > 2) && ((ServletDef)object).getRunAs() != null) {
                stringBuilder.append("    <run-as>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "role-name", ((ServletDef)object).getRunAs());
                stringBuilder.append("    </run-as>\n");
            }
            Object object2 = ((ServletDef)object).getSecurityRoleRefs().iterator();
            while (object2.hasNext()) {
                SecurityRoleRef securityRoleRef = (SecurityRoleRef)object2.next();
                stringBuilder.append("    <security-role-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "role-name", securityRoleRef.getName());
                WebXml.appendElement(stringBuilder, INDENT6, "role-link", securityRoleRef.getLink());
                stringBuilder.append("    </security-role-ref>\n");
            }
            if (this.getMajorVersion() != 2 && (object2 = ((ServletDef)object).getMultipartDef()) != null) {
                stringBuilder.append("    <multipart-config>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "location", ((MultipartDef)object2).getLocation());
                WebXml.appendElement(stringBuilder, INDENT6, "max-file-size", ((MultipartDef)object2).getMaxFileSize());
                WebXml.appendElement(stringBuilder, INDENT6, "max-request-size", ((MultipartDef)object2).getMaxRequestSize());
                WebXml.appendElement(stringBuilder, INDENT6, "file-size-threshold", ((MultipartDef)object2).getFileSizeThreshold());
                stringBuilder.append("    </multipart-config>\n");
            }
            stringBuilder.append("  </servlet>\n");
        }
        stringBuilder.append('\n');
        for (Map.Entry entry : this.servletMappings.entrySet()) {
            stringBuilder.append("  <servlet-mapping>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "servlet-name", (String)entry.getValue());
            WebXml.appendElement(stringBuilder, INDENT4, "url-pattern", (String)entry.getKey());
            stringBuilder.append("  </servlet-mapping>\n");
        }
        stringBuilder.append('\n');
        if (this.sessionConfig != null) {
            stringBuilder.append("  <session-config>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "session-timeout", this.sessionConfig.getSessionTimeout());
            if (this.majorVersion >= 3) {
                stringBuilder.append("    <cookie-config>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "name", this.sessionConfig.getCookieName());
                WebXml.appendElement(stringBuilder, INDENT6, "domain", this.sessionConfig.getCookieDomain());
                WebXml.appendElement(stringBuilder, INDENT6, "path", this.sessionConfig.getCookiePath());
                WebXml.appendElement(stringBuilder, INDENT6, "comment", this.sessionConfig.getCookieComment());
                WebXml.appendElement(stringBuilder, INDENT6, "http-only", this.sessionConfig.getCookieHttpOnly());
                WebXml.appendElement(stringBuilder, INDENT6, "secure", this.sessionConfig.getCookieSecure());
                WebXml.appendElement(stringBuilder, INDENT6, "max-age", this.sessionConfig.getCookieMaxAge());
                stringBuilder.append("    </cookie-config>\n");
                for (SessionTrackingMode sessionTrackingMode : this.sessionConfig.getSessionTrackingModes()) {
                    WebXml.appendElement(stringBuilder, INDENT4, "tracking-mode", sessionTrackingMode.name());
                }
            }
            stringBuilder.append("  </session-config>\n\n");
        }
        for (Map.Entry entry : this.mimeMappings.entrySet()) {
            stringBuilder.append("  <mime-mapping>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "extension", (String)entry.getKey());
            WebXml.appendElement(stringBuilder, INDENT4, "mime-type", (String)entry.getValue());
            stringBuilder.append("  </mime-mapping>\n");
        }
        stringBuilder.append('\n');
        if (this.welcomeFiles.size() > 0) {
            stringBuilder.append("  <welcome-file-list>\n");
            for (String string : this.welcomeFiles) {
                WebXml.appendElement(stringBuilder, INDENT4, "welcome-file", string);
            }
            stringBuilder.append("  </welcome-file-list>\n\n");
        }
        for (ErrorPage errorPage : this.errorPages.values()) {
            object = errorPage.getExceptionType();
            int n = errorPage.getErrorCode();
            if (object == null && n == 0 && this.getMajorVersion() == 2) continue;
            stringBuilder.append("  <error-page>\n");
            if (errorPage.getExceptionType() != null) {
                WebXml.appendElement(stringBuilder, INDENT4, "exception-type", (String)object);
            } else if (errorPage.getErrorCode() > 0) {
                WebXml.appendElement(stringBuilder, INDENT4, "error-code", Integer.toString(n));
            }
            WebXml.appendElement(stringBuilder, INDENT4, "location", errorPage.getLocation());
            stringBuilder.append("  </error-page>\n");
        }
        stringBuilder.append('\n');
        if (this.taglibs.size() > 0 || this.jspPropertyGroups.size() > 0) {
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
                stringBuilder.append("  <jsp-config>\n");
            }
            for (Map.Entry entry : this.taglibs.entrySet()) {
                stringBuilder.append("    <taglib>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "taglib-uri", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT6, "taglib-location", (String)entry.getValue());
                stringBuilder.append("    </taglib>\n");
            }
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
                for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
                    stringBuilder.append("    <jsp-property-group>\n");
                    for (String string : jspPropertyGroup.getUrlPatterns()) {
                        WebXml.appendElement(stringBuilder, INDENT6, "url-pattern", string);
                    }
                    WebXml.appendElement(stringBuilder, INDENT6, "el-ignored", jspPropertyGroup.getElIgnored());
                    WebXml.appendElement(stringBuilder, INDENT6, "page-encoding", jspPropertyGroup.getPageEncoding());
                    WebXml.appendElement(stringBuilder, INDENT6, "scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                    WebXml.appendElement(stringBuilder, INDENT6, "is-xml", jspPropertyGroup.getIsXml());
                    for (String string : jspPropertyGroup.getIncludePreludes()) {
                        WebXml.appendElement(stringBuilder, INDENT6, "include-prelude", string);
                    }
                    for (String string : jspPropertyGroup.getIncludeCodas()) {
                        WebXml.appendElement(stringBuilder, INDENT6, "include-coda", string);
                    }
                    WebXml.appendElement(stringBuilder, INDENT6, "deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntax());
                    WebXml.appendElement(stringBuilder, INDENT6, "trim-directive-whitespaces", jspPropertyGroup.getTrimWhitespace());
                    WebXml.appendElement(stringBuilder, INDENT6, "default-content-type", jspPropertyGroup.getDefaultContentType());
                    WebXml.appendElement(stringBuilder, INDENT6, "buffer", jspPropertyGroup.getBuffer());
                    WebXml.appendElement(stringBuilder, INDENT6, "error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                    stringBuilder.append("    </jsp-property-group>\n");
                }
                stringBuilder.append("  </jsp-config>\n\n");
            }
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (ContextResourceEnvRef contextResourceEnvRef : this.resourceEnvRefs.values()) {
                stringBuilder.append("  <resource-env-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", contextResourceEnvRef.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "resource-env-ref-name", contextResourceEnvRef.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "resource-env-ref-type", contextResourceEnvRef.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextResourceEnvRef.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : contextResourceEnvRef.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextResourceEnvRef.getLookupName());
                stringBuilder.append("  </resource-env-ref>\n");
            }
            stringBuilder.append('\n');
        }
        for (ContextResource contextResource : this.resourceRefs.values()) {
            stringBuilder.append("  <resource-ref>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", contextResource.getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "res-ref-name", contextResource.getName());
            WebXml.appendElement(stringBuilder, INDENT4, "res-type", contextResource.getType());
            WebXml.appendElement(stringBuilder, INDENT4, "res-auth", contextResource.getAuth());
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
                WebXml.appendElement(stringBuilder, INDENT4, "res-sharing-scope", contextResource.getScope());
            }
            WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextResource.getProperty("mappedName"));
            for (InjectionTarget injectionTarget : contextResource.getInjectionTargets()) {
                stringBuilder.append("    <injection-target>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                stringBuilder.append("    </injection-target>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextResource.getLookupName());
            stringBuilder.append("  </resource-ref>\n");
        }
        stringBuilder.append('\n');
        for (SecurityConstraint securityConstraint : this.securityConstraints) {
            stringBuilder.append("  <security-constraint>\n");
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", securityConstraint.getDisplayName());
            }
            for (SecurityCollection securityCollection : securityConstraint.findCollections()) {
                stringBuilder.append("    <web-resource-collection>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "web-resource-name", securityCollection.getName());
                WebXml.appendElement(stringBuilder, INDENT6, "description", securityCollection.getDescription());
                for (String string : securityCollection.findPatterns()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "url-pattern", string);
                }
                for (String string : securityCollection.findMethods()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "http-method", string);
                }
                for (String string : securityCollection.findOmittedMethods()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "http-method-omission", string);
                }
                stringBuilder.append("    </web-resource-collection>\n");
            }
            if (securityConstraint.findAuthRoles().length > 0) {
                stringBuilder.append("    <auth-constraint>\n");
                for (String string : securityConstraint.findAuthRoles()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "role-name", string);
                }
                stringBuilder.append("    </auth-constraint>\n");
            }
            if (securityConstraint.getUserConstraint() != null) {
                stringBuilder.append("    <user-data-constraint>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "transport-guarantee", securityConstraint.getUserConstraint());
                stringBuilder.append("    </user-data-constraint>\n");
            }
            stringBuilder.append("  </security-constraint>\n");
        }
        stringBuilder.append('\n');
        if (this.loginConfig != null) {
            stringBuilder.append("  <login-config>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "auth-method", this.loginConfig.getAuthMethod());
            WebXml.appendElement(stringBuilder, INDENT4, "realm-name", this.loginConfig.getRealmName());
            if (this.loginConfig.getErrorPage() != null || this.loginConfig.getLoginPage() != null) {
                stringBuilder.append("    <form-login-config>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "form-login-page", this.loginConfig.getLoginPage());
                WebXml.appendElement(stringBuilder, INDENT6, "form-error-page", this.loginConfig.getErrorPage());
                stringBuilder.append("    </form-login-config>\n");
            }
            stringBuilder.append("  </login-config>\n\n");
        }
        for (String string : this.securityRoles) {
            stringBuilder.append("  <security-role>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "role-name", string);
            stringBuilder.append("  </security-role>\n");
        }
        for (ContextEnvironment contextEnvironment : this.envEntries.values()) {
            stringBuilder.append("  <env-entry>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", contextEnvironment.getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "env-entry-name", contextEnvironment.getName());
            WebXml.appendElement(stringBuilder, INDENT4, "env-entry-type", contextEnvironment.getType());
            WebXml.appendElement(stringBuilder, INDENT4, "env-entry-value", contextEnvironment.getValue());
            WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextEnvironment.getProperty("mappedName"));
            for (InjectionTarget injectionTarget : contextEnvironment.getInjectionTargets()) {
                stringBuilder.append("    <injection-target>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                stringBuilder.append("    </injection-target>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextEnvironment.getLookupName());
            stringBuilder.append("  </env-entry>\n");
        }
        stringBuilder.append('\n');
        for (ContextEjb contextEjb : this.ejbRefs.values()) {
            stringBuilder.append("  <ejb-ref>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", contextEjb.getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-name", contextEjb.getName());
            WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-type", contextEjb.getType());
            WebXml.appendElement(stringBuilder, INDENT4, "home", contextEjb.getHome());
            WebXml.appendElement(stringBuilder, INDENT4, "remote", contextEjb.getRemote());
            WebXml.appendElement(stringBuilder, INDENT4, "ejb-link", contextEjb.getLink());
            WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextEjb.getProperty("mappedName"));
            for (InjectionTarget injectionTarget : contextEjb.getInjectionTargets()) {
                stringBuilder.append("    <injection-target>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                stringBuilder.append("    </injection-target>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextEjb.getLookupName());
            stringBuilder.append("  </ejb-ref>\n");
        }
        stringBuilder.append('\n');
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (ContextLocalEjb contextLocalEjb : this.ejbLocalRefs.values()) {
                stringBuilder.append("  <ejb-local-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", contextLocalEjb.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-name", contextLocalEjb.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-type", contextLocalEjb.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "local-home", contextLocalEjb.getHome());
                WebXml.appendElement(stringBuilder, INDENT4, "local", contextLocalEjb.getLocal());
                WebXml.appendElement(stringBuilder, INDENT4, "ejb-link", contextLocalEjb.getLink());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextLocalEjb.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : contextLocalEjb.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextLocalEjb.getLookupName());
                stringBuilder.append("  </ejb-local-ref>\n");
            }
            stringBuilder.append('\n');
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
            for (ContextService contextService : this.serviceRefs.values()) {
                stringBuilder.append("  <service-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", contextService.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", contextService.getDisplayname());
                WebXml.appendElement(stringBuilder, INDENT4, "service-ref-name", contextService.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "service-interface", contextService.getInterface());
                WebXml.appendElement(stringBuilder, INDENT4, "service-ref-type", contextService.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "wsdl-file", contextService.getWsdlfile());
                WebXml.appendElement(stringBuilder, INDENT4, "jaxrpc-mapping-file", contextService.getJaxrpcmappingfile());
                object = contextService.getServiceqnameNamespaceURI();
                if (object != null) {
                    object = (String)object + ":";
                }
                object = (String)object + contextService.getServiceqnameLocalpart();
                WebXml.appendElement(stringBuilder, INDENT4, "service-qname", (String)object);
                Iterator<String> iterator = contextService.getServiceendpoints();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    stringBuilder.append("    <port-component-ref>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "service-endpoint-interface", string);
                    WebXml.appendElement(stringBuilder, INDENT6, "port-component-link", contextService.getProperty(string));
                    stringBuilder.append("    </port-component-ref>\n");
                }
                Iterator<String> iterator2 = contextService.getHandlers();
                while (iterator2.hasNext()) {
                    String string = iterator2.next();
                    stringBuilder.append("    <handler>\n");
                    ContextHandler contextHandler = contextService.getHandler(string);
                    WebXml.appendElement(stringBuilder, INDENT6, "handler-name", contextHandler.getName());
                    WebXml.appendElement(stringBuilder, INDENT6, "handler-class", contextHandler.getHandlerclass());
                    stringBuilder.append("    </handler>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextService.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : contextService.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextService.getLookupName());
                stringBuilder.append("  </service-ref>\n");
            }
            stringBuilder.append('\n');
        }
        if (!this.postConstructMethods.isEmpty()) {
            for (Map.Entry entry : this.postConstructMethods.entrySet()) {
                stringBuilder.append("  <post-construct>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-class", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-method", (String)entry.getValue());
                stringBuilder.append("  </post-construct>\n");
            }
            stringBuilder.append('\n');
        }
        if (!this.preDestroyMethods.isEmpty()) {
            for (Map.Entry entry : this.preDestroyMethods.entrySet()) {
                stringBuilder.append("  <pre-destroy>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-class", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-method", (String)entry.getValue());
                stringBuilder.append("  </pre-destroy>\n");
            }
            stringBuilder.append('\n');
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
            for (MessageDestinationRef messageDestinationRef : this.messageDestinationRefs.values()) {
                stringBuilder.append("  <message-destination-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", messageDestinationRef.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-ref-name", messageDestinationRef.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-type", messageDestinationRef.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-usage", messageDestinationRef.getUsage());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-link", messageDestinationRef.getLink());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", messageDestinationRef.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : messageDestinationRef.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", messageDestinationRef.getLookupName());
                stringBuilder.append("  </message-destination-ref>\n");
            }
            stringBuilder.append('\n');
            for (MessageDestination messageDestination : this.messageDestinations.values()) {
                stringBuilder.append("  <message-destination>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", messageDestination.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", messageDestination.getDisplayName());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-name", messageDestination.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", messageDestination.getProperty("mappedName"));
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", messageDestination.getLookupName());
                stringBuilder.append("  </message-destination>\n");
            }
            stringBuilder.append('\n');
        }
        if ((this.getMajorVersion() > 2 || this.getMinorVersion() > 3) && this.localeEncodingMappings.size() > 0) {
            stringBuilder.append("  <locale-encoding-mapping-list>\n");
            for (Map.Entry entry : this.localeEncodingMappings.entrySet()) {
                stringBuilder.append("    <locale-encoding-mapping>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "locale", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT6, "encoding", (String)entry.getValue());
                stringBuilder.append("    </locale-encoding-mapping>\n");
            }
            stringBuilder.append("  </locale-encoding-mapping-list>\n");
        }
        stringBuilder.append("</web-app>");
        return stringBuilder.toString();
    }

    private static void appendElement(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        if (string3.length() == 0) {
            stringBuilder.append(string);
            stringBuilder.append('<');
            stringBuilder.append(string2);
            stringBuilder.append("/>\n");
        } else {
            stringBuilder.append(string);
            stringBuilder.append('<');
            stringBuilder.append(string2);
            stringBuilder.append('>');
            stringBuilder.append(WebXml.escapeXml(string3));
            stringBuilder.append("</");
            stringBuilder.append(string2);
            stringBuilder.append(">\n");
        }
    }

    private static void appendElement(StringBuilder stringBuilder, String string, String string2, Object object) {
        if (object == null) {
            return;
        }
        WebXml.appendElement(stringBuilder, string, string2, object.toString());
    }

    private static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void configureContext(Context context) {
        Object object;
        context.setPublicId(this.publicId);
        context.setEffectiveMajorVersion(this.getMajorVersion());
        context.setEffectiveMinorVersion(this.getMinorVersion());
        for (Map.Entry<String, String> object2 : this.contextParams.entrySet()) {
            context.addParameter(object2.getKey(), object2.getValue());
        }
        context.setDisplayName(this.displayName);
        context.setDistributable(this.distributable);
        for (ContextLocalEjb contextLocalEjb : this.ejbLocalRefs.values()) {
            context.getNamingResources().addLocalEjb(contextLocalEjb);
        }
        for (ContextEjb contextEjb : this.ejbRefs.values()) {
            context.getNamingResources().addEjb(contextEjb);
        }
        for (ContextEnvironment contextEnvironment : this.envEntries.values()) {
            context.getNamingResources().addEnvironment(contextEnvironment);
        }
        for (ErrorPage errorPage : this.errorPages.values()) {
            context.addErrorPage(errorPage);
        }
        for (FilterDef filterDef : this.filters.values()) {
            if (filterDef.getAsyncSupported() == null) {
                filterDef.setAsyncSupported("false");
            }
            context.addFilterDef(filterDef);
        }
        for (FilterMap filterMap : this.filterMaps) {
            context.addFilterMap(filterMap);
        }
        for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
            object = new ApplicationJspPropertyGroupDescriptor(jspPropertyGroup);
            context.getJspConfigDescriptor().getJspPropertyGroups().add(object);
        }
        for (String string : this.listeners) {
            context.addApplicationListener(string);
        }
        for (Map.Entry entry : this.localeEncodingMappings.entrySet()) {
            context.addLocaleEncodingMappingParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.loginConfig != null) {
            context.setLoginConfig(this.loginConfig);
        }
        for (MessageDestinationRef messageDestinationRef : this.messageDestinationRefs.values()) {
            context.getNamingResources().addMessageDestinationRef(messageDestinationRef);
        }
        context.setIgnoreAnnotations(this.metadataComplete);
        for (Map.Entry entry : this.mimeMappings.entrySet()) {
            context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
        }
        for (ContextResourceEnvRef contextResourceEnvRef : this.resourceEnvRefs.values()) {
            context.getNamingResources().addResourceEnvRef(contextResourceEnvRef);
        }
        for (ContextResource contextResource : this.resourceRefs.values()) {
            context.getNamingResources().addResource(contextResource);
        }
        for (SecurityConstraint securityConstraint : this.securityConstraints) {
            context.addConstraint(securityConstraint);
        }
        for (String string : this.securityRoles) {
            context.addSecurityRole(string);
        }
        for (ContextService contextService : this.serviceRefs.values()) {
            context.getNamingResources().addService(contextService);
        }
        for (ServletDef servletDef : this.servlets.values()) {
            object = context.createWrapper();
            if (servletDef.getLoadOnStartup() != null) {
                object.setLoadOnStartup(servletDef.getLoadOnStartup());
            }
            if (servletDef.getEnabled() != null) {
                object.setEnabled(servletDef.getEnabled());
            }
            object.setName(servletDef.getServletName());
            Iterator<String> iterator = servletDef.getParameterMap();
            for (Map.Entry<String, String> entry : iterator.entrySet()) {
                object.addInitParameter(entry.getKey(), entry.getValue());
            }
            object.setRunAs(servletDef.getRunAs());
            Set<SecurityRoleRef> set = servletDef.getSecurityRoleRefs();
            for (SecurityRoleRef securityRoleRef : set) {
                object.addSecurityReference(securityRoleRef.getName(), securityRoleRef.getLink());
            }
            object.setServletClass(servletDef.getServletClass());
            MultipartDef multipartDef = servletDef.getMultipartDef();
            if (multipartDef != null) {
                if (multipartDef.getMaxFileSize() != null && multipartDef.getMaxRequestSize() != null && multipartDef.getFileSizeThreshold() != null) {
                    object.setMultipartConfigElement(new MultipartConfigElement(multipartDef.getLocation(), Long.parseLong(multipartDef.getMaxFileSize()), Long.parseLong(multipartDef.getMaxRequestSize()), Integer.parseInt(multipartDef.getFileSizeThreshold())));
                } else {
                    object.setMultipartConfigElement(new MultipartConfigElement(multipartDef.getLocation()));
                }
            }
            if (servletDef.getAsyncSupported() != null) {
                object.setAsyncSupported(servletDef.getAsyncSupported());
            }
            object.setOverridable(servletDef.isOverridable());
            context.addChild((Container)object);
        }
        for (Map.Entry entry : this.servletMappings.entrySet()) {
            context.addServletMapping((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.sessionConfig != null) {
            if (this.sessionConfig.getSessionTimeout() != null) {
                context.setSessionTimeout(this.sessionConfig.getSessionTimeout());
            }
            Iterator<Object> iterator = context.getServletContext().getSessionCookieConfig();
            iterator.setName(this.sessionConfig.getCookieName());
            iterator.setDomain(this.sessionConfig.getCookieDomain());
            iterator.setPath(this.sessionConfig.getCookiePath());
            iterator.setComment(this.sessionConfig.getCookieComment());
            if (this.sessionConfig.getCookieHttpOnly() != null) {
                iterator.setHttpOnly(this.sessionConfig.getCookieHttpOnly());
            }
            if (this.sessionConfig.getCookieSecure() != null) {
                iterator.setSecure(this.sessionConfig.getCookieSecure());
            }
            if (this.sessionConfig.getCookieMaxAge() != null) {
                iterator.setMaxAge(this.sessionConfig.getCookieMaxAge());
            }
            if (this.sessionConfig.getSessionTrackingModes().size() > 0) {
                context.getServletContext().setSessionTrackingModes(this.sessionConfig.getSessionTrackingModes());
            }
        }
        for (Map.Entry entry : this.taglibs.entrySet()) {
            object = new ApplicationTaglibDescriptor((String)entry.getValue(), (String)entry.getKey());
            context.getJspConfigDescriptor().getTaglibs().add(object);
        }
        for (String string : this.welcomeFiles) {
            if (string == null || string.length() <= 0) continue;
            context.addWelcomeFile(string);
        }
        for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
            object = context.findServletMapping("*.jsp");
            if (object == null) {
                object = "jsp";
            }
            if (context.findChild((String)object) != null) {
                for (String string : jspPropertyGroup.getUrlPatterns()) {
                    context.addServletMapping(string, (String)object, true);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            for (String string : jspPropertyGroup.getUrlPatterns()) {
                log.debug((Object)("Skiping " + string + " , no servlet " + (String)object));
            }
        }
        for (Map.Entry entry : this.postConstructMethods.entrySet()) {
            context.addPostConstructMethod((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : this.preDestroyMethods.entrySet()) {
            context.addPreDestroyMethod((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean merge(Set<WebXml> set) {
        WebXml webXml = new WebXml();
        for (WebXml object22 : set) {
            if (WebXml.mergeMap(object22.getContextParams(), this.contextParams, webXml.getContextParams(), object22, "Context Parameter")) continue;
            return false;
        }
        this.contextParams.putAll(webXml.getContextParams());
        if (this.displayName == null) {
            for (WebXml webXml2 : set) {
                String string = webXml2.getDisplayName();
                if (string == null) continue;
                if (webXml.getDisplayName() == null) {
                    webXml.setDisplayName(string);
                    continue;
                }
                log.error((Object)sm.getString("webXml.mergeConflictDisplayName", new Object[]{webXml2.getName(), webXml2.getURL()}));
                return false;
            }
            this.displayName = webXml.getDisplayName();
        }
        if (this.distributable) {
            for (WebXml webXml3 : set) {
                if (webXml3.isDistributable()) continue;
                this.distributable = false;
                break;
            }
        }
        for (WebXml webXml4 : set) {
            if (WebXml.mergeResourceMap(webXml4.getEjbLocalRefs(), this.ejbLocalRefs, webXml.getEjbLocalRefs(), webXml4)) continue;
            return false;
        }
        this.ejbLocalRefs.putAll(webXml.getEjbLocalRefs());
        for (WebXml webXml5 : set) {
            if (WebXml.mergeResourceMap(webXml5.getEjbRefs(), this.ejbRefs, webXml.getEjbRefs(), webXml5)) continue;
            return false;
        }
        this.ejbRefs.putAll(webXml.getEjbRefs());
        for (WebXml webXml6 : set) {
            if (WebXml.mergeResourceMap(webXml6.getEnvEntries(), this.envEntries, webXml.getEnvEntries(), webXml6)) continue;
            return false;
        }
        this.envEntries.putAll(webXml.getEnvEntries());
        for (WebXml webXml7 : set) {
            if (WebXml.mergeMap(webXml7.getErrorPages(), this.errorPages, webXml.getErrorPages(), webXml7, "Error Page")) continue;
            return false;
        }
        this.errorPages.putAll(webXml.getErrorPages());
        ArrayList arrayList = new ArrayList();
        for (WebXml webXml8 : set) {
            for (FilterMap filterMap : webXml8.getFilterMappings()) {
                if (this.filterMappingNames.contains(filterMap.getFilterName())) continue;
                arrayList.add(filterMap);
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FilterMap filterMap = (FilterMap)iterator.next();
            this.addFilterMapping(filterMap);
        }
        for (WebXml webXml9 : set) {
            for (Map.Entry<String, FilterDef> entry : webXml9.getFilters().entrySet()) {
                if (this.filters.containsKey(entry.getKey())) {
                    WebXml.mergeFilter(entry.getValue(), this.filters.get(entry.getKey()), false);
                    continue;
                }
                if (webXml.getFilters().containsKey(entry.getKey())) {
                    if (WebXml.mergeFilter(entry.getValue(), webXml.getFilters().get(entry.getKey()), true)) continue;
                    log.error((Object)sm.getString("webXml.mergeConflictFilter", new Object[]{entry.getKey(), webXml9.getName(), webXml9.getURL()}));
                    return false;
                }
                webXml.getFilters().put(entry.getKey(), entry.getValue());
            }
        }
        this.filters.putAll(webXml.getFilters());
        for (WebXml webXml10 : set) {
            for (JspPropertyGroup jspPropertyGroup : webXml10.getJspPropertyGroups()) {
                this.addJspPropertyGroup(jspPropertyGroup);
            }
        }
        for (WebXml webXml11 : set) {
            for (String string : webXml11.getListeners()) {
                this.addListener(string);
            }
        }
        for (WebXml webXml12 : set) {
            if (WebXml.mergeMap(webXml12.getLocalEncodingMappings(), this.localeEncodingMappings, webXml.getLocalEncodingMappings(), webXml12, "Locale Encoding Mapping")) continue;
            return false;
        }
        this.localeEncodingMappings.putAll(webXml.getLocalEncodingMappings());
        if (this.getLoginConfig() == null) {
            void var4_24;
            Object var4_23 = null;
            for (WebXml webXml13 : set) {
                LoginConfig loginConfig = webXml13.loginConfig;
                if (loginConfig == null) continue;
                if (var4_24 == null || loginConfig.equals(var4_24)) {
                    LoginConfig loginConfig2 = loginConfig;
                    continue;
                }
                log.error((Object)sm.getString("webXml.mergeConflictLoginConfig", new Object[]{webXml13.getName(), webXml13.getURL()}));
            }
            this.loginConfig = var4_24;
        }
        for (WebXml webXml14 : set) {
            if (WebXml.mergeResourceMap(webXml14.getMessageDestinationRefs(), this.messageDestinationRefs, webXml.getMessageDestinationRefs(), webXml14)) continue;
            return false;
        }
        this.messageDestinationRefs.putAll(webXml.getMessageDestinationRefs());
        for (WebXml webXml15 : set) {
            if (WebXml.mergeResourceMap(webXml15.getMessageDestinations(), this.messageDestinations, webXml.getMessageDestinations(), webXml15)) continue;
            return false;
        }
        this.messageDestinations.putAll(webXml.getMessageDestinations());
        for (WebXml webXml16 : set) {
            if (WebXml.mergeMap(webXml16.getMimeMappings(), this.mimeMappings, webXml.getMimeMappings(), webXml16, "Mime Mapping")) continue;
            return false;
        }
        this.mimeMappings.putAll(webXml.getMimeMappings());
        for (WebXml webXml17 : set) {
            if (WebXml.mergeResourceMap(webXml17.getResourceEnvRefs(), this.resourceEnvRefs, webXml.getResourceEnvRefs(), webXml17)) continue;
            return false;
        }
        this.resourceEnvRefs.putAll(webXml.getResourceEnvRefs());
        for (WebXml webXml18 : set) {
            if (WebXml.mergeResourceMap(webXml18.getResourceRefs(), this.resourceRefs, webXml.getResourceRefs(), webXml18)) continue;
            return false;
        }
        this.resourceRefs.putAll(webXml.getResourceRefs());
        for (WebXml webXml19 : set) {
            for (SecurityConstraint securityConstraint : webXml19.getSecurityConstraints()) {
                this.addSecurityConstraint(securityConstraint);
            }
        }
        for (WebXml webXml20 : set) {
            for (String string : webXml20.getSecurityRoles()) {
                this.addSecurityRole(string);
            }
        }
        for (WebXml webXml21 : set) {
            if (WebXml.mergeResourceMap(webXml21.getServiceRefs(), this.serviceRefs, webXml.getServiceRefs(), webXml21)) continue;
            return false;
        }
        this.serviceRefs.putAll(webXml.getServiceRefs());
        ArrayList<Map.Entry<String, String>> arrayList2 = new ArrayList<Map.Entry<String, String>>();
        for (WebXml webXml22 : set) {
            for (Map.Entry<String, String> entry : webXml22.getServletMappings().entrySet()) {
                if (this.servletMappingNames.contains(entry.getValue()) || this.servletMappings.containsKey(entry.getKey())) continue;
                arrayList2.add(entry);
            }
        }
        for (Map.Entry entry : arrayList2) {
            this.addServletMapping((String)entry.getKey(), (String)entry.getValue());
        }
        for (WebXml webXml23 : set) {
            for (Map.Entry<String, ServletDef> entry : webXml23.getServlets().entrySet()) {
                if (this.servlets.containsKey(entry.getKey())) {
                    WebXml.mergeServlet(entry.getValue(), this.servlets.get(entry.getKey()), false);
                    continue;
                }
                if (webXml.getServlets().containsKey(entry.getKey())) {
                    if (WebXml.mergeServlet(entry.getValue(), webXml.getServlets().get(entry.getKey()), true)) continue;
                    log.error((Object)sm.getString("webXml.mergeConflictServlet", new Object[]{entry.getKey(), webXml23.getName(), webXml23.getURL()}));
                    return false;
                }
                webXml.getServlets().put(entry.getKey(), entry.getValue());
            }
        }
        this.servlets.putAll(webXml.getServlets());
        if (this.sessionConfig.getSessionTimeout() == null) {
            for (WebXml webXml24 : set) {
                Integer n = webXml24.getSessionConfig().getSessionTimeout();
                if (n == null) continue;
                if (webXml.getSessionConfig().getSessionTimeout() == null) {
                    webXml.getSessionConfig().setSessionTimeout(n.toString());
                    continue;
                }
                if (n.equals(webXml.getSessionConfig().getSessionTimeout())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionTimeout", new Object[]{webXml24.getName(), webXml24.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getSessionTimeout() != null) {
                this.sessionConfig.setSessionTimeout(webXml.getSessionConfig().getSessionTimeout().toString());
            }
        }
        if (this.sessionConfig.getCookieName() == null) {
            for (WebXml webXml25 : set) {
                String string = webXml25.getSessionConfig().getCookieName();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookieName() == null) {
                    webXml.getSessionConfig().setCookieName(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookieName())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookieName", new Object[]{webXml25.getName(), webXml25.getURL()}));
                return false;
            }
            this.sessionConfig.setCookieName(webXml.getSessionConfig().getCookieName());
        }
        if (this.sessionConfig.getCookieDomain() == null) {
            for (WebXml webXml26 : set) {
                String string = webXml26.getSessionConfig().getCookieDomain();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookieDomain() == null) {
                    webXml.getSessionConfig().setCookieDomain(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookieDomain())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookieDomain", new Object[]{webXml26.getName(), webXml26.getURL()}));
                return false;
            }
            this.sessionConfig.setCookieDomain(webXml.getSessionConfig().getCookieDomain());
        }
        if (this.sessionConfig.getCookiePath() == null) {
            for (WebXml webXml27 : set) {
                String string = webXml27.getSessionConfig().getCookiePath();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookiePath() == null) {
                    webXml.getSessionConfig().setCookiePath(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookiePath())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookiePath", new Object[]{webXml27.getName(), webXml27.getURL()}));
                return false;
            }
            this.sessionConfig.setCookiePath(webXml.getSessionConfig().getCookiePath());
        }
        if (this.sessionConfig.getCookieComment() == null) {
            for (WebXml webXml28 : set) {
                String string = webXml28.getSessionConfig().getCookieComment();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookieComment() == null) {
                    webXml.getSessionConfig().setCookieComment(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookieComment())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookieComment", new Object[]{webXml28.getName(), webXml28.getURL()}));
                return false;
            }
            this.sessionConfig.setCookieComment(webXml.getSessionConfig().getCookieComment());
        }
        if (this.sessionConfig.getCookieHttpOnly() == null) {
            for (WebXml webXml29 : set) {
                Boolean bl = webXml29.getSessionConfig().getCookieHttpOnly();
                if (bl == null) continue;
                if (webXml.getSessionConfig().getCookieHttpOnly() == null) {
                    webXml.getSessionConfig().setCookieHttpOnly(bl.toString());
                    continue;
                }
                if (bl.equals(webXml.getSessionConfig().getCookieHttpOnly())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookieHttpOnly", new Object[]{webXml29.getName(), webXml29.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getCookieHttpOnly() != null) {
                this.sessionConfig.setCookieHttpOnly(webXml.getSessionConfig().getCookieHttpOnly().toString());
            }
        }
        if (this.sessionConfig.getCookieSecure() == null) {
            for (WebXml webXml30 : set) {
                Boolean bl = webXml30.getSessionConfig().getCookieSecure();
                if (bl == null) continue;
                if (webXml.getSessionConfig().getCookieSecure() == null) {
                    webXml.getSessionConfig().setCookieSecure(bl.toString());
                    continue;
                }
                if (bl.equals(webXml.getSessionConfig().getCookieSecure())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookieSecure", new Object[]{webXml30.getName(), webXml30.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getCookieSecure() != null) {
                this.sessionConfig.setCookieSecure(webXml.getSessionConfig().getCookieSecure().toString());
            }
        }
        if (this.sessionConfig.getCookieMaxAge() == null) {
            for (WebXml webXml31 : set) {
                Integer n = webXml31.getSessionConfig().getCookieMaxAge();
                if (n == null) continue;
                if (webXml.getSessionConfig().getCookieMaxAge() == null) {
                    webXml.getSessionConfig().setCookieMaxAge(n.toString());
                    continue;
                }
                if (n.equals(webXml.getSessionConfig().getCookieMaxAge())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionCookieMaxAge", new Object[]{webXml31.getName(), webXml31.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getCookieMaxAge() != null) {
                this.sessionConfig.setCookieMaxAge(webXml.getSessionConfig().getCookieMaxAge().toString());
            }
        }
        if (this.sessionConfig.getSessionTrackingModes().size() == 0) {
            for (WebXml webXml32 : set) {
                EnumSet<SessionTrackingMode> enumSet = webXml32.getSessionConfig().getSessionTrackingModes();
                if (enumSet.size() <= 0) continue;
                if (webXml.getSessionConfig().getSessionTrackingModes().size() == 0) {
                    webXml.getSessionConfig().getSessionTrackingModes().addAll(enumSet);
                    continue;
                }
                if (enumSet.equals(webXml.getSessionConfig().getSessionTrackingModes())) continue;
                log.error((Object)sm.getString("webXml.mergeConflictSessionTrackingMode", new Object[]{webXml32.getName(), webXml32.getURL()}));
                return false;
            }
            this.sessionConfig.getSessionTrackingModes().addAll(webXml.getSessionConfig().getSessionTrackingModes());
        }
        for (WebXml webXml33 : set) {
            if (WebXml.mergeMap(webXml33.getTaglibs(), this.taglibs, webXml.getTaglibs(), webXml33, "Taglibs")) continue;
            return false;
        }
        this.taglibs.putAll(webXml.getTaglibs());
        for (WebXml webXml34 : set) {
            if (!webXml34.alwaysAddWelcomeFiles && this.welcomeFiles.size() != 0) continue;
            for (String string : webXml34.getWelcomeFiles()) {
                this.addWelcomeFile(string);
            }
        }
        if (this.postConstructMethods.isEmpty()) {
            for (WebXml webXml35 : set) {
                if (WebXml.mergeLifecycleCallback(webXml35.getPostConstructMethods(), webXml.getPostConstructMethods(), webXml35, "Post Construct Methods")) continue;
                return false;
            }
            this.postConstructMethods.putAll(webXml.getPostConstructMethods());
        }
        if (this.preDestroyMethods.isEmpty()) {
            for (WebXml webXml36 : set) {
                if (WebXml.mergeLifecycleCallback(webXml36.getPreDestroyMethods(), webXml.getPreDestroyMethods(), webXml36, "Pre Destroy Methods")) continue;
                return false;
            }
            this.preDestroyMethods.putAll(webXml.getPreDestroyMethods());
        }
        return true;
    }

    private static <T extends ResourceBase> boolean mergeResourceMap(Map<String, T> map, Map<String, T> map2, Map<String, T> map3, WebXml webXml) {
        for (ResourceBase resourceBase : map.values()) {
            String string = resourceBase.getName();
            if (map2.containsKey(string)) {
                ((ResourceBase)map2.get(string)).getInjectionTargets().addAll(resourceBase.getInjectionTargets());
                continue;
            }
            ResourceBase resourceBase2 = (ResourceBase)map3.get(string);
            if (resourceBase2 != null) {
                if (resourceBase2.equals(resourceBase)) continue;
                log.error((Object)sm.getString("webXml.mergeConflictResource", new Object[]{string, webXml.getName(), webXml.getURL()}));
                return false;
            }
            map3.put(string, resourceBase);
        }
        return true;
    }

    private static <T> boolean mergeMap(Map<String, T> map, Map<String, T> map2, Map<String, T> map3, WebXml webXml, String string) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (map2.containsKey(string2)) continue;
            T t = entry.getValue();
            if (map3.containsKey(string2)) {
                if (t == null || t.equals(map3.get(string2))) continue;
                log.error((Object)sm.getString("webXml.mergeConflictString", new Object[]{string, string2, webXml.getName(), webXml.getURL()}));
                return false;
            }
            map3.put(string2, t);
        }
        return true;
    }

    private static boolean mergeFilter(FilterDef filterDef, FilterDef filterDef2, boolean bl) {
        if (filterDef2.getAsyncSupported() == null) {
            filterDef2.setAsyncSupported(filterDef.getAsyncSupported());
        } else if (filterDef.getAsyncSupported() != null && bl && !filterDef.getAsyncSupported().equals(filterDef2.getAsyncSupported())) {
            return false;
        }
        if (filterDef2.getFilterClass() == null) {
            filterDef2.setFilterClass(filterDef.getFilterClass());
        } else if (filterDef.getFilterClass() != null && bl && !filterDef.getFilterClass().equals(filterDef2.getFilterClass())) {
            return false;
        }
        for (Map.Entry<String, String> entry : filterDef.getParameterMap().entrySet()) {
            if (filterDef2.getParameterMap().containsKey(entry.getKey())) {
                if (!bl || filterDef2.getParameterMap().get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
            filterDef2.addInitParameter(entry.getKey(), entry.getValue());
        }
        return true;
    }

    private static boolean mergeServlet(ServletDef servletDef, ServletDef servletDef2, boolean bl) {
        if (servletDef2.getServletClass() != null && servletDef2.getJspFile() != null) {
            return false;
        }
        if (servletDef.getServletClass() != null && servletDef.getJspFile() != null) {
            return false;
        }
        if (servletDef2.getServletClass() == null && servletDef2.getJspFile() == null) {
            servletDef2.setServletClass(servletDef.getServletClass());
            servletDef2.setJspFile(servletDef.getJspFile());
        } else if (bl) {
            if (!(servletDef.getServletClass() == null || servletDef2.getJspFile() == null && servletDef.getServletClass().equals(servletDef2.getServletClass()))) {
                return false;
            }
            if (!(servletDef.getJspFile() == null || servletDef2.getServletClass() == null && servletDef.getJspFile().equals(servletDef2.getJspFile()))) {
                return false;
            }
        }
        for (SecurityRoleRef object : servletDef.getSecurityRoleRefs()) {
            servletDef2.addSecurityRoleRef(object);
        }
        if (servletDef2.getLoadOnStartup() == null) {
            if (servletDef.getLoadOnStartup() != null) {
                servletDef2.setLoadOnStartup(servletDef.getLoadOnStartup().toString());
            }
        } else if (servletDef.getLoadOnStartup() != null && bl && !servletDef.getLoadOnStartup().equals(servletDef2.getLoadOnStartup())) {
            return false;
        }
        if (servletDef2.getEnabled() == null) {
            if (servletDef.getEnabled() != null) {
                servletDef2.setEnabled(servletDef.getEnabled().toString());
            }
        } else if (servletDef.getEnabled() != null && bl && !servletDef.getEnabled().equals(servletDef2.getEnabled())) {
            return false;
        }
        for (Map.Entry entry : servletDef.getParameterMap().entrySet()) {
            if (servletDef2.getParameterMap().containsKey(entry.getKey())) {
                if (!bl || servletDef2.getParameterMap().get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
            servletDef2.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (servletDef2.getMultipartDef() == null) {
            servletDef2.setMultipartDef(servletDef.getMultipartDef());
        } else if (servletDef.getMultipartDef() != null) {
            return WebXml.mergeMultipartDef(servletDef.getMultipartDef(), servletDef2.getMultipartDef(), bl);
        }
        if (servletDef2.getAsyncSupported() == null) {
            if (servletDef.getAsyncSupported() != null) {
                servletDef2.setAsyncSupported(servletDef.getAsyncSupported().toString());
            }
        } else if (servletDef.getAsyncSupported() != null && bl && !servletDef.getAsyncSupported().equals(servletDef2.getAsyncSupported())) {
            return false;
        }
        return true;
    }

    private static boolean mergeMultipartDef(MultipartDef multipartDef, MultipartDef multipartDef2, boolean bl) {
        if (multipartDef2.getLocation() == null) {
            multipartDef2.setLocation(multipartDef.getLocation());
        } else if (multipartDef.getLocation() != null && bl && !multipartDef.getLocation().equals(multipartDef2.getLocation())) {
            return false;
        }
        if (multipartDef2.getFileSizeThreshold() == null) {
            multipartDef2.setFileSizeThreshold(multipartDef.getFileSizeThreshold());
        } else if (multipartDef.getFileSizeThreshold() != null && bl && !multipartDef.getFileSizeThreshold().equals(multipartDef2.getFileSizeThreshold())) {
            return false;
        }
        if (multipartDef2.getMaxFileSize() == null) {
            multipartDef2.setMaxFileSize(multipartDef.getMaxFileSize());
        } else if (multipartDef.getMaxFileSize() != null && bl && !multipartDef.getMaxFileSize().equals(multipartDef2.getMaxFileSize())) {
            return false;
        }
        if (multipartDef2.getMaxRequestSize() == null) {
            multipartDef2.setMaxRequestSize(multipartDef.getMaxRequestSize());
        } else if (multipartDef.getMaxRequestSize() != null && bl && !multipartDef.getMaxRequestSize().equals(multipartDef2.getMaxRequestSize())) {
            return false;
        }
        return true;
    }

    private static boolean mergeLifecycleCallback(Map<String, String> map, Map<String, String> map2, WebXml webXml, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (map2.containsKey(string2)) {
                if (string3 == null || string3.equals(map2.get(string2))) continue;
                log.error((Object)sm.getString("webXml.mergeConflictString", new Object[]{string, string2, webXml.getName(), webXml.getURL()}));
                return false;
            }
            map2.put(string2, string3);
        }
        return true;
    }

    public static Set<WebXml> orderWebFragments(WebXml webXml, Map<String, WebXml> map, ServletContext servletContext) {
        Object object;
        WebXml webXml2;
        HashSet<WebXml> hashSet;
        LinkedHashSet<WebXml> linkedHashSet = new LinkedHashSet<WebXml>();
        boolean bl = webXml.getAbsoluteOrdering() != null;
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
            hashSet = webXml.getAbsoluteOrdering();
            for (String string : hashSet) {
                if (ORDER_OTHERS.equals(string)) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (hashSet.contains(entry.getKey()) || (webXml2 = (WebXml)entry.getValue()) == null) continue;
                        linkedHashSet.add(webXml2);
                    }
                    continue;
                }
                object = map.get(string);
                if (object != null) {
                    linkedHashSet.add((WebXml)object);
                    continue;
                }
                log.warn((Object)sm.getString("webXml.wrongFragmentName", new Object[]{string}));
            }
        } else {
            for (WebXml webXml3 : map.values()) {
                if (!webXml3.isDuplicated()) continue;
                throw new IllegalArgumentException(sm.getString("webXml.duplicateFragment", new Object[]{webXml3.getName()}));
            }
            for (WebXml webXml4 : map.values()) {
                Iterator<String> iterator = webXml4.getBeforeOrdering().iterator();
                while (iterator.hasNext()) {
                    bl2 = true;
                    object = iterator.next();
                    if (((String)object).equals(ORDER_OTHERS)) continue;
                    WebXml webXml5 = map.get(object);
                    if (webXml5 == null) {
                        iterator.remove();
                        continue;
                    }
                    webXml5.addAfterOrdering(webXml4.getName());
                }
                object = webXml4.getAfterOrdering().iterator();
                while (object.hasNext()) {
                    bl2 = true;
                    String string = (String)object.next();
                    if (string.equals(ORDER_OTHERS)) continue;
                    webXml2 = map.get(string);
                    if (webXml2 == null) {
                        object.remove();
                        continue;
                    }
                    webXml2.addBeforeOrdering(webXml4.getName());
                }
            }
            for (WebXml webXml6 : map.values()) {
                if (webXml6.getBeforeOrdering().contains(ORDER_OTHERS)) {
                    WebXml.makeBeforeOthersExplicit(webXml6.getAfterOrdering(), map);
                }
                if (!webXml6.getAfterOrdering().contains(ORDER_OTHERS)) continue;
                WebXml.makeAfterOthersExplicit(webXml6.getBeforeOrdering(), map);
            }
            hashSet = new HashSet<WebXml>();
            HashSet<WebXml> hashSet2 = new HashSet<WebXml>();
            HashSet<WebXml> hashSet3 = new HashSet<WebXml>();
            for (WebXml webXml7 : map.values()) {
                if (webXml7.getBeforeOrdering().contains(ORDER_OTHERS)) {
                    hashSet.add(webXml7);
                    webXml7.getBeforeOrdering().remove(ORDER_OTHERS);
                    continue;
                }
                if (webXml7.getAfterOrdering().contains(ORDER_OTHERS)) {
                    hashSet3.add(webXml7);
                    webXml7.getAfterOrdering().remove(ORDER_OTHERS);
                    continue;
                }
                hashSet2.add(webXml7);
            }
            WebXml.decoupleOtherGroups(hashSet);
            WebXml.decoupleOtherGroups(hashSet2);
            WebXml.decoupleOtherGroups(hashSet3);
            WebXml.orderFragments(linkedHashSet, hashSet);
            WebXml.orderFragments(linkedHashSet, hashSet2);
            WebXml.orderFragments(linkedHashSet, hashSet3);
        }
        if (servletContext != null) {
            hashSet = null;
            if (bl2) {
                hashSet = new ArrayList();
                for (WebXml webXml8 : linkedHashSet) {
                    hashSet.add((WebXml)((Object)webXml8.getJarName()));
                }
            }
            servletContext.setAttribute("javax.servlet.context.orderedLibs", hashSet);
        }
        return linkedHashSet;
    }

    private static void decoupleOtherGroups(Set<WebXml> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (WebXml webXml : set) {
            hashSet.add(webXml.getName());
        }
        for (WebXml webXml : set) {
            Iterator<String> iterator = webXml.getAfterOrdering().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (hashSet.contains(string)) continue;
                iterator.remove();
            }
        }
    }

    private static void orderFragments(Set<WebXml> set, Set<WebXml> set2) {
        HashSet<WebXml> hashSet = new HashSet<WebXml>();
        HashSet<WebXml> hashSet2 = new HashSet<WebXml>();
        while (set2.size() > 0) {
            Iterator<WebXml> iterator = set2.iterator();
            while (iterator.hasNext()) {
                WebXml webXml = iterator.next();
                for (WebXml webXml2 : hashSet2) {
                    webXml.getAfterOrdering().remove(webXml2.getName());
                }
                if (!webXml.getAfterOrdering().isEmpty()) continue;
                hashSet.add(webXml);
                set.add(webXml);
                iterator.remove();
            }
            if (hashSet.size() == 0) {
                throw new IllegalArgumentException(sm.getString("webXml.mergeConflictOrder"));
            }
            hashSet2.clear();
            hashSet2.addAll(hashSet);
            hashSet.clear();
        }
    }

    private static void makeBeforeOthersExplicit(Set<String> set, Map<String, WebXml> map) {
        for (String string : set) {
            WebXml webXml;
            if (string.equals(ORDER_OTHERS) || (webXml = map.get(string)).getBeforeOrdering().contains(ORDER_OTHERS)) continue;
            webXml.addBeforeOrderingOthers();
            WebXml.makeBeforeOthersExplicit(webXml.getAfterOrdering(), map);
        }
    }

    private static void makeAfterOthersExplicit(Set<String> set, Map<String, WebXml> map) {
        for (String string : set) {
            WebXml webXml;
            if (string.equals(ORDER_OTHERS) || (webXml = map.get(string)).getAfterOrdering().contains(ORDER_OTHERS)) continue;
            webXml.addAfterOrderingOthers();
            WebXml.makeAfterOthersExplicit(webXml.getBeforeOrdering(), map);
        }
    }
}

