/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.linkerissues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.descriptors.konan.DeserializedKlibModuleOrigin;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOrigin;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.utils.ResolvedDependencies;
import org.jetbrains.kotlin.utils.ResolvedDependenciesSupport;
import org.jetbrains.kotlin.utils.ResolvedDependency;
import org.jetbrains.kotlin.utils.ResolvedDependencyArtifactPath;
import org.jetbrains.kotlin.utils.ResolvedDependencyId;
import org.jetbrains.kotlin.utils.ResolvedDependencyVersion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 /2\u00020\u0001:\u0003/01B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020 J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\fH\u0016J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0)2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\fH\u0004J0\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,H\u0014J$\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0&*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020.0&H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u001a*\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "", "externalDependenciesLoader", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ExternalDependenciesLoader;", "(Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ExternalDependenciesLoader;)V", "externalDependencies", "Lorg/jetbrains/kotlin/utils/ResolvedDependencies;", "getExternalDependencies", "()Lorg/jetbrains/kotlin/utils/ResolvedDependencies;", "externalDependencies$delegate", "Lkotlin/Lazy;", "externalDependencyModules", "", "Lorg/jetbrains/kotlin/utils/ResolvedDependency;", "getExternalDependencyModules", "()Ljava/util/Collection;", "moduleIdComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/utils/ResolvedDependencyId;", "Lkotlin/Comparator;", "getModuleIdComparator", "()Ljava/util/Comparator;", "sourceCodeModuleId", "getSourceCodeModuleId", "()Lorg/jetbrains/kotlin/utils/ResolvedDependencyId;", "hasSimpleName", "", "getHasSimpleName", "(Lorg/jetbrains/kotlin/utils/ResolvedDependencyId;)Z", "isKotlinLibrary", "kotlinLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "getKotlinLibrary", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getUserVisibleModuleId", "deserializer", "getUserVisibleModules", "", "deserializers", "mergedModules", "", "modulesFromDeserializers", "excludedModuleIds", "", "stampDependenciesWithRequestedVersionEqualToSelectedVersion", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ModuleWithUninitializedDependencies;", "Companion", "ExternalDependenciesLoader", "ModuleWithUninitializedDependencies", "ir.serialization.common"})
public class UserVisibleIrModulesSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy externalDependencies$delegate;
    @NotNull
    private final Comparator<ResolvedDependencyId> moduleIdComparator;
    @NotNull
    public static final String KOTLIN_LIBRARY_PREFIX = "org.jetbrains.kotlin";
    @NotNull
    private static final UserVisibleIrModulesSupport DEFAULT = new UserVisibleIrModulesSupport(ExternalDependenciesLoader.Companion.getEMPTY());

    public UserVisibleIrModulesSupport(@NotNull ExternalDependenciesLoader externalDependenciesLoader) {
        Intrinsics.checkNotNullParameter(externalDependenciesLoader, "externalDependenciesLoader");
        this.externalDependencies$delegate = LazyKt.lazy((Function0)new Function0<ResolvedDependencies>(externalDependenciesLoader){
            final /* synthetic */ ExternalDependenciesLoader $externalDependenciesLoader;
            {
                this.$externalDependenciesLoader = $externalDependenciesLoader;
                super(0);
            }

            @NotNull
            public final ResolvedDependencies invoke() {
                return this.$externalDependenciesLoader.load();
            }
        });
        this.moduleIdComparator = (arg_0, arg_1) -> UserVisibleIrModulesSupport.moduleIdComparator$lambda-18(this, arg_0, arg_1);
    }

    private final ResolvedDependencies getExternalDependencies() {
        Lazy lazy = this.externalDependencies$delegate;
        Object var2_2 = null;
        return (ResolvedDependencies)lazy.getValue();
    }

    private final Collection<ResolvedDependency> getExternalDependencyModules() {
        return this.getExternalDependencies().getModules();
    }

    @NotNull
    public final ResolvedDependencyId getSourceCodeModuleId() {
        return this.getExternalDependencies().getSourceCodeModuleId();
    }

    @NotNull
    public final ResolvedDependencyId getUserVisibleModuleId(@NotNull IrModuleDeserializer deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        String string2 = deserializer.getModuleFragment().getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue(string2, "deserializer.moduleFragm\u2026ringStripSpecialMarkers()");
        String nameFromMetadataModuleHeader = string2;
        String[] stringArray = this.getKotlinLibrary(deserializer);
        String nameFromKlibManifest = stringArray == null ? null : KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)stringArray);
        stringArray = new String[]{nameFromMetadataModuleHeader, nameFromKlibManifest};
        return new ResolvedDependencyId((Iterable<String>)CollectionsKt.listOfNotNull(stringArray));
    }

    @NotNull
    public Map<ResolvedDependencyId, ResolvedDependency> getUserVisibleModules(@NotNull Collection<? extends IrModuleDeserializer> deserializers) {
        Intrinsics.checkNotNullParameter(deserializers, "deserializers");
        return this.mergedModules(deserializers);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<ResolvedDependencyId, ResolvedDependency> modulesFromDeserializers(@NotNull Collection<? extends IrModuleDeserializer> deserializers, @NotNull Set<ResolvedDependencyId> excludedModuleIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(deserializers, "deserializers");
        Intrinsics.checkNotNullParameter(excludedModuleIds, "excludedModuleIds");
        Iterable $this$mapNotNull$iv = deserializers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<ResolvedDependencyId, ModuleWithUninitializedDependencies> pair;
            Pair<ResolvedDependencyId, ModuleWithUninitializedDependencies> pair2;
            Pair<ResolvedDependencyId, ModuleWithUninitializedDependencies> pair3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrModuleDeserializer deserializer = (IrModuleDeserializer)element$iv$iv;
            boolean bl2 = false;
            ResolvedDependencyId moduleId = this.getUserVisibleModuleId(deserializer);
            if (excludedModuleIds.contains(moduleId)) {
                pair3 = null;
            } else {
                void $this$mapTo$iv$iv;
                Pair[] pairArray = new Pair[]{TuplesKt.to(ResolvedDependencyId.Companion.getDEFAULT_SOURCE_CODE_MODULE_ID(), ResolvedDependencyVersion.Companion.getEMPTY())};
                ResolvedDependency module2 = new ResolvedDependency(moduleId, false, ResolvedDependencyVersion.Companion.getEMPTY(), MapsKt.mutableMapOf(pairArray), new LinkedHashSet(), 2, null);
                Iterable $this$map$iv = deserializer.getModuleDependencies();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrModuleDeserializer irModuleDeserializer = (IrModuleDeserializer)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    ResolvedDependencyId resolvedDependencyId = this.getUserVisibleModuleId((IrModuleDeserializer)it);
                    collection.add(resolvedDependencyId);
                }
                List outgoingDependencyIds = (List)destination$iv$iv2;
                pair3 = pair2 = TuplesKt.to(moduleId, new ModuleWithUninitializedDependencies(module2, outgoingDependencyIds));
            }
            if (pair2 == null) continue;
            Pair<ResolvedDependencyId, ModuleWithUninitializedDependencies> it$iv$iv = pair = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map<ResolvedDependencyId, ModuleWithUninitializedDependencies> modules = MapsKt.toMap((List)destination$iv$iv);
        return this.stampDependenciesWithRequestedVersionEqualToSelectedVersion(modules);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<ResolvedDependencyId, ResolvedDependency> mergedModules(@NotNull Collection<? extends IrModuleDeserializer> deserializers) {
        void destination$iv;
        void $this$associateByTo$iv;
        Iterable $this$forEach$iv;
        Object uniqueName2;
        Map map;
        Intrinsics.checkNotNullParameter(deserializers, "deserializers");
        Map $this$mergedModules_u24lambda_u2d4 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Iterable $this$forEach$iv2 = this.getExternalDependencyModules();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv2.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            ResolvedDependency externalDependency = (ResolvedDependency)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv3 = externalDependency.getId().getUniqueNames();
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv3.iterator();
            while (iterator3.hasNext()) {
                Object element$iv2 = iterator3.next();
                uniqueName2 = (String)element$iv2;
                boolean bl3 = false;
                Map map2 = $this$mergedModules_u24lambda_u2d4;
                map2.put(uniqueName2, externalDependency);
            }
        }
        Map externalDependencyModulesByNames = map;
        Map artifactPathsToOriginModules = new LinkedHashMap();
        Iterable $this$forEach$iv4 = this.getExternalDependencyModules();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv4) {
            ResolvedDependency originModule = (ResolvedDependency)element$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv5 = originModule.getArtifactPaths();
            boolean $i$f$forEach32 = false;
            for (Object element$iv3 : $this$forEach$iv5) {
                ResolvedDependencyArtifactPath artifactPath = (ResolvedDependencyArtifactPath)element$iv3;
                boolean bl5 = false;
                uniqueName2 = artifactPathsToOriginModules;
                uniqueName2.put(artifactPath, originModule);
            }
        }
        List providedModules = new ArrayList();
        Map<ResolvedDependencyId, ResolvedDependency> $i$f$forEach22 = this.modulesFromDeserializers(deserializers, SetsKt.setOf(this.getSourceCodeModuleId()));
        boolean $i$f$forEach33 = false;
        Iterator element$iv = $this$forEach$iv.entrySet().iterator();
        while (element$iv.hasNext()) {
            void $this$forEach$iv6;
            void $this$mapNotNullTo$iv$iv;
            Object $this$forEach$iv7;
            Object incomingDependencyIdsToStampRequestedVersion;
            ResolvedDependencyId resolvedDependencyId;
            ResolvedDependencyVersion originModuleVersion;
            Object object;
            Object uniqueName2;
            Object object2;
            ResolvedDependencyId adjustedIncomingDependencyId;
            Map<ResolvedDependencyId, ResolvedDependencyVersion> map3;
            Object $dstr$incomingDependencyId$requestedVersion;
            ResolvedDependency module2;
            block18: {
                Map.Entry element$iv4;
                Map.Entry $dstr$moduleId$module = element$iv4 = element$iv.next();
                boolean bl6 = false;
                Map.Entry $i$f$forEach32 = $dstr$moduleId$module;
                ResolvedDependencyId moduleId = (ResolvedDependencyId)$i$f$forEach32.getKey();
                Map.Entry element$iv3 = $dstr$moduleId$module;
                module2 = (ResolvedDependency)element$iv3.getValue();
                ResolvedDependency externalDependencyModule = UserVisibleIrModulesSupport.mergedModules$findMatchingExternalDependencyModule(externalDependencyModulesByNames, moduleId);
                if (externalDependencyModule != null) {
                    Map<ResolvedDependencyId, ResolvedDependencyVersion> $this$forEach$iv8 = module2.getRequestedVersionsByIncomingDependencies();
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry<ResolvedDependencyId, ResolvedDependencyVersion> element$iv5 : $this$forEach$iv8.entrySet()) {
                        $dstr$incomingDependencyId$requestedVersion = element$iv5;
                        boolean bl7 = false;
                        Object object3 = $dstr$incomingDependencyId$requestedVersion;
                        ResolvedDependencyId incomingDependencyId = (ResolvedDependencyId)object3.getKey();
                        Object object4 = $dstr$incomingDependencyId$requestedVersion;
                        ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)object4.getValue();
                        map3 = UserVisibleIrModulesSupport.mergedModules$findMatchingExternalDependencyModule(externalDependencyModulesByNames, incomingDependencyId);
                        ResolvedDependencyId resolvedDependencyId2 = adjustedIncomingDependencyId = map3 == null ? incomingDependencyId : ((ResolvedDependency)((Object)map3)).getId();
                        map3 = externalDependencyModule.getRequestedVersionsByIncomingDependencies();
                        object2 = map3;
                        if (object2.containsKey(adjustedIncomingDependencyId)) continue;
                        map3 = externalDependencyModule.getRequestedVersionsByIncomingDependencies();
                        map3.put(adjustedIncomingDependencyId, requestedVersion);
                    }
                    continue;
                }
                uniqueName2 = module2.getArtifactPaths();
                Iterator element$iv5 = uniqueName2.iterator();
                while (element$iv5.hasNext()) {
                    $dstr$incomingDependencyId$requestedVersion = element$iv5.next();
                    Object it = (ResolvedDependencyArtifactPath)$dstr$incomingDependencyId$requestedVersion;
                    boolean bl8 = false;
                    if ((it = (ResolvedDependency)artifactPathsToOriginModules.get(it)) == null) continue;
                    object = it;
                    break block18;
                }
                object = null;
            }
            ResolvedDependency $i$f$forEach4 = object;
            ResolvedDependencyVersion resolvedDependencyVersion = originModuleVersion = $i$f$forEach4 == null ? null : $i$f$forEach4.getSelectedVersion();
            if (originModuleVersion != null) {
                Iterator $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv;
                module2.setSelectedVersion(originModuleVersion);
                uniqueName2 = module2.getRequestedVersionsByIncomingDependencies();
                boolean $i$f$mapNotNull = false;
                $dstr$incomingDependencyId$requestedVersion = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach52 = false;
                map3 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (map3.hasNext()) {
                    ResolvedDependencyId resolvedDependencyId3;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = map3.next();
                    boolean bl9 = false;
                    Map.Entry $dstr$incomingDependencyId$requestedVersion2 = element$iv$iv;
                    boolean bl10 = false;
                    ResolvedDependencyId incomingDependencyId = (ResolvedDependencyId)$dstr$incomingDependencyId$requestedVersion2.getKey();
                    ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)$dstr$incomingDependencyId$requestedVersion2.getValue();
                    ResolvedDependencyId resolvedDependencyId4 = resolvedDependencyId3 = requestedVersion.isEmpty() ? incomingDependencyId : null;
                    if (resolvedDependencyId3 == null) continue;
                    ResolvedDependencyId it$iv$iv = resolvedDependencyId = resolvedDependencyId3;
                    boolean bl11 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                incomingDependencyIdsToStampRequestedVersion = (List)destination$iv$iv;
                $this$forEach$iv7 = (Iterable)incomingDependencyIdsToStampRequestedVersion;
                boolean $i$f$forEach6 = false;
                $this$mapNotNullTo$iv$iv2 = $this$forEach$iv7.iterator();
                while ($this$mapNotNullTo$iv$iv2.hasNext()) {
                    Object element$iv6 = $this$mapNotNullTo$iv$iv2.next();
                    ResolvedDependencyId incomingDependencyId = (ResolvedDependencyId)element$iv6;
                    boolean bl12 = false;
                    Map<ResolvedDependencyId, ResolvedDependencyVersion> $i$f$forEach52 = module2.getRequestedVersionsByIncomingDependencies();
                    $i$f$forEach52.put(incomingDependencyId, originModuleVersion);
                }
            } else if (module2.getRequestedVersionsByIncomingDependencies().isEmpty()) {
                incomingDependencyIdsToStampRequestedVersion = module2.getRequestedVersionsByIncomingDependencies();
                $this$forEach$iv7 = this.getSourceCodeModuleId();
                ResolvedDependencyVersion $i$f$forEach6 = module2.getSelectedVersion();
                incomingDependencyIdsToStampRequestedVersion.put((ResolvedDependencyId)$this$forEach$iv7, (ResolvedDependencyVersion)$i$f$forEach6);
            }
            Object $this$mapNotNull$iv = module2.getRequestedVersionsByIncomingDependencies();
            boolean $i$f$mapNotNull = false;
            Map<ResolvedDependencyId, ResolvedDependencyVersion> $i$f$forEach6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach7 = false;
            Iterator $i$f$forEach52 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while ($i$f$forEach52.hasNext()) {
                ResolvedDependencyId resolvedDependencyId5;
                Object object5;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = $i$f$forEach52.next();
                boolean bl13 = false;
                Map.Entry $dstr$incomingDependencyId$requestedVersion3 = element$iv$iv;
                boolean bl14 = false;
                ResolvedDependencyId incomingDependencyId = (ResolvedDependencyId)$dstr$incomingDependencyId$requestedVersion3.getKey();
                ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)$dstr$incomingDependencyId$requestedVersion3.getValue();
                ResolvedDependency resolvedDependency = UserVisibleIrModulesSupport.mergedModules$findMatchingExternalDependencyModule(externalDependencyModulesByNames, incomingDependencyId);
                if (resolvedDependency == null) {
                    object5 = null;
                } else {
                    ResolvedDependencyId adjustedIncomingDependencyId2 = resolvedDependency.getId();
                    object5 = resolvedDependencyId = new Triple<ResolvedDependencyId, ResolvedDependencyId, ResolvedDependencyVersion>(incomingDependencyId, adjustedIncomingDependencyId2, requestedVersion);
                }
                if (resolvedDependencyId == null) continue;
                ResolvedDependencyId it$iv$iv = resolvedDependencyId5 = resolvedDependencyId;
                boolean bl15 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach8 = false;
            for (Object element$iv7 : $this$forEach$iv6) {
                Triple $dstr$incomingDependencyId$adjustedIncomingDependencyId$requestedVersion = (Triple)element$iv7;
                boolean bl16 = false;
                ResolvedDependencyId incomingDependencyId = (ResolvedDependencyId)$dstr$incomingDependencyId$adjustedIncomingDependencyId$requestedVersion.component1();
                adjustedIncomingDependencyId = (ResolvedDependencyId)$dstr$incomingDependencyId$adjustedIncomingDependencyId$requestedVersion.component2();
                ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)$dstr$incomingDependencyId$adjustedIncomingDependencyId$requestedVersion.component3();
                module2.getRequestedVersionsByIncomingDependencies().remove(incomingDependencyId);
                object2 = module2.getRequestedVersionsByIncomingDependencies();
                object2.put(adjustedIncomingDependencyId, requestedVersion);
            }
            Collection collection = providedModules;
            collection.add(module2);
        }
        $this$forEach$iv = CollectionsKt.plus(this.getExternalDependencyModules(), (Iterable)providedModules);
        Map $i$f$forEach33 = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv8 : $this$associateByTo$iv) {
            void it;
            ResolvedDependency bl6 = (ResolvedDependency)element$iv8;
            void var36_82 = destination$iv;
            boolean bl17 = false;
            ResolvedDependencyId resolvedDependencyId = it.getId();
            var36_82.put(resolvedDependencyId, element$iv8);
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ResolvedDependencyId, ResolvedDependency> stampDependenciesWithRequestedVersionEqualToSelectedVersion(Map<ResolvedDependencyId, ModuleWithUninitializedDependencies> $this$stampDependenciesWithRequestedVersionEqualToSelectedVersion) {
        void $this$mapValuesTo$iv$iv;
        Map<ResolvedDependencyId, ModuleWithUninitializedDependencies> $this$mapValues$iv = $this$stampDependenciesWithRequestedVersionEqualToSelectedVersion;
        boolean $i$f$mapValues = false;
        Map<ResolvedDependencyId, ModuleWithUninitializedDependencies> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            ModuleWithUninitializedDependencies moduleWithUninitializedDependencies;
            void $dstr$moduleId$moduleWithUninitializedDependencies;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            ResolvedDependencyId moduleId = (ResolvedDependencyId)$dstr$moduleId$moduleWithUninitializedDependencies.getKey();
            ModuleWithUninitializedDependencies moduleWithUninitializedDependencies2 = moduleWithUninitializedDependencies = (ModuleWithUninitializedDependencies)$dstr$moduleId$moduleWithUninitializedDependencies.getValue();
            ResolvedDependency module2 = moduleWithUninitializedDependencies2.component1();
            List<ResolvedDependencyId> outgoingDependencyIds = moduleWithUninitializedDependencies2.component2();
            Iterable $this$forEach$iv = outgoingDependencyIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResolvedDependencyId outgoingDependencyId = (ResolvedDependencyId)element$iv;
                boolean bl3 = false;
                ResolvedDependency dependencyModule = MapsKt.getValue($this$stampDependenciesWithRequestedVersionEqualToSelectedVersion, outgoingDependencyId).getModule();
                Map<ResolvedDependencyId, ResolvedDependencyVersion> map4 = dependencyModule.getRequestedVersionsByIncomingDependencies();
                ResolvedDependencyVersion resolvedDependencyVersion = dependencyModule.getSelectedVersion();
                map4.put(moduleId, resolvedDependencyVersion);
            }
            ResolvedDependency resolvedDependency = module2;
            map3.put(k2, resolvedDependency);
        }
        return destination$iv$iv;
    }

    @Nullable
    protected final KotlinLibrary getKotlinLibrary(@NotNull IrModuleDeserializer $this$kotlinLibrary) {
        Intrinsics.checkNotNullParameter($this$kotlinLibrary, "<this>");
        KlibModuleOrigin klibModuleOrigin = $this$kotlinLibrary.getModuleDescriptor().getCapability(KlibModuleOrigin.Companion.getCAPABILITY());
        DeserializedKlibModuleOrigin deserializedKlibModuleOrigin = klibModuleOrigin instanceof DeserializedKlibModuleOrigin ? (DeserializedKlibModuleOrigin)klibModuleOrigin : null;
        return deserializedKlibModuleOrigin == null ? null : deserializedKlibModuleOrigin.getLibrary();
    }

    @NotNull
    public final Comparator<ResolvedDependencyId> getModuleIdComparator() {
        return this.moduleIdComparator;
    }

    protected boolean isKotlinLibrary(@NotNull ResolvedDependencyId $this$isKotlinLibrary) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isKotlinLibrary, "<this>");
            Iterable $this$any$iv = $this$isKotlinLibrary.getUniqueNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String uniqueName = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(uniqueName, KOTLIN_LIBRARY_PREFIX, false, 2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean getHasSimpleName(@NotNull ResolvedDependencyId $this$hasSimpleName) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$hasSimpleName, "<this>");
            Iterable $this$all$iv = $this$hasSimpleName.getUniqueNames();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block4: {
                        String uniqueName = (String)element$iv;
                        boolean bl3 = false;
                        CharSequence $this$none$iv = uniqueName;
                        boolean $i$f$none = false;
                        CharSequence charSequence2 = $this$none$iv;
                        for (int i = 0; i < charSequence2.length(); ++i) {
                            char element$iv2 = charSequence2.charAt(i);
                            char it = element$iv2;
                            boolean bl4 = false;
                            if (!(it == '.' || it == ':')) continue;
                            bl2 = false;
                            break block4;
                        }
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final ResolvedDependency mergedModules$findMatchingExternalDependencyModule(Map<String, ResolvedDependency> externalDependencyModulesByNames, ResolvedDependencyId moduleId) {
        ResolvedDependency resolvedDependency;
        block1: {
            Iterable iterable = moduleId.getUniqueNames();
            for (Object t : iterable) {
                String uniqueName = (String)t;
                boolean bl = false;
                ResolvedDependency resolvedDependency2 = externalDependencyModulesByNames.get(uniqueName);
                if (resolvedDependency2 == null) continue;
                resolvedDependency = resolvedDependency2;
                break block1;
            }
            resolvedDependency = null;
        }
        return resolvedDependency;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int moduleIdComparator$lambda-18(UserVisibleIrModulesSupport this$0, ResolvedDependencyId a, ResolvedDependencyId b) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (Intrinsics.areEqual(a, b)) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue(a, "a");
        if (this$0.isKotlinLibrary(a)) {
            Intrinsics.checkNotNullExpressionValue(b, "b");
            if (!this$0.isKotlinLibrary(b)) {
                return 1;
            }
        }
        if (!this$0.isKotlinLibrary(a)) {
            Intrinsics.checkNotNullExpressionValue(b, "b");
            if (this$0.isKotlinLibrary(b)) {
                return -1;
            }
        }
        if (this$0.getHasSimpleName(a)) {
            Intrinsics.checkNotNullExpressionValue(b, "b");
            if (!this$0.getHasSimpleName(b)) {
                return -1;
            }
        }
        if (!this$0.getHasSimpleName(a)) {
            Intrinsics.checkNotNullExpressionValue(b, "b");
            if (this$0.getHasSimpleName(b)) {
                return 1;
            }
        }
        Iterator<String> aUniqueNames = a.getUniqueNames().iterator();
        Iterator<String> bUniqueNames = b.getUniqueNames().iterator();
        while (aUniqueNames.hasNext() && bUniqueNames.hasNext()) {
            int diff = aUniqueNames.next().compareTo(bUniqueNames.next());
            if (diff == 0) continue;
            return diff;
        }
        if (aUniqueNames.hasNext()) {
            return 1;
        }
        if (!bUniqueNames.hasNext()) return 0;
        return -1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ExternalDependenciesLoader;", "", "load", "Lorg/jetbrains/kotlin/utils/ResolvedDependencies;", "Companion", "ir.serialization.common"})
    public static interface ExternalDependenciesLoader {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public ResolvedDependencies load();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ExternalDependenciesLoader$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ExternalDependenciesLoader;", "getEMPTY", "()Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ExternalDependenciesLoader;", "from", "externalDependenciesFile", "Lorg/jetbrains/kotlin/konan/file/File;", "onMalformedExternalDependencies", "Lkotlin/Function1;", "", "", "ir.serialization.common"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final ExternalDependenciesLoader EMPTY;

            private Companion() {
            }

            @NotNull
            public final ExternalDependenciesLoader getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final ExternalDependenciesLoader from(@Nullable File externalDependenciesFile, @NotNull Function1<? super String, Unit> onMalformedExternalDependencies) {
                Intrinsics.checkNotNullParameter(onMalformedExternalDependencies, "onMalformedExternalDependencies");
                return externalDependenciesFile != null ? (ExternalDependenciesLoader)new ExternalDependenciesLoader(externalDependenciesFile, onMalformedExternalDependencies){
                    final /* synthetic */ File $externalDependenciesFile;
                    final /* synthetic */ Function1<String, Unit> $onMalformedExternalDependencies;
                    {
                        this.$externalDependenciesFile = $externalDependenciesFile;
                        this.$onMalformedExternalDependencies = $onMalformedExternalDependencies;
                    }

                    @NotNull
                    public ResolvedDependencies load() {
                        ResolvedDependencies resolvedDependencies;
                        if (this.$externalDependenciesFile.getExists()) {
                            byte[] byArray = this.$externalDependenciesFile.readBytes();
                            Intrinsics.checkNotNullExpressionValue(byArray, "externalDependenciesFile.readBytes()");
                            String externalDependenciesText = new String(byArray, Charsets.UTF_8);
                            resolvedDependencies = ResolvedDependenciesSupport.INSTANCE.deserialize(externalDependenciesText, (Function2<? super Integer, ? super String, Unit>)new Function2<Integer, String, Unit>(this.$onMalformedExternalDependencies, this.$externalDependenciesFile){
                                final /* synthetic */ Function1<String, Unit> $onMalformedExternalDependencies;
                                final /* synthetic */ File $externalDependenciesFile;
                                {
                                    this.$onMalformedExternalDependencies = $onMalformedExternalDependencies;
                                    this.$externalDependenciesFile = $externalDependenciesFile;
                                    super(2);
                                }

                                public final void invoke(int lineNo, @NotNull String line) {
                                    Intrinsics.checkNotNullParameter(line, "line");
                                    this.$onMalformedExternalDependencies.invoke("Malformed external dependencies at " + this.$externalDependenciesFile + ':' + lineNo + ": " + line);
                                }
                            });
                        } else {
                            resolvedDependencies = ResolvedDependencies.Companion.getEMPTY();
                        }
                        return resolvedDependencies;
                    }
                } : EMPTY;
            }

            static {
                $$INSTANCE = new Companion();
                EMPTY = new ExternalDependenciesLoader(){

                    @NotNull
                    public ResolvedDependencies load() {
                        return ResolvedDependencies.Companion.getEMPTY();
                    }
                };
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$ModuleWithUninitializedDependencies;", "", "module", "Lorg/jetbrains/kotlin/utils/ResolvedDependency;", "outgoingDependencyIds", "", "Lorg/jetbrains/kotlin/utils/ResolvedDependencyId;", "(Lorg/jetbrains/kotlin/utils/ResolvedDependency;Ljava/util/List;)V", "getModule", "()Lorg/jetbrains/kotlin/utils/ResolvedDependency;", "getOutgoingDependencyIds", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.serialization.common"})
    protected static final class ModuleWithUninitializedDependencies {
        @NotNull
        private final ResolvedDependency module;
        @NotNull
        private final List<ResolvedDependencyId> outgoingDependencyIds;

        public ModuleWithUninitializedDependencies(@NotNull ResolvedDependency module2, @NotNull List<ResolvedDependencyId> outgoingDependencyIds) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(outgoingDependencyIds, "outgoingDependencyIds");
            this.module = module2;
            this.outgoingDependencyIds = outgoingDependencyIds;
        }

        @NotNull
        public final ResolvedDependency getModule() {
            return this.module;
        }

        @NotNull
        public final List<ResolvedDependencyId> getOutgoingDependencyIds() {
            return this.outgoingDependencyIds;
        }

        @NotNull
        public final ResolvedDependency component1() {
            return this.module;
        }

        @NotNull
        public final List<ResolvedDependencyId> component2() {
            return this.outgoingDependencyIds;
        }

        @NotNull
        public final ModuleWithUninitializedDependencies copy(@NotNull ResolvedDependency module2, @NotNull List<ResolvedDependencyId> outgoingDependencyIds) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(outgoingDependencyIds, "outgoingDependencyIds");
            return new ModuleWithUninitializedDependencies(module2, outgoingDependencyIds);
        }

        public static /* synthetic */ ModuleWithUninitializedDependencies copy$default(ModuleWithUninitializedDependencies moduleWithUninitializedDependencies, ResolvedDependency resolvedDependency, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                resolvedDependency = moduleWithUninitializedDependencies.module;
            }
            if ((n & 2) != 0) {
                list2 = moduleWithUninitializedDependencies.outgoingDependencyIds;
            }
            return moduleWithUninitializedDependencies.copy(resolvedDependency, list2);
        }

        @NotNull
        public String toString() {
            return "ModuleWithUninitializedDependencies(module=" + this.module + ", outgoingDependencyIds=" + this.outgoingDependencyIds + ')';
        }

        public int hashCode() {
            int result2 = this.module.hashCode();
            result2 = result2 * 31 + ((Object)this.outgoingDependencyIds).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleWithUninitializedDependencies)) {
                return false;
            }
            ModuleWithUninitializedDependencies moduleWithUninitializedDependencies = (ModuleWithUninitializedDependencies)other;
            if (!Intrinsics.areEqual(this.module, moduleWithUninitializedDependencies.module)) {
                return false;
            }
            return Intrinsics.areEqual(this.outgoingDependencyIds, moduleWithUninitializedDependencies.outgoingDependencyIds);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "getDEFAULT", "()Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "KOTLIN_LIBRARY_PREFIX", "", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UserVisibleIrModulesSupport getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

