/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataStruct;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceImplementation;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContextImpl;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.lower.WasmBridgesConstructionKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportPair;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRtt;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "binaryDataStruct", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataStruct;", "classMetadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "interfaceTable", "jsCodeName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunction", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "backend.wasm"})
public final class DeclarationGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final IrBuiltIns irBuiltIns;

    public DeclarationGenerator(@NotNull WasmModuleCodegenContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.backendContext = this.context.getBackendContext();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException(Intrinsics.stringPlus("Unexpected element of type ", Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
    }

    private final String jsCodeName(IrFunction declaration2) {
        StringBuilder stringBuilder2 = new StringBuilder();
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(declaration2);
        Intrinsics.checkNotNull(fqName2);
        return stringBuilder2.append(fqName2.asString()).append('_').append(WasmBridgesConstructionKt.wasmSignature((IrSimpleFunction)declaration2, this.irBuiltIns).hashCode()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        void it;
        WasmType wasmType;
        Collection<WasmType> collection;
        void $this$mapTo$iv$iv;
        WasmType $this$map$iv22;
        boolean isIntrinsic;
        WasmImportPair wasmImportPair;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (declaration2 instanceof IrConstructor && this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(declaration2))) {
            return;
        }
        String jsCode2 = AnnotationsKt.getJsFunAnnotation(declaration2);
        if (jsCode2 != null) {
            String jsCodeName = this.jsCodeName(declaration2);
            this.context.addJsFun(jsCodeName, jsCode2);
            wasmImportPair = new WasmImportPair("js_code", this.jsCodeName(declaration2));
        } else {
            wasmImportPair = AnnotationsKt.getWasmImportAnnotation(declaration2);
        }
        WasmImportPair importedName = wasmImportPair;
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation(declaration2) || AnnotationsKt.getWasmOpAnnotation(declaration2) != null;
        if (isIntrinsic) {
            return;
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride(declaration2)) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration2);
        WasmType resultType = DeclarationGeneratorKt.isExported(declaration2, this.context.getBackendContext()) ? this.context.transformExportedResultType(declaration2.getReturnType()) : this.context.transformResultType(declaration2.getReturnType());
        Iterable iterable = irParameters;
        String string2 = watName;
        boolean $i$f$map22 = false;
        void var11_17 = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv22, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            WasmType t = this.getContext().transformValueParameterType((IrValueParameter)it2);
            wasmType = importedName != null && t instanceof WasmRefNullType ? (WasmType)WasmEqRef.INSTANCE : t;
            collection.add(wasmType);
        }
        collection = (List)destination$iv$iv;
        WasmType $i$f$map22 = $this$map$iv22 = resultType;
        boolean bl3 = false;
        wasmType = importedName != null && it instanceof WasmRefNullType ? (WasmType)WasmEqRef.INSTANCE : it;
        List<WasmType> list2 = CollectionsKt.listOfNotNull(wasmType);
        Collection<WasmType> collection2 = collection;
        String string3 = string2;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(string3, (List<? extends WasmType>)collection2, (List<? extends WasmType>)list2);
        this.context.defineFunctionType(declaration2.getSymbol(), wasmFunctionType);
        if (declaration2 instanceof IrSimpleFunction) {
            if (((IrSimpleFunction)declaration2).getModality() == Modality.ABSTRACT) {
                return;
            }
            if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isOverridableOrOverrides((IrSimpleFunction)declaration2)) {
                this.context.registerVirtualFunction(((IrSimpleFunction)declaration2).getSymbol());
            }
        }
        boolean $this$map$iv22 = Intrinsics.areEqual(declaration2, IrResolveUtilsKt.getRealOverrideTarget(declaration2));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration2 + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        if (importedName != null) {
            this.context.defineFunction(declaration2.getSymbol(), new WasmFunction.Imported(watName, wasmFunctionType, importedName));
            return;
        }
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, wasmFunctionType, null, null, 12, null);
        WasmFunctionCodegenContextImpl functionCodegenContext = new WasmFunctionCodegenContextImpl(declaration2, function2, this.backendContext, this.context);
        for (IrValueParameter irParameter2 : irParameters) {
            functionCodegenContext.defineLocal(irParameter2.getSymbol());
        }
        WasmExpressionBuilder exprGen = functionCodegenContext.getBodyGen();
        BodyGenerator bodyBuilder = new BodyGenerator(functionCodegenContext);
        IrBody body2 = declaration2.getBody();
        if (body2 instanceof IrBlockBody) {
            for (IrStatement statement2 : ((IrBlockBody)body2).getStatements()) {
                bodyBuilder.statementToWasmInstruction(statement2);
            }
        } else if (body2 instanceof IrExpressionBody) {
            bodyBuilder.generateExpression(((IrExpressionBody)body2).getExpression());
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Unexpected body ", body2).toString());
        }
        if (declaration2 instanceof IrConstructor) {
            exprGen.buildGetLocal(function2.getLocals().get(0));
            exprGen.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty() && declaration2.getBody() instanceof IrBlockBody) {
            exprGen.buildUnreachable();
        }
        this.context.defineFunction(declaration2.getSymbol(), function2);
        if (Intrinsics.areEqual(declaration2, this.backendContext.getStartFunction())) {
            this.context.setStartFunction(function2);
        }
        if (DeclarationGeneratorKt.isExported(declaration2, this.backendContext)) {
            String string4 = declaration2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string4, "identifier");
            this.context.addExport(new WasmExport.Function(string4, function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        WasmTable table;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (IrUtilsKt.isAnnotationClass(declaration2)) {
            return;
        }
        IrClassSymbol symbol2 = declaration2.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation(declaration2);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayInfo2;
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo2 = wasmArrayInfo;
            boolean bl = false;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr, new WasmStructFieldDeclaration("field", this.getContext().transformFieldType(wasmArrayAnnotation.getType()), true));
            this.getContext().defineGcType(symbol2, wasmArrayDeclaration);
            return;
        }
        if (IrUtilsKt.isInterface(declaration2)) {
            InterfaceMetadata metadata = new InterfaceMetadata(declaration2, this.irBuiltIns);
            for (VirtualMethodMetadata method : metadata.getMethods()) {
                IrSimpleFunctionSymbol methodSymbol = method.getFunction().getSymbol();
                table = new WasmTable(null, new WasmRefNullType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceFunctionType(methodSymbol))), null, 5, null);
                this.context.defineInterfaceMethodTable(methodSymbol, table);
            }
            this.context.registerInterface(symbol2);
        } else {
            ClassMetadata metadata;
            Object object;
            Collection<WasmStructFieldDeclaration> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2));
            Iterable method = ClassInfoKt.allFields(declaration2, this.irBuiltIns);
            String string2 = nameStr;
            boolean $i$f$map = false;
            table = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrField irField = (IrField)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                object = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue(object, "it.name.toString()");
                WasmStructFieldDeclaration wasmStructFieldDeclaration = new WasmStructFieldDeclaration((String)object, this.getContext().transformFieldType(it.getType()), true);
                collection.add(wasmStructFieldDeclaration);
            }
            collection = (List)destination$iv$iv2;
            List list2 = collection;
            String string3 = string2;
            WasmStructDeclaration structType = new WasmStructDeclaration(string3, list2);
            this.context.defineGcType(symbol2, structType);
            int depth = 0;
            ClassMetadata subMetadata = metadata = this.context.getClassMetadata(symbol2);
            while ((destination$iv$iv2 = subMetadata.getSuperClass()) != null) {
                subMetadata = destination$iv$iv2;
                int destination$iv$iv2 = depth;
                depth = destination$iv$iv2 + 1;
            }
            List initBody = new ArrayList();
            WasmIrExpressionBuilder wasmExpressionGenerator = new WasmIrExpressionBuilder(initBody);
            WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(symbol2);
            ClassMetadata superClass = metadata.getSuperClass();
            if (superClass != null) {
                WasmSymbol<WasmGlobal> superRTT = this.context.referenceClassRTT(superClass.getKlass().getSymbol());
                wasmExpressionGenerator.buildGetGlobal(superRTT);
                wasmExpressionGenerator.buildRttSub(wasmGcType);
            } else {
                wasmExpressionGenerator.buildRttCanon(wasmGcType);
            }
            String string4 = Intrinsics.stringPlus("rtt_of_", nameStr);
            object = new WasmRtt(depth, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)new WasmSymbol<WasmStructDeclaration>(structType));
            WasmGlobal rtt = new WasmGlobal(string4, (WasmType)object, false, initBody, null, 16, null);
            this.context.defineRTT(symbol2, rtt);
            this.context.registerClass(symbol2);
            this.context.generateTypeInfo(symbol2, this.binaryDataStruct(metadata));
            if (declaration2.getModality() != Modality.ABSTRACT) {
                this.context.generateInterfaceTable(symbol2, this.interfaceTable(metadata));
                for (IrClass i : metadata.getInterfaces()) {
                    void $this$associateTo$iv$iv;
                    InterfaceImplementation interfaceImplementation = new InterfaceImplementation(i.getSymbol(), declaration2.getSymbol());
                    InterfaceMetadata interfaceMetadata = new InterfaceMetadata(i, this.irBuiltIns);
                    Iterable $this$associate$iv = interfaceMetadata.getMethods();
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                    Iterable iterable = $this$associate$iv;
                    Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Object v0;
                        VirtualMethodMetadata method2;
                        Map map;
                        block15: {
                            Iterable iterable2;
                            map = destination$iv$iv3;
                            method2 = (VirtualMethodMetadata)element$iv$iv;
                            boolean bl = false;
                            Iterable iterable3 = iterable2 = (Iterable)metadata.getVirtualMethods();
                            for (Object t : iterable3) {
                                VirtualMethodMetadata it = (VirtualMethodMetadata)t;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual(it.getSignature(), method2.getSignature())) continue;
                                v0 = t;
                                break block15;
                            }
                            v0 = null;
                        }
                        VirtualMethodMetadata virtualMethodMetadata = v0;
                        if (virtualMethodMetadata == null) {
                            throw new IllegalStateException(("Cannot find class implementation of method " + method2.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable(declaration2)).toString());
                        }
                        VirtualMethodMetadata classMethod = virtualMethodMetadata;
                        Pair<IrSimpleFunctionSymbol, WasmSymbol<WasmFunction>> pair = TuplesKt.to(method2.getFunction().getSymbol(), this.getContext().referenceFunction(classMethod.getFunction().getSymbol()));
                        map.put(pair.getFirst(), pair.getSecond());
                    }
                    Map table2 = destination$iv$iv3;
                    this.context.registerInterfaceImplementationMethod(interfaceImplementation, table2);
                }
            }
        }
        for (IrDeclaration member2 : declaration2.getDeclarations()) {
            IrElementVisitorVoidKt.acceptVoid(member2, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct binaryDataStruct(ClassMetadata classMetadata) {
        Collection<WasmSymbol<Integer>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int invalidIndex = -1;
        ConstantDataIntField vtableSizeField = new ConstantDataIntField("V-table length", classMetadata.getVirtualMethods().size());
        Iterable iterable = classMetadata.getVirtualMethods();
        String string2 = "V-table";
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            WasmSymbol<Integer> wasmSymbol = it.getFunction().getModality() == Modality.ABSTRACT ? new WasmSymbol<Integer>(invalidIndex) : this.getContext().referenceVirtualFunctionId(it.getFunction().getSymbol());
            collection.add(wasmSymbol);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        String string3 = string2;
        ConstantDataIntArray vtableArray = new ConstantDataIntArray(string3, list2);
        ConstantDataIntField interfaceTablePtr = new ConstantDataIntField("interfaceTablePtr", this.context.referenceInterfaceTableAddress(classMetadata.getKlass().getSymbol()));
        ConstantDataElement[] constantDataElementArray = new ConstantDataElement[]{interfaceTablePtr, vtableSizeField, vtableArray};
        return new ConstantDataStruct("Class TypeInfo: " + IrUtilsKt.getFqNameWhenAvailable(classMetadata.getKlass()) + ' ', CollectionsKt.listOf(constantDataElementArray));
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct interfaceTable(ClassMetadata classMetadata) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        WasmSymbol<Integer> wasmSymbol;
        Collection<WasmSymbol<Integer>> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        List<IrClass> interfaces = classMetadata.getInterfaces();
        ConstantDataIntField size = new ConstantDataIntField("size", interfaces.size());
        Iterable iterable = interfaces;
        String string2 = "interfaceIds";
        boolean $i$f$map22 = false;
        void var7_8 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrClass irClass2 = (IrClass)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            wasmSymbol = this.getContext().referenceInterfaceId(it.getSymbol());
            collection.add(wasmSymbol);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        String string3 = string2;
        ConstantDataIntArray interfaceIds = new ConstantDataIntArray(string3, list2);
        Iterable $i$f$map22 = interfaces;
        string2 = "interfaceImplementationId";
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClass bl = (IrClass)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            wasmSymbol = this.getContext().referenceInterfaceImplementationId(new InterfaceImplementation(it.getSymbol(), classMetadata.getKlass().getSymbol()));
            collection.add(wasmSymbol);
        }
        Collection<WasmSymbol<Integer>> collection2 = collection = (List)destination$iv$iv2;
        String string4 = string2;
        ConstantDataIntArray interfaceImplementationIds = new ConstantDataIntArray(string4, (List<WasmSymbol<Integer>>)collection2);
        ConstantDataElement[] constantDataElementArray = new ConstantDataElement[]{size, interfaceIds, interfaceImplementationIds};
        return new ConstantDataStruct("Class interface table: " + IrUtilsKt.getFqNameWhenAvailable(classMetadata.getKlass()) + ' ', CollectionsKt.listOf(constantDataElementArray));
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (!declaration2.isStatic()) {
            return;
        }
        WasmType wasmType = this.context.transformType(declaration2.getType());
        List initBody = new ArrayList();
        WasmIrExpressionBuilder wasmExpressionGenerator = new WasmIrExpressionBuilder(initBody);
        DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration2)), wasmType, true, initBody, null, 16, null);
        this.context.defineGlobal(declaration2.getSymbol(), global);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

