/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.server.Receiver;
import net.sf.sdedit.ui.impl.DiagramTextTab;
import net.sf.sdedit.util.Grep;

public class RealtimeServer
extends Thread
implements Constants {
    private ServerSocket serverSocket;
    private Editor editor;
    private List<Receiver> receivers;
    private boolean shutDown;

    public RealtimeServer(int port, Editor editor) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.editor = editor;
        this.receivers = new LinkedList<Receiver>();
    }

    public void shutDown() {
        this.shutDown = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Receiver receiver : this.receivers) {
            receiver.shutDown();
        }
    }

    public int getPort() {
        if (this.serverSocket == null) {
            return 0;
        }
        return this.serverSocket.getLocalPort();
    }

    private void createReceiver(final Socket socket) throws IOException {
        InputStream stream = socket.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, ConfigurationManager.getGlobalConfiguration().getFileEncoding()));
        String line = reader.readLine();
        if (line != null) {
            BufferedReader decodingReader;
            String title;
            String[] parts = new Grep(Grep.NO_UNESCAPE).parse("^(.*)\\[(.*)\\]$", line = line.trim());
            if (parts != null) {
                String enc = parts[1];
                title = parts[0];
                BufferedReader theReader = null;
                try {
                    theReader = new BufferedReader(new InputStreamReader(stream, enc));
                }
                catch (Exception failed) {
                    failed.printStackTrace();
                    theReader = null;
                }
                decodingReader = theReader == null ? reader : theReader;
            } else {
                title = line;
                decodingReader = reader;
            }
            if (title.length() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiagramTextTab tab = (DiagramTextTab)RealtimeServer.this.editor.getUI().addSequenceDiagramTextTab(title, ConfigurationManager.createNewDefaultConfiguration(SequenceConfiguration.class), true);
                        Receiver receiver = new Receiver(tab, decodingReader, socket);
                        RealtimeServer.this.receivers.add(receiver);
                        Thread receiverThread = new Thread(receiver);
                        receiverThread.setDaemon(true);
                        receiverThread.start();
                    }
                });
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (this.shutDown) {
                    return;
                }
                this.editor.getUI().errorMessage(e, null, "Exception caught while waiting for a client to be connected.");
                return;
            }
            try {
                this.createReceiver(socket);
                continue;
            }
            catch (Exception e) {
                this.editor.getUI().errorMessage(e, null, "Exception caught while establishing a connection to a client.");
                continue;
            }
            break;
        }
    }
}

