/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaderField;
import org.apache.tomcat.util.http.NamesEnumerator;
import org.apache.tomcat.util.http.ValuesEnumerator;
import org.apache.tomcat.util.res.StringManager;

public class MimeHeaders {
    public static final int DEFAULT_HEADER_SIZE = 8;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.http");
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private int limit = -1;

    public void setLimit(int n) {
        this.limit = n;
        if (n > 0 && this.headers.length > n && this.count < n) {
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[n];
            System.arraycopy(this.headers, 0, mimeHeaderFieldArray, 0, this.count);
            this.headers = mimeHeaderFieldArray;
        }
    }

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].recycle();
        }
        this.count = 0;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("=== MimeHeaders ===");
        Enumeration<String> enumeration = this.names();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Enumeration<String> enumeration2 = this.values(string);
            while (enumeration2.hasMoreElements()) {
                printWriter.print(string);
                printWriter.print(" = ");
                printWriter.println(enumeration2.nextElement());
            }
        }
        return stringWriter.toString();
    }

    public int size() {
        return this.count;
    }

    public MessageBytes getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public MessageBytes getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public int findHeader(String string, int n) {
        for (int i = n; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public Enumeration<String> names() {
        return new NamesEnumerator(this);
    }

    public Enumeration<String> values(String string) {
        return new ValuesEnumerator(this, string);
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mimeHeaderField;
        if (this.limit > -1 && this.count >= this.limit) {
            throw new IllegalStateException(sm.getString("headers.maxCountFail", new Object[]{this.limit}));
        }
        int n = this.headers.length;
        if (this.count >= n) {
            int n2 = this.count * 2;
            if (this.limit > 0 && n2 > this.limit) {
                n2 = this.limit;
            }
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[n2];
            System.arraycopy(this.headers, 0, mimeHeaderFieldArray, 0, n);
            this.headers = mimeHeaderFieldArray;
        }
        if ((mimeHeaderField = this.headers[this.count]) == null) {
            this.headers[this.count] = mimeHeaderField = new MimeHeaderField();
        }
        ++this.count;
        return mimeHeaderField;
    }

    public MessageBytes addValue(String string) {
        MimeHeaderField mimeHeaderField = this.createHeader();
        mimeHeaderField.getName().setString(string);
        return mimeHeaderField.getValue();
    }

    public MessageBytes addValue(byte[] byArray, int n, int n2) {
        MimeHeaderField mimeHeaderField = this.createHeader();
        mimeHeaderField.getName().setBytes(byArray, n, n2);
        return mimeHeaderField.getValue();
    }

    public MessageBytes addValue(char[] cArray, int n, int n2) {
        MimeHeaderField mimeHeaderField = this.createHeader();
        mimeHeaderField.getName().setChars(cArray, n, n2);
        return mimeHeaderField.getValue();
    }

    public MessageBytes setValue(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(string)) continue;
            for (int j = i + 1; j < this.count; ++j) {
                if (!this.headers[j].getName().equalsIgnoreCase(string)) continue;
                this.removeHeader(j--);
            }
            return this.headers[i].getValue();
        }
        MimeHeaderField mimeHeaderField = this.createHeader();
        mimeHeaderField.getName().setString(string);
        return mimeHeaderField.getValue();
    }

    public MessageBytes getValue(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(string)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public MessageBytes getUniqueValue(String string) {
        MessageBytes messageBytes = null;
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(string)) continue;
            if (messageBytes == null) {
                messageBytes = this.headers[i].getValue();
                continue;
            }
            throw new IllegalArgumentException();
        }
        return messageBytes;
    }

    public String getHeader(String string) {
        MessageBytes messageBytes = this.getValue(string);
        return messageBytes != null ? messageBytes.toString() : null;
    }

    public void removeHeader(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(string)) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeader(int n) {
        MimeHeaderField mimeHeaderField = this.headers[n];
        mimeHeaderField.recycle();
        this.headers[n] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mimeHeaderField;
        --this.count;
    }
}

