/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.config.Config;
import tim.prune.data.Unit;

public abstract class Distance {
    private static final double EARTH_RADIUS_M = 6372795.0;

    public static double convertRadiansToDistance(double d) {
        return Distance.convertRadiansToDistance(d, Config.getUnitSet().getDistanceUnit());
    }

    public static double convertRadiansToDistance(double d, Unit unit) {
        return d * 6372795.0 * unit.getMultFactorFromStd();
    }

    public static double convertDistanceToRadians(double d) {
        return Distance.convertDistanceToRadians(d, Config.getUnitSet().getDistanceUnit());
    }

    public static double convertDistanceToRadians(double d, Unit unit) {
        return d / 6372795.0 / unit.getMultFactorFromStd();
    }
}

