# LilyPond

LilyPond is a music engraving program, devoted to producing the highest-quality
sheet music possible.  It brings the aesthetics of traditionally engraved music
to computer printouts.  LilyPond is free software and part of the
[GNU Project](https://www.gnu.org).


## General information

- Main website: https://lilypond.org
- Downloads: https://lilypond.org/download.html
- Documentation: https://lilypond.org/manuals
- Official repository: https://savannah.gnu.org/projects/lilypond
- Development repository and issue tracker: https://gitlab.com/lilypond/lilypond
- Mailing lists: https://lilypond.org/contact
- Contributor’s Guide: https://lilypond.org/doc/latest/Documentation/contributor


## Overview

LilyPond is a text-based music notation program.  It produces elegant, balanced
scores, the look of which was inspired by classical hand-engraving.  LilyPond
is cross-platform and extremely flexible thanks to its extension system written
in the Scheme programming language.

More about LilyPond in our [Introduction](https://lilypond.org/introduction).


## Building and installing

Binaries are available at https://lilypond.org/download.html

For compiling LilyPond yourself, refer to
[Compiling](https://lilypond.org/doc/latest/Documentation/contributor/compiling)
in the Contributor's Guide.


## Versioning

LilyPond uses a versioning scheme that easily identifies stable and
development releases.  In a version *x.y.z*, an even second number *y*
denotes a stable version.  For development versions, *y* is odd.


## Documentation

The manuals can be read online at https://lilypond.org/manuals

It is also possible to build the documentation locally: follow the instructions at
https://lilypond.org/doc/latest/Documentation/contributor/generating-documentation


## Support

The lilypond-user@gnu.org mailing list is the primary place for users to help
each other.  Refer to [Contact](https://lilypond.org/contact) for
subscription and archives.  Mailing lists in other languages are also
referenced there.


## Contributing

LilyPond is run by volunteers.  If you are interested in contributing, please
get in touch with us on the lilypond-devel@gnu.org mailing list
([more information](https://lilypond.org/contact)).  The
[Contributor’s Guide](https://lilypond.org/doc/latest/Documentation/contributor)
will help you get started.
