" vim-airline template by chartoin (http://github.com/chartoin)
" Base 16 Tomorrow Scheme by Chris Kempson (http://chriskempson.com)
let g:airline#themes#base16_tomorrow#palette = {}
let s:gui00 = "#1d1f21"
let s:gui01 = "#282a2e"
let s:gui02 = "#373b41"
let s:gui03 = "#969896"
let s:gui04 = "#b4b7b4"
let s:gui05 = "#c5c8c6"
let s:gui06 = "#e0e0e0"
let s:gui07 = "#ffffff"
let s:gui08 = "#cc6666"
let s:gui09 = "#de935f"
let s:gui0A = "#f0c674"
let s:gui0B = "#b5bd68"
let s:gui0C = "#8abeb7"
let s:gui0D = "#81a2be"
let s:gui0E = "#b294bb"
let s:gui0F = "#a3685a"

let s:cterm00 = 0
let s:cterm03 = 8
let s:cterm05 = 7
let s:cterm07 = 15
let s:cterm08 = 1
let s:cterm0A = 3
let s:cterm0B = 2
let s:cterm0C = 6
let s:cterm0D = 4
let s:cterm0E = 5
if exists('base16colorspace') && base16colorspace == "256"
  let s:cterm01 = 18
  let s:cterm02 = 19
  let s:cterm04 = 20
  let s:cterm06 = 21
  let s:cterm09 = 16
  let s:cterm0F = 17
else
  let s:cterm01 = 10
  let s:cterm02 = 11
  let s:cterm04 = 12
  let s:cterm06 = 13
  let s:cterm09 = 9
  let s:cterm0F = 14
endif

let s:N1   = [ s:gui01, s:gui0B, s:cterm01, s:cterm0B ]
let s:N2   = [ s:gui06, s:gui02, s:cterm06, s:cterm02 ]
let s:N3   = [ s:gui09, s:gui01, s:cterm09, s:cterm01 ]
let g:airline#themes#base16_tomorrow#palette.normal = airline#themes#generate_color_map(s:N1, s:N2, s:N3)

let s:I1   = [ s:gui01, s:gui0D, s:cterm01, s:cterm0D ]
let s:I2   = [ s:gui06, s:gui02, s:cterm06, s:cterm02 ]
let s:I3   = [ s:gui09, s:gui01, s:cterm09, s:cterm01 ]
let g:airline#themes#base16_tomorrow#palette.insert = airline#themes#generate_color_map(s:I1, s:I2, s:I3)

let s:R1   = [ s:gui01, s:gui08, s:cterm01, s:cterm08 ]
let s:R2   = [ s:gui06, s:gui02, s:cterm06, s:cterm02 ]
let s:R3   = [ s:gui09, s:gui01, s:cterm09, s:cterm01 ]
let g:airline#themes#base16_tomorrow#palette.replace = airline#themes#generate_color_map(s:R1, s:R2, s:R3)

let s:V1   = [ s:gui01, s:gui0E, s:cterm01, s:cterm0E ]
let s:V2   = [ s:gui06, s:gui02, s:cterm06, s:cterm02 ]
let s:V3   = [ s:gui09, s:gui01, s:cterm09, s:cterm01 ]
let g:airline#themes#base16_tomorrow#palette.visual = airline#themes#generate_color_map(s:V1, s:V2, s:V3)

let s:IA1   = [ s:gui05, s:gui01, s:cterm05, s:cterm01 ]
let s:IA2   = [ s:gui05, s:gui01, s:cterm05, s:cterm01 ]
let s:IA3   = [ s:gui05, s:gui01, s:cterm05, s:cterm01 ]
let g:airline#themes#base16_tomorrow#palette.inactive = airline#themes#generate_color_map(s:IA1, s:IA2, s:IA3)

" Here we define the color map for ctrlp.  We check for the g:loaded_ctrlp
" variable so that related functionality is loaded iff the user is using
" ctrlp. Note that this is optional, and if you do not define ctrlp colors
" they will be chosen automatically from the existing palette.
if !get(g:, 'loaded_ctrlp', 0)
  finish
endif
let g:airline#themes#base16_tomorrow#palette.ctrlp = airline#extensions#ctrlp#generate_color_map(
      \ [ s:gui07, s:gui02, s:cterm07, s:cterm02, '' ],
      \ [ s:gui07, s:gui04, s:cterm07, s:cterm04, '' ],
      \ [ s:gui05, s:gui01, s:cterm05, s:cterm01, 'bold' ])
