/**
 * SECTION:edsf-persona
 * @short_description: A persona subclass which represents a single EDS contact.
 * 
 * <para>Each <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance represents a single EDS <link linkend="EContact"><type>EContact</type></link>. When the contact is modified (either by this folks client, or a different client), the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> remains the same, but is assigned a new <link linkend="EContact"><type>EContact</type></link>. It then updates its properties from this new contact.</para>
 */
/**
 * EDSF_TYPE_PERSONA:
 * 
 * The type for <link linkend="EdsfPersona"><type>EdsfPersona</type></link>.
 */
/**
 * edsf_persona_change_system_groups:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance
 * @system_groups: (in): &nbsp;.  <para>the complete set of system group ids the contact should be a member of </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s system groups.
 * 
 * <para>The system groups are a property exposed by Google Contacts address books, and can include any combination of the following identifier: - &quot;Contacts&quot; - &quot;Family&quot; - &quot;Friends&quot; - &quot;Coworkers&quot;</para><para>Setting the system groups will also change the group membership to include the localized version of those groups, and may change the value of <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link>.</para><para>Attempting to call this method on a persona beloging to a PersonaStore which is not Google will throw a PropertyError.</para><para>It&apos;s preferred to call this rather than setting <link linkend="EdsfPersona--system-groups"><type>"system-groups"</type></link> directly, as this method gives error notification and will only return once the groups have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the groups failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-change-system-groups-finish"><function>edsf_persona_change_system_groups_finish()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_change_system_groups_finish:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s system groups.
 * 
 * <para>The system groups are a property exposed by Google Contacts address books, and can include any combination of the following identifier: - &quot;Contacts&quot; - &quot;Family&quot; - &quot;Friends&quot; - &quot;Coworkers&quot;</para><para>Setting the system groups will also change the group membership to include the localized version of those groups, and may change the value of <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link>.</para><para>Attempting to call this method on a persona beloging to a PersonaStore which is not Google will throw a PropertyError.</para><para>It&apos;s preferred to call this rather than setting <link linkend="EdsfPersona--system-groups"><type>"system-groups"</type></link> directly, as this method gives error notification and will only return once the groups have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the groups failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-change-system-groups"><function>edsf_persona_change_system_groups()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_change_in_google_personal_group:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance
 * @in_personal: (in): &nbsp;.  <para>Whether to add or remove the personal group membership </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change whether this contact belongs to the personal group or not.
 * 
 * <para>The personal contact group is a concept that exists only in Google address books. Other backends will throw a PropertyError.</para><para>It&apos;s preferred to call this rather than setting <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link> directly, as this method gives error notification and will only return once the membership has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if the address book is not Google, or if setting the property failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-change-in-google-personal-group-finish"><function>edsf_persona_change_in_google_personal_group_finish()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_change_in_google_personal_group_finish:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change whether this contact belongs to the personal group or not.
 * 
 * <para>The personal contact group is a concept that exists only in Google address books. Other backends will throw a PropertyError.</para><para>It&apos;s preferred to call this rather than setting <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link> directly, as this method gives error notification and will only return once the membership has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if the address book is not Google, or if setting the property failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-change-in-google-personal-group"><function>edsf_persona_change_in_google_personal_group()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * EDSF_PERSONA_phone_fields:
 * 
 * vCard field names for telephone numbers.
 *
 * Since: 0.6.0
 */
/**
 * EDSF_PERSONA_address_fields:
 * 
 * vCard field names for postal addresses.
 *
 * Since: 0.6.0
 */
/**
 * EDSF_PERSONA_email_fields:
 * 
 * vCard field names for e-mail addresses.
 *
 * Since: 0.6.0
 */
/**
 * EDSF_PERSONA_url_properties:
 * 
 * vCard field names for miscellaneous URIs.
 *
 * Since: 0.6.0
 * Deprecated: 0.6.3: Replaced by %FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_BLOG.
 */
/**
 * EDSF_PERSONA_folks_field_attribute_name:
 * 
 * Name of folks’ custom parameter indicating automatic fields
 * 
 * <para>Folks can create extra fields to improve linking between personas. These fields have a boolean-typed parameter added with this name, and the value ‘TRUE’. This allows clients to detect such fields and (for example) ignore them in the UI.</para>
 *
 * Since: 0.9.7
 */
/**
 * EDSF_PERSONA_gender_attribute_name:
 * 
 * The vCard attribute used to specify a Contact&apos;s gender
 * 
 * <para>Based on: <ulink url="http://tools.ietf.org/html/draft-ietf-vcarddav-vcardrev-22"></ulink></para><para>Note that the above document is a draft and the gender property is still considered experimental, hence the &quot;X-&quot; prefix in the attribute name. So this might change.</para>
 *
 * Since: 0.6.0
 */
/**
 * EDSF_PERSONA_gender_male:
 * 
 * The value used to define the male gender for the X-GENDER vCard property.
 * 
 * <para>Based on: <ulink url="http://tools.ietf.org/html/draft-ietf-vcarddav-vcardrev-22"></ulink></para>
 *
 * Since: 0.6.0
 */
/**
 * EDSF_PERSONA_gender_female:
 * 
 * The value used to define the female gender for the X-GENDER vCard property.
 * 
 * <para>Based on: <ulink url="http://tools.ietf.org/html/draft-ietf-vcarddav-vcardrev-22"></ulink></para>
 *
 * Since: 0.6.0
 */
/**
 * edsf_persona_new:
 * @store: (in): &nbsp;.  <para>the store which will contain the persona </para>
 * @contact: (in): &nbsp;.  <para>the EDS contact being represented by the persona </para>
 * 
 * Create a new persona.
 * 
 * <para>Create a new persona for the <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link> <code>store</code>, representing the EDS contact given by <code>contact</code>.</para>
 *
 * Since: 0.6.0
 */
/**
 * EdsfPersona:contact:
 * 
 * The e-d-s contact represented by this Persona
 */
/**
 * edsf_persona_get_contact:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="EdsfPersona--contact"><type>"contact"</type></link> property.
 * 
 * The e-d-s contact represented by this Persona
 * 
 * Returns: the value of the <link linkend="EdsfPersona--contact"><type>"contact"</type></link> property
 */
/**
 * EdsfPersona:contact-id:
 * 
 * The e-d-s contact uid
 * 
 * <para>This is guaranteed to be a non-empty string, unique within the persona store.</para>
 *
 * Since: 0.6.0
 */
/**
 * edsf_persona_get_contact_id:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="EdsfPersona--contact-id"><type>"contact-id"</type></link> property.
 * 
 * The e-d-s contact uid
 * 
 * <para>This is guaranteed to be a non-empty string, unique within the persona store.</para>
 * 
 * Returns: the value of the <link linkend="EdsfPersona--contact-id"><type>"contact-id"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * EdsfPersona:system-groups:
 * 
 * The complete set of system group identifiers the contact belongs to. See <link linkend="edsf-persona-change-system-groups"><function>edsf_persona_change_system_groups()</function></link> for details.
 * 
 * <para>This is stored in the X-GOOGLE-SYSTEM-GROUP-IDS vCard field in EDS.</para>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_get_system_groups:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="EdsfPersona--system-groups"><type>"system-groups"</type></link> property.
 * 
 * The complete set of system group identifiers the contact belongs to. See <link linkend="edsf-persona-change-system-groups"><function>edsf_persona_change_system_groups()</function></link> for details.
 * 
 * <para>This is stored in the X-GOOGLE-SYSTEM-GROUP-IDS vCard field in EDS.</para>
 * 
 * Returns: the value of the <link linkend="EdsfPersona--system-groups"><type>"system-groups"</type></link> property
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_set_system_groups:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance to modify
 * @value: the new value of the <link linkend="EdsfPersona--system-groups"><type>"system-groups"</type></link> property
 * 
 * Set the value of the <link linkend="EdsfPersona--system-groups"><type>"system-groups"</type></link> property to @value.
 * 
 * The complete set of system group identifiers the contact belongs to. See <link linkend="edsf-persona-change-system-groups"><function>edsf_persona_change_system_groups()</function></link> for details.
 * 
 * <para>This is stored in the X-GOOGLE-SYSTEM-GROUP-IDS vCard field in EDS.</para>
 *
 * Since: 0.9.0
 */
/**
 * EdsfPersona:in-google-personal-group:
 * 
 * Whether this contact is in the “My Contacts” section of the user’s address book, rather than the “Other” section.
 *
 * Since: 0.7.3
 */
/**
 * edsf_persona_get_in_google_personal_group:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link> property.
 * 
 * Whether this contact is in the “My Contacts” section of the user’s address book, rather than the “Other” section.
 * 
 * Returns: the value of the <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link> property
 *
 * Since: 0.7.3
 */
/**
 * edsf_persona_set_in_google_personal_group:
 * @self: the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance to modify
 * @value: the new value of the <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link> property
 * 
 * Set the value of the <link linkend="EdsfPersona--in-google-personal-group"><type>"in-google-personal-group"</type></link> property to @value.
 * 
 * Whether this contact is in the “My Contacts” section of the user’s address book, rather than the “Other” section.
 *
 * Since: 0.7.3
 */
/**
 * EdsfPersona:
 * 
 * A persona subclass which represents a single EDS contact.
 * 
 * <para>Each <link linkend="EdsfPersona"><type>EdsfPersona</type></link> instance represents a single EDS <link linkend="EContact"><type>EContact</type></link>. When the contact is modified (either by this folks client, or a different client), the <link linkend="EdsfPersona"><type>EdsfPersona</type></link> remains the same, but is assigned a new <link linkend="EContact"><type>EContact</type></link>. It then updates its properties from this new contact.</para>
 */
/**
 * EdsfPersonaClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="EDSF-TYPE-PERSONA:CAPS"><literal>EDSF_TYPE_PERSONA</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
