/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.tcilatex;

import com.dickimawbooks.texparserlib.SpecialListener;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SWSpecialListener
implements SpecialListener {
    private static final Pattern HEIGHT_PATTERN = Pattern.compile(" *height +(\\d*\\.?\\d+)([a-z]+) *");
    private static final Pattern WIDTH_PATTERN = Pattern.compile(" *width +(\\d*\\.?\\d+)([a-z]+) *");
    private static final Pattern FILE_PATTERN = Pattern.compile(" *tempfilename\\s+'(.+)'\\s*");

    @Override
    public TeXObjectList process(TeXParser teXParser, String string) throws IOException {
        Object object;
        if (!string.contains("language \"Scientific Word\"")) {
            return null;
        }
        String[] stringArray = string.split(";");
        KeyValList keyValList = new KeyValList();
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            TeXUnit teXUnit;
            object = HEIGHT_PATTERN.matcher(stringArray[i]);
            if (((Matcher)object).matches()) {
                try {
                    float f = Float.parseFloat(((Matcher)object).group(1));
                    teXUnit = teXParser.getListener().createUnit(((Matcher)object).group(2));
                    keyValList.put("height", new UserDimension(f, teXUnit));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            object = WIDTH_PATTERN.matcher(stringArray[i]);
            if (((Matcher)object).matches()) {
                try {
                    float f = Float.parseFloat(((Matcher)object).group(1));
                    teXUnit = teXParser.getListener().createUnit(((Matcher)object).group(2));
                    keyValList.put("width", new UserDimension(f, teXUnit));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            object = FILE_PATTERN.matcher(stringArray[i]);
            if (!((Matcher)object).matches()) continue;
            string2 = ((Matcher)object).group(1);
        }
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        object = new TeXObjectList();
        ((TeXObjectList)object).add(laTeXParserListener.getControlSequence("includegraphics"));
        ((TeXObjectList)object).add(laTeXParserListener.getOther(91));
        ((TeXObjectList)object).add(keyValList);
        ((TeXObjectList)object).add(laTeXParserListener.getOther(93));
        ((TeXObjectList)object).add(laTeXParserListener.createGroup(string2));
        return object;
    }
}

