/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class RomanNumeral
extends Primitive
implements Expandable {
    private static final int[] DECIMAL = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN = new String[]{"m", "cm", "d", "cd", "c", "cx", "l", "xl", "x", "ix", "v", "iv", "i"};

    public RomanNumeral() {
        this("romannumeral");
    }

    public RomanNumeral(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new RomanNumeral(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        return teXParser.getListener().createString(RomanNumeral.romannumeral(numerical.number(teXParser)));
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        return teXParser.getListener().createString(RomanNumeral.romannumeral(numerical.number(teXParser)));
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        teXParser.getListener().getWriteable().write(RomanNumeral.romannumeral(numerical.number(teXParser)));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        teXParser.getListener().getWriteable().write(RomanNumeral.romannumeral(numerical.number(teXParser)));
    }

    public static String romannumeral(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < DECIMAL.length) {
            int n3 = DECIMAL[n2];
            String string = ROMAN[n2];
            if (n < n3) {
                ++n2;
                continue;
            }
            n -= n3;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

