/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.filters.CorsFilter;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.SessionIdGeneratorBase;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.res.StringManager;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator {
    private final Log log = LogFactory.getLog(AuthenticatorBase.class);
    private static final String DATE_ONE = FastHttpDateFormat.formatDate((long)1L);
    protected static final StringManager sm = StringManager.getManager(AuthenticatorBase.class);
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String REALM_NAME = "Authentication required";
    protected boolean alwaysUseSession = false;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;
    protected Context context = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected boolean disableProxyCaching = true;
    protected boolean securePagesWithPragma = false;
    protected String secureRandomClass = null;
    protected String secureRandomAlgorithm = "SHA1PRNG";
    protected String secureRandomProvider = null;
    protected boolean sendAuthInfoResponseHeaders = false;
    protected SessionIdGeneratorBase sessionIdGenerator = null;
    protected SingleSignOn sso = null;
    private AllowCorsPreflight allowCorsPreflight = AllowCorsPreflight.NEVER;

    public AuthenticatorBase() {
        super(true);
    }

    public String getAllowCorsPreflight() {
        return this.allowCorsPreflight.name().toLowerCase(Locale.ENGLISH);
    }

    public void setAllowCorsPreflight(String string) {
        this.allowCorsPreflight = AllowCorsPreflight.valueOf(string.trim().toUpperCase(Locale.ENGLISH));
    }

    public boolean getAlwaysUseSession() {
        return this.alwaysUseSession;
    }

    public void setAlwaysUseSession(boolean bl) {
        this.alwaysUseSession = bl;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    @Override
    public Container getContainer() {
        return this.context;
    }

    @Override
    public void setContainer(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean bl) {
        this.disableProxyCaching = bl;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean bl) {
        this.securePagesWithPragma = bl;
    }

    public boolean getChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean bl) {
        this.changeSessionIdOnAuthentication = bl;
    }

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String string) {
        this.secureRandomClass = string;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String string) {
        this.secureRandomAlgorithm = string;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String string) {
        this.secureRandomProvider = string;
    }

    public boolean isSendAuthInfoResponseHeaders() {
        return this.sendAuthInfoResponseHeaders;
    }

    public void setSendAuthInfoResponseHeaders(boolean bl) {
        this.sendAuthInfoResponseHeaders = bl;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object object;
        Principal principal;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Security checking request " + request.getMethod() + " " + request.getRequestURI()));
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (this.cache && (principal = request.getUserPrincipal()) == null && (object = request.getSessionInternal(false)) != null && (principal = object.getPrincipal()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("We have cached auth type " + object.getAuthType() + " for principal " + principal));
            }
            request.setAuthType(object.getAuthType());
            request.setUserPrincipal(principal);
        }
        boolean bl = this.isContinuationRequired(request);
        object = this.context.getRealm();
        SecurityConstraint[] securityConstraintArray = object.findSecurityConstraints(request, this.context);
        if (securityConstraintArray == null && !this.context.getPreemptiveAuthentication() && !bl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Not subject to any constraint");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (securityConstraintArray != null && this.disableProxyCaching && !"POST".equalsIgnoreCase(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else {
                response.setHeader("Cache-Control", "private");
            }
            response.setHeader("Expires", DATE_ONE);
        }
        if (securityConstraintArray != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Calling hasUserDataPermission()");
            }
            if (!object.hasUserDataPermission(request, response, securityConstraintArray)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Failed hasUserDataPermission() test");
                }
                return;
            }
        }
        boolean bl2 = false;
        if (securityConstraintArray != null) {
            bl2 = true;
            for (int i = 0; i < securityConstraintArray.length && bl2; ++i) {
                String[] stringArray;
                if (!securityConstraintArray[i].getAuthConstraint()) {
                    bl2 = false;
                    continue;
                }
                if (securityConstraintArray[i].getAllRoles() || (stringArray = securityConstraintArray[i].findAuthRoles()) != null && stringArray.length != 0) continue;
                bl2 = false;
            }
        }
        if (!bl && bl2) {
            bl = true;
        }
        if (!bl && this.context.getPreemptiveAuthentication()) {
            boolean bl3 = bl = request.getCoyoteRequest().getMimeHeaders().getValue("authorization") != null;
        }
        if (!bl && this.context.getPreemptiveAuthentication() && "CLIENT_CERT".equals(this.getAuthMethod())) {
            X509Certificate[] x509CertificateArray = this.getRequestCertificates(request);
            boolean bl4 = bl = x509CertificateArray != null && x509CertificateArray.length > 0;
        }
        if ((bl || securityConstraintArray != null) && this.allowCorsPreflightBypass(request)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"CORS Preflight request bypassing authentication");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (bl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Calling authenticate()");
            }
            if (!this.authenticate(request, response, loginConfig)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Failed authenticate() test");
                }
                return;
            }
        }
        if (securityConstraintArray != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Calling accessControl()");
            }
            if (!object.hasResourcePermission(request, response, securityConstraintArray, this.context)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Failed accessControl() test");
                }
                return;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    protected boolean allowCorsPreflightBypass(Request request) {
        String string;
        String string2;
        boolean bl = false;
        if (this.allowCorsPreflight != AllowCorsPreflight.NEVER && "OPTIONS".equals(request.getMethod()) && (string2 = request.getHeader("Origin")) != null && !string2.isEmpty() && RequestUtil.isValidOrigin((String)string2) && !RequestUtil.isSameOrigin((HttpServletRequest)request, (String)string2) && (string = request.getHeader("Access-Control-Request-Method")) != null && !string.isEmpty()) {
            if (this.allowCorsPreflight == AllowCorsPreflight.ALWAYS) {
                bl = true;
            } else if (this.allowCorsPreflight == AllowCorsPreflight.FILTER && DispatcherType.REQUEST == request.getDispatcherType()) {
                block0: for (FilterDef filterDef : request.getContext().findFilterDefs()) {
                    if (!CorsFilter.class.getName().equals(filterDef.getFilterClass())) continue;
                    for (FilterMap filterMap : this.context.findFilterMaps()) {
                        if (!filterMap.getFilterName().equals(filterDef.getFilterName())) continue;
                        if ((filterMap.getDispatcherMapping() & 8) <= 0) break block0;
                        for (String string3 : filterMap.getURLPatterns()) {
                            if (!"/*".equals(string3)) continue;
                            bl = true;
                            break block0;
                        }
                        break block0;
                    }
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        if (this.context == null || this.context.getLoginConfig() == null) {
            return true;
        }
        return this.authenticate(request, httpServletResponse, this.context.getLoginConfig());
    }

    @Override
    public abstract boolean authenticate(Request var1, HttpServletResponse var2, LoginConfig var3) throws IOException;

    protected boolean isContinuationRequired(Request request) {
        return false;
    }

    protected X509Certificate[] getRequestCertificates(Request request) throws IllegalStateException {
        X509Certificate[] x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return x509CertificateArray;
    }

    protected void associate(String string, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(string, session);
    }

    protected boolean checkForCachedAuthentication(Request request, HttpServletResponse httpServletResponse, boolean bl) {
        String string;
        Principal principal = request.getUserPrincipal();
        String string2 = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.check.found", new Object[]{principal.getName()}));
            }
            if (string2 != null) {
                this.associate(string2, request.getSessionInternal(true));
            }
            return true;
        }
        if (bl && string2 != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.check.sso", new Object[]{string2}));
            }
            if (this.reauthenticateFromSSO(string2, request)) {
                return true;
            }
        }
        if (request.getCoyoteRequest().getRemoteUserNeedsAuthorization() && (string = request.getCoyoteRequest().getRemoteUser().toString()) != null) {
            String string3;
            Principal principal2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.check.authorize", new Object[]{string}));
            }
            if ((principal2 = this.context.getRealm().authenticate(string)) == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("authenticator.check.authorizeFail", new Object[]{string}));
                }
                principal2 = new GenericPrincipal(string, null, null);
            }
            if ((string3 = request.getAuthType()) == null || string3.length() == 0) {
                string3 = this.getAuthMethod();
            }
            this.register(request, httpServletResponse, principal2, string3, string, null);
            return true;
        }
        return false;
    }

    protected boolean reauthenticateFromSSO(String string, Request request) {
        Realm realm;
        if (this.sso == null || string == null) {
            return false;
        }
        boolean bl = false;
        Container container = this.getContainer();
        if (container != null && (realm = container.getRealm()) != null) {
            bl = this.sso.reauthenticate(string, realm, request);
        }
        if (bl) {
            this.associate(string, request.getSessionInternal(true));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reauthenticated cached principal '" + request.getUserPrincipal().getName() + "' with auth type '" + request.getAuthType() + "'"));
            }
        }
        return bl;
    }

    public void register(Request request, HttpServletResponse httpServletResponse, Principal principal, String string, String string2, String string3) {
        String string4;
        Object object;
        if (this.log.isDebugEnabled()) {
            object = principal == null ? "none" : principal.getName();
            this.log.debug((Object)("Authenticated '" + (String)object + "' with type '" + string + "'"));
        }
        request.setAuthType(string);
        request.setUserPrincipal(principal);
        if (this.sendAuthInfoResponseHeaders && Boolean.TRUE.equals(request.getAttribute("org.apache.tomcat.request.forwarded"))) {
            httpServletResponse.setHeader("remote-user", request.getRemoteUser());
            httpServletResponse.setHeader("auth-type", request.getAuthType());
        }
        if ((object = request.getSessionInternal(false)) != null) {
            if (this.getChangeSessionIdOnAuthentication() && principal != null) {
                string4 = this.changeSessionID(request, (Session)object);
                if (object.getNote("org.apache.catalina.authenticator.SESSION_ID") != null) {
                    object.setNote("org.apache.catalina.authenticator.SESSION_ID", string4);
                }
            }
        } else if (this.alwaysUseSession) {
            object = request.getSessionInternal(true);
        }
        if (object != null && this.cache) {
            object.setAuthType(string);
            object.setPrincipal(principal);
        }
        if (this.sso == null) {
            return;
        }
        string4 = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (string4 == null) {
            string4 = this.sessionIdGenerator.generateSessionId();
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, string4);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String string5 = this.sso.getCookieDomain();
            if (string5 != null) {
                cookie.setDomain(string5);
            }
            if (request.getServletContext().getSessionCookieConfig().isHttpOnly() || request.getContext().getUseHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            httpServletResponse.addCookie(cookie);
            this.sso.register(string4, principal, string, string2, string3);
            request.setNote("org.apache.catalina.request.SSOID", string4);
        } else {
            if (principal == null) {
                this.sso.deregister(string4);
                request.removeNote("org.apache.catalina.request.SSOID");
                return;
            }
            this.sso.update(string4, principal, string, string2, string3);
        }
        if (object == null) {
            object = request.getSessionInternal(true);
        }
        this.sso.associate(string4, (Session)object);
    }

    protected String changeSessionID(Request request, Session session) {
        String string = null;
        if (this.log.isDebugEnabled()) {
            string = session.getId();
        }
        String string2 = request.changeSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("authenticator.changeSessionId", new Object[]{string, string2}));
        }
        return string2;
    }

    @Override
    public void login(String string, String string2, Request request) throws ServletException {
        Principal principal = this.doLogin(request, string, string2);
        this.register(request, request.getResponse(), principal, this.getAuthMethod(), string, string2);
    }

    protected abstract String getAuthMethod();

    protected Principal doLogin(Request request, String string, String string2) throws ServletException {
        Principal principal = this.context.getRealm().authenticate(string, string2);
        if (principal == null) {
            throw new ServletException(sm.getString("authenticator.loginFail"));
        }
        return principal;
    }

    @Override
    public void logout(Request request) throws ServletException {
        Principal principal = request.getPrincipal();
        if (principal instanceof GenericPrincipal) {
            try {
                ((GenericPrincipal)principal).logout();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.log.debug((Object)sm.getString("authenticator.tomcatPrincipalLogoutFail"), throwable);
            }
        }
        this.register(request, request.getResponse(), null, null, null, null);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Container container = this.context.getParent();
        while (this.sso == null && container != null) {
            Valve[] valveArray;
            for (Valve valve : valveArray = container.getPipeline().getValves()) {
                if (!(valve instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valve;
                break;
            }
            if (this.sso != null) continue;
            container = container.getParent();
        }
        if (this.log.isDebugEnabled()) {
            if (this.sso != null) {
                this.log.debug((Object)("Found SingleSignOn Valve at " + this.sso));
            } else {
                this.log.debug((Object)"No SingleSignOn Valve is present");
            }
        }
        this.sessionIdGenerator = new StandardSessionIdGenerator();
        this.sessionIdGenerator.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        this.sessionIdGenerator.setSecureRandomClass(this.getSecureRandomClass());
        this.sessionIdGenerator.setSecureRandomProvider(this.getSecureRandomProvider());
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.sso = null;
    }

    protected static enum AllowCorsPreflight {
        NEVER,
        FILTER,
        ALWAYS;

    }
}

