/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.event.ActionEvent;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesWrapper;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.JavaFieldsProvider;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.ExcludingIterator;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.heapviewer.utils.InterruptibleIterator;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.heapviewer.utils.counters.InstanceCounter;
import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Type;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.openide.util.NbPreferences;

class JavaFieldsPlugin
extends HeapViewPlugin {
    private static final String KEY_INSTANCE_FIELDS = "iFields";
    private static final String KEY_INSTANCE_STATIC_FIELDS = "iStaticFields";
    private static final String KEY_CLASS_FIELDS_HISTOGRAM = "cFieldsHisto";
    private static final String KEY_CLASS_STATIC_FIELDS = "cStaticFields";
    private volatile boolean iFields = JavaFieldsPlugin.readItem("iFields", true);
    private volatile boolean iStaticFields = JavaFieldsPlugin.readItem("iStaticFields", true);
    private volatile boolean cFieldsHisto = JavaFieldsPlugin.readItem("cFieldsHisto", true);
    private volatile boolean cStaticFields = JavaFieldsPlugin.readItem("cStaticFields", true);
    private static final Format VALUES_COUNT_FORMAT = NumberFormat.getInstance();
    private static final TreeTableView.ColumnConfiguration CCONF_CLASS = new TreeTableView.ColumnConfiguration(DataType.COUNT, null, DataType.COUNT, SortOrder.DESCENDING, Boolean.FALSE);
    private static final TreeTableView.ColumnConfiguration CCONF_INSTANCE = new TreeTableView.ColumnConfiguration(null, DataType.COUNT, DataType.NAME, SortOrder.UNSORTED, null);
    private final Heap heap;
    private HeapViewerNode selected;
    private final TreeTableView objectsView;

    JavaFieldsPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.JavaFieldsPlugin_Name(), Bundle.JavaFieldsPlugin_Description(), Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        this.heap = context.getFragment().getHeap();
        TreeTableViewColumn[] columns = new TreeTableViewColumn[]{new TreeTableViewColumn.Name(this.heap), new TreeTableViewColumn.LogicalValue(this.heap), new TreeTableViewColumn.Count(this.heap, true, true), new TreeTableViewColumn.OwnSize(this.heap, false, false), new TreeTableViewColumn.RetainedSize(this.heap, false, false), new TreeTableViewColumn.ObjectID(this.heap)};
        this.objectsView = new TreeTableView("java_objects_fields", context, actions, columns){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                HeapViewerNode _selected;
                TreeTableView treeTableView = JavaFieldsPlugin.this.objectsView;
                synchronized (treeTableView) {
                    _selected = JavaFieldsPlugin.this.selected;
                }
                if (_selected != null) {
                    HeapViewerNode[] heapViewerNodeArray;
                    boolean filtered = false;
                    HeapViewerNode[] nodes = null;
                    InstancesWrapper wrapper = HeapViewerNode.getValue(_selected, DataType.INSTANCES_WRAPPER, heap);
                    if (wrapper != null) {
                        ArrayList<HeapViewerNode> fieldNodes = new ArrayList<HeapViewerNode>();
                        if (JavaFieldsPlugin.this.cFieldsHisto) {
                            HeapViewerNode[] histo = JavaFieldsPlugin.this.getClassFieldsHistogram(wrapper, root, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
                            fieldNodes.addAll(Arrays.asList(histo));
                        } else {
                            filtered = true;
                        }
                        if (JavaFieldsPlugin.this.cStaticFields) {
                            JavaClass jclass = wrapper.getJavaClass();
                            if (jclass != null) {
                                List fields = jclass.getStaticFieldValues();
                                fieldNodes.addAll(Arrays.asList(JavaFieldsProvider.getNodes(fields, root, heap, viewID, viewFilter, dataTypes, sortOrders, progress)));
                            }
                        } else {
                            filtered = true;
                        }
                        nodes = fieldNodes.toArray(HeapViewerNode.NO_NODES);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!JavaFieldsPlugin.this.cFieldsHisto && !CCONF_INSTANCE.equals(JavaFieldsPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                    JavaFieldsPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                                } else if (JavaFieldsPlugin.this.cFieldsHisto && !CCONF_CLASS.equals(JavaFieldsPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                    JavaFieldsPlugin.this.objectsView.configureColumns(CCONF_CLASS);
                                }
                            }
                        });
                    } else {
                        Instance instance = HeapViewerNode.getValue(_selected, DataType.INSTANCE, heap);
                        if (instance != null) {
                            ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
                            if (JavaFieldsPlugin.this.iFields) {
                                fields.addAll(instance.getFieldValues());
                            } else {
                                filtered = true;
                            }
                            if (JavaFieldsPlugin.this.iStaticFields) {
                                fields.addAll(instance.getStaticFieldValues());
                            } else {
                                filtered = true;
                            }
                            nodes = JavaFieldsProvider.getNodes(fields, root, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CCONF_INSTANCE.equals(JavaFieldsPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                                        JavaFieldsPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                                    }
                                }
                            });
                        }
                    }
                    if (nodes == null || nodes.length == 0) {
                        HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
                        heapViewerNodeArray = heapViewerNodeArray2;
                        heapViewerNodeArray2[0] = new TextNode(filtered ? Bundle.JavaFieldsPlugin_NoFieldsFiltered() : Bundle.JavaFieldsPlugin_NoFields());
                    } else {
                        heapViewerNodeArray = nodes;
                    }
                    return heapViewerNodeArray;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!CCONF_INSTANCE.equals(JavaFieldsPlugin.this.objectsView.getCurrentColumnConfiguration())) {
                            JavaFieldsPlugin.this.objectsView.configureColumns(CCONF_INSTANCE);
                        }
                    }
                });
                return new HeapViewerNode[]{new TextNode(Bundle.JavaFieldsPlugin_NoSelection())};
            }

            @Override
            protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                JMenu mInstance = new JMenu(Bundle.JavaFieldsPlugin_MenuShowInstance());
                mInstance.add(new JCheckBoxMenuItem(Bundle.JavaFieldsPlugin_MenuFields(), JavaFieldsPlugin.this.iFields){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaFieldsPlugin.this.iFields = this.isSelected();
                                JavaFieldsPlugin.storeItem(JavaFieldsPlugin.KEY_INSTANCE_FIELDS, JavaFieldsPlugin.this.iFields);
                                this.reloadView();
                            }
                        });
                    }
                });
                mInstance.add(new JCheckBoxMenuItem(Bundle.JavaFieldsPlugin_MenuStaticFields(), JavaFieldsPlugin.this.iStaticFields){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaFieldsPlugin.this.iStaticFields = this.isSelected();
                                JavaFieldsPlugin.storeItem(JavaFieldsPlugin.KEY_INSTANCE_STATIC_FIELDS, JavaFieldsPlugin.this.iStaticFields);
                                this.reloadView();
                            }
                        });
                    }
                });
                popup.add(mInstance);
                JMenu mClass = new JMenu(Bundle.JavaFieldsPlugin_MenuShowClass());
                mClass.add(new JCheckBoxMenuItem(Bundle.JavaFieldsPlugin_MenuFieldsHisto(), JavaFieldsPlugin.this.cFieldsHisto){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaFieldsPlugin.this.cFieldsHisto = this.isSelected();
                                JavaFieldsPlugin.storeItem(JavaFieldsPlugin.KEY_CLASS_FIELDS_HISTOGRAM, JavaFieldsPlugin.this.cFieldsHisto);
                                this.reloadView();
                            }
                        });
                    }
                });
                mClass.add(new JCheckBoxMenuItem(Bundle.JavaFieldsPlugin_MenuStaticFields(), JavaFieldsPlugin.this.cStaticFields){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JavaFieldsPlugin.this.cStaticFields = this.isSelected();
                                JavaFieldsPlugin.storeItem(JavaFieldsPlugin.KEY_CLASS_STATIC_FIELDS, JavaFieldsPlugin.this.cStaticFields);
                                this.reloadView();
                            }
                        });
                    }
                });
                popup.add(mClass);
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closed() {
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            this.selected = this.objectsView.getRoot();
        }
        this.objectsView.closed();
    }

    private HeapViewerNode[] getClassFieldsHistogram(final InstancesWrapper instances, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        final List<Field> fields = JavaFieldsPlugin.getAllInstanceFields(instances.getJavaClass());
        NodesComputer<Field> computer = new NodesComputer<Field>(fields.size(), UIThresholds.MAX_INSTANCE_FIELDS){

            @Override
            protected boolean sorts(DataType dataType) {
                return true;
            }

            @Override
            protected HeapViewerNode createNode(Field field) {
                return new FieldHistogramNode(field){

                    @Override
                    InterruptibleIterator<Instance> instancesIterator() {
                        return new InterruptibleIterator<Instance>(instances.getInstancesIterator());
                    }

                    @Override
                    int instancesCount() {
                        return instances.getInstancesCount();
                    }
                };
            }

            @Override
            protected ProgressIterator<Field> objectsIterator(int index, Progress progress) {
                ListIterator iterator = fields.listIterator(index);
                return new ProgressIterator<Field>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaFieldsPlugin_FieldsContainerMoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaFieldsPlugin_FieldsContainerSamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaFieldsPlugin_FieldsContainerNodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    private static List<Field> getAllInstanceFields(JavaClass jclass) {
        ArrayList<Field> fields = new ArrayList<Field>(50);
        for (JavaClass jcls = jclass; jcls != null; jcls = jcls.getSuperClass()) {
            fields.addAll(jcls.getFields());
        }
        return fields;
    }

    private static FieldValue getValueOfField(Instance instance, String name) {
        List fieldValues = instance.getFieldValues();
        for (int i = fieldValues.size() - 1; i >= 0; --i) {
            FieldValue fieldValue = (FieldValue)fieldValues.get(i);
            if (!fieldValue.getField().getName().equals(name)) continue;
            return fieldValue;
        }
        return null;
    }

    private static boolean readItem(String itemName, boolean initial) {
        return NbPreferences.forModule(JavaFieldsPlugin.class).getBoolean("JavaFieldsPlugin." + itemName, initial);
    }

    private static void storeItem(String itemName, boolean value) {
        NbPreferences.forModule(JavaFieldsPlugin.class).putBoolean("JavaFieldsPlugin." + itemName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            if (Objects.equals((Object)this.selected, (Object)node)) {
                return;
            }
            this.selected = node;
        }
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                return new JavaFieldsPlugin(context, actions);
            }
            return null;
        }
    }

    public static class FieldsHistogramRendererProvider
    extends HeapViewerRenderer.Provider {
        @Override
        public boolean supportsView(HeapContext context, String viewID) {
            return "java_objects_fields".equals(viewID);
        }

        @Override
        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            renderers.put(FieldHistogramNode.class, new FieldHistogramNodeRenderer());
            renderers.put(PrimitiveFieldValueNode.class, new PrimitiveFieldValueNodeRenderer());
        }
    }

    private static class PrimitiveFieldValueNodeRenderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        private PrimitiveFieldValueNodeRenderer() {
        }

        public void setValue(Object value, int row) {
            PrimitiveFieldValueNode n = (PrimitiveFieldValueNode)((Object)value);
            if (n != null) {
                this.setNormalValue(n.getType() + " ");
                this.setBoldValue(n.getValue());
            } else {
                this.setNormalValue("");
                this.setBoldValue("");
            }
            this.setIcon(Icons.getIcon((String)"LanguageIcons.Primitive"));
        }

        @Override
        public String getShortName() {
            return this.getBoldValue();
        }
    }

    private static class FieldHistogramNodeRenderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        private FieldHistogramNodeRenderer() {
        }

        public void setValue(Object value, int row) {
            FieldHistogramNode n = (FieldHistogramNode)((Object)value);
            if (n != null) {
                this.setBoldValue(n.getFieldName());
                this.setGrayValue(n.getValuesCount() == -1 ? "" : " " + Bundle.JavaFieldsPlugin_ValuesCountHint(VALUES_COUNT_FORMAT.format(n.getValuesCount())));
            } else {
                this.setBoldValue("");
                this.setGrayValue("");
            }
            this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        }

        @Override
        public String getShortName() {
            return this.getBoldValue();
        }
    }

    static abstract class InstanceFieldValueNode
    extends InstanceNode.IncludingNull {
        private final int valuesCount;

        InstanceFieldValueNode(Instance instance, int valuesCount) {
            super(instance);
            this.valuesCount = valuesCount;
        }

        public int getValuesCount() {
            return this.valuesCount;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceFieldValueNode)) {
                return false;
            }
            return Objects.equals(this.getInstance(), ((InstanceFieldValueNode)((Object)o)).getInstance());
        }

        @Override
        public int hashCode() {
            return this.getInstance() == null ? 37 : super.hashCode();
        }

        abstract String fieldName();

        abstract InterruptibleIterator<Instance> instancesIterator();

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.COUNT) {
                return this.getValuesCount();
            }
            return super.getValue(type, heap);
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            final String fieldName = this.fieldName();
            NodesComputer<Instance> computer = new NodesComputer<Instance>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return true;
                }

                @Override
                protected HeapViewerNode createNode(Instance object) {
                    return new InstanceNode(object){

                        @Override
                        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                            List<FieldValue> fields = JavaFieldsProvider.InstanceFieldsProvider.getFields(this, heap, true, true);
                            return JavaFieldsProvider.getNodes(fields, this, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
                        }
                    };
                }

                @Override
                protected ProgressIterator<Instance> objectsIterator(int index, final Progress _progress) {
                    final Instance _instance = this.getInstance();
                    _progress.setupUnknownSteps();
                    ExcludingIterator<Instance> fieldInstanceIterator = new ExcludingIterator<Instance>(this.instancesIterator()){

                        @Override
                        protected boolean exclude(Instance instance) {
                            _progress.step();
                            FieldValue value = JavaFieldsPlugin.getValueOfField(instance, fieldName);
                            if (!(value instanceof ObjectFieldValue)) {
                                return true;
                            }
                            return !Objects.equals(_instance, ((ObjectFieldValue)value).getInstance());
                        }
                    };
                    return new ProgressIterator<Instance>(fieldInstanceIterator, index, true, _progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.JavaFieldsPlugin_FieldHistogramMoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.JavaFieldsPlugin_FieldHistogramSamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.JavaFieldsPlugin_FieldHistogramNodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
        }
    }

    static abstract class PrimitiveFieldValueNode
    extends HeapViewerNode {
        private final String fieldValue;
        private final String fieldType;
        private final int valuesCount;

        PrimitiveFieldValueNode(String fieldValue, String fieldType, int valuesCount) {
            this.fieldValue = fieldValue;
            this.fieldType = fieldType;
            this.valuesCount = valuesCount;
        }

        public String getType() {
            return this.fieldType;
        }

        public String getValue() {
            return this.fieldValue;
        }

        public int getValuesCount() {
            return this.valuesCount;
        }

        abstract String fieldName();

        abstract InterruptibleIterator<Instance> instancesIterator();

        public String getName() {
            return this.getType() + " " + this.getValue();
        }

        public String toString() {
            return this.getName();
        }

        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.NAME) {
                return this.getName();
            }
            if (type == DataType.COUNT) {
                return this.getValuesCount();
            }
            return super.getValue(type, heap);
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            final String fieldName = this.fieldName();
            NodesComputer<Instance> computer = new NodesComputer<Instance>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return true;
                }

                @Override
                protected HeapViewerNode createNode(Instance object) {
                    return new InstanceNode(object){

                        @Override
                        public boolean isLeaf() {
                            return true;
                        }
                    };
                }

                @Override
                protected ProgressIterator<Instance> objectsIterator(int index, final Progress _progress) {
                    _progress.setupUnknownSteps();
                    ExcludingIterator<Instance> fieldInstanceIterator = new ExcludingIterator<Instance>(this.instancesIterator()){

                        @Override
                        protected boolean exclude(Instance instance) {
                            _progress.step();
                            FieldValue value = JavaFieldsPlugin.getValueOfField(instance, fieldName);
                            return value == null || !fieldValue.equals(value.getValue());
                        }
                    };
                    return new ProgressIterator<Instance>(fieldInstanceIterator, index, true, _progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.JavaFieldsPlugin_FieldHistogramMoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.JavaFieldsPlugin_FieldHistogramSamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.JavaFieldsPlugin_FieldHistogramNodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
        }
    }

    static abstract class FieldHistogramNode
    extends HeapViewerNode {
        private final String fieldName;
        private final Type fieldType;
        private int valuesCount = -1;

        FieldHistogramNode(Field field) {
            this.fieldName = field.getName();
            this.fieldType = field.getType();
        }

        String getFieldName() {
            return this.fieldName;
        }

        Type getFieldType() {
            return this.fieldType;
        }

        int getValuesCount() {
            return this.valuesCount;
        }

        private String getName() {
            if (this.valuesCount == -1) {
                return this.fieldName;
            }
            return this.fieldName + " " + Bundle.JavaFieldsPlugin_ValuesCountHint(this.valuesCount);
        }

        abstract int instancesCount();

        abstract InterruptibleIterator<Instance> instancesIterator();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HeapViewerNode[] lazilyComputeChildren(final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            try {
                int instancesCount = this.instancesCount();
                String fieldTypeName = this.fieldType.getName();
                if ("object".equals(fieldTypeName)) {
                    final InstanceCounter values = new InstanceCounter(instancesCount);
                    try {
                        progress.setupKnownSteps(instancesCount);
                        InterruptibleIterator<Instance> instances = this.instancesIterator();
                        while (instances.hasNext()) {
                            Instance instance = (Instance)instances.next();
                            progress.step();
                            FieldValue value = JavaFieldsPlugin.getValueOfField(instance, this.fieldName);
                            if (!(value instanceof ObjectFieldValue)) continue;
                            values.count(((ObjectFieldValue)value).getInstance());
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        progress.finish();
                    }
                    this.valuesCount = values.size();
                    NodesComputer<InstanceCounter.Record> computer = new NodesComputer<InstanceCounter.Record>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                        @Override
                        protected boolean sorts(DataType dataType) {
                            return true;
                        }

                        @Override
                        protected HeapViewerNode createNode(InstanceCounter.Record object) {
                            return new InstanceFieldValueNode(object.getInstance(heap), object.getCount()){

                                @Override
                                String fieldName() {
                                    return fieldName;
                                }

                                @Override
                                InterruptibleIterator<Instance> instancesIterator() {
                                    return this.instancesIterator();
                                }
                            };
                        }

                        @Override
                        protected ProgressIterator<InstanceCounter.Record> objectsIterator(int index, Progress progress) {
                            InstanceCounter.Iterator iterator = values.iterator();
                            return new ProgressIterator<InstanceCounter.Record>(iterator, index, true, progress);
                        }

                        @Override
                        protected String getMoreNodesString(String moreNodesCount) {
                            return Bundle.JavaFieldsPlugin_FieldHistogramMoreNodes(moreNodesCount);
                        }

                        @Override
                        protected String getSamplesContainerString(String objectsCount) {
                            return Bundle.JavaFieldsPlugin_FieldHistogramSamplesContainer(objectsCount);
                        }

                        @Override
                        protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                            return Bundle.JavaFieldsPlugin_FieldHistogramNodesContainer(firstNodeIdx, lastNodeIdx);
                        }
                    };
                    return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
                }
                final PrimitiveCounter counter = PrimitiveCounter.create(fieldTypeName, instancesCount);
                try {
                    progress.setupKnownSteps(instancesCount);
                    InterruptibleIterator<Instance> instances = this.instancesIterator();
                    while (instances.hasNext()) {
                        Instance instance = (Instance)instances.next();
                        progress.step();
                        FieldValue value = JavaFieldsPlugin.getValueOfField(instance, this.fieldName);
                        if (value == null) continue;
                        counter.count(JavaFieldsPlugin.getValueOfField(instance, this.fieldName).getValue());
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    progress.finish();
                }
                this.valuesCount = counter.size();
                NodesComputer<PrimitiveCounter.Record> computer = new NodesComputer<PrimitiveCounter.Record>(this.valuesCount, UIThresholds.MAX_MERGED_OBJECTS){

                    @Override
                    protected boolean sorts(DataType dataType) {
                        return true;
                    }

                    @Override
                    protected HeapViewerNode createNode(PrimitiveCounter.Record object) {
                        return new PrimitiveFieldValueNode(object.getValue(), fieldType.getName(), object.getCount()){

                            @Override
                            String fieldName() {
                                return fieldName;
                            }

                            @Override
                            InterruptibleIterator<Instance> instancesIterator() {
                                return this.instancesIterator();
                            }
                        };
                    }

                    @Override
                    protected ProgressIterator<PrimitiveCounter.Record> objectsIterator(int index, Progress progress) {
                        Iterator<? extends PrimitiveCounter.Record> iterator = counter.iterator();
                        return new ProgressIterator<PrimitiveCounter.Record>(iterator, index, true, progress);
                    }

                    @Override
                    protected String getMoreNodesString(String moreNodesCount) {
                        return Bundle.JavaFieldsPlugin_FieldHistogramMoreNodes(moreNodesCount);
                    }

                    @Override
                    protected String getSamplesContainerString(String objectsCount) {
                        return Bundle.JavaFieldsPlugin_FieldHistogramSamplesContainer(objectsCount);
                    }

                    @Override
                    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                        return Bundle.JavaFieldsPlugin_FieldHistogramNodesContainer(firstNodeIdx, lastNodeIdx);
                    }
                };
                return computer.computeNodes(this, heap, viewID, null, dataTypes, sortOrders, progress);
            }
            catch (OutOfMemoryError e) {
                System.err.println("Out of memory in JavaFieldsPlugin: " + e.getMessage());
                HeapUtils.handleOOME(true, e);
                return new HeapViewerNode[]{new ErrorNode.OOME()};
            }
        }

        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.NAME) {
                return this.getName();
            }
            return super.getValue(type, heap);
        }

        public String toString() {
            return this.getName();
        }
    }
}

