/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.servlet31.ReadListener;
import org.apache.coyote.http11.upgrade.servlet31.WebConnection;
import org.apache.coyote.http11.upgrade.servlet31.WriteListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.server.WsFrameServer;
import org.apache.tomcat.websocket.server.WsHandshakeRequest;
import org.apache.tomcat.websocket.server.WsRemoteEndpointImplServer;
import org.apache.tomcat.websocket.server.WsServerContainer;

public class WsHttpUpgradeHandler
implements HttpUpgradeHandler {
    private final Log log = LogFactory.getLog(WsHttpUpgradeHandler.class);
    private static final StringManager sm = StringManager.getManager(WsHttpUpgradeHandler.class);
    private final ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private Endpoint ep;
    private ServerEndpointConfig serverEndpointConfig;
    private WsServerContainer webSocketContainer;
    private WsHandshakeRequest handshakeRequest;
    private List<Extension> negotiatedExtensions;
    private String subProtocol;
    private Transformation transformation;
    private Map<String, String> pathParameters;
    private boolean secure;
    private WebConnection connection;
    private WsSession wsSession;

    public void preInit(Endpoint endpoint, ServerEndpointConfig serverEndpointConfig, WsServerContainer wsServerContainer, WsHandshakeRequest wsHandshakeRequest, List<Extension> list, String string, Transformation transformation, Map<String, String> map, boolean bl) {
        this.ep = endpoint;
        this.serverEndpointConfig = serverEndpointConfig;
        this.webSocketContainer = wsServerContainer;
        this.handshakeRequest = wsHandshakeRequest;
        this.negotiatedExtensions = list;
        this.subProtocol = string;
        this.transformation = transformation;
        this.pathParameters = map;
        this.secure = bl;
    }

    public void init(WebConnection webConnection) {
        AbstractServletOutputStream abstractServletOutputStream;
        AbstractServletInputStream abstractServletInputStream;
        if (this.ep == null) {
            throw new IllegalStateException(sm.getString("wsHttpUpgradeHandler.noPreInit"));
        }
        this.connection = webConnection;
        try {
            abstractServletInputStream = webConnection.getInputStream();
            abstractServletOutputStream = webConnection.getOutputStream();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        String string = null;
        Object object = this.handshakeRequest.getHttpSession();
        if (object != null) {
            string = ((HttpSession)object).getId();
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            WsRemoteEndpointImplServer wsRemoteEndpointImplServer = new WsRemoteEndpointImplServer(abstractServletOutputStream, this.webSocketContainer);
            this.wsSession = new WsSession(this.ep, wsRemoteEndpointImplServer, this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), string, this.negotiatedExtensions, this.subProtocol, this.pathParameters, this.secure, (EndpointConfig)this.serverEndpointConfig);
            WsFrameServer wsFrameServer = new WsFrameServer(abstractServletInputStream, this.wsSession, this.transformation);
            abstractServletOutputStream.setWriteListener((WriteListener)new WsWriteListener(this, wsRemoteEndpointImplServer));
            wsRemoteEndpointImplServer.setTransformation(wsFrameServer.getTransformation());
            this.ep.onOpen((Session)this.wsSession, (EndpointConfig)this.serverEndpointConfig);
            this.webSocketContainer.registerSession(this.serverEndpointConfig.getPath(), this.wsSession);
            abstractServletInputStream.setReadListener((ReadListener)new WsReadListener(this, wsFrameServer));
        }
        catch (DeploymentException deploymentException) {
            throw new IllegalArgumentException(deploymentException);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public void destroy() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                this.log.error((Object)sm.getString("wsHttpUpgradeHandler.destroyFailed"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, throwable.getMessage()), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, throwable.getMessage()));
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.ep.onError((Session)this.wsSession, throwable);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private void close(CloseReason closeReason) {
        this.wsSession.onClose(closeReason);
    }

    private static class WsWriteListener
    implements WriteListener {
        private final WsHttpUpgradeHandler wsProtocolHandler;
        private final WsRemoteEndpointImplServer wsRemoteEndpointServer;

        private WsWriteListener(WsHttpUpgradeHandler wsHttpUpgradeHandler, WsRemoteEndpointImplServer wsRemoteEndpointImplServer) {
            this.wsProtocolHandler = wsHttpUpgradeHandler;
            this.wsRemoteEndpointServer = wsRemoteEndpointImplServer;
        }

        public void onWritePossible() {
            this.wsRemoteEndpointServer.onWritePossible(false);
        }

        public void onError(Throwable throwable) {
            this.wsProtocolHandler.onError(throwable);
            this.wsRemoteEndpointServer.close();
        }
    }

    private static class WsReadListener
    implements ReadListener {
        private final WsHttpUpgradeHandler wsProtocolHandler;
        private final WsFrameServer wsFrame;

        private WsReadListener(WsHttpUpgradeHandler wsHttpUpgradeHandler, WsFrameServer wsFrameServer) {
            this.wsProtocolHandler = wsHttpUpgradeHandler;
            this.wsFrame = wsFrameServer;
        }

        public void onDataAvailable() {
            try {
                this.wsFrame.onDataAvailable();
            }
            catch (WsIOException wsIOException) {
                this.wsProtocolHandler.close(wsIOException.getCloseReason());
            }
            catch (IOException iOException) {
                this.onError(iOException);
                CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, iOException.getMessage());
                this.wsProtocolHandler.close(closeReason);
            }
        }

        public void onAllDataRead() {
            throw new IllegalStateException();
        }

        public void onError(Throwable throwable) {
            this.wsProtocolHandler.onError(throwable);
        }
    }
}

