/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HeaderUtil;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalAprInputBuffer
extends AbstractInputBuffer<Long> {
    private static final Log log = LogFactory.getLog(InternalAprInputBuffer.class);
    private ByteBuffer bbuf;
    private long socket;
    private SocketWrapper<Long> wrapper;

    public InternalAprInputBuffer(Request request, int n, boolean bl, HttpParser httpParser) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[n];
        this.bbuf = n < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((n / 1500 + 1) * 1500);
        this.rejectIllegalHeaderName = bl;
        this.httpParser = httpParser;
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    @Override
    public void recycle() {
        this.socket = 0L;
        this.wrapper = null;
        super.recycle();
    }

    @Override
    public boolean parseRequestLine(boolean bl) throws IOException {
        int n = 0;
        do {
            if (this.pos >= this.lastValid) {
                if (bl) {
                    return false;
                }
                if (!this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
            }
            if (this.request.getStartTime() < 0L) {
                this.request.setStartTime(System.currentTimeMillis());
            }
            this.chr = this.buf[this.pos++];
        } while (this.chr == 13 || this.chr == 10);
        --this.pos;
        n = this.pos;
        if (this.pos >= this.lastValid) {
            if (bl) {
                return false;
            }
            if (!this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
        }
        boolean bl2 = false;
        while (!bl2) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                bl2 = true;
                this.request.method().setBytes(this.buf, n, this.pos - n);
            } else if (!HttpParser.isToken(this.buf[this.pos])) {
                String string = this.parseInvalid(n, this.buf);
                throw new IllegalArgumentException(sm.getString("iib.invalidmethod", new Object[]{string}));
            }
            ++this.pos;
        }
        while (bl2) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            bl2 = false;
        }
        n = this.pos;
        int n2 = 0;
        int n3 = -1;
        boolean bl3 = false;
        while (!bl2) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos - 1] == 13 && this.buf[this.pos] != 10) {
                this.request.protocol().setString("HTTP/1.1");
                String string = this.parseInvalid(n, this.buf);
                throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                bl2 = true;
                n2 = this.pos;
            } else if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    bl2 = true;
                    this.request.protocol().setString("");
                    bl3 = true;
                    n2 = this.buf[this.pos - 1] == 13 ? this.pos - 1 : this.pos;
                } else if (this.buf[this.pos] == 63 && n3 == -1) {
                    n3 = this.pos;
                } else {
                    if (n3 != -1 && !this.httpParser.isQueryRelaxed(this.buf[this.pos])) {
                        String string = this.parseInvalid(n, this.buf);
                        throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                    }
                    if (this.httpParser.isNotRequestTargetRelaxed(this.buf[this.pos])) {
                        String string = this.parseInvalid(n, this.buf);
                        throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                    }
                }
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, n, n2 - n);
        if (n3 >= 0) {
            this.request.queryString().setBytes(this.buf, n3 + 1, n2 - n3 - 1);
            this.request.requestURI().setBytes(this.buf, n, n3 - n);
        } else {
            this.request.requestURI().setBytes(this.buf, n, n2 - n);
        }
        while (bl2 && !bl3) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            bl2 = false;
        }
        n = this.pos;
        n2 = 0;
        while (!bl3) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos - 1] == 13 && this.buf[this.pos] == 10) {
                    n2 = this.pos - 1;
                    bl3 = true;
                } else if (!HttpParser.isHttpProtocol(this.buf[this.pos])) {
                    String string = this.parseInvalid(n, this.buf);
                    throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol", new Object[]{string}));
                }
            }
            ++this.pos;
        }
        if (n2 - n > 0) {
            this.request.protocol().setBytes(this.buf, n, n2 - n);
        }
        if (this.request.protocol().isNull()) {
            throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol"));
        }
        return true;
    }

    @Override
    public boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        while (this.parseHeader()) {
        }
        this.parsingHeader = false;
        this.end = this.pos;
        return true;
    }

    private boolean parseHeader() throws IOException {
        int n;
        while (true) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13 || this.prevChr == 13) {
                if (this.prevChr == 13 && this.chr == 10) {
                    ++this.pos;
                    return false;
                }
                if (this.prevChr != 13) break;
                --this.pos;
                break;
            }
            ++this.pos;
        }
        int n2 = n = this.pos;
        boolean bl = false;
        MessageBytes messageBytes = null;
        while (!bl) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 58) {
                bl = true;
                messageBytes = this.headers.addValue(this.buf, n, this.pos - n);
            } else if (!HttpParser.isToken(this.buf[this.pos])) {
                this.skipLine(n2, n);
                return true;
            }
            this.chr = this.buf[this.pos];
            if (this.chr >= 65 && this.chr <= 90) {
                this.buf[this.pos] = (byte)(this.chr - -32);
            }
            ++this.pos;
        }
        n = this.pos;
        int n3 = this.pos;
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3) {
            boolean bl4 = true;
            while (bl4) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                bl4 = false;
            }
            int n4 = n3;
            while (!bl2) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                this.prevChr = this.chr;
                this.chr = this.buf[this.pos];
                if (this.chr != 13) {
                    if (this.prevChr == 13 && this.chr == 10) {
                        bl2 = true;
                    } else {
                        if (this.prevChr == 13) {
                            this.headers.removeHeader(this.headers.size() - 1);
                            this.skipLine(n2, n);
                            return true;
                        }
                        if (this.chr != 9 && HttpParser.isControl(this.chr)) {
                            this.headers.removeHeader(this.headers.size() - 1);
                            this.skipLine(n2, n);
                            return true;
                        }
                        if (this.buf[this.pos] == 32) {
                            this.buf[n3] = this.buf[this.pos];
                            ++n3;
                        } else {
                            this.buf[n3] = this.buf[this.pos];
                            n4 = ++n3;
                        }
                    }
                }
                ++this.pos;
            }
            n3 = n4;
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            byte by = this.buf[this.pos];
            if (by != 32 && by != 9) {
                bl3 = false;
                continue;
            }
            bl2 = false;
            this.buf[n3] = by;
            ++n3;
        }
        messageBytes.setBytes(this.buf, n, n3 - n);
        return true;
    }

    private void skipLine(int n, int n2) throws IOException {
        boolean bl = false;
        int n3 = n2;
        if (this.pos - 1 > n2) {
            n3 = this.pos - 1;
        }
        while (!bl) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13) {
                if (this.prevChr == 13 && this.chr == 10) {
                    bl = true;
                } else {
                    n3 = this.pos;
                }
            }
            ++this.pos;
        }
        if (this.rejectIllegalHeaderName || log.isDebugEnabled()) {
            String string = sm.getString("iib.invalidheader", new Object[]{HeaderUtil.toPrintableString(this.buf, n, n3 - n + 1)});
            if (this.rejectIllegalHeaderName) {
                throw new IllegalArgumentException(string);
            }
            log.debug((Object)string);
        }
    }

    @Override
    public int doRead(ByteChunk byteChunk, Request request) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(byteChunk, request);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(byteChunk, request);
    }

    @Override
    protected void init(SocketWrapper<Long> socketWrapper, AbstractEndpoint<Long> abstractEndpoint) throws IOException {
        this.wrapper = socketWrapper;
        this.socket = socketWrapper.getSocket();
        Socket.setrbb(this.socket, this.bbuf);
    }

    @Override
    protected boolean fill(boolean bl) throws IOException {
        return this.fill();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean fill() throws IOException {
        int n = 0;
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            this.bbuf.clear();
            n = Socket.recvbb(this.socket, 0, this.buf.length - this.lastValid);
            if (n <= 0) {
                if (-n != 120002) throw new IOException(sm.getString("iib.failedread"));
                return false;
            }
            this.bbuf.limit(n);
            this.bbuf.get(this.buf, this.pos, n);
            this.lastValid = this.pos + n;
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
            this.bbuf.clear();
            n = Socket.recvbb(this.socket, 0, this.buf.length - this.lastValid);
            if (n > 0) {
                this.bbuf.limit(n);
                this.bbuf.get(this.buf, this.pos, n);
                this.lastValid = this.pos + n;
            } else {
                if (-n == 120005) throw new SocketTimeoutException(sm.getString("iib.failedread"));
                if (-n == 120001) {
                    throw new SocketTimeoutException(sm.getString("iib.failedread"));
                }
                if (n == 0) {
                    return false;
                }
                if (-n != 20014) throw new IOException(sm.getString("iib.failedread"));
                if (!this.wrapper.isSecure()) throw new IOException(sm.getString("iib.failedread"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("iib.apr.sslGeneralError", new Object[]{this.socket, this.wrapper}));
                }
            }
        }
        if (n <= 0) return false;
        return true;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk byteChunk, Request request) throws IOException {
            if (InternalAprInputBuffer.this.pos >= InternalAprInputBuffer.this.lastValid && !InternalAprInputBuffer.this.fill()) {
                return -1;
            }
            int n = InternalAprInputBuffer.this.lastValid - InternalAprInputBuffer.this.pos;
            byteChunk.setBytes(InternalAprInputBuffer.this.buf, InternalAprInputBuffer.this.pos, n);
            InternalAprInputBuffer.this.pos = InternalAprInputBuffer.this.lastValid;
            return n;
        }

        @Override
        public int available() {
            if (InternalAprInputBuffer.this.lastValid > InternalAprInputBuffer.this.pos) {
                return InternalAprInputBuffer.this.lastValid - InternalAprInputBuffer.this.pos;
            }
            return 0;
        }
    }
}

