/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentDateFormat {
    private final String format;
    private final Locale locale;
    private final TimeZone timezone;
    private final Queue<SimpleDateFormat> queue = new ConcurrentLinkedQueue<SimpleDateFormat>();

    public ConcurrentDateFormat(String string, Locale locale, TimeZone timeZone) {
        this.format = string;
        this.locale = locale;
        this.timezone = timeZone;
        SimpleDateFormat simpleDateFormat = this.createInstance();
        this.queue.add(simpleDateFormat);
    }

    public String format(Date date) {
        SimpleDateFormat simpleDateFormat = this.queue.poll();
        if (simpleDateFormat == null) {
            simpleDateFormat = this.createInstance();
        }
        String string = simpleDateFormat.format(date);
        this.queue.add(simpleDateFormat);
        return string;
    }

    public Date parse(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.queue.poll();
        if (simpleDateFormat == null) {
            simpleDateFormat = this.createInstance();
        }
        Date date = simpleDateFormat.parse(string);
        simpleDateFormat.setTimeZone(this.timezone);
        this.queue.add(simpleDateFormat);
        return date;
    }

    private SimpleDateFormat createInstance() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format, this.locale);
        simpleDateFormat.setTimeZone(this.timezone);
        return simpleDateFormat;
    }
}

