/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.tomcat.util.ExceptionUtils;

public class ResponseIncludeWrapper
extends HttpServletResponseWrapper {
    private static final String LAST_MODIFIED = "last-modified";
    private static final DateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    protected long lastModified = -1L;
    protected final ServletOutputStream captureServletOutputStream;
    protected ServletOutputStream servletOutputStream;
    protected PrintWriter printWriter;

    public ResponseIncludeWrapper(HttpServletResponse httpServletResponse, ServletOutputStream servletOutputStream) {
        super(httpServletResponse);
        this.captureServletOutputStream = servletOutputStream;
    }

    public void flushOutputStreamOrWriter() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public PrintWriter getWriter() throws IOException {
        if (this.servletOutputStream == null) {
            if (this.printWriter == null) {
                this.setCharacterEncoding(this.getCharacterEncoding());
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.captureServletOutputStream, this.getCharacterEncoding()));
            }
            return this.printWriter;
        }
        throw new IllegalStateException();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter == null) {
            if (this.servletOutputStream == null) {
                this.servletOutputStream = this.captureServletOutputStream;
            }
            return this.servletOutputStream;
        }
        throw new IllegalStateException();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void addDateHeader(String string, long l) {
        super.addDateHeader(string, l);
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals(LAST_MODIFIED)) {
            this.lastModified = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String string, String string2) {
        super.addHeader(string, string2);
        String string3 = string.toLowerCase(Locale.ENGLISH);
        if (string3.equals(LAST_MODIFIED)) {
            try {
                DateFormat dateFormat = RFC1123_FORMAT;
                synchronized (dateFormat) {
                    this.lastModified = RFC1123_FORMAT.parse(string2).getTime();
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
        }
    }

    public void setDateHeader(String string, long l) {
        super.setDateHeader(string, l);
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals(LAST_MODIFIED)) {
            this.lastModified = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String string, String string2) {
        super.setHeader(string, string2);
        String string3 = string.toLowerCase(Locale.ENGLISH);
        if (string3.equals(LAST_MODIFIED)) {
            try {
                DateFormat dateFormat = RFC1123_FORMAT;
                synchronized (dateFormat) {
                    this.lastModified = RFC1123_FORMAT.parse(string2).getTime();
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
        }
    }

    static {
        RFC1123_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

