/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractGroup;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.tomcat.util.buf.StringUtils;

public class MemoryGroup
extends AbstractGroup {
    protected final MemoryUserDatabase database;
    protected final CopyOnWriteArrayList<Role> roles = new CopyOnWriteArrayList();

    MemoryGroup(MemoryUserDatabase memoryUserDatabase, String string, String string2) {
        this.database = memoryUserDatabase;
        this.setGroupname(string);
        this.setDescription(string2);
    }

    @Override
    public Iterator<Role> getRoles() {
        return this.roles.iterator();
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public Iterator<User> getUsers() {
        ArrayList<User> arrayList = new ArrayList<User>();
        Iterator<User> iterator = this.database.getUsers();
        while (iterator.hasNext()) {
            User user = iterator.next();
            if (!user.isInGroup(this)) continue;
            arrayList.add(user);
        }
        return arrayList.iterator();
    }

    @Override
    public void addRole(Role role) {
        this.roles.addIfAbsent(role);
    }

    @Override
    public boolean isInRole(Role role) {
        return this.roles.contains(role);
    }

    @Override
    public void removeRole(Role role) {
        this.roles.remove(role);
    }

    @Override
    public void removeRoles() {
        this.roles.clear();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<group groupname=\"");
        stringBuilder.append(this.groupname);
        stringBuilder.append("\"");
        if (this.description != null) {
            stringBuilder.append(" description=\"");
            stringBuilder.append(this.description);
            stringBuilder.append("\"");
        }
        stringBuilder.append(" roles=\"");
        StringUtils.join(this.roles, (char)',', (StringUtils.Function)new StringUtils.Function<Role>(){

            public String apply(Role role) {
                return role.getRolename();
            }
        }, (StringBuilder)stringBuilder);
        stringBuilder.append("\"");
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }
}

