/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.libgraal;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.views.ApplicationViewsSupport;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceViewPlugin;
import org.graalvm.visualvm.core.ui.DataSourceViewPluginProvider;
import org.graalvm.visualvm.graalvm.libgraal.MemoryModel;
import org.graalvm.visualvm.graalvm.libgraal.MemoryViewPlugin;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;

public class MemoryViewPluginProvider
extends DataSourceViewPluginProvider<Application> {
    private static final String JVMCINativeLibraryFlag = "UseJVMCINativeLibrary";
    static final String LIBGRAAL_HEAP = "Libgraal";
    private final ObjectName libgraalName = MemoryViewPluginProvider.getLibgraalName();

    protected DataSourceViewPlugin createPlugin(Application application) {
        return new MemoryViewPlugin((DataSource)application, MemoryModel.create(application, LIBGRAAL_HEAP, this.libgraalName));
    }

    protected boolean supportsPluginFor(Application t) {
        return this.isSupported(t);
    }

    protected boolean supportsSavePluginFor(Application application, Class<? extends Snapshot> snapshotClass) {
        return ApplicationSnapshot.class.isAssignableFrom(snapshotClass);
    }

    protected void savePlugin(Application application, Snapshot snapshot) {
        MemoryViewPlugin view = (MemoryViewPlugin)this.getCachedPlugin((DataSource)application);
        if (view != null) {
            view.getModel().save(snapshot);
        } else {
            MemoryModel.create((DataSource)application, LIBGRAAL_HEAP).save(snapshot);
        }
    }

    private MemoryViewPluginProvider() {
    }

    public static void initialize() {
        ApplicationViewsSupport.sharedInstance().getMonitorView().registerPluginProvider((DataSourceViewPluginProvider)new MemoryViewPluginProvider());
    }

    private static ObjectName getLibgraalName() {
        try {
            return new ObjectName("java.lang:type=MemoryPool,name=Libgraal");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isSupported(Application app) {
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
        if (jmxModel != null) {
            String val = jmxModel.getFlagValue(JVMCINativeLibraryFlag);
            return Boolean.valueOf(val);
        }
        return false;
    }
}

